/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.rest;

import eu.dnetlib.dhp.collection.plugin.utils.JsonUtils;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RestIterator
implements Iterator<String> {
    private static final Logger log = LoggerFactory.getLogger(RestIterator.class);
    public static final String UTF_8 = "UTF-8";
    private final HttpClientParams clientParams;
    private final String BASIC = "basic";
    private final JsonUtils jsonUtils;
    private final String baseUrl;
    private final String resumptionType;
    private final String resumptionParam;
    private final String resultFormatValue;
    private String queryParams;
    private final int resultSizeValue;
    private int resumptionInt = 0;
    private int resultTotal = -1;
    private String resumptionStr = Integer.toString(this.resumptionInt);
    private InputStream resultStream;
    private Transformer transformer;
    private XPath xpath;
    private String query;
    private XPathExpression xprResultTotalPath;
    private XPathExpression xprResumptionPath;
    private XPathExpression xprEntity;
    private final String queryFormat;
    private final String querySize;
    private final String authMethod;
    private final String authToken;
    private final Queue<String> recordQueue = new PriorityBlockingQueue<String>();
    private int discoverResultSize = 0;
    private int pagination = 1;
    private final String resultOutputFormat;

    public RestIterator(HttpClientParams clientParams, String baseUrl, String resumptionType, String resumptionParam, String resumptionXpath, String resultTotalXpath, String resultFormatParam, String resultFormatValue, String resultSizeParam, String resultSizeValueStr, String queryParams, String entityXpath, String authMethod, String authToken, String resultOutputFormat) {
        this.clientParams = clientParams;
        this.jsonUtils = new JsonUtils();
        this.baseUrl = baseUrl;
        this.resumptionType = resumptionType;
        this.resumptionParam = resumptionParam;
        this.resultFormatValue = resultFormatValue;
        this.resultSizeValue = Integer.valueOf(resultSizeValueStr);
        this.queryParams = queryParams;
        this.authMethod = authMethod;
        this.authToken = authToken;
        this.resultOutputFormat = resultOutputFormat;
        this.queryFormat = StringUtils.isNotBlank((CharSequence)resultFormatParam) ? "&" + resultFormatParam + "=" + resultFormatValue : "";
        this.querySize = StringUtils.isNotBlank((CharSequence)resultSizeParam) ? "&" + resultSizeParam + "=" + resultSizeValueStr : "";
        try {
            this.initXmlTransformation(resultTotalXpath, resumptionXpath, entityXpath);
        }
        catch (Exception e) {
            throw new IllegalStateException("xml transformation init failed: " + e.getMessage());
        }
        this.initQueue();
    }

    private void initXmlTransformation(String resultTotalXpath, String resumptionXpath, String entityXpath) throws TransformerConfigurationException, XPathExpressionException {
        TransformerFactory factory = TransformerFactory.newInstance();
        this.transformer = factory.newTransformer();
        this.transformer.setOutputProperty("indent", "yes");
        this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        this.xpath = XPathFactory.newInstance().newXPath();
        this.xprResultTotalPath = this.xpath.compile(resultTotalXpath);
        this.xprResumptionPath = this.xpath.compile(StringUtils.isBlank((CharSequence)resumptionXpath) ? "/" : resumptionXpath);
        this.xprEntity = this.xpath.compile(entityXpath);
    }

    private void initQueue() {
        this.query = this.baseUrl + "?" + this.queryParams + this.querySize + this.queryFormat;
        log.info("REST calls starting with {}", (Object)this.query);
    }

    private void disconnect() {
    }

    @Override
    public boolean hasNext() {
        if (this.recordQueue.isEmpty() && this.query.isEmpty()) {
            this.disconnect();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Queue<String> queue = this.recordQueue;
        synchronized (queue) {
            while (this.recordQueue.isEmpty() && !this.query.isEmpty()) {
                try {
                    this.query = this.downloadPage(this.query);
                }
                catch (CollectorException e) {
                    log.debug("CollectorPlugin.next()-Exception: {}", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            return this.recordQueue.poll();
        }
    }

    private String downloadPage(String query) throws CollectorException {
        String resultXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        String nextQuery = "";
        String emptyXml = resultXml + "<" + "recordWrap" + "></" + "recordWrap" + ">";
        Node resultNode = null;
        NodeList nodeList = null;
        String qUrlArgument = "";
        int urlOldResumptionSize = 0;
        if (this.resumptionType.equalsIgnoreCase("deep-cursor")) {
            log.debug("check resumptionType deep-cursor and check cursor=*?{}", (Object)query);
            if (!query.contains("&cursor=")) {
                query = query + "&cursor=*";
            }
        }
        try {
            InputStream theHttpInputStream;
            HttpURLConnection conn;
            log.info("requestig URL [{}]", (Object)query);
            URL qUrl = new URL(query);
            log.debug("authMethod: {}", (Object)this.authMethod);
            if ("bearer".equalsIgnoreCase(this.authMethod)) {
                log.trace("authMethod before inputStream: {}", (Object)resultXml);
                conn = (HttpURLConnection)qUrl.openConnection();
                conn.setRequestProperty("Authorization", "Bearer " + this.authToken);
                conn.setRequestProperty("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
                conn.setRequestMethod("GET");
                theHttpInputStream = conn.getInputStream();
            } else if ("basic".equalsIgnoreCase(this.authMethod)) {
                log.trace("authMethod before inputStream: {}", (Object)resultXml);
                conn = (HttpURLConnection)qUrl.openConnection();
                conn.setRequestProperty("Authorization", "Basic " + this.authToken);
                conn.setRequestProperty("Accept", ContentType.APPLICATION_XML.getMimeType());
                conn.setRequestMethod("GET");
                theHttpInputStream = conn.getInputStream();
            } else {
                theHttpInputStream = qUrl.openStream();
            }
            this.resultStream = theHttpInputStream;
            if ("json".equals(this.resultOutputFormat)) {
                String resultJson = IOUtils.toString((InputStream)this.resultStream, (Charset)StandardCharsets.UTF_8);
                resultXml = this.jsonUtils.convertToXML(resultJson);
                this.resultStream = IOUtils.toInputStream((String)resultXml, (String)UTF_8);
            }
            if (!emptyXml.equalsIgnoreCase(resultXml)) {
                resultNode = (Node)this.xpath.evaluate("/", new InputSource(this.resultStream), XPathConstants.NODE);
                nodeList = (NodeList)this.xprEntity.evaluate(resultNode, XPathConstants.NODESET);
                log.debug("nodeList.length: {}", (Object)nodeList.getLength());
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    StringWriter sw = new StringWriter();
                    this.transformer.transform(new DOMSource(nodeList.item(i)), new StreamResult(sw));
                    String toEnqueue = sw.toString();
                    if (toEnqueue == null || StringUtils.isBlank((CharSequence)toEnqueue) || emptyXml.equalsIgnoreCase(toEnqueue)) {
                        log.warn("The following record resulted in empty item for the feeding queue: {}", (Object)resultXml);
                        continue;
                    }
                    this.recordQueue.add(sw.toString());
                }
            } else {
                log.warn("resultXml is equal with emptyXml");
            }
            this.resumptionInt += this.resultSizeValue;
            switch (this.resumptionType.toLowerCase()) {
                case "scan": {
                    this.resumptionStr = this.xprResumptionPath.evaluate(resultNode);
                    break;
                }
                case "count": {
                    this.resumptionStr = Integer.toString(this.resumptionInt);
                    break;
                }
                case "discover": {
                    String[] arrayQUrlArgument;
                    if (this.resultSizeValue < 2) {
                        throw new CollectorException("Mode: discover, Param 'resultSizeValue' is less than 2");
                    }
                    qUrlArgument = qUrl.getQuery();
                    for (String arrayUrlArgStr : arrayQUrlArgument = qUrlArgument.split("&")) {
                        if (!arrayUrlArgStr.startsWith(this.resumptionParam)) continue;
                        String[] resumptionKeyValue = arrayUrlArgStr.split("=");
                        if (this.isInteger(resumptionKeyValue[1])) {
                            urlOldResumptionSize = Integer.parseInt(resumptionKeyValue[1]);
                            log.debug("discover OldResumptionSize from Url (int): {}", (Object)urlOldResumptionSize);
                            continue;
                        }
                        log.debug("discover OldResumptionSize from Url (str): {}", (Object)resumptionKeyValue[1]);
                    }
                    if (emptyXml.equalsIgnoreCase(resultXml) || nodeList != null && nodeList.getLength() < this.resultSizeValue) {
                        if (nodeList != null) {
                            this.discoverResultSize += nodeList.getLength();
                        }
                        this.resultTotal = this.discoverResultSize;
                    } else {
                        this.resumptionStr = Integer.toString(this.resumptionInt);
                        this.resultTotal = this.resumptionInt + 1;
                        if (nodeList != null) {
                            this.discoverResultSize += nodeList.getLength();
                        }
                    }
                    log.info("discoverResultSize: {}", (Object)this.discoverResultSize);
                    break;
                }
                case "pagination": 
                case "page": {
                    ++this.pagination;
                    if (nodeList != null) {
                        this.discoverResultSize += nodeList.getLength();
                    } else {
                        this.resultTotal = this.discoverResultSize;
                        this.pagination = this.discoverResultSize;
                    }
                    this.resumptionInt = this.pagination;
                    this.resumptionStr = Integer.toString(this.resumptionInt);
                    break;
                }
                case "deep-cursor": {
                    this.resumptionStr = this.encodeValue(this.xprResumptionPath.evaluate(resultNode));
                    this.queryParams = this.queryParams.replace("&cursor=*", "");
                    this.resumptionInt = nodeList != null && nodeList.getLength() < this.discoverResultSize ? (this.resumptionInt += nodeList.getLength() + 1 - this.resultSizeValue) : (this.resumptionInt += nodeList.getLength() - this.resultSizeValue);
                    this.discoverResultSize = nodeList.getLength();
                    log.debug("downloadPage().deep-cursor: resumptionStr=" + this.resumptionStr + " ; queryParams=" + this.queryParams + " resumptionLengthIncreased: " + this.resumptionInt);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException("collection failed: " + e.getMessage());
        }
        try {
            if (this.resultTotal == -1) {
                this.resultTotal = Integer.parseInt(this.xprResultTotalPath.evaluate(resultNode));
                if (this.resumptionType.equalsIgnoreCase("page") && !"basic".equalsIgnoreCase(this.authMethod)) {
                    ++this.resultTotal;
                }
                log.info("resultTotal was -1 is now: " + this.resultTotal);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException("downloadPage resultTotal couldn't parse: " + e.getMessage());
        }
        log.debug("resultTotal: " + this.resultTotal);
        log.debug("resInt: " + this.resumptionInt);
        nextQuery = this.resumptionInt <= this.resultTotal ? this.baseUrl + "?" + this.queryParams + this.querySize + "&" + this.resumptionParam + "=" + this.resumptionStr + this.queryFormat : "";
        log.debug("nextQueryUrl: " + nextQuery);
        return nextQuery;
    }

    private boolean isInteger(String s) {
        boolean isValidInteger = false;
        try {
            Integer.parseInt(s);
            isValidInteger = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return isValidInteger;
    }

    private String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    public String getResultFormatValue() {
        return this.resultFormatValue;
    }

    public String getResultOutputFormat() {
        return this.resultOutputFormat;
    }
}

