/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.raid;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.raid.model.RAiDEntity;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class GenerateRAiDActionSetJob {
    private static final Logger log = LoggerFactory.getLogger(GenerateRAiDActionSetJob.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final List<KeyValue> RAID_COLLECTED_FROM = OafMapperUtils.listKeyValues((String[])new String[]{"10|infrastruct_::f66f1bd369679b5b077dcdf006089556", "OpenAIRE"});
    private static final Qualifier RAID_QUALIFIER = OafMapperUtils.qualifier((String)"0049", (String)"Research Activity", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
    private static final Qualifier RAID_INFERENCE_QUALIFIER = OafMapperUtils.qualifier((String)"raid:openaireinference", (String)"Inferred by OpenAIRE", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions");
    private static final DataInfo RAID_DATA_INFO = OafMapperUtils.dataInfo((Boolean)false, (String)"OpenAIRE", (Boolean)true, (Boolean)false, (Qualifier)RAID_INFERENCE_QUALIFIER, (String)"0.92");

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)GenerateRAiDActionSetJob.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/raid/action_set_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("inputPath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {} ", (Object)outputPath);
        String baseUrl = parser.get("baseUrl");
        log.info("baseUrl: {}", (Object)baseUrl);
        String graphBasePath = parser.get("graphBasePath");
        log.info("graphBasePath: {}", (Object)graphBasePath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            GenerateRAiDActionSetJob.removeOutputDir(spark, outputPath);
            GenerateRAiDActionSetJob.saveActionSet(spark, inputPath, outputPath, baseUrl, graphBasePath);
        });
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }

    static void saveActionSet(SparkSession spark, String inputPath, String outputPath, String baseUrl, String graphBasePath) {
        GenerateRAiDActionSetJob.raidEntitiesToAtomicActions(spark, inputPath, baseUrl, graphBasePath).mapToPair((PairFunction & Serializable)aa -> new Tuple2((Object)new Text(aa.getClazz().getCanonicalName()), (Object)new Text(OBJECT_MAPPER.writeValueAsString(aa)))).saveAsHadoopFile(outputPath, Text.class, Text.class, SequenceFileOutputFormat.class);
    }

    static JavaRDD<AtomicAction<? extends Oaf>> raidEntitiesToAtomicActions(SparkSession spark, String inputPath, String baseUrl, String graphBasePath) {
        JavaRDD graphEntities = GenerateRAiDActionSetJob.readInputPath(spark, inputPath).map((Function & Serializable)r -> GenerateRAiDActionSetJob.rawRAiDtoGraphEntities(r, baseUrl)).flatMap(List::iterator);
        JavaRDD raidToResultRels = graphEntities.filter((Function & Serializable)e -> e instanceof Relation).map((Function & Serializable)e -> (Relation)e).filter((Function & Serializable)rel -> rel.getRelClass().equals("HasPart"));
        JavaRDD<Relation> relevantRels = GenerateRAiDActionSetJob.readRelevantRelations(spark, graphBasePath);
        JavaRDD newRels = relevantRels.mapToPair((PairFunction & Serializable)rel -> new Tuple2((Object)rel.getSource(), rel)).join(raidToResultRels.mapToPair((PairFunction & Serializable)rel -> new Tuple2((Object)rel.getTarget(), rel))).flatMap((FlatMapFunction & Serializable)x -> {
            Relation leftRel = (Relation)((Tuple2)x._2())._1();
            String entityId = leftRel.getTarget();
            String relType = leftRel.getRelType();
            Relation raidRel = (Relation)((Tuple2)x._2())._2();
            String raidId = ((Relation)((Tuple2)x._2())._2()).getSource();
            ArrayList<Relation> res = new ArrayList<Relation>();
            Relation rel1 = OafMapperUtils.getRelation((String)raidId, (String)entityId, (String)relType, (String)"part", (String)"HasPart", (List)raidRel.getCollectedfrom(), (DataInfo)raidRel.getDataInfo(), (Long)raidRel.getLastupdatetimestamp());
            Relation rel2 = OafMapperUtils.getRelation((String)entityId, (String)raidId, (String)relType, (String)"part", (String)"IsPartOf", (List)raidRel.getCollectedfrom(), (DataInfo)raidRel.getDataInfo(), (Long)raidRel.getLastupdatetimestamp());
            res.add(rel1);
            res.add(rel2);
            return res.iterator();
        }).distinct();
        return graphEntities.map((Function & Serializable)e -> e instanceof Relation ? new AtomicAction(Relation.class, (Oaf)((Relation)e)) : new AtomicAction(OtherResearchProduct.class, (Oaf)((OtherResearchProduct)e))).union(newRels.map((Function & Serializable)rel -> new AtomicAction(Relation.class, (Oaf)rel)));
    }

    private static JavaRDD<Relation> readRelevantRelations(SparkSession spark, String graphBasePath) {
        return spark.read().schema(Encoders.bean(Relation.class).schema()).json(graphBasePath + "/relation").as(Encoders.bean(Relation.class)).toJavaRDD().filter((Function & Serializable)rel -> rel.getDataInfo().getDeletedbyinference() == false).filter((Function & Serializable)rel -> rel.getRelType().equals("resultProject") || rel.getRelType().equals("resultOrganization") || rel.getRelType().equals("resultResult")).filter((Function & Serializable)rel -> rel.getRelClass().equals("isProducedBy") || rel.getRelClass().equals("hasAuthorInstitution") || rel.getRelClass().equals("merges"));
    }

    protected static List<Oaf> rawRAiDtoGraphEntities(RAiDEntity r, String baseUrl) {
        Date now = new Date();
        OtherResearchProduct orp = new OtherResearchProduct();
        ArrayList<Oaf> res = new ArrayList<Oaf>();
        String raidId = GenerateRAiDActionSetJob.calculateOpenaireId(r.getId());
        orp.setId(raidId);
        orp.setCollectedfrom(RAID_COLLECTED_FROM);
        orp.setDataInfo(RAID_DATA_INFO);
        orp.setTitle(Collections.singletonList(OafMapperUtils.structuredProperty((String)r.getTitle(), (Qualifier)OafMapperUtils.qualifier((String)"main title", (String)"main title", (String)"dnet:dataCite_title", (String)"dnet:dataCite_title"), (DataInfo)RAID_DATA_INFO)));
        orp.setDescription(OafMapperUtils.listFields((DataInfo)RAID_DATA_INFO, (String[])new String[]{r.getDescription()}));
        Instance instance = new Instance();
        instance.setInstancetype(RAID_QUALIFIER);
        instance.setUrl(Collections.singletonList(baseUrl + raidId.split("\\|")[1]));
        orp.setInstance(Collections.singletonList(instance));
        orp.setRelevantdate(Arrays.asList(OafMapperUtils.structuredProperty((String)r.getEndDate(), (Qualifier)OafMapperUtils.qualifier((String)"endDate", (String)"endDate", (String)"dnet:dataCite_date", (String)"dnet:dataCite_date"), (DataInfo)RAID_DATA_INFO), OafMapperUtils.structuredProperty((String)r.getStartDate(), (Qualifier)OafMapperUtils.qualifier((String)"startDate", (String)"startDate", (String)"dnet:dataCite_date", (String)"dnet:dataCite_date"), (DataInfo)RAID_DATA_INFO)));
        orp.setLastupdatetimestamp(Long.valueOf(now.getTime()));
        orp.setDateofacceptance(OafMapperUtils.field((Object)r.getStartDate(), (DataInfo)RAID_DATA_INFO));
        res.add((Oaf)orp);
        for (String resultId : r.getIds()) {
            Relation rel1 = OafMapperUtils.getRelation((String)raidId, (String)resultId, (String)"resultResult", (String)"part", (String)"HasPart", (OafEntity)orp);
            Relation rel2 = OafMapperUtils.getRelation((String)resultId, (String)raidId, (String)"resultResult", (String)"part", (String)"IsPartOf", (OafEntity)orp);
            res.add((Oaf)rel1);
            res.add((Oaf)rel2);
        }
        return res;
    }

    public static String calculateOpenaireId(String raid) {
        return String.format("50|%s::%s", "raid________", DHPUtils.md5((String)raid));
    }

    private static JavaRDD<RAiDEntity> readInputPath(SparkSession spark, String path) {
        return spark.read().json(path).as(Encoders.bean(RAiDEntity.class)).toJavaRDD();
    }
}

