/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.crossref;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.ror.GenerateRorActionSetJob;
import eu.dnetlib.dhp.collection.crossref.Crossref2Oaf$;
import eu.dnetlib.dhp.collection.crossref.Crossref2Oaf$TransformationType$;
import eu.dnetlib.dhp.collection.crossref.UnpayWall;
import eu.dnetlib.dhp.collection.crossref.funderInfo;
import eu.dnetlib.dhp.collection.crossref.mappingAffiliation;
import eu.dnetlib.dhp.collection.crossref.mappingAuthor;
import eu.dnetlib.dhp.collection.crossref.mappingFunder;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.AccessRight;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.InstanceTypeMapping;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OpenAccessRoute;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.Subject;
import eu.dnetlib.dhp.schema.oaf.utils.DoiCleaningRule;
import eu.dnetlib.dhp.schema.oaf.utils.GraphCleaningFunctions;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.Row;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileByteRef;
import scala.util.matching.Regex;

public final class Crossref2Oaf$
implements Product,
Serializable {
    public static final Crossref2Oaf$ MODULE$;
    private final Logger logger;
    private final ObjectMapper mapper;
    private final List<funderInfo> irishFunder;
    private final List<String> invalidName;

    static {
        new Crossref2Oaf$();
    }

    public Logger logger() {
        return this.logger;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public List<funderInfo> irishFunder() {
        return this.irishFunder;
    }

    public List<String> invalidName() {
        return this.invalidName;
    }

    public Option<String> getIrishId(String doi) {
        String id = (String)Predef$.MODULE$.refArrayOps((Object[])doi.split("/")).last();
        return this.irishFunder().find((Function1)new Serializable(id){
            public static final long serialVersionUID = 0L;
            public final String id$1;

            public final boolean apply(funderInfo f) {
                return this.id$1.equalsIgnoreCase(f.id()) || f.synonym().nonEmpty() && f.synonym().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getIrishId.1 $outer;

                    public final boolean apply(String s) {
                        return s.equalsIgnoreCase(this.$outer.id$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.id$1 = id$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(funderInfo f) {
                return f.id();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public KeyValue createCrossrefCollectedFrom() {
        void var1_1;
        KeyValue cf = new KeyValue();
        cf.setValue("Crossref");
        cf.setKey("10|openaire____::081b82f96300b6a6e3d282bad31cb6e2");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public KeyValue createUnpayWallCollectedFrom() {
        void var1_1;
        KeyValue cf = new KeyValue();
        cf.setValue("UnpayWall");
        cf.setKey(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10|openaire____::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DHPUtils.md5((String)"UnpayWall".toLowerCase())})));
        return var1_1;
    }

    public DataInfo generateDataInfo() {
        return this.generateDataInfo("0.91");
    }

    /*
     * WARNING - void declaration
     */
    public DataInfo generateDataInfo(String trust) {
        void var2_2;
        DataInfo di = new DataInfo();
        di.setDeletedbyinference(Predef$.MODULE$.boolean2Boolean(false));
        di.setInferred(Predef$.MODULE$.boolean2Boolean(false));
        di.setInvisible(Predef$.MODULE$.boolean2Boolean(false));
        di.setTrust(trust);
        di.setProvenanceaction(OafMapperUtils.qualifier((String)"sysimport:actionset", (String)"sysimport:actionset", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"));
        return var2_2;
    }

    public AccessRight getOpenAccessQualifier() {
        return OafMapperUtils.accessRight((String)"OPEN", (String)"Open Access", (String)"dnet:access_modes", (String)"dnet:access_modes");
    }

    public AccessRight getRestrictedQualifier() {
        return OafMapperUtils.accessRight((String)"RESTRICTED", (String)"Restricted", (String)"dnet:access_modes", (String)"dnet:access_modes");
    }

    public AccessRight getUnknownQualifier() {
        return OafMapperUtils.accessRight((String)"UNKNOWN", (String)"not available", (String)"dnet:access_modes", (String)"dnet:access_modes");
    }

    public AccessRight getEmbargoedAccessQualifier() {
        return OafMapperUtils.accessRight((String)"EMBARGO", (String)"Embargo", (String)"dnet:access_modes", (String)"dnet:access_modes");
    }

    public AccessRight getClosedAccessQualifier() {
        return OafMapperUtils.accessRight((String)"CLOSED", (String)"Closed Access", (String)"dnet:access_modes", (String)"dnet:access_modes");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AccessRight decideAccessRight(Field<String> lic, String date) {
        if (lic == null) {
            return this.getUnknownQualifier();
        }
        String license = (String)lic.getValue();
        if (license.startsWith("cc") || license.startsWith("http://creativecommons.org/licenses") || license.startsWith("https://creativecommons.org/licenses") || license.equals("http://pubs.acs.org/page/policy/authorchoice_ccby_termsofuse.html") || license.equals("http://pubs.acs.org/page/policy/authorchoice_termsofuse.html") || license.equals("http://pubs.acs.org/page/policy/authorchoice_ccbyncnd_termsofuse.html") || license.equals("http://www.apa.org/pubs/journals/resources/open-access.aspx")) {
            AccessRight oaq = this.getOpenAccessQualifier();
            oaq.setOpenAccessRoute(OpenAccessRoute.hybrid);
            return oaq;
        }
        if (!license.equals("https://academic.oup.com/journals/pages/open_access/funder_policies/chorus/standard_publication_model")) return this.getClosedAccessQualifier();
        LocalDate now = LocalDate.now();
        try {
            LocalDate pub_date = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            if (!((double)(now.toEpochDay() - pub_date.toEpochDay()) / 365.0 > 1.0)) return this.getEmbargoedAccessQualifier();
            AccessRight oaq = this.getOpenAccessQualifier();
            oaq.setOpenAccessRoute(OpenAccessRoute.hybrid);
            return oaq;
        }
        catch (Exception exception) {
            try {
                LocalDate pub_date = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"));
                if (!((double)(now.toEpochDay() - pub_date.toEpochDay()) / 365.0 > 1.0)) return this.getEmbargoedAccessQualifier();
                AccessRight oaq = this.getOpenAccessQualifier();
                oaq.setOpenAccessRoute(OpenAccessRoute.hybrid);
                return oaq;
            }
            catch (Exception exception2) {
                return this.getClosedAccessQualifier();
            }
        }
    }

    public boolean isValidAuthorName(String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return false;
        }
        return !this.invalidName().contains((Object)fullName.toLowerCase().trim());
    }

    public boolean filterResult(Result publication) {
        String publisher;
        if (publication == null) {
            return false;
        }
        if (publication.getId() == null || publication.getId().isEmpty()) {
            return false;
        }
        if (publication.getTitle() == null || publication.getTitle().size() == 0) {
            return false;
        }
        int s = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getTitle()).asScala()).count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructuredProperty p) {
                return p.getValue() != null && new StringOps(Predef$.MODULE$.augmentString(p.getValue())).nonEmpty() && !p.getValue().equalsIgnoreCase("[NO TITLE AVAILABLE]");
            }
        });
        if (s == 0) {
            return false;
        }
        String string = publisher = publication.getPublisher() == null ? null : (String)publication.getPublisher().getValue();
        if (publisher != null && (publisher.equalsIgnoreCase("Test accounts") || publisher.equalsIgnoreCase("CrossRef Test Account"))) {
            return false;
        }
        if (publication.getAuthor() == null || publication.getAuthor().size() == 0) {
            return true;
        }
        Buffer authors = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getAuthor()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Author s) {
                return new StringOps(Predef$.MODULE$.augmentString(s.getFullname())).nonEmpty() ? s.getFullname() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.getName(), s.getSurname()}));
            }
        }, Buffer$.MODULE$.canBuildFrom());
        int c = authors.count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String fullName) {
                return Crossref2Oaf$.MODULE$.isValidAuthorName(fullName);
            }
        });
        if (c == 0) {
            return false;
        }
        return authors.count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String s) {
                return s.equalsIgnoreCase("Addie Jackson");
            }
        }) <= 0 || !"Elsevier BV".equalsIgnoreCase((String)publication.getPublisher().getValue());
    }

    public Option<OpenAccessRoute> get_unpaywall_color(String input) {
        if (input == null || input.equalsIgnoreCase("close")) {
            return None$.MODULE$;
        }
        if (input.equalsIgnoreCase("green")) {
            return new Some((Object)OpenAccessRoute.green);
        }
        if (input.equalsIgnoreCase("bronze")) {
            return new Some((Object)OpenAccessRoute.bronze);
        }
        if (input.equalsIgnoreCase("hybrid")) {
            return new Some((Object)OpenAccessRoute.hybrid);
        }
        return new Some((Object)OpenAccessRoute.gold);
    }

    public Option<OpenAccessRoute> get_color(String input) {
        if (input == null || input.equalsIgnoreCase("closed")) {
            return None$.MODULE$;
        }
        if (input.equalsIgnoreCase("green")) {
            return new Some((Object)OpenAccessRoute.green);
        }
        if (input.equalsIgnoreCase("bronze")) {
            return new Some((Object)OpenAccessRoute.bronze);
        }
        if (input.equalsIgnoreCase("hybrid")) {
            return new Some((Object)OpenAccessRoute.hybrid);
        }
        return new Some((Object)OpenAccessRoute.gold);
    }

    public Result mappingResult(Result result, JsonAST.JValue json, Qualifier instanceType, String originalType) {
        JsonAST.JValue has_review;
        ObjectRef formats$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        String doi = DoiCleaningRule.clean((String)((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash("DOI")).extract((Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class))));
        result.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{OafMapperUtils.structuredProperty((String)doi, (Qualifier)OafMapperUtils.qualifier((String)PidType.doi.toString(), (String)PidType.doi.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null)}))).asJava());
        List clinicalTrialNumbers = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("clinical-trial-number")).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue check$ifrefutable$1) {
                JsonAST.JValue jValue = check$ifrefutable$1;
                boolean bl = jValue instanceof JsonAST.JString;
                return bl;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(JsonAST.JValue x$1) {
                JsonAST.JValue jValue = x$1;
                if (jValue instanceof JsonAST.JString) {
                    String ctr;
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String string = ctr = jString.s();
                    return string;
                }
                throw new MatchError((Object)jValue);
            }
        });
        List alternativeIds = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("alternative-id")).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue check$ifrefutable$2) {
                JsonAST.JValue jValue = check$ifrefutable$2;
                boolean bl = jValue instanceof JsonAST.JString;
                return bl;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(JsonAST.JValue x$2) {
                JsonAST.JValue jValue = x$2;
                if (jValue instanceof JsonAST.JString) {
                    String ids;
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String string = ids = jString.s();
                    return string;
                }
                throw new MatchError((Object)jValue);
            }
        });
        List list = clinicalTrialNumbers;
        List list2 = alternativeIds;
        List tmp = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{doi})).$colon$colon$colon(list2).$colon$colon$colon(list);
        ArrayList originalIds = new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)tmp.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String id) {
                return id != null;
            }
        })).asJava());
        result.setOriginalId(originalIds);
        result.setDataInfo(this.generateDataInfo());
        result.setLastupdatetimestamp(Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("indexed")).$bslash("timestamp")).extract((Formats)this.formats$2(formats$lzy, bitmap$0), (Manifest)ManifestFactory$.MODULE$.Long()))));
        result.setDateofcollection((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("indexed")).$bslash("date-time")).extract((Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class)));
        result.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{this.createCrossrefCollectedFrom()}))).asJava());
        String publisher = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash("publisher")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
        if (publisher != null && new StringOps(Predef$.MODULE$.augmentString(publisher)).nonEmpty()) {
            result.setPublisher(OafMapperUtils.field((Object)publisher, null));
        }
        List mainTitles = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("title")).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue check$ifrefutable$3) {
                JsonAST.JValue jValue = check$ifrefutable$3;
                boolean bl = jValue instanceof JsonAST.JString;
                return bl;
            }
        }).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue x$5) {
                JsonAST.JValue jValue = x$5;
                if (jValue instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String title = jString.s();
                    boolean bl = new StringOps(Predef$.MODULE$.augmentString(title)).nonEmpty();
                    return bl;
                }
                throw new MatchError((Object)jValue);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructuredProperty apply(JsonAST.JValue x$6) {
                JsonAST.JValue jValue = x$6;
                if (jValue instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String title = jString.s();
                    StructuredProperty structuredProperty = OafMapperUtils.structuredProperty((String)title, (Qualifier)ModelConstants.MAIN_TITLE_QUALIFIER, null);
                    return structuredProperty;
                }
                throw new MatchError((Object)jValue);
            }
        });
        List originalTitles = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("original-title")).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue check$ifrefutable$4) {
                JsonAST.JValue jValue = check$ifrefutable$4;
                boolean bl = jValue instanceof JsonAST.JString;
                return bl;
            }
        }).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue x$7) {
                JsonAST.JValue jValue = x$7;
                if (jValue instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String title = jString.s();
                    boolean bl = new StringOps(Predef$.MODULE$.augmentString(title)).nonEmpty();
                    return bl;
                }
                throw new MatchError((Object)jValue);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructuredProperty apply(JsonAST.JValue x$8) {
                JsonAST.JValue jValue = x$8;
                if (jValue instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String title = jString.s();
                    StructuredProperty structuredProperty = OafMapperUtils.structuredProperty((String)title, (Qualifier)ModelConstants.ALTERNATIVE_TITLE_QUALIFIER, null);
                    return structuredProperty;
                }
                throw new MatchError((Object)jValue);
            }
        });
        List shortTitles = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("short-title")).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue check$ifrefutable$5) {
                JsonAST.JValue jValue = check$ifrefutable$5;
                boolean bl = jValue instanceof JsonAST.JString;
                return bl;
            }
        }).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue x$9) {
                JsonAST.JValue jValue = x$9;
                if (jValue instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String title = jString.s();
                    boolean bl = new StringOps(Predef$.MODULE$.augmentString(title)).nonEmpty();
                    return bl;
                }
                throw new MatchError((Object)jValue);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructuredProperty apply(JsonAST.JValue x$10) {
                JsonAST.JValue jValue = x$10;
                if (jValue instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String title = jString.s();
                    StructuredProperty structuredProperty = OafMapperUtils.structuredProperty((String)title, (Qualifier)ModelConstants.ALTERNATIVE_TITLE_QUALIFIER, null);
                    return structuredProperty;
                }
                throw new MatchError((Object)jValue);
            }
        });
        List subtitles = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("subtitle")).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue check$ifrefutable$6) {
                JsonAST.JValue jValue = check$ifrefutable$6;
                boolean bl = jValue instanceof JsonAST.JString;
                return bl;
            }
        }).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue x$11) {
                JsonAST.JValue jValue = x$11;
                if (jValue instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String title = jString.s();
                    boolean bl = new StringOps(Predef$.MODULE$.augmentString(title)).nonEmpty();
                    return bl;
                }
                throw new MatchError((Object)jValue);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructuredProperty apply(JsonAST.JValue x$12) {
                JsonAST.JValue jValue = x$12;
                if (jValue instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String title = jString.s();
                    StructuredProperty structuredProperty = OafMapperUtils.structuredProperty((String)title, (Qualifier)ModelConstants.SUBTITLE_QUALIFIER, null);
                    return structuredProperty;
                }
                throw new MatchError((Object)jValue);
            }
        });
        List list3 = mainTitles;
        List list4 = originalTitles;
        List list5 = shortTitles;
        result.setTitle((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)subtitles.$colon$colon$colon(list5).$colon$colon$colon(list4).$colon$colon$colon(list3)).asJava());
        List descriptionList = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("abstract")).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue check$ifrefutable$7) {
                JsonAST.JValue jValue = check$ifrefutable$7;
                boolean bl = jValue instanceof JsonAST.JString;
                return bl;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Field<String> apply(JsonAST.JValue x$16) {
                JsonAST.JValue jValue = x$16;
                if (jValue instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String description = jString.s();
                    Field field = OafMapperUtils.field((Object)description, null);
                    return field;
                }
                throw new MatchError((Object)jValue);
            }
        });
        result.setDescription((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)descriptionList).asJava());
        List sourceList = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("source")).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue check$ifrefutable$8) {
                JsonAST.JValue jValue = check$ifrefutable$8;
                boolean bl = jValue instanceof JsonAST.JString;
                return bl;
            }
        }).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue x$17) {
                JsonAST.JValue jValue = x$17;
                if (jValue instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String source = jString.s();
                    boolean bl = source != null && new StringOps(Predef$.MODULE$.augmentString(source)).nonEmpty();
                    return bl;
                }
                throw new MatchError((Object)jValue);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Field<String> apply(JsonAST.JValue x$18) {
                JsonAST.JValue jValue = x$18;
                if (jValue instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String source = jString.s();
                    Field field = OafMapperUtils.field((Object)source, null);
                    return field;
                }
                throw new MatchError((Object)jValue);
            }
        });
        result.setSource((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)sourceList).asJava());
        StructuredProperty createdDate = this.generateDate((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("created")).$bslash("date-time")).extract((Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class)), (List<List<Object>>)((List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("created")).$bslash("date-parts")).extract((Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))), "created", "dnet:dataCite_date");
        StructuredProperty postedDate = this.generateDate((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("posted")).$bslash("date-time")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class)), (List<List<Object>>)((List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("posted")).$bslash("date-parts")).extract((Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))), "available", "dnet:dataCite_date");
        StructuredProperty acceptedDate = this.generateDate((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("accepted")).$bslash("date-time")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class)), (List<List<Object>>)((List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("accepted")).$bslash("date-parts")).extract((Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))), "accepted", "dnet:dataCite_date");
        StructuredProperty publishedPrintDate = this.generateDate((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("published-print")).$bslash("date-time")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class)), (List<List<Object>>)((List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("published-print")).$bslash("date-parts")).extract((Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))), "published-print", "dnet:dataCite_date");
        StructuredProperty publishedOnlineDate = this.generateDate((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("published-online")).$bslash("date-time")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class)), (List<List<Object>>)((List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("published-online")).$bslash("date-parts")).extract((Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))), "published-online", "dnet:dataCite_date");
        String issuedDate = this.extractDate((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("issued")).$bslash("date-time")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class)), (List<List<Object>>)((List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("issued")).$bslash("date-parts")).extract((Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))));
        if (StringUtils.isNotBlank((CharSequence)issuedDate)) {
            result.setDateofacceptance(OafMapperUtils.field((Object)issuedDate, null));
        } else {
            result.setDateofacceptance(OafMapperUtils.field((Object)createdDate.getValue(), null));
        }
        result.setRelevantdate((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{createdDate, postedDate, acceptedDate, publishedOnlineDate, publishedPrintDate})).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructuredProperty p) {
                return p != null;
            }
        })).asJava());
        List subjectList = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash("subject")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Nothing$> apply() {
                return Nil$.MODULE$;
            }
        }, (Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        if (subjectList.nonEmpty()) {
            result.setSubject((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)subjectList.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Subject apply(String s) {
                    return OafMapperUtils.subject((String)s, (Qualifier)ModelConstants.SUBTITLE_QUALIFIER, null);
                }
            }, List$.MODULE$.canBuildFrom())).asJava());
        }
        List authorList = (List)((TraversableLike)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash("author")).extract((Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(mappingAuthor.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(mappingAuthor a) {
                return a.family().isDefined();
            }
        });
        List sorted_list = (List)authorList.sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(mappingAuthor a, mappingAuthor b) {
                return a.sequence().isDefined() && ((String)a.sequence().get()).equalsIgnoreCase("first");
            }
        });
        result.setAuthor((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)sorted_list.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Author apply(Tuple2<mappingAuthor, Object> x0$1) {
                Tuple2<mappingAuthor, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    mappingAuthor a = (mappingAuthor)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Author author = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateAuthor((String)a.given().orNull(Predef$.MODULE$.$conforms()), (String)a.family().get(), (String)a.ORCID().orNull(Predef$.MODULE$.$conforms()), index, a.affiliation());
                    return author;
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom())).asJava());
        Instance instance = new Instance();
        List license = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("license")).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue check$ifrefutable$9) {
                JsonAST.JValue jValue = check$ifrefutable$9;
                boolean bl = jValue instanceof JsonAST.JObject;
                return bl;
            }
        }).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Tuple2<Field<String>, String>> apply(JsonAST.JValue x$21) {
                JsonAST.JValue jValue = x$21;
                if (jValue instanceof JsonAST.JObject) {
                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                    List license = jObject.obj();
                    List list = (List)license.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$10) {
                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$10;
                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                            if (option.isEmpty()) return false;
                            String string = (String)((Tuple2)option.get())._1();
                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                            if (!"URL".equals(string)) return false;
                            if (!(jValue instanceof JsonAST.JString)) return false;
                            return true;
                        }
                    }).flatMap((Function1)new Serializable(this, license){
                        public static final long serialVersionUID = 0L;
                        private final List license$1;

                        public final List<Tuple2<Field<String>, String>> apply(Tuple2<String, JsonAST.JValue> x$20) {
                            Tuple2<String, JsonAST.JValue> tuple2 = x$20;
                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                            if (!option.isEmpty()) {
                                String string = (String)((Tuple2)option.get())._1();
                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                if ("URL".equals(string) && jValue instanceof JsonAST.JString) {
                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                    String lic = jString.s();
                                    List list = (List)this.license$1.withFilter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$11) {
                                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$11;
                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                            if (option.isEmpty()) return false;
                                            String string = (String)((Tuple2)option.get())._1();
                                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                            if (!"content-version".equals(string)) return false;
                                            if (!(jValue instanceof JsonAST.JString)) return false;
                                            return true;
                                        }
                                    }).map((Function1)new Serializable(this, lic){
                                        public static final long serialVersionUID = 0L;
                                        private final String lic$1;

                                        public final Tuple2<Field<String>, String> apply(Tuple2<String, JsonAST.JValue> x$19) {
                                            Tuple2<String, JsonAST.JValue> tuple2 = x$19;
                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                            if (!option.isEmpty()) {
                                                String string = (String)((Tuple2)option.get())._1();
                                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                if ("content-version".equals(string) && jValue instanceof JsonAST.JString) {
                                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                                    String content_version = jString.s();
                                                    Tuple2 tuple22 = new Tuple2((Object)OafMapperUtils.field((Object)this.lic$1, null), (Object)content_version);
                                                    return tuple22;
                                                }
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            this.lic$1 = lic$1;
                                        }
                                    }, List$.MODULE$.canBuildFrom());
                                    return list;
                                }
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.license$1 = license$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    return list;
                }
                throw new MatchError((Object)jValue);
            }
        });
        List l = (List)license.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Field<String>, String> d) {
                return StringUtils.isNotBlank((CharSequence)((CharSequence)((Field)d._1()).getValue()));
            }
        });
        if (l.nonEmpty()) {
            if (l.exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Field<String>, String> d) {
                    return ((String)d._2()).equals("vor");
                }
            })) {
                l.foreach((Function1)new Serializable(instance){
                    public static final long serialVersionUID = 0L;
                    private final Instance instance$1;

                    public final void apply(Tuple2<Field<String>, String> d) {
                        if (((String)d._2()).equals("vor")) {
                            this.instance$1.setLicense((Field)d._1());
                        }
                    }
                    {
                        this.instance$1 = instance$1;
                    }
                });
            } else {
                instance.setLicense((Field)((Tuple2)l.head())._1());
            }
        }
        instance.setPid(result.getPid());
        JsonAST.JValue jValue = has_review = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("relation")).$bslash("has-review")).$bslash("id");
        JsonAST.JNothing$ jNothing$ = JsonAST.JNothing$.MODULE$;
        if (jValue == null ? jNothing$ != null : !jValue.equals(jNothing$)) {
            instance.setRefereed(OafMapperUtils.qualifier((String)"0001", (String)"peerReviewed", (String)"dnet:review_levels", (String)"dnet:review_levels"));
        }
        if (doi.startsWith("10.3410") || doi.startsWith("10.12703")) {
            instance.setHostedby(OafMapperUtils.keyValue((String)OafMapperUtils.createOpenaireId((int)10, (String)"openaire____::H1Connect", (boolean)true), (String)"H1Connect"));
        }
        instance.setAccessright(this.decideAccessRight((Field<String>)instance.getLicense(), (String)result.getDateofacceptance().getValue()));
        instance.setInstancetype(instanceType);
        InstanceTypeMapping itm = new InstanceTypeMapping();
        itm.setOriginalType(originalType);
        itm.setVocabularyName("openaire::coar_resource_types_3_1");
        instance.setInstanceTypeMapping((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InstanceTypeMapping[]{itm}))).asJava());
        instance.setCollectedfrom(this.createCrossrefCollectedFrom());
        if (StringUtils.isNotBlank((CharSequence)issuedDate)) {
            instance.setDateofacceptance(OafMapperUtils.field((Object)issuedDate, null));
        } else {
            instance.setDateofacceptance(OafMapperUtils.field((Object)createdDate.getValue(), null));
        }
        List s = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"https://doi.org/").append((Object)doi).toString()}));
        if (s.nonEmpty()) {
            instance.setUrl((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)s).asJava());
        }
        result.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{instance}))).asJava());
        String oldId = this.generateIdentifier(result, doi);
        result.setId(oldId);
        String newId = IdentifierFactory.createDOIBoostIdentifier((Result)result);
        Object object = oldId.equalsIgnoreCase(newId) ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)result.getOriginalId().add(oldId));
        result.setId(newId);
        return result.getId() == null ? null : result;
    }

    public String generateIdentifier(Result oaf, String doi) {
        String id = DHPUtils.md5((String)doi.toLowerCase());
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"50|doiboost____|", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id}));
    }

    public Author eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateAuthor(String given, String family, String orcid, int index, Option<List<mappingAffiliation>> affiliation) {
        Author a = new Author();
        a.setName(given);
        a.setSurname(family);
        a.setFullname(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{given, family})));
        a.setRank(Predef$.MODULE$.int2Integer(index + 1));
        if (affiliation.isDefined()) {
            a.setRawAffiliationString((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)affiliation.get()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(mappingAffiliation a) {
                    return a.name();
                }
            }, List$.MODULE$.canBuildFrom())).asJava());
        }
        if (StringUtils.isNotBlank((CharSequence)orcid)) {
            a.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{OafMapperUtils.structuredProperty((String)orcid, (Qualifier)OafMapperUtils.qualifier((String)"orcid_pending", (String)"orcid_pending", (String)"dnet:pid_types", (String)"dnet:pid_types"), (DataInfo)this.generateDataInfo())}))).asJava());
        }
        return a;
    }

    public Tuple3<Qualifier, Qualifier, String> getTypeQualifier(String resourceType, VocabularyGroup vocabularies) {
        Qualifier typeQualifier;
        if (resourceType != null && new StringOps(Predef$.MODULE$.augmentString(resourceType)).nonEmpty() && (typeQualifier = vocabularies.getSynonymAsQualifier("dnet:publication_resource", resourceType)) != null) {
            return new Tuple3((Object)typeQualifier, (Object)vocabularies.getSynonymAsQualifier("dnet:result_typologies", typeQualifier.getClassid()), (Object)resourceType);
        }
        return null;
    }

    public Result mergeUnpayWall(Result r, UnpayWall uw) {
        if (uw != null) {
            r.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{(KeyValue)r.getCollectedfrom().get(0), this.createUnpayWallCollectedFrom()}))).asJava());
            Instance i = new Instance();
            i.setCollectedfrom(this.createUnpayWallCollectedFrom());
            if (uw.best_oa_location() != null) {
                Option<OpenAccessRoute> colour;
                i.setUrl((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{uw.best_oa_location().url()}))).asJava());
                if (uw.best_oa_location().license().isDefined()) {
                    i.setLicense(OafMapperUtils.field((Object)uw.best_oa_location().license().get(), null));
                }
                if ((colour = this.get_unpaywall_color(uw.oa_status())).isDefined()) {
                    AccessRight a = new AccessRight();
                    a.setClassid("OPEN");
                    a.setClassname("OPEN");
                    a.setSchemeid("dnet:access_modes");
                    a.setSchemename("dnet:access_modes");
                    a.setOpenAccessRoute((OpenAccessRoute)colour.get());
                    i.setAccessright(a);
                }
                i.setInstancetype(((Instance)r.getInstance().get(0)).getInstancetype());
                i.setInstanceTypeMapping(((Instance)r.getInstance().get(0)).getInstanceTypeMapping());
                i.setPid(r.getPid());
                r.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{(Instance)r.getInstance().get(0), i}))).asJava());
            }
        }
        return r;
    }

    public List<String> generateAffliation(Row input) {
        String doi = input.getString(0);
        String rorId = input.getString(1);
        String pubId = IdentifierFactory.idFromPid((String)"50", (String)"doi", (String)DoiCleaningRule.clean((String)doi), (boolean)true);
        String affId = GenerateRorActionSetJob.calculateOpenaireId(rorId);
        Relation r = new Relation();
        r.setSource(pubId);
        r.setTarget(affId);
        r.setRelType("resultOrganization");
        r.setRelClass("hasAuthorInstitution");
        r.setSubRelType("affiliation");
        r.setDataInfo(this.generateDataInfo());
        r.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{this.createCrossrefCollectedFrom()}))).asJava());
        Relation r1 = new Relation();
        r1.setTarget(pubId);
        r1.setSource(affId);
        r1.setRelType("resultOrganization");
        r1.setRelClass("isAuthorInstitutionOf");
        r1.setSubRelType("affiliation");
        r1.setDataInfo(this.generateDataInfo());
        r1.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{this.createCrossrefCollectedFrom()}))).asJava());
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.mapper().writeValueAsString((Object)r), this.mapper().writeValueAsString((Object)r1)}));
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<Oaf> convert(String input, VocabularyGroup vocabularies, Enumeration.Value mode) {
        Nil$ nil$;
        Nil$ resultList;
        block19: {
            Result result;
            block18: {
                block17: {
                    List doisReference;
                    List funderList;
                    VolatileByteRef bitmap$0;
                    ObjectRef json$lzy;
                    ObjectRef formats$lzy;
                    block16: {
                        Tuple3<Qualifier, Qualifier, String> typology;
                        formats$lzy = ObjectRef.zero();
                        json$lzy = ObjectRef.zero();
                        bitmap$0 = VolatileByteRef.create((byte)0);
                        resultList = Nil$.MODULE$;
                        String objectType = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$2(input, json$lzy, bitmap$0)).$bslash("type")).extractOrElse((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Null$ apply() {
                                return null;
                            }
                        }, (Formats)this.formats$3(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
                        if (objectType == null) {
                            return resultList;
                        }
                        JsonAST.JValue is_review = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$2(input, json$lzy, bitmap$0)).$bslash("relation")).$bslash("is-review-of")).$bslash("id");
                        boolean force_to_review = false;
                        JsonAST.JValue jValue = is_review;
                        JsonAST.JNothing$ jNothing$ = JsonAST.JNothing$.MODULE$;
                        if (jValue == null ? jNothing$ != null : !jValue.equals(jNothing$)) {
                            force_to_review = true;
                        }
                        if ((typology = this.getTypeQualifier(force_to_review ? "peer-review" : objectType, vocabularies)) == null) {
                            return Nil$.MODULE$;
                        }
                        result = this.generateItemFromType((Qualifier)typology._2());
                        if (result == null) {
                            return Nil$.MODULE$;
                        }
                        this.mappingResult(result, this.json$2(input, json$lzy, bitmap$0), (Qualifier)typology._1(), (String)typology._3());
                        if (result == null) return Nil$.MODULE$;
                        if (result.getId() == null) {
                            return Nil$.MODULE$;
                        }
                        Result result2 = result;
                        if (result2 instanceof Publication) {
                            Publication publication = (Publication)result2;
                            this.convertPublication(publication, this.json$2(input, json$lzy, bitmap$0), (Qualifier)typology._1());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            if (!(result2 instanceof Dataset)) throw new MatchError((Object)result2);
                            Dataset dataset = (Dataset)result2;
                            this.convertDataset(dataset);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        Enumeration.Value value = mode;
                        Enumeration.Value value2 = Crossref2Oaf$TransformationType$.MODULE$.OnlyRelation();
                        if (!(value == null ? value2 != null : !value.equals(value2))) break block16;
                        Enumeration.Value value3 = mode;
                        Enumeration.Value value4 = Crossref2Oaf$TransformationType$.MODULE$.All();
                        if (value3 != null ? !value3.equals(value4) : value4 != null) break block17;
                    }
                    if ((funderList = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$2(input, json$lzy, bitmap$0)).$bslash("funder")).extractOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final List<Nothing$> apply() {
                            return Nil$.MODULE$;
                        }
                    }, (Formats)this.formats$3(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(mappingFunder.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).nonEmpty()) {
                        Nil$ nil$2 = resultList;
                        resultList = this.mappingFunderToRelations((List<mappingFunder>)funderList, result.getId(), this.createCrossrefCollectedFrom(), result.getDataInfo(), Predef$.MODULE$.Long2long(result.getLastupdatetimestamp())).$colon$colon$colon((List)nil$2);
                    }
                    if ((doisReference = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$2(input, json$lzy, bitmap$0)).$bslash("reference")).withFilter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(JsonAST.JValue check$ifrefutable$12) {
                            JsonAST.JValue jValue = check$ifrefutable$12;
                            boolean bl = jValue instanceof JsonAST.JObject;
                            return bl;
                        }
                    }).flatMap((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final List<String> apply(JsonAST.JValue x$24) {
                            JsonAST.JValue jValue = x$24;
                            if (jValue instanceof JsonAST.JObject) {
                                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                                List reference_json = jObject.obj();
                                List list = (List)reference_json.withFilter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$13) {
                                        Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$13;
                                        Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                        if (option.isEmpty()) return false;
                                        String string = (String)((Tuple2)option.get())._1();
                                        JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                        if (!"DOI".equals(string)) return false;
                                        if (!(jValue instanceof JsonAST.JString)) return false;
                                        return true;
                                    }
                                }).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(Tuple2<String, JsonAST.JValue> x$23) {
                                        Tuple2<String, JsonAST.JValue> tuple2 = x$23;
                                        Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                        if (!option.isEmpty()) {
                                            String string = (String)((Tuple2)option.get())._1();
                                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                            if ("DOI".equals(string) && jValue instanceof JsonAST.JString) {
                                                String doi_json;
                                                JsonAST.JString jString = (JsonAST.JString)jValue;
                                                String string2 = doi_json = jString.s();
                                                return string2;
                                            }
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                }, List$.MODULE$.canBuildFrom());
                                return list;
                            }
                            throw new MatchError((Object)jValue);
                        }
                    })) != null && doisReference.nonEmpty()) {
                        List<Relation> citation_relations = this.generateCitationRelations((List<String>)doisReference, result);
                        Nil$ nil$3 = resultList;
                        resultList = citation_relations.$colon$colon$colon((List)nil$3);
                    }
                }
                if (!this.filterResult(result)) {
                    nil$ = Nil$.MODULE$;
                    return nil$;
                }
                Enumeration.Value value = mode;
                Enumeration.Value value5 = Crossref2Oaf$TransformationType$.MODULE$.OnlyResult();
                if (!(value == null ? value5 != null : !value.equals(value5))) break block18;
                Enumeration.Value value6 = mode;
                Enumeration.Value value7 = Crossref2Oaf$TransformationType$.MODULE$.All();
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block19;
            }
            Nil$ nil$4 = resultList;
            nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Result[]{result})).$colon$colon$colon((List)nil$4);
            return nil$;
        }
        nil$ = resultList;
        return nil$;
    }

    public List<Relation> eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$createCiteRelation(Result source, String targetPid, String targetPidType) {
        String targetId = IdentifierFactory.idFromPid((String)"50", (String)targetPidType, (String)targetPid, (boolean)true);
        Relation from = new Relation();
        from.setSource(source.getId());
        from.setTarget(targetId);
        from.setRelType("resultResult");
        from.setRelClass("Cites");
        from.setSubRelType("citation");
        from.setCollectedfrom(source.getCollectedfrom());
        from.setDataInfo(source.getDataInfo());
        from.setLastupdatetimestamp(source.getLastupdatetimestamp());
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relation[]{from}));
    }

    public List<Relation> generateCitationRelations(List<String> dois, Result result) {
        return (List)dois.flatMap((Function1)new Serializable(result){
            public static final long serialVersionUID = 0L;
            private final Result result$1;

            public final List<Relation> apply(String d) {
                return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$createCiteRelation(this.result$1, d, "doi");
            }
            {
                this.result$1 = result$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public List<Relation> mappingFunderToRelations(List<mappingFunder> funders, String sourceId, KeyValue cf, DataInfo di, long ts) {
        Queue queue = new Queue();
        if (funders != null) {
            funders.foreach((Function1)new Serializable(sourceId, cf, di, ts, queue){
                public static final long serialVersionUID = 0L;
                private final String sourceId$1;
                private final KeyValue cf$1;
                private final DataInfo di$1;
                private final long ts$1;
                private final Queue queue$1;

                public final Object apply(mappingFunder funder) {
                    BoxedUnit boxedUnit;
                    if (funder.DOI().isDefined() && new StringOps(Predef$.MODULE$.augmentString((String)funder.DOI().get())).nonEmpty()) {
                        BoxedUnit boxedUnit2;
                        BoxedUnit boxedUnit3;
                        if (Crossref2Oaf$.MODULE$.getIrishId((String)funder.DOI().get()).isDefined()) {
                            String nsPrefix = (String)new StringOps(Predef$.MODULE$.augmentString((String)Crossref2Oaf$.MODULE$.getIrishId((String)funder.DOI().get()).get())).padTo(12, (Object)BoxesRunTime.boxToCharacter((char)'_'), Predef$.MODULE$.StringCanBuildFrom());
                            String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1(nsPrefix, "1e5e62235d094afd01cd56e65112fc63");
                            this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                            boxedUnit3 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        String string = (String)funder.DOI().get();
                        boolean bl = "10.13039/100010663".equals(string) ? true : ("10.13039/100010661".equals(string) ? true : ("10.13039/501100007601".equals(string) ? true : ("10.13039/501100000780".equals(string) ? true : "10.13039/100010665".equals(string))));
                        if (bl) {
                            Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "corda__h2020", (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String award) {
                                    return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$extractECAward$1(award);
                                }
                            }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boolean bl2 = "10.13039/100011199".equals(string) ? true : ("10.13039/100004431".equals(string) ? true : ("10.13039/501100004963".equals(string) ? true : "10.13039/501100000780".equals(string)));
                            if (bl2) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "corda_______", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String award) {
                                        return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$extractECAward$1(award);
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("10.13039/501100000781".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "corda_______", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String award) {
                                        return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$extractECAward$1(award);
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "corda__h2020", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String award) {
                                        return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$extractECAward$1(award);
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "corda_____he", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String award) {
                                        return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$extractECAward$1(award);
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("10.13039/100000001".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "nsf_________", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String a) {
                                        return a;
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("10.13039/501100001665".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "anr_________", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String a) {
                                        return a;
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("10.13039/501100002341".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "aka_________", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String a) {
                                        return a;
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("10.13039/501100001602".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "sfi_________", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String a) {
                                        return a.replace("SFI", "");
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("10.13039/501100000923".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "arc_________", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String a) {
                                        return a;
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("10.13039/501100000038".equals(string)) {
                                String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("nserc_______", "1e5e62235d094afd01cd56e65112fc63");
                                this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                boxedUnit2 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                            } else if ("10.13039/501100000155".equals(string)) {
                                String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("sshrc_______", "1e5e62235d094afd01cd56e65112fc63");
                                this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                boxedUnit2 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                            } else if ("10.13039/501100000024".equals(string)) {
                                String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("cihr________", "1e5e62235d094afd01cd56e65112fc63");
                                this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                boxedUnit2 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                            } else if ("10.13039/501100001659".equals(string)) {
                                String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("dfgf________", "1e5e62235d094afd01cd56e65112fc63");
                                this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                boxedUnit2 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                            } else if ("10.13039/100020031".equals(string)) {
                                String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("tara________", "1e5e62235d094afd01cd56e65112fc63");
                                this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                boxedUnit2 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                            } else if ("10.13039/501100005416".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "rcn_________", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String a) {
                                        return a;
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("10.13039/501100002848".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "conicytf____", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String a) {
                                        return a;
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("10.13039/501100003448".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "gsrt________", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String award) {
                                        return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$extractECAward$1(award);
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("10.13039/501100010198".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "sgov________", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String a) {
                                        return a;
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("10.13039/501100004564".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "mestd_______", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String award) {
                                        return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$extractECAward$1(award);
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if ("10.13039/501100003407".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "miur________", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String a) {
                                        return a;
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("miur________", "1e5e62235d094afd01cd56e65112fc63");
                                this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                boxedUnit2 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                            } else {
                                boolean bl3 = "10.13039/501100006588".equals(string) ? true : "10.13039/501100004488".equals(string);
                                if (bl3) {
                                    Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "irb_hr______", (Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(String a) {
                                            return a.replaceAll("Project No.", "").replaceAll("HRZZ-", "");
                                        }
                                    }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else if ("10.13039/501100006769".equals(string)) {
                                    Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "rsf_________", (Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(String a) {
                                            return a;
                                        }
                                    }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else if ("10.13039/501100001711".equals(string)) {
                                    Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "snsf________", (Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(String award) {
                                            return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$snsfRule$1(award);
                                        }
                                    }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else if ("10.13039/501100004410".equals(string)) {
                                    Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "tubitakf____", (Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(String a) {
                                            return a;
                                        }
                                    }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else if ("10.13039/100004440".equals(string)) {
                                    Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "wt__________", (Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(String a) {
                                            return a;
                                        }
                                    }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                    String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("wt__________", "1e5e62235d094afd01cd56e65112fc63");
                                    this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                    boxedUnit2 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                                } else if ("10.13039/100018231".equals(string)) {
                                    Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "asap________", (Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(String a) {
                                            return a;
                                        }
                                    }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else if ("10.13039/501100001942".equals(string)) {
                                    String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("chistera____", "1e5e62235d094afd01cd56e65112fc63");
                                    this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                    boxedUnit2 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                                } else {
                                    boolean bl4 = "10.13039/100018693".equals(string) ? true : ("10.13039/100018694".equals(string) ? true : ("10.13039/100019188".equals(string) ? true : ("10.13039/100019180".equals(string) ? true : ("10.13039/100018695".equals(string) ? true : ("10.13039/100019185".equals(string) ? true : ("10.13039/100019186".equals(string) ? true : "10.13039/100019187".equals(string)))))));
                                    if (bl4) {
                                        Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "corda_____he", (Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(String award) {
                                                return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$extractECAward$1(award);
                                            }
                                        }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else if ("10.13039/501100001871".equals(string)) {
                                        Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "fct_________", (Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(String a) {
                                                return a;
                                            }
                                        }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else if ("10.13039/501100000925".equals(string)) {
                                        Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "nhmrc_______", (Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(String a) {
                                                return a;
                                            }
                                        }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else if ("10.13039/100000002".equals(string)) {
                                        Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "nih_________", (Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(String a) {
                                                return a;
                                            }
                                        }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else if ("10.13039/501100003246".equals(string)) {
                                        Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "nwo_________", (Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(String a) {
                                                return a;
                                            }
                                        }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        boolean bl5 = "10.13039/100014013".equals(string) ? true : ("10.13039/501100000267".equals(string) ? true : ("10.13039/501100000268".equals(string) ? true : ("10.13039/501100000269".equals(string) ? true : ("10.13039/501100000266".equals(string) ? true : ("10.13039/501100006041".equals(string) ? true : ("10.13039/501100000265".equals(string) ? true : ("10.13039/501100000270".equals(string) ? true : ("10.13039/501100013589".equals(string) ? true : "10.13039/501100000271".equals(string)))))))));
                                        if (bl5) {
                                            Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "ukri________", (Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply(String a) {
                                                    return a;
                                                }
                                            }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        } else if ("10.13039/501100013209".equals(string)) {
                                            Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "hfri________", (Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply(String a) {
                                                    return a;
                                                }
                                            }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                            String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("hfri________", "1e5e62235d094afd01cd56e65112fc63");
                                            this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                            boxedUnit2 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                                        } else if ("10.13039/501100010790".equals(string)) {
                                            Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "erasmusplus_", (Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply(String a) {
                                                    return a;
                                                }
                                            }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        } else if ("10.13039/501100004836".equals(string)) {
                                            Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "irfd________", (Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply(String a) {
                                                    return a;
                                                }
                                            }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                            String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("irfd________", "1e5e62235d094afd01cd56e65112fc63");
                                            this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                            boxedUnit2 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                                        } else if ("10.13039/501100002808".equals(string)) {
                                            Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "cf__________", (Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply(String a) {
                                                    return a;
                                                }
                                            }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                            String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("cf__________", "1e5e62235d094afd01cd56e65112fc63");
                                            this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                            boxedUnit2 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                                        } else if ("10.13039/501100009708".equals(string)) {
                                            Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "nnf___________", (Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply(String a) {
                                                    return a;
                                                }
                                            }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                            String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("nnf_________", "1e5e62235d094afd01cd56e65112fc63");
                                            this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                            boxedUnit2 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                                        } else if ("10.13039/501100018877".equals(string)) {
                                            Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "rif___________", (Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply(String a) {
                                                    return a;
                                                }
                                            }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                            String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("rif_________", "1e5e62235d094afd01cd56e65112fc63");
                                            this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                            boxedUnit2 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                                        } else {
                                            Crossref2Oaf$.MODULE$.logger().debug(new StringBuilder().append((Object)"no match for ").append(funder.DOI().get()).toString());
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        }
                                    }
                                }
                            }
                        }
                        boxedUnit = boxedUnit2;
                    } else {
                        BoxedUnit boxedUnit4;
                        String string = funder.name();
                        if ("European Union\u2019s Horizon 2020 research and innovation program".equals(string)) {
                            Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "corda__h2020", (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String award) {
                                    return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$extractECAward$1(award);
                                }
                            }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else if ("European Union's".equals(string)) {
                            Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "corda__h2020", (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String award) {
                                    return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$extractECAward$1(award);
                                }
                            }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                            Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "corda_______", (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String award) {
                                    return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$extractECAward$1(award);
                                }
                            }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                            Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "corda_____he", (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String award) {
                                    return Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$extractECAward$1(award);
                                }
                            }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boolean bl = "The French National Research Agency (ANR)".equals(string) ? true : "The French National Research Agency".equals(string);
                            if (bl) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "anr_________", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String a) {
                                        return a;
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit4 = BoxedUnit.UNIT;
                            } else if ("CONICYT, Programa de Formaci\u00f3n de Capital Humano Avanzado".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "conicytf____", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String a) {
                                        return a;
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                boxedUnit4 = BoxedUnit.UNIT;
                            } else if ("Wellcome Trust Masters Fellowship".equals(string)) {
                                Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(funder, "wt__________", (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String a) {
                                        return a;
                                    }
                                }, this.sourceId$1, this.cf$1, this.di$1, this.ts$1, this.queue$1);
                                String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1("wt__________", "1e5e62235d094afd01cd56e65112fc63");
                                this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                                boxedUnit4 = this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                            } else {
                                Crossref2Oaf$.MODULE$.logger().debug(new StringBuilder().append((Object)"no match for ").append((Object)funder.name()).toString());
                                boxedUnit4 = BoxedUnit.UNIT;
                            }
                        }
                        boxedUnit = boxedUnit4;
                    }
                    return boxedUnit;
                }
                {
                    this.sourceId$1 = sourceId$1;
                    this.cf$1 = cf$1;
                    this.di$1 = di$1;
                    this.ts$1 = ts$1;
                    this.queue$1 = queue$1;
                }
            });
        }
        return queue.toList();
    }

    public void convertDataset(Dataset dataset) {
    }

    public void convertPublication(Publication publication, JsonAST.JValue json, Qualifier cobjCategory) {
        ObjectRef formats$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        List containerTitles = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("container-title")).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue check$ifrefutable$14) {
                JsonAST.JValue jValue = check$ifrefutable$14;
                boolean bl = jValue instanceof JsonAST.JString;
                return bl;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(JsonAST.JValue x$27) {
                JsonAST.JValue jValue = x$27;
                if (jValue instanceof JsonAST.JString) {
                    String ct;
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String string = ct = jString.s();
                    return string;
                }
                throw new MatchError((Object)jValue);
            }
        });
        if (cobjCategory.getClassname().toLowerCase().contains("book")) {
            List ISBN = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("ISBN")).withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(JsonAST.JValue check$ifrefutable$15) {
                    JsonAST.JValue jValue = check$ifrefutable$15;
                    boolean bl = jValue instanceof JsonAST.JString;
                    return bl;
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(JsonAST.JValue x$28) {
                    JsonAST.JValue jValue = x$28;
                    if (jValue instanceof JsonAST.JString) {
                        String isbn;
                        JsonAST.JString jString = (JsonAST.JString)jValue;
                        String string = isbn = jString.s();
                        return string;
                    }
                    throw new MatchError((Object)jValue);
                }
            });
            if (ISBN.nonEmpty() && containerTitles.nonEmpty()) {
                String source = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ISBN: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{containerTitles.head(), ISBN.head()}));
                if (publication.getSource() == null) {
                    publication.setSource((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Field[]{OafMapperUtils.field((Object)source, null)}))).asJava());
                } else {
                    List l;
                    List list = l = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getSource()).asScala()).toList();
                    List ll = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Field[]{OafMapperUtils.field((Object)source, null)})).$colon$colon$colon(list);
                    publication.setSource((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ll).asJava());
                }
            }
        } else {
            List issnInfos = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("issn-type")).withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(JsonAST.JValue check$ifrefutable$16) {
                    JsonAST.JValue jValue = check$ifrefutable$16;
                    boolean bl = jValue instanceof JsonAST.JArray;
                    return bl;
                }
            }).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final List<Tuple2<String, String>> apply(JsonAST.JValue x$33) {
                    JsonAST.JValue jValue = x$33;
                    if (jValue instanceof JsonAST.JArray) {
                        JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                        List issn_types = jArray.arr();
                        List list = (List)issn_types.withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(JsonAST.JValue check$ifrefutable$17) {
                                JsonAST.JValue jValue = check$ifrefutable$17;
                                boolean bl = jValue instanceof JsonAST.JObject;
                                return bl;
                            }
                        }).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final List<Tuple2<String, String>> apply(JsonAST.JValue x$32) {
                                JsonAST.JValue jValue = x$32;
                                if (jValue instanceof JsonAST.JObject) {
                                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                                    List issn_type = jObject.obj();
                                    List list = (List)issn_type.withFilter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$18) {
                                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$18;
                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                            if (option.isEmpty()) return false;
                                            String string = (String)((Tuple2)option.get())._1();
                                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                            if (!"type".equals(string)) return false;
                                            if (!(jValue instanceof JsonAST.JString)) return false;
                                            return true;
                                        }
                                    }).flatMap((Function1)new Serializable(this, issn_type){
                                        public static final long serialVersionUID = 0L;
                                        private final List issn_type$1;

                                        public final List<Tuple2<String, String>> apply(Tuple2<String, JsonAST.JValue> x$31) {
                                            Tuple2<String, JsonAST.JValue> tuple2 = x$31;
                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                            if (!option.isEmpty()) {
                                                String string = (String)((Tuple2)option.get())._1();
                                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                if ("type".equals(string) && jValue instanceof JsonAST.JString) {
                                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                                    String tp = jString.s();
                                                    List list = (List)this.issn_type$1.withFilter((Function1)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        /*
                                                         * Enabled force condition propagation
                                                         * Lifted jumps to return sites
                                                         */
                                                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$19) {
                                                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$19;
                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                            if (option.isEmpty()) return false;
                                                            String string = (String)((Tuple2)option.get())._1();
                                                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                            if (!"value".equals(string)) return false;
                                                            if (!(jValue instanceof JsonAST.JString)) return false;
                                                            return true;
                                                        }
                                                    }).map((Function1)new Serializable(this, tp){
                                                        public static final long serialVersionUID = 0L;
                                                        private final String tp$1;

                                                        public final Tuple2<String, String> apply(Tuple2<String, JsonAST.JValue> x$30) {
                                                            Tuple2<String, JsonAST.JValue> tuple2 = x$30;
                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                            if (!option.isEmpty()) {
                                                                String string = (String)((Tuple2)option.get())._1();
                                                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                if ("value".equals(string) && jValue instanceof JsonAST.JString) {
                                                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                    String vl = jString.s();
                                                                    Tuple2 tuple22 = new Tuple2((Object)this.tp$1, (Object)vl);
                                                                    return tuple22;
                                                                }
                                                            }
                                                            throw new MatchError(tuple2);
                                                        }
                                                        {
                                                            this.tp$1 = tp$1;
                                                        }
                                                    }, List$.MODULE$.canBuildFrom());
                                                    return list;
                                                }
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            this.issn_type$1 = issn_type$1;
                                        }
                                    }, List$.MODULE$.canBuildFrom());
                                    return list;
                                }
                                throw new MatchError((Object)jValue);
                            }
                        }, List$.MODULE$.canBuildFrom());
                        return list;
                    }
                    throw new MatchError((Object)jValue);
                }
            });
            String volume = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash("volume")).extractOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }, (Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
            if (containerTitles.nonEmpty()) {
                Journal journal = new Journal();
                journal.setName((String)containerTitles.head());
                if (issnInfos.nonEmpty()) {
                    issnInfos.foreach((Function1)new Serializable(journal){
                        public static final long serialVersionUID = 0L;
                        private final Journal journal$1;

                        public final void apply(Tuple2<String, String> tp) {
                            String string = (String)tp._1();
                            if ("electronic".equals(string)) {
                                this.journal$1.setIssnOnline((String)tp._2());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else if ("print".equals(string)) {
                                this.journal$1.setIssnPrinted((String)tp._2());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        {
                            this.journal$1 = journal$1;
                        }
                    });
                }
                journal.setVol(volume);
                String page = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash("page")).extractOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }, (Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
                if (page != null) {
                    String[] pp = page.split("-");
                    if (Predef$.MODULE$.refArrayOps((Object[])pp).nonEmpty()) {
                        journal.setSp((String)Predef$.MODULE$.refArrayOps((Object[])pp).head());
                    }
                    if (Predef$.MODULE$.refArrayOps((Object[])pp).size() > 1) {
                        journal.setEp(pp[1]);
                    }
                }
                publication.setJournal(journal);
            }
        }
    }

    public String extractDate(String dt, List<List<Object>> datePart) {
        if (StringUtils.isNotBlank((CharSequence)dt)) {
            return GraphCleaningFunctions.cleanDate((String)dt);
        }
        if (datePart != null && datePart.size() == 1) {
            List res = (List)datePart.head();
            if (res.size() == 3) {
                Object arg$macro$1 = res.head();
                int arg$macro$2 = BoxesRunTime.unboxToInt((Object)res.apply(1));
                int arg$macro$3 = BoxesRunTime.unboxToInt((Object)res.apply(2));
                String dp = new StringOps("%s-%02d-%02d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToInteger((int)arg$macro$2), BoxesRunTime.boxToInteger((int)arg$macro$3)}));
                if (dp.length() == 10) {
                    return GraphCleaningFunctions.cleanDate((String)dp);
                }
            } else {
                if (res.size() == 2) {
                    Object arg$macro$4 = res.head();
                    int arg$macro$5 = BoxesRunTime.unboxToInt((Object)res.apply(1));
                    String dp = new StringOps("%s-%02d-01").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$4, BoxesRunTime.boxToInteger((int)arg$macro$5)}));
                    return GraphCleaningFunctions.cleanDate((String)dp);
                }
                if (res.size() == 1) {
                    return GraphCleaningFunctions.cleanDate((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-01-01"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{res.head()})));
                }
            }
        }
        return null;
    }

    public StructuredProperty generateDate(String dt, List<List<Object>> datePart, String classId, String schemeId) {
        String dp = this.extractDate(dt, datePart);
        if (StringUtils.isNotBlank((CharSequence)dp)) {
            return OafMapperUtils.structuredProperty((String)dp, (Qualifier)OafMapperUtils.qualifier((String)classId, (String)classId, (String)schemeId, (String)schemeId), null);
        }
        return null;
    }

    public Result generateItemFromType(Qualifier objectType) {
        if (objectType.getClassid().equalsIgnoreCase("publication")) {
            Publication item = new Publication();
            item.setResourcetype(objectType);
            return item;
        }
        if (objectType.getClassid().equalsIgnoreCase("dataset")) {
            Dataset item = new Dataset();
            item.setResourcetype(objectType);
            return item;
        }
        if (objectType.getClassid().equalsIgnoreCase("software")) {
            Software item = new Software();
            item.setResourcetype(objectType);
            return item;
        }
        if (objectType.getClassid().equalsIgnoreCase("OtherResearchProduct")) {
            OtherResearchProduct item = new OtherResearchProduct();
            item.setResourcetype(objectType);
            return item;
        }
        return null;
    }

    public String productPrefix() {
        return "Crossref2Oaf";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Crossref2Oaf$;
    }

    public int hashCode() {
        return -1029170635;
    }

    public String toString() {
        return "Crossref2Oaf";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final DefaultFormats$ formats$lzycompute$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        Crossref2Oaf$ crossref2Oaf$ = this;
        synchronized (crossref2Oaf$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                formats$lzy$1.elem = DefaultFormats$.MODULE$;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$1.elem;
        }
    }

    private final DefaultFormats$ formats$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.formats$lzycompute$1(formats$lzy$1, bitmap$0$1) : (DefaultFormats$)formats$lzy$1.elem;
    }

    private final JsonAST.JValue json$lzycompute$1(String s$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        Crossref2Oaf$ crossref2Oaf$ = this;
        synchronized (crossref2Oaf$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                json$lzy$1.elem = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(s$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$1.elem;
        }
    }

    private final JsonAST.JValue json$1(String s$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.json$lzycompute$1(s$1, json$lzy$1, bitmap$0$1) : (JsonAST.JValue)json$lzy$1.elem;
    }

    private final DefaultFormats$ formats$lzycompute$2(ObjectRef formats$lzy$2, VolatileByteRef bitmap$0$2) {
        Crossref2Oaf$ crossref2Oaf$ = this;
        synchronized (crossref2Oaf$) {
            if ((byte)(bitmap$0$2.elem & 1) == 0) {
                formats$lzy$2.elem = DefaultFormats$.MODULE$;
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$2.elem;
        }
    }

    private final DefaultFormats$ formats$2(ObjectRef formats$lzy$2, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 1) == 0 ? this.formats$lzycompute$2(formats$lzy$2, bitmap$0$2) : (DefaultFormats$)formats$lzy$2.elem;
    }

    private final DefaultFormats$ formats$lzycompute$3(ObjectRef formats$lzy$3, VolatileByteRef bitmap$0$3) {
        Crossref2Oaf$ crossref2Oaf$ = this;
        synchronized (crossref2Oaf$) {
            if ((byte)(bitmap$0$3.elem & 1) == 0) {
                formats$lzy$3.elem = DefaultFormats$.MODULE$;
                bitmap$0$3.elem = (byte)(bitmap$0$3.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$3.elem;
        }
    }

    private final DefaultFormats$ formats$3(ObjectRef formats$lzy$3, VolatileByteRef bitmap$0$3) {
        return (byte)(bitmap$0$3.elem & 1) == 0 ? this.formats$lzycompute$3(formats$lzy$3, bitmap$0$3) : (DefaultFormats$)formats$lzy$3.elem;
    }

    private final JsonAST.JValue json$lzycompute$2(String input$1, ObjectRef json$lzy$2, VolatileByteRef bitmap$0$3) {
        Crossref2Oaf$ crossref2Oaf$ = this;
        synchronized (crossref2Oaf$) {
            if ((byte)(bitmap$0$3.elem & 2) == 0) {
                json$lzy$2.elem = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$3.elem = (byte)(bitmap$0$3.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$2.elem;
        }
    }

    private final JsonAST.JValue json$2(String input$1, ObjectRef json$lzy$2, VolatileByteRef bitmap$0$3) {
        return (byte)(bitmap$0$3.elem & 2) == 0 ? this.json$lzycompute$2(input$1, json$lzy$2, bitmap$0$3) : (JsonAST.JValue)json$lzy$2.elem;
    }

    /*
     * WARNING - void declaration
     */
    public final String eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$snsfRule$1(String award) {
        void var3_3;
        String tmp1 = StringUtils.substringAfter((String)award, (String)"_");
        String tmp2 = StringUtils.substringBefore((String)tmp1, (String)"/");
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"From ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{award, tmp2})));
        return var3_3;
    }

    public final String eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$extractECAward$1(String award) {
        Regex awardECRegex = new StringOps(Predef$.MODULE$.augmentString("[0-9]{4,9}")).r();
        if (awardECRegex.findAllIn((CharSequence)award).hasNext()) {
            return (String)awardECRegex.findAllIn((CharSequence)award).max((Ordering)Ordering.String$.MODULE$);
        }
        return null;
    }

    public final Relation eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(String sourceId, String targetId, String relClass, KeyValue cf$1, DataInfo di$1, long ts$1) {
        Relation r = new Relation();
        r.setSource(sourceId);
        r.setTarget(targetId);
        r.setRelType("resultProject");
        r.setRelClass(relClass);
        r.setSubRelType("outcome");
        r.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{cf$1}))).asJava());
        r.setDataInfo(di$1);
        r.setLastupdatetimestamp(Predef$.MODULE$.long2Long(ts$1));
        return r;
    }

    public final void eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateSimpleRelationFromAward$1(mappingFunder funder, String nsPrefix, Function1 extractField, String sourceId$1, KeyValue cf$1, DataInfo di$1, long ts$1, Queue queue$1) {
        if (funder.award().isDefined() && ((TraversableOnce)funder.award().get()).nonEmpty()) {
            ((List)((TraversableLike)((List)funder.award().get()).map(extractField, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String a) {
                    return a != null && new StringOps(Predef$.MODULE$.augmentString(a)).nonEmpty();
                }
            })).foreach((Function1)new Serializable(sourceId$1, cf$1, di$1, ts$1, queue$1, nsPrefix){
                public static final long serialVersionUID = 0L;
                private final String sourceId$1;
                private final KeyValue cf$1;
                private final DataInfo di$1;
                private final long ts$1;
                private final Queue queue$1;
                private final String nsPrefix$1;

                public final Queue<Relation> apply(String award) {
                    String targetId = Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1(this.nsPrefix$1, DHPUtils.md5((String)award));
                    this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(this.sourceId$1, targetId, "isProducedBy", this.cf$1, this.di$1, this.ts$1));
                    return (Queue)this.queue$1.$plus$eq((Object)Crossref2Oaf$.MODULE$.eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$generateRelation$1(targetId, this.sourceId$1, "produces", this.cf$1, this.di$1, this.ts$1));
                }
                {
                    this.sourceId$1 = sourceId$1;
                    this.cf$1 = cf$1;
                    this.di$1 = di$1;
                    this.ts$1 = ts$1;
                    this.queue$1 = queue$1;
                    this.nsPrefix$1 = nsPrefix$1;
                }
            });
        }
    }

    public final String eu$dnetlib$dhp$collection$crossref$Crossref2Oaf$$getProjectId$1(String nsPrefix, String targetId) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"40|", "::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nsPrefix, targetId}));
    }

    private final DefaultFormats$ formats$lzycompute$4(ObjectRef formats$lzy$4, VolatileByteRef bitmap$0$4) {
        Crossref2Oaf$ crossref2Oaf$ = this;
        synchronized (crossref2Oaf$) {
            if ((byte)(bitmap$0$4.elem & 1) == 0) {
                formats$lzy$4.elem = DefaultFormats$.MODULE$;
                bitmap$0$4.elem = (byte)(bitmap$0$4.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$4.elem;
        }
    }

    private final DefaultFormats$ formats$4(ObjectRef formats$lzy$4, VolatileByteRef bitmap$0$4) {
        return (byte)(bitmap$0$4.elem & 1) == 0 ? this.formats$lzycompute$4(formats$lzy$4, bitmap$0$4) : (DefaultFormats$)formats$lzy$4.elem;
    }

    private Crossref2Oaf$() {
        MODULE$ = this;
        Product.class.$init$((Product)this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.mapper = new ObjectMapper();
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        String s = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/collection/crossref/irish_funder.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        this.irishFunder = (List)package$.MODULE$.jvalue2extractable(this.json$1(s, json$lzy, bitmap$0)).extract((Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(funderInfo.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        this.invalidName = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",", "none none", "none, none", "none &na;", "(:null)", "test test test", "test test", "test", "&na; &na;"}));
    }
}

