/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.gtr2;

import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.common.collection.HttpConnector2;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gtr2PublicationsIterator
implements Iterator<String> {
    private static final Logger log = LoggerFactory.getLogger(Gtr2PublicationsIterator.class);
    private final HttpConnector2 connector;
    private static final DateTimeFormatter simpleDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final int MAX_ATTEMPTS = 10;
    private final String baseUrl;
    private int currPage;
    private int endPage;
    private boolean incremental = false;
    private LocalDate fromDate;
    private final Map<String, String> cache = new HashMap<String, String>();
    private final Queue<String> queue = new LinkedList<String>();
    private String nextElement;

    public Gtr2PublicationsIterator(String baseUrl, String fromDate, String startPage, String endPage, HttpClientParams clientParams) throws CollectorException {
        this.baseUrl = baseUrl;
        this.currPage = NumberUtils.toInt((String)startPage, (int)1);
        this.endPage = NumberUtils.toInt((String)endPage, (int)Integer.MAX_VALUE);
        this.incremental = StringUtils.isNotBlank((CharSequence)fromDate);
        this.connector = new HttpConnector2(clientParams);
        if (this.incremental) {
            this.fromDate = this.parseDate(fromDate);
        }
        this.prepareNextElement();
    }

    @Override
    public boolean hasNext() {
        return this.nextElement != null;
    }

    @Override
    public String next() {
        try {
            String string = this.nextElement;
            return string;
        }
        finally {
            this.prepareNextElement();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void prepareNextElement() {
        while (this.currPage <= this.endPage && this.queue.isEmpty()) {
            log.info("FETCHING PAGE + " + this.currPage + "/" + this.endPage);
            this.queue.addAll(this.fetchPage(this.currPage++));
        }
        this.nextElement = this.queue.poll();
    }

    private List<String> fetchPage(int pageNumber) {
        ArrayList<String> res = new ArrayList<String>();
        try {
            Document doc = this.loadURL(this.baseUrl + "/publication?page=" + pageNumber, 0);
            for (Object po : doc.selectNodes("//*[local-name() = 'publication']")) {
                Element mainEntity = (Element)((Element)po).detach();
                if (this.filterIncremental(mainEntity)) {
                    String publicationOverview = mainEntity.attributeValue("url");
                    res.add(this.loadURL(publicationOverview, -1).asXML());
                    continue;
                }
                log.debug("Skipped entity");
            }
        }
        catch (Throwable e) {
            log.error("Exception fetching page " + pageNumber, e);
            throw new RuntimeException("Exception fetching page " + pageNumber, e);
        }
        return res;
    }

    private boolean filterIncremental(Element e) {
        return !this.incremental || this.isAfter(e.valueOf("@*[local-name() = 'created']"), this.fromDate) || this.isAfter(e.valueOf("@*[local-name() = 'updated']"), this.fromDate);
    }

    /*
     * Exception decompiling
     */
    private Document loadURL(String cleanUrl, int attempt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LocalDate parseDate(String s) {
        return LocalDate.parse(s.contains("T") ? s.substring(0, s.indexOf("T")) : s, simpleDateTimeFormatter);
    }

    private boolean isAfter(String d, LocalDate fromDate) {
        return StringUtils.isNotBlank((CharSequence)d) && this.parseDate(d).isAfter(fromDate);
    }
}

