/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.mongodb;

import com.mongodb.client.MongoCollection;
import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.CollectorPlugin;
import eu.dnetlib.dhp.common.MdstoreClient;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDStoreCollectorPlugin
implements CollectorPlugin {
    private static final Logger log = LoggerFactory.getLogger(MDStoreCollectorPlugin.class);
    public static final String MONGODB_DBNAME = "mongodb_dbname";
    public static final String MDSTORE_ID = "mdstore_id";

    @Override
    public Stream<String> collect(ApiDescriptor api, AggregatorReport report) throws CollectorException {
        String mongoBaseUrl = Optional.ofNullable(api.getBaseUrl()).orElseThrow(() -> new CollectorException("missing mongodb baseUrl, expected in eu.dnetlib.dhp.collection.ApiDescriptor.baseUrl"));
        log.info("mongoBaseUrl: {}", (Object)mongoBaseUrl);
        String dbName = (String)Optional.ofNullable(api.getParams().get(MONGODB_DBNAME)).orElseThrow(() -> new CollectorException(String.format("missing parameter '%s'", MONGODB_DBNAME)));
        log.info("dbName: {}", (Object)dbName);
        String mdId = (String)Optional.ofNullable(api.getParams().get(MDSTORE_ID)).orElseThrow(() -> new CollectorException(String.format("missing parameter '%s'", MDSTORE_ID)));
        log.info("mdId: {}", (Object)mdId);
        MdstoreClient client = new MdstoreClient(mongoBaseUrl, dbName);
        MongoCollection mdstore = client.mdStore(mdId);
        long size = mdstore.count();
        return StreamSupport.stream(Spliterators.spliterator(mdstore.find().iterator(), size, 64), false).map(doc -> doc.getString((Object)"body"));
    }
}

