/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.oai;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.CollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.oai.OaiIteratorFactory;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class OaiCollectorPlugin
implements CollectorPlugin {
    public static final String DATE_REGEX = "\\d{4}-\\d{2}-\\d{2}";
    public static final String UTC_DATETIME_REGEX = "\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z";
    private static final String FORMAT_PARAM = "format";
    private static final String OAI_SET_PARAM = "set";
    private static final Object OAI_FROM_DATE_PARAM = "fromDate";
    private static final Object OAI_UNTIL_DATE_PARAM = "untilDate";
    private OaiIteratorFactory oaiIteratorFactory;
    private HttpClientParams clientParams;

    public OaiCollectorPlugin(HttpClientParams clientParams) {
        this.clientParams = clientParams;
    }

    @Override
    public Stream<String> collect(ApiDescriptor api, AggregatorReport report) throws CollectorException {
        String baseUrl = api.getBaseUrl();
        String mdFormat = (String)api.getParams().get(FORMAT_PARAM);
        String setParam = (String)api.getParams().get(OAI_SET_PARAM);
        String fromDate = (String)api.getParams().get(OAI_FROM_DATE_PARAM);
        String untilDate = (String)api.getParams().get(OAI_UNTIL_DATE_PARAM);
        ArrayList<String> sets = new ArrayList<String>();
        if (setParam != null) {
            sets.addAll(Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)setParam)));
        }
        if (sets.isEmpty()) {
            sets.add("");
        }
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorException("Param 'baseurl' is null or empty");
        }
        if (mdFormat == null || mdFormat.isEmpty()) {
            throw new CollectorException("Param 'mdFormat' is null or empty");
        }
        if (fromDate != null && !fromDate.matches(DATE_REGEX) && !fromDate.matches(UTC_DATETIME_REGEX)) {
            throw new CollectorException("Invalid date (YYYY-MM-DD or YYYY-MM-DDT00:00:00Z): " + fromDate);
        }
        if (untilDate != null && !untilDate.matches(DATE_REGEX) && !untilDate.matches(UTC_DATETIME_REGEX)) {
            throw new CollectorException("Invalid date (YYYY-MM-DD or YYYY-MM-DDT00:00:00Z): " + untilDate);
        }
        Iterator iters = sets.stream().map(set -> this.getOaiIteratorFactory().newIterator(baseUrl, mdFormat, (String)set, fromDate, untilDate, this.getClientParams(), report)).iterator();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Iterators.concat(iters), 16), false);
    }

    public OaiIteratorFactory getOaiIteratorFactory() {
        if (this.oaiIteratorFactory == null) {
            this.oaiIteratorFactory = new OaiIteratorFactory();
        }
        return this.oaiIteratorFactory;
    }

    public HttpClientParams getClientParams() {
        return this.clientParams;
    }

    public void setClientParams(HttpClientParams clientParams) {
        this.clientParams = clientParams;
    }
}

