/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.osf;

import eu.dnetlib.dhp.collection.plugin.utils.JsonUtils;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.common.collection.HttpConnector2;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsfPreprintsIterator
implements Iterator<String> {
    private static final Logger log = LoggerFactory.getLogger(OsfPreprintsIterator.class);
    private static final int MAX_ATTEMPTS = 5;
    private final HttpClientParams clientParams;
    private final String baseUrl;
    private final int pageSize;
    private String currentUrl;
    private final Queue<String> recordQueue = new PriorityBlockingQueue<String>();

    public OsfPreprintsIterator(String baseUrl, int pageSize, HttpClientParams clientParams) {
        this.clientParams = clientParams;
        this.baseUrl = baseUrl;
        this.pageSize = pageSize;
        this.initQueue();
    }

    private void initQueue() {
        this.currentUrl = this.baseUrl + "?filter:is_published:d=true&format=json&page[size]=" + this.pageSize;
        log.info("REST calls starting with {}", (Object)this.currentUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Queue<String> queue = this.recordQueue;
        synchronized (queue) {
            while (this.recordQueue.isEmpty() && StringUtils.isNotBlank((CharSequence)this.currentUrl) && this.currentUrl.startsWith("http")) {
                try {
                    this.currentUrl = this.downloadPage(this.currentUrl);
                }
                catch (CollectorException e) {
                    log.debug("CollectorPlugin.next()-Exception: {}", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            return !this.recordQueue.isEmpty();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Queue<String> queue = this.recordQueue;
        synchronized (queue) {
            return this.recordQueue.poll();
        }
    }

    private String downloadPage(String url) throws CollectorException {
        Document doc = this.downloadUrl(url, 0);
        for (Object o : doc.selectNodes("/*/data")) {
            Document doc1;
            String href;
            Element n = (Element)((Element)o).detach();
            Element group = DocumentHelper.createElement((String)"group");
            group.addAttribute("id", n.valueOf("./id"));
            group.addElement("preprint").add(n);
            for (Object o1 : n.selectNodes(".//contributors//href")) {
                href = ((Node)o1).getText();
                if (!StringUtils.isNotBlank((CharSequence)href) || !href.startsWith("http")) continue;
                doc1 = this.downloadUrl(href, 0);
                group.addElement("contributors").add(doc1.getRootElement().detach());
            }
            for (Object o1 : n.selectNodes(".//primary_file//href")) {
                href = ((Node)o1).getText();
                if (!StringUtils.isNotBlank((CharSequence)href) || !href.startsWith("http")) continue;
                doc1 = this.downloadUrl(href, 0);
                group.addElement("primary_file").add(doc1.getRootElement().detach());
            }
            for (Object o1 : n.selectNodes(".//relationships/license/links/related/href")) {
                href = ((Node)o1).getText();
                if (!StringUtils.isNotBlank((CharSequence)href) || !href.startsWith("http")) continue;
                doc1 = this.downloadUrl(href, 0);
                group.addElement("license").add(doc1.getRootElement().detach());
            }
            this.recordQueue.add(DocumentHelper.createDocument((Element)group).asXML());
        }
        return doc.valueOf("/*/links/next");
    }

    private Document downloadUrl(String url, int attempt) throws CollectorException {
        if (attempt > 5) {
            throw new CollectorException("Max Number of attempts reached, url:" + url);
        }
        if (attempt > 0) {
            int delay = attempt * 5000;
            log.debug("Attempt {} with delay {}", (Object)attempt, (Object)delay);
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                new CollectorException((Throwable)e);
            }
        }
        try {
            log.info("requesting URL [{}]", (Object)url);
            HttpConnector2 connector = new HttpConnector2(this.clientParams);
            String json = connector.getInputSource(url);
            String xml = JsonUtils.convertToXML(json);
            return DocumentHelper.parseText((String)xml);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
            if (e instanceof CollectorException && e.getMessage().contains("401")) {
                Element root = DocumentHelper.createElement((String)"error_401_authorization_required");
                return DocumentHelper.createDocument((Element)root);
            }
            return this.downloadUrl(url, attempt + 1);
        }
    }
}

