/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.bio;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import eu.dnetlib.dhp.aggregation.AbstractVocabularyTest;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.dhp.sx.bio.BioDBToOAF;
import eu.dnetlib.dhp.sx.bio.BioDBToOAF$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$AuthorPID$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$EBILinks$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$GzFileIterator$;
import eu.dnetlib.dhp.sx.bio.ebi.SparkCreatePubmedDump;
import eu.dnetlib.dhp.sx.bio.pubmed.PMArticle;
import eu.dnetlib.dhp.sx.bio.pubmed.PMAuthor;
import eu.dnetlib.dhp.sx.bio.pubmed.PMIdentifier;
import eu.dnetlib.dhp.sx.bio.pubmed.PMParser;
import eu.dnetlib.dhp.sx.bio.pubmed.PMParser2;
import eu.dnetlib.dhp.sx.bio.pubmed.PMSubject;
import eu.dnetlib.dhp.sx.bio.pubmed.PubMedToOaf$;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.io.IOUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.SomeValue$;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={MockitoExtension.class})
@ScalaSignature(bytes="\u0006\u0001\r=e\u0001B.]\u0001\u001dDQA\u001c\u0001\u0005\u0002=DqA\u001d\u0001C\u0002\u0013\u00051\u000fC\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002;\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\u00191\u0011Q\u0006\u0001\u0001\u0003_A!\"a\u0018\u0006\u0005\u0003\u0005\u000b\u0011BA1\u0011\u0019qW\u0001\"\u0001\u0002r!9\u0011\u0011P\u0003\u0005B\u0005m\u0004bBAB\u000b\u0011\u0005\u0013QQ\u0004\b\u0003#\u0003\u0001\u0012AAJ\r\u001d\t)\n\u0001E\u0001\u0003/CaA\\\u0006\u0005\u0002\u0005e\u0005bBAN\u0017\u0011\u0005\u0011Q\u0014\u0005\b\u0003[\u0003A\u0011AA\u0003\u0011\u001d\t9\f\u0001C\u0001\u0003s3a!!2\u0001\u0001\u0006\u001d\u0007BCAk!\tU\r\u0011\"\u0001\u0002X\"Q\u0011\u0011\u001c\t\u0003\u0012\u0003\u0006I!a\u0014\t\u0015\u0005m\u0007C!f\u0001\n\u0003\t9\u000e\u0003\u0006\u0002^B\u0011\t\u0012)A\u0005\u0003\u001fBaA\u001c\t\u0005\u0002\u0005}\u0007\"CAt!\u0005\u0005I\u0011AAu\u0011%\ty\u000fEI\u0001\n\u0003\t\t\u0010C\u0005\u0003\bA\t\n\u0011\"\u0001\u0002r\"I!\u0011\u0002\t\u0002\u0002\u0013\u0005#1\u0002\u0005\n\u0005\u001b\u0001\u0012\u0011!C\u0001\u0005\u001fA\u0011Ba\u0006\u0011\u0003\u0003%\tA!\u0007\t\u0013\t\u0015\u0002#!A\u0005B\t\u001d\u0002\"\u0003B\u001a!\u0005\u0005I\u0011\u0001B\u001b\u0011%\u0011I\u0004EA\u0001\n\u0003\u0012Y\u0004C\u0005\u0003>A\t\t\u0011\"\u0011\u0002\u0006\"I!q\b\t\u0002\u0002\u0013\u0005#\u0011I\u0004\n\u0005\u000b\u0002\u0011\u0011!E\u0001\u0005\u000f2\u0011\"!2\u0001\u0003\u0003E\tA!\u0013\t\r9\u0014C\u0011\u0001B,\u0011%\u0011iDIA\u0001\n\u000b\n)\tC\u0005\u0002\u001c\n\n\t\u0011\"!\u0003Z!I!q\f\u0012\u0002\u0002\u0013\u0005%\u0011\r\u0005\b\u0005g\u0002A\u0011\u0001B;\u0011\u001d\u0011Y\b\u0001C\u0001\u0003\u000bAqAa \u0001\t\u0003\t)\u0001C\u0004\u0003\u0004\u0002!\t!!\u0002\t\u000f\t\u001d\u0005\u0001\"\u0003\u0003\n\"9!1\u0014\u0001\u0005\u0002\u0005\u0015\u0001b\u0002BP\u0001\u0011%!\u0011\u0015\u0005\b\u0005o\u0003A\u0011AA\u0003\u0011\u001d\u0011I\f\u0001C\u0001\u0003\u000bAqA!0\u0001\t\u0003\t)\u0001C\u0004\u0003B\u0002!\t!!\u0002\t\u000f\t\u0015\u0007\u0001\"\u0001\u0002\u0006\u00191!\u0011\u001a\u0001A\u0005\u0017D!B!44\u0005+\u0007I\u0011AAl\u0011)\u0011ym\rB\tB\u0003%\u0011q\n\u0005\u000b\u0005#\u001c$Q3A\u0005\u0002\u0005]\u0007B\u0003Bjg\tE\t\u0015!\u0003\u0002P!Q!Q[\u001a\u0003\u0016\u0004%\t!a6\t\u0015\t]7G!E!\u0002\u0013\ty\u0005\u0003\u0006\u0003ZN\u0012)\u001a!C\u0001\u0003/D!Ba74\u0005#\u0005\u000b\u0011BA(\u0011)\u0011in\rBK\u0002\u0013\u0005\u0011q\u001b\u0005\u000b\u0005?\u001c$\u0011#Q\u0001\n\u0005=\u0003B\u0003Bqg\tU\r\u0011\"\u0001\u0002X\"Q!1]\u001a\u0003\u0012\u0003\u0006I!a\u0014\t\r9\u001cD\u0011\u0001Bs\u0011%\t9oMA\u0001\n\u0003\u0011)\u0010C\u0005\u0002pN\n\n\u0011\"\u0001\u0002r\"I!qA\u001a\u0012\u0002\u0013\u0005\u0011\u0011\u001f\u0005\n\u0007\u0007\u0019\u0014\u0013!C\u0001\u0003cD\u0011b!\u00024#\u0003%\t!!=\t\u0013\r\u001d1'%A\u0005\u0002\u0005E\b\"CB\u0005gE\u0005I\u0011AAy\u0011%\u0011IaMA\u0001\n\u0003\u0012Y\u0001C\u0005\u0003\u000eM\n\t\u0011\"\u0001\u0003\u0010!I!qC\u001a\u0002\u0002\u0013\u000511\u0002\u0005\n\u0005K\u0019\u0014\u0011!C!\u0005OA\u0011Ba\r4\u0003\u0003%\taa\u0004\t\u0013\te2'!A\u0005B\tm\u0002\"\u0003B\u001fg\u0005\u0005I\u0011IAC\u0011%\u0011ydMA\u0001\n\u0003\u001a\u0019bB\u0005\u0004\u0018\u0001\t\t\u0011#\u0001\u0004\u001a\u0019I!\u0011\u001a\u0001\u0002\u0002#\u000511\u0004\u0005\u0007]F#\taa\t\t\u0013\tu\u0012+!A\u0005F\u0005\u0015\u0005\"CAN#\u0006\u0005I\u0011QB\u0013\u0011%\u0011y&UA\u0001\n\u0003\u001b\u0019\u0004C\u0004\u0004@\u0001!\ta!\u0011\t\u000f\r%\u0003\u0001\"\u0001\u0002\u0006!91Q\n\u0001\u0005\u0002\u0005\u0015\u0001bBB)\u0001\u0011\u0005\u0011Q\u0001\u0005\r\u0007+\u0002\u0001\u0013!A\u0001\u0002\u0013\u00051q\u000b\u0002\u000f\u0005&|7k\u00195pY&DH+Z:u\u0015\tif,A\u0002cS>T!a\u00181\u0002\u0005MD(BA1c\u0003\r!\u0007\u000e\u001d\u0006\u0003G\u0012\fq\u0001\u001a8fi2L'MC\u0001f\u0003\t)Wo\u0001\u0001\u0014\u0005\u0001A\u0007CA5m\u001b\u0005Q'BA6a\u0003-\twm\u001a:fO\u0006$\u0018n\u001c8\n\u00055T'AF!cgR\u0014\u0018m\u0019;W_\u000e\f'-\u001e7bef$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0001\bCA9\u0001\u001b\u0005a\u0016AB7baB,'/F\u0001u!\t)h0D\u0001w\u0015\t9\b0\u0001\u0005eCR\f'-\u001b8e\u0015\tI(0A\u0004kC\u000e\\7o\u001c8\u000b\u0005md\u0018!\u00034bgR,'\u000f_7m\u0015\u0005i\u0018aA2p[&\u0011qP\u001e\u0002\r\u001f\nTWm\u0019;NCB\u0004XM]\u0001\b[\u0006\u0004\b/\u001a:!\u0003\u0015\u0019X\r^+q)\t\t9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\t\ti!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u0012\u0005-!\u0001B+oSRD3\u0001BA\u000b!\u0011\t9\"!\u000b\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t1!\u00199j\u0015\u0011\ty\"!\t\u0002\u000f),\b/\u001b;fe*!\u00111EA\u0013\u0003\u0015QWO\\5u\u0015\t\t9#A\u0002pe\u001eLA!a\u000b\u0002\u001a\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0003-\t+hMZ3sK\u0012\u0014V-\u00193fe&#XM]1u_J\u001cR!BA\u0019\u0003o\u0001B!!\u0003\u00024%!\u0011QGA\u0006\u0005\u0019\te.\u001f*fMB1\u0011\u0011HA%\u0003\u001frA!a\u000f\u0002F9!\u0011QHA\"\u001b\t\tyDC\u0002\u0002B\u0019\fa\u0001\u0010:p_Rt\u0014BAA\u0007\u0013\u0011\t9%a\u0003\u0002\u000fA\f7m[1hK&!\u00111JA'\u0005!IE/\u001a:bi>\u0014(\u0002BA$\u0003\u0017\u0001B!!\u0015\u0002Z9!\u00111KA+!\u0011\ti$a\u0003\n\t\u0005]\u00131B\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0013Q\f\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005]\u00131B\u0001\u0007e\u0016\fG-\u001a:\u0011\t\u0005\r\u0014QN\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005\u0011\u0011n\u001c\u0006\u0003\u0003W\nAA[1wC&!\u0011qNA3\u00059\u0011UO\u001a4fe\u0016$'+Z1eKJ$B!a\u001d\u0002xA\u0019\u0011QO\u0003\u000e\u0003\u0001Aq!a\u0018\b\u0001\u0004\t\t'A\u0004iCNtU\r\u001f;\u0015\u0005\u0005u\u0004\u0003BA\u0005\u0003\u007fJA!!!\u0002\f\t9!i\\8mK\u0006t\u0017\u0001\u00028fqR$\"!a\"\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017SA!!$\u0002j\u0005!A.\u00198h\u0013\u0011\tY&a#\u0002\u001d\u001dSh)\u001b7f\u0013R,'/\u0019;peB\u0019\u0011QO\u0006\u0003\u001d\u001dSh)\u001b7f\u0013R,'/\u0019;peN\u00191\"!\r\u0015\u0005\u0005M\u0015!B1qa2LHCBA:\u0003?\u000bI\u000bC\u0004\u0002\"6\u0001\r!a)\u0002\u0005%\u001c\b\u0003BA2\u0003KKA!a*\u0002f\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\tY+\u0004a\u0001\u0003\u001f\n\u0001\"\u001a8d_\u0012LgnZ\u0001\bi\u0016\u001cH\u000fU5eQ\rq\u0011\u0011\u0017\t\u0005\u0003/\t\u0019,\u0003\u0003\u00026\u0006e!\u0001\u0002+fgR\f!#\u001a=ue\u0006\u001cG/\u00114gS2L\u0017\r^5p]R!\u00111XAa!\u0019\tI$!0\u0002P%!\u0011qXA'\u0005\u0011a\u0015n\u001d;\t\u000f\u0005\rw\u00021\u0001\u0002P\u0005\t1OA\u0005BkRDwN\u001d)J\tN9\u0001#!\r\u0002J\u0006=\u0007\u0003BA\u0005\u0003\u0017LA!!4\u0002\f\t9\u0001K]8ek\u000e$\b\u0003BA\u0005\u0003#LA!a5\u0002\f\ta1+\u001a:jC2L'0\u00192mK\u00069\u0001/\u001b3UsB,WCAA(\u0003!\u0001\u0018\u000e\u001a+za\u0016\u0004\u0013a\u00019jI\u0006!\u0001/\u001b3!)\u0019\t\t/a9\u0002fB\u0019\u0011Q\u000f\t\t\u000f\u0005UW\u00031\u0001\u0002P!9\u00111\\\u000bA\u0002\u0005=\u0013\u0001B2paf$b!!9\u0002l\u00065\b\"CAk-A\u0005\t\u0019AA(\u0011%\tYN\u0006I\u0001\u0002\u0004\ty%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M(\u0006BA(\u0003k\\#!a>\u0011\t\u0005e(1A\u0007\u0003\u0003wTA!!@\u0002\u0000\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0005\u0003\tY!\u0001\u0006b]:|G/\u0019;j_:LAA!\u0002\u0002|\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\"\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tE\u0001\u0003BA\u0005\u0005'IAA!\u0006\u0002\f\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0004B\u0011!\u0011\tIA!\b\n\t\t}\u00111\u0002\u0002\u0004\u0003:L\b\"\u0003B\u00127\u0005\u0005\t\u0019\u0001B\t\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0006\t\u0007\u0005W\u0011\tDa\u0007\u000e\u0005\t5\"\u0002\u0002B\u0018\u0003\u0017\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tYE!\f\u0002\u0011\r\fg.R9vC2$B!! \u00038!I!1E\u000f\u0002\u0002\u0003\u0007!1D\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!\u0011C\u0001\ti>\u001cFO]5oO\u00061Q-];bYN$B!! \u0003D!I!1\u0005\u0011\u0002\u0002\u0003\u0007!1D\u0001\n\u0003V$\bn\u001c:Q\u0013\u0012\u00032!!\u001e#'\u0015\u0011#1JAh!)\u0011iEa\u0015\u0002P\u0005=\u0013\u0011]\u0007\u0003\u0005\u001fRAA!\u0015\u0002\f\u00059!/\u001e8uS6,\u0017\u0002\u0002B+\u0005\u001f\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u00119\u0005\u0006\u0004\u0002b\nm#Q\f\u0005\b\u0003+,\u0003\u0019AA(\u0011\u001d\tY.\na\u0001\u0003\u001f\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003d\t=\u0004CBA\u0005\u0005K\u0012I'\u0003\u0003\u0003h\u0005-!AB(qi&|g\u000e\u0005\u0005\u0002\n\t-\u0014qJA(\u0013\u0011\u0011i'a\u0003\u0003\rQ+\b\u000f\\33\u0011%\u0011\tHJA\u0001\u0002\u0004\t\t/A\u0002yIA\nq#\u001a=ue\u0006\u001cG/Q;uQ>\u0014\u0018\nZ3oi&4\u0017.\u001a:\u0015\t\t]$\u0011\u0010\t\u0007\u0003s\ti,!9\t\u000f\u0005\rw\u00051\u0001\u0002P\u0005\u0011B/Z:u!\u0006\u00148/\u001b8h!V\u0014W.\u001a33Q\rA\u0013\u0011W\u0001\fi\u0016\u001cH/\u0012\"J\t\u0006$\u0018\rK\u0002*\u0003c\u000bq\u0002^3tiB+(-\\3e)>|\u0015M\u001a\u0015\u0004U\u0005E\u0016AD2iK\u000e\\\u0007+T!si&\u001cG.\u001a\u000b\u0005\u0003\u000f\u0011Y\tC\u0004\u0003\u000e.\u0002\rAa$\u0002\u000f\u0005\u0014H/[2mKB!!\u0011\u0013BL\u001b\t\u0011\u0019JC\u0002\u0003\u0016r\u000ba\u0001];c[\u0016$\u0017\u0002\u0002BM\u0005'\u0013\u0011\u0002U'BeRL7\r\\3\u0002)Q,7\u000f\u001e)beNLgn\u001a)vE6,G\rW'MQ\ra\u0013\u0011W\u0001\u0017G\",7m\u001b)vE6,G\rU;cY&\u001c\u0017\r^5p]R!\u0011q\u0001BR\u0011\u001d\u0011)+\fa\u0001\u0005O\u000b\u0011a\u001c\t\u0005\u0005S\u0013\u0019,\u0004\u0002\u0003,*!!Q\u0016BX\u0003\ry\u0017M\u001a\u0006\u0004\u0005c\u0003\u0017AB:dQ\u0016l\u0017-\u0003\u0003\u00036\n-&aA(bM\u0006\u0019B/Z:u!V\u0014W.\u001a3Ta2LG\u000f^5oO\u0006!B/Z:u!V\u0014W.\u001a3Pe&<\u0017N\\1m\u0013\u0012C3aLAY\u0003E!Xm\u001d;Qk\nlW\rZ'baBLgn\u001a\u0015\u0004a\u0005E\u0016\u0001\u0004;fgR\u0004FI\u0011+p\u001f\u00063\u0005fA\u0019\u00022\u0006\u0001B/Z:u+:K\u0005O]8u)>|\u0015I\u0012\u0015\u0004e\u0005E&\u0001C#C\u00132Kgn[:\u0014\u000fM\n\t$!3\u0002P\u00069!/\u001a7UsB,\u0017\u0001\u0003:fYRK\b/\u001a\u0011\u0002\t\u0011\fG/Z\u0001\u0006I\u0006$X\rI\u0001\u0006i&$H.Z\u0001\u0007i&$H.\u001a\u0011\u0002\tAl\u0017\u000eZ\u0001\u0006a6LG\rI\u0001\ni\u0006\u0014x-\u001a;QS\u0012\f!\u0002^1sO\u0016$\b+\u001b3!\u00035!\u0018M]4fiBKG\rV=qK\u0006qA/\u0019:hKR\u0004\u0016\u000e\u001a+za\u0016\u0004CC\u0004Bt\u0005S\u0014YO!<\u0003p\nE(1\u001f\t\u0004\u0003k\u001a\u0004b\u0002Bg\u0001\u0002\u0007\u0011q\n\u0005\b\u0005#\u0004\u0005\u0019AA(\u0011\u001d\u0011)\u000e\u0011a\u0001\u0003\u001fBqA!7A\u0001\u0004\ty\u0005C\u0004\u0003^\u0002\u0003\r!a\u0014\t\u000f\t\u0005\b\t1\u0001\u0002PQq!q\u001dB|\u0005s\u0014YP!@\u0003\u0000\u000e\u0005\u0001\"\u0003Bg\u0003B\u0005\t\u0019AA(\u0011%\u0011\t.\u0011I\u0001\u0002\u0004\ty\u0005C\u0005\u0003V\u0006\u0003\n\u00111\u0001\u0002P!I!\u0011\\!\u0011\u0002\u0003\u0007\u0011q\n\u0005\n\u0005;\f\u0005\u0013!a\u0001\u0003\u001fB\u0011B!9B!\u0003\u0005\r!a\u0014\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014AD2paf$C-\u001a4bk2$H%N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137)\u0011\u0011Yb!\u0004\t\u0013\t\r\"*!AA\u0002\tEA\u0003BA?\u0007#A\u0011Ba\tM\u0003\u0003\u0005\rAa\u0007\u0015\t\u0005u4Q\u0003\u0005\n\u0005Gy\u0015\u0011!a\u0001\u00057\t\u0001\"\u0012\"J\u0019&t7n\u001d\t\u0004\u0003k\n6#B)\u0004\u001e\u0005=\u0007C\u0005B'\u0007?\ty%a\u0014\u0002P\u0005=\u0013qJA(\u0005OLAa!\t\u0003P\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001c\u0015\u0005\reAC\u0004Bt\u0007O\u0019Ica\u000b\u0004.\r=2\u0011\u0007\u0005\b\u0005\u001b$\u0006\u0019AA(\u0011\u001d\u0011\t\u000e\u0016a\u0001\u0003\u001fBqA!6U\u0001\u0004\ty\u0005C\u0004\u0003ZR\u0003\r!a\u0014\t\u000f\tuG\u000b1\u0001\u0002P!9!\u0011\u001d+A\u0002\u0005=C\u0003BB\u001b\u0007{\u0001b!!\u0003\u0003f\r]\u0002\u0003EA\u0005\u0007s\ty%a\u0014\u0002P\u0005=\u0013qJA(\u0013\u0011\u0019Y$a\u0003\u0003\rQ+\b\u000f\\37\u0011%\u0011\t(VA\u0001\u0002\u0004\u00119/A\bqCJ\u001cXmX3cS~c\u0017N\\6t)\u0011\u0019\u0019e!\u0012\u0011\r\u0005e\u0012Q\u0018Bt\u0011\u001d\u00199E\u0016a\u0001\u0003\u001f\nQ!\u001b8qkR\fa\u0003^3ti\u000e\u0013xn]:sK\u001ad\u0015N\\6t)>|\u0015I\u0012\u0015\u0004/\u0006E\u0016!\u0005;fgR,%)\u0013'j].\u001cHk\\(B\r\"\u001a\u0001,!-\u0002)M\u001c\u0007n\u001c7jqJ+7o\u001c7wK\u0012$vnT!GQ\rI\u0016\u0011W\u0001\u0017aJ|G/Z2uK\u0012$co\\2bEVd\u0017M]5fgR!1\u0011LB5!\u0011\u0019Yf!\u001a\u000e\u0005\ru#\u0002BB0\u0007C\n!B^8dC\n,H.\u0019:z\u0015\r\u0019\u0019\u0007Y\u0001\u0007G>lWn\u001c8\n\t\r\u001d4Q\f\u0002\u0010->\u001c\u0017MY;mCJLxI]8va\"A!1\u0005.\u0002\u0002\u0003\u0007\u0001\u000fK\u0004\u0001\u0007[\u001aIha\u001f\u0011\t\r=4QO\u0007\u0003\u0007cRAaa\u001d\u0002\u001a\u0005IQ\r\u001f;f]NLwN\\\u0005\u0005\u0007o\u001a\tH\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d#a! $\u0005\r}\u0004\u0003BBA\u0007\u0017k!aa!\u000b\t\u0005}1Q\u0011\u0006\u0005\u0003G\u00199I\u0003\u0003\u0004\n\u0006\u0015\u0012aB7pG.LGo\\\u0005\u0005\u0007\u001b\u001b\u0019I\u0001\tN_\u000e\\\u0017\u000e^8FqR,gn]5p]\u0002")
public class BioScholixTest
extends AbstractVocabularyTest {
    private volatile BioScholixTest$GzFileIterator$ GzFileIterator$module;
    private volatile BioScholixTest$AuthorPID$ AuthorPID$module;
    private volatile BioScholixTest$EBILinks$ EBILinks$module;
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public BioScholixTest$GzFileIterator$ GzFileIterator() {
        if (this.GzFileIterator$module == null) {
            this.GzFileIterator$lzycompute$1();
        }
        return this.GzFileIterator$module;
    }

    public BioScholixTest$AuthorPID$ AuthorPID() {
        if (this.AuthorPID$module == null) {
            this.AuthorPID$lzycompute$1();
        }
        return this.AuthorPID$module;
    }

    public BioScholixTest$EBILinks$ EBILinks() {
        if (this.EBILinks$module == null) {
            this.EBILinks$lzycompute$1();
        }
        return this.EBILinks$module;
    }

    public /* synthetic */ VocabularyGroup protected$vocabularies(BioScholixTest x$1) {
        return x$1.vocabularies;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    @BeforeEach
    public void setUp() {
        super.setUpVocabulary();
    }

    @Test
    public void testPid() {
        List pids = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000163025705", "000000018494732X", "0000000308873343", "0000000335964515", "0000000333457333", "0000000335964515", "0000000302921949", "http://orcid.org/0000-0001-8567-3543", "http://orcid.org/0000-0001-7868-8528", "0000-0001-9189-1440", "0000-0003-3727-9247", "0000-0001-7246-1058", "000000033962389X", "0000000330371470", "0000000171236123", "0000000272569752", "0000000293231371", "http://orcid.org/0000-0003-3345-7333", "0000000340145688", "http://orcid.org/0000-0003-4894-1689"}));
        pids.foreach((Function1 & Serializable & scala.Serializable)pid -> {
            BioScholixTest.$anonfun$testPid$1(pid);
            return BoxedUnit.UNIT;
        });
    }

    public List<String> extractAffiliation(String s) {
        String regex = "<Affiliation>(.*)<\\/Affiliation>";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(s);
        ListBuffer l = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (matcher.find()) {
            l.$plus$eq((Object)matcher.group(1));
        }
        return l.toList();
    }

    public List<AuthorPID> extractAuthorIdentifier(String s) {
        String regex = "<Identifier Source=\"(.*)\">(.*)<\\/Identifier>";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(s);
        ListBuffer l = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (matcher.find()) {
            l.$plus$eq((Object)new AuthorPID(this, matcher.group(1), matcher.group(2)));
        }
        return l.toList();
    }

    @Test
    public void testParsingPubmed2() {
        ObjectMapper mapper = new ObjectMapper();
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/single_pubmed.xml"));
        PMParser2 parser = new PMParser2();
        PMArticle article = parser.parse(xml);
        Predef$.MODULE$.println((Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)PubMedToOaf$.MODULE$.convert(article, this.vocabularies)));
    }

    @Test
    public void testEBIData() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        new PMParser(xml).foreach((Function1 & Serializable & scala.Serializable)s -> {
            Predef$.MODULE$.println((Object)this.mapper().writeValueAsString((Object)s));
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPubmedToOaf() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        List r = (List)((List)new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).toList().map((Function1 & Serializable & scala.Serializable)s -> (PMArticle)this.mapper().readValue(s, PMArticle.class), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)a -> PubMedToOaf$.MODULE$.convert(a, this.protected$vocabularies(this)), List$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)10, (int)r.size());
        Assertions.assertTrue((boolean)((LinearSeqOptimized)((List)r.map((Function1 & Serializable & scala.Serializable)p -> (Result)p, List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)p -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> i.getInstancetype().getClassid(), Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$testPubmedToOaf$7(p))));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(r.head()));
    }

    private void checkPMArticle(PMArticle article) {
        Assertions.assertNotNull((Object)article.getPmid());
        Assertions.assertNotNull((Object)article.getTitle());
        Assertions.assertNotNull((Object)article.getAuthors());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(article.getAuthors()).asScala()).foreach((Function1 & Serializable & scala.Serializable)a -> {
            BioScholixTest.$anonfun$checkPMArticle$1(a);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testParsingPubmedXML() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        PMParser parser = new PMParser(xml);
        parser.foreach((Function1 & Serializable & scala.Serializable)article -> {
            this.checkPMArticle(article);
            return BoxedUnit.UNIT;
        });
    }

    private void checkPubmedPublication(Oaf o) {
        Assertions.assertTrue((boolean)(o instanceof Publication));
        Publication p = (Publication)o;
        Assertions.assertNotNull((Object)p.getId());
        Assertions.assertNotNull((Object)p.getTitle());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getTitle()).asScala()).foreach((Function1 & Serializable & scala.Serializable)t -> {
            BioScholixTest.$anonfun$checkPubmedPublication$1(t);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getAuthor()).asScala()).foreach((Function1 & Serializable & scala.Serializable)a -> {
            BioScholixTest.$anonfun$checkPubmedPublication$2(a);
            return BoxedUnit.UNIT;
        });
        Assertions.assertNotNull((Object)p.getInstance());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).foreach((Function1 & Serializable & scala.Serializable)i -> {
            BioScholixTest.$anonfun$checkPubmedPublication$3(i);
            return BoxedUnit.UNIT;
        });
        Assertions.assertNotNull((Object)p.getOriginalId());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getOriginalId()).asScala()).foreach((Function1 & Serializable & scala.Serializable)oId -> {
            BioScholixTest.$anonfun$checkPubmedPublication$4(oId);
            return BoxedUnit.UNIT;
        });
        boolean hasPMC = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).exists((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$checkPubmedPublication$5(i)));
        if (hasPMC) {
            Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getOriginalId()).asScala()).exists((Function1 & Serializable & scala.Serializable)oId -> BoxesRunTime.boxToBoolean((boolean)oId.startsWith("od_______267::"))));
            return;
        }
    }

    public void testPubmedSplitting() {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("test").master("local").getOrCreate();
        new SparkCreatePubmedDump("", (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), LoggerFactory.getLogger(this.getClass())).createPubmedDump(spark, "/home/sandro/Downloads/pubmed", "/home/sandro/Downloads/pubmed_mapped", this.vocabularies);
    }

    @Test
    public void testPubmedOriginalID() {
        PMArticle article = new PMArticle();
        article.setPmid("1234");
        article.setTitle("a Title");
        article.getPublicationTypes().add(new PMSubject("article", null, null));
        Publication publication = (Publication)PubMedToOaf$.MODULE$.convert(article, this.vocabularies);
        Assertions.assertNotNull((Object)publication);
        Assertions.assertEquals((Object)"50|pmid________::81dc9bdb52d04dc20036dbd8313ed055", (Object)publication.getId());
        article.setPmcId("PMC1517292");
        publication = (Publication)PubMedToOaf$.MODULE$.convert(article, this.vocabularies);
        Assertions.assertNotNull((Object)publication);
        Assertions.assertEquals((Object)"50|pmid________::81dc9bdb52d04dc20036dbd8313ed055", (Object)publication.getId());
        String oldOpenaireID = "od_______267::0000072375bc0e68fa09d4e6b7658248";
        boolean hasOldOpenAIREID = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getOriginalId()).asScala()).exists((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)o.equalsIgnoreCase(oldOpenaireID)));
        Assertions.assertTrue((boolean)hasOldOpenAIREID);
    }

    @Test
    public void testPubmedMapping() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        PMParser parser = new PMParser(xml);
        ListBuffer results = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        parser.foreach((Function1 & Serializable & scala.Serializable)x -> results.$plus$eq((Object)PubMedToOaf$.MODULE$.convert(x, this.protected$vocabularies(this))));
        results.foreach((Function1 & Serializable & scala.Serializable)o -> {
            this.checkPubmedPublication(o);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPDBToOAF() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pdb_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            BioScholixTest.$anonfun$testPDBToOAF$2(s);
            return BoxedUnit.UNIT;
        });
        List result = (List)new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).toList().flatMap((Function1 & Serializable & scala.Serializable)o -> BioDBToOAF$.MODULE$.pdbTOOaf(o), List$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)result.nonEmpty());
        result.foreach((Function1 & Serializable & scala.Serializable)r -> {
            BioScholixTest.$anonfun$testPDBToOAF$5(r);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)result.count((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$testPDBToOAF$6(o)))));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    @Test
    public void testUNIprotToOAF() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/uniprot_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            BioScholixTest.$anonfun$testUNIprotToOAF$2(s);
            return BoxedUnit.UNIT;
        });
        List result = (List)new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).toList().flatMap((Function1 & Serializable & scala.Serializable)o -> BioDBToOAF$.MODULE$.uniprotToOAF(o), List$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)result.nonEmpty());
        result.foreach((Function1 & Serializable & scala.Serializable)r -> {
            BioScholixTest.$anonfun$testUNIprotToOAF$5(r);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)result.count((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$testUNIprotToOAF$6(o)))));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    public List<EBILinks> parse_ebi_links(String input) {
        LazyRef formats$lzy = new LazyRef();
        LazyRef json$lzy = new LazyRef();
        String pmid = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(BioScholixTest.json$1(json$lzy, input)).$bslash("publication")).$bslash("pmid")).extract((Formats)BioScholixTest.formats$1(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
        return package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(BioScholixTest.json$1(json$lzy, input)).$bslash$bslash("Link")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$1(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            JsonAST.JValue jValue = x$9;
            if (jValue instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                List link = jObject.obj();
                return (List)link.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$3(check$ifrefutable$2))).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> {
                    Tuple2 tuple2 = x$8;
                    Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                    if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                        String string = (String)tuple22._1();
                        JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                        if ("Target".equals(string) && jValue instanceof JsonAST.JObject) {
                            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                            List target = jObject.obj();
                            return (List)link.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$5(check$ifrefutable$3))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
                                Tuple2 tuple2 = x$7;
                                Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                    String string = (String)tuple22._1();
                                    JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                    if ("RelationshipType".equals(string) && jValue instanceof JsonAST.JObject) {
                                        JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                                        List relType = jObject.obj();
                                        return (List)relType.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$7(check$ifrefutable$4))).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> {
                                            Tuple2 tuple2 = x$6;
                                            Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                            if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                                String string = (String)tuple22._1();
                                                JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                                if ("Name".equals(string) && jValue instanceof JsonAST.JString) {
                                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                                    String relation = jString.s();
                                                    return (List)link.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$9(check$ifrefutable$5))).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> {
                                                        Tuple2 tuple2 = x$5;
                                                        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                                            String string = (String)tuple22._1();
                                                            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                                            if ("PublicationDate".equals(string) && jValue instanceof JsonAST.JString) {
                                                                JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                String publicationDate = jString.s();
                                                                return (List)target.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$11(check$ifrefutable$6))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
                                                                    Tuple2 tuple2 = x$4;
                                                                    Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                    if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                                                        String string = (String)tuple22._1();
                                                                        JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                                                        if ("Title".equals(string) && jValue instanceof JsonAST.JString) {
                                                                            JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                            String title = jString.s();
                                                                            return (List)target.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$7 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$13(check$ifrefutable$7))).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
                                                                                Tuple2 tuple2 = x$3;
                                                                                Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                                                                    String string = (String)tuple22._1();
                                                                                    JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                                                                    if ("Identifier".equals(string) && jValue instanceof JsonAST.JObject) {
                                                                                        JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                                                                                        List identifier = jObject.obj();
                                                                                        return (List)identifier.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$8 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$15(check$ifrefutable$8))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
                                                                                            Tuple2 tuple2 = x$2;
                                                                                            Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                            if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                                                                                String string = (String)tuple22._1();
                                                                                                JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                                                                                if ("IDScheme".equals(string) && jValue instanceof JsonAST.JString) {
                                                                                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                                                    String idScheme = jString.s();
                                                                                                    return (List)identifier.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$9 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$17(check$ifrefutable$9))).map((Function1 & Serializable & scala.Serializable)x$1 -> {
                                                                                                        Tuple2 tuple2 = x$1;
                                                                                                        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                                        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                                                                                            String string = (String)tuple22._1();
                                                                                                            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                                                                                            if ("ID".equals(string) && jValue instanceof JsonAST.JString) {
                                                                                                                JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                                                                String id = jString.s();
                                                                                                                return new EBILinks(this, relation, publicationDate, title, pmid, id, idScheme);
                                                                                                            }
                                                                                                        }
                                                                                                        throw new MatchError((Object)tuple2);
                                                                                                    }, List$.MODULE$.canBuildFrom());
                                                                                                }
                                                                                            }
                                                                                            throw new MatchError((Object)tuple2);
                                                                                        }, List$.MODULE$.canBuildFrom());
                                                                                    }
                                                                                }
                                                                                throw new MatchError((Object)tuple2);
                                                                            }, List$.MODULE$.canBuildFrom());
                                                                        }
                                                                    }
                                                                    throw new MatchError((Object)tuple2);
                                                                }, List$.MODULE$.canBuildFrom());
                                                            }
                                                        }
                                                        throw new MatchError((Object)tuple2);
                                                    }, List$.MODULE$.canBuildFrom());
                                                }
                                            }
                                            throw new MatchError((Object)tuple2);
                                        }, List$.MODULE$.canBuildFrom());
                                    }
                                }
                                throw new MatchError((Object)tuple2);
                            }, List$.MODULE$.canBuildFrom());
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)jValue);
        });
    }

    @Test
    public void testCrossrefLinksToOAF() {
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/crossref_links"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            BioScholixTest.$anonfun$testCrossrefLinksToOAF$2(s);
            return BoxedUnit.UNIT;
        });
        List result = new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).map((Function1 & Serializable & scala.Serializable)s -> BioDBToOAF$.MODULE$.crossrefLinksToOaf(s)).toList();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.nonEmpty());
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    @Test
    public void testEBILinksToOAF() {
        BufferedReaderIterator iterator = this.GzFileIterator().apply(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/ebi_links.gz"), "UTF-8");
        String data = iterator.next();
        List res = (List)((List)BioDBToOAF$.MODULE$.parse_ebi_links(BioDBToOAF$.MODULE$.extractEBILinksFromDump(data).links()).filter((Function1 & Serializable & scala.Serializable)input -> BoxesRunTime.boxToBoolean((boolean)BioDBToOAF$.MODULE$.EBITargetLinksFilter(input)))).flatMap((Function1 & Serializable & scala.Serializable)input -> BioDBToOAF$.MODULE$.convertEBILinksToOaf(input), List$.MODULE$.canBuildFrom());
        Predef$.MODULE$.print((Object)BoxesRunTime.boxToInteger((int)res.length()));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(res.head()));
    }

    @Test
    public void scholixResolvedToOAF() {
        LazyRef formats$lzy = new LazyRef();
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/scholix_resolved"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            BioScholixTest.$anonfun$scholixResolvedToOAF$2(s);
            return BoxedUnit.UNIT;
        });
        List l2 = new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).map((Function1 & Serializable & scala.Serializable)input -> {
            LazyRef json$lzy = new LazyRef();
            return (BioDBToOAF.ScholixResolved)package$.MODULE$.jvalue2extractable(BioScholixTest.json$2(json$lzy, input)).extract((Formats)BioScholixTest.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(BioDBToOAF.ScholixResolved.class));
        }).toList();
        List result = (List)l2.map((Function1 & Serializable & scala.Serializable)s -> BioDBToOAF$.MODULE$.scholixResolvedToOAF(s), List$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)result.nonEmpty());
    }

    private final void GzFileIterator$lzycompute$1() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.GzFileIterator$module == null) {
                this.GzFileIterator$module = new BioScholixTest$GzFileIterator$(this);
            }
        }
    }

    private final void AuthorPID$lzycompute$1() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.AuthorPID$module == null) {
                this.AuthorPID$module = new BioScholixTest$AuthorPID$(this);
            }
        }
    }

    private final void EBILinks$lzycompute$1() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.EBILinks$module == null) {
                this.EBILinks$module = new BioScholixTest$EBILinks$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$testPid$1(String pid) {
        String pidCleaned = new PMIdentifier(pid, "ORCID").getPid();
        Predef$.MODULE$.println((Object)pidCleaned);
        Assertions.assertTrue((boolean)pidCleaned.matches("[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{3}[0-9X]"));
    }

    public static final /* synthetic */ boolean $anonfun$testPubmedToOaf$7(String p) {
        return "0037".equalsIgnoreCase(p);
    }

    public static final /* synthetic */ void $anonfun$checkPMArticle$1(PMAuthor a) {
        Assertions.assertNotNull((Object)a);
        Assertions.assertNotNull((Object)a.getFullName());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$1(StructuredProperty t) {
        Assertions.assertNotNull((Object)t.getValue());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$2(Author a) {
        Assertions.assertNotNull((Object)a.getFullname());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$3(Instance i) {
        Assertions.assertNotNull((Object)i.getCollectedfrom());
        Assertions.assertNotNull((Object)i.getPid());
        Assertions.assertNotNull((Object)i.getInstancetype());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$4(String oId) {
        Assertions.assertNotNull((Object)oId);
    }

    public static final /* synthetic */ boolean $anonfun$checkPubmedPublication$6(StructuredProperty pid) {
        return pid.getQualifier().getClassid().equalsIgnoreCase(PidType.pmc.toString());
    }

    public static final /* synthetic */ boolean $anonfun$checkPubmedPublication$5(Instance i) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(i.getPid()).asScala()).exists((Function1 & Serializable & scala.Serializable)pid -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$checkPubmedPublication$6(pid)));
    }

    public static final /* synthetic */ void $anonfun$testPDBToOAF$2(String s) {
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty());
    }

    public static final /* synthetic */ void $anonfun$testPDBToOAF$5(Oaf r) {
        Assertions.assertNotNull((Object)r);
    }

    public static final /* synthetic */ boolean $anonfun$testPDBToOAF$6(Oaf o) {
        return o instanceof Relation;
    }

    public static final /* synthetic */ void $anonfun$testUNIprotToOAF$2(String s) {
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty());
    }

    public static final /* synthetic */ void $anonfun$testUNIprotToOAF$5(Oaf r) {
        Assertions.assertNotNull((Object)r);
    }

    public static final /* synthetic */ boolean $anonfun$testUNIprotToOAF$6(Oaf o) {
        return o instanceof Relation;
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$1(LazyRef formats$lzy$1) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$1;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$1.initialized() ? (DefaultFormats$)formats$lzy$1.value() : (DefaultFormats$)formats$lzy$1.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$1(LazyRef formats$lzy$1) {
        if (formats$lzy$1.initialized()) {
            return (DefaultFormats$)formats$lzy$1.value();
        }
        return BioScholixTest.formats$lzycompute$1(formats$lzy$1);
    }

    private static final /* synthetic */ JsonAST.JValue json$lzycompute$1(LazyRef json$lzy$1, String input$1) {
        JsonAST.JValue jValue;
        LazyRef lazyRef = json$lzy$1;
        synchronized (lazyRef) {
            jValue = json$lzy$1.initialized() ? (JsonAST.JValue)json$lzy$1.value() : (JsonAST.JValue)json$lzy$1.initialize((Object)JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
        }
        return jValue;
    }

    private static final JsonAST.JValue json$1(LazyRef json$lzy$1, String input$1) {
        if (json$lzy$1.initialized()) {
            return (JsonAST.JValue)json$lzy$1.value();
        }
        return BioScholixTest.json$lzycompute$1(json$lzy$1, input$1);
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$1(JsonAST.JValue check$ifrefutable$1) {
        JsonAST.JValue jValue = check$ifrefutable$1;
        return jValue instanceof JsonAST.JObject;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("Target".equals(string) && jValue instanceof JsonAST.JObject) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$5(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("RelationshipType".equals(string) && jValue instanceof JsonAST.JObject) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$7(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("Name".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$9(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("PublicationDate".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$11(Tuple2 check$ifrefutable$6) {
        Tuple2 tuple2 = check$ifrefutable$6;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("Title".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$13(Tuple2 check$ifrefutable$7) {
        Tuple2 tuple2 = check$ifrefutable$7;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("Identifier".equals(string) && jValue instanceof JsonAST.JObject) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$15(Tuple2 check$ifrefutable$8) {
        Tuple2 tuple2 = check$ifrefutable$8;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("IDScheme".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$17(Tuple2 check$ifrefutable$9) {
        Tuple2 tuple2 = check$ifrefutable$9;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("ID".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$testCrossrefLinksToOAF$2(String s) {
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty());
    }

    public static final /* synthetic */ void $anonfun$scholixResolvedToOAF$2(String s) {
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty());
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$2(LazyRef formats$lzy$2) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$2;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$2.initialized() ? (DefaultFormats$)formats$lzy$2.value() : (DefaultFormats$)formats$lzy$2.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$2(LazyRef formats$lzy$2) {
        if (formats$lzy$2.initialized()) {
            return (DefaultFormats$)formats$lzy$2.value();
        }
        return BioScholixTest.formats$lzycompute$2(formats$lzy$2);
    }

    private static final /* synthetic */ JsonAST.JValue json$lzycompute$2(LazyRef json$lzy$2, String input$2) {
        JsonAST.JValue jValue;
        LazyRef lazyRef = json$lzy$2;
        synchronized (lazyRef) {
            jValue = json$lzy$2.initialized() ? (JsonAST.JValue)json$lzy$2.value() : (JsonAST.JValue)json$lzy$2.initialize((Object)JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$2), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
        }
        return jValue;
    }

    private static final JsonAST.JValue json$2(LazyRef json$lzy$2, String input$2) {
        if (json$lzy$2.initialized()) {
            return (JsonAST.JValue)json$lzy$2.value();
        }
        return BioScholixTest.json$lzycompute$2(json$lzy$2, input$2);
    }

    public BioScholixTest() {
        this.mapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public class AuthorPID
    implements Product,
    scala.Serializable {
        private final String pidType;
        private final String pid;
        public final /* synthetic */ BioScholixTest $outer;

        public String pidType() {
            return this.pidType;
        }

        public String pid() {
            return this.pid;
        }

        public AuthorPID copy(String pidType, String pid) {
            return new AuthorPID(this.eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer(), pidType, pid);
        }

        public String copy$default$1() {
            return this.pidType();
        }

        public String copy$default$2() {
            return this.pid();
        }

        public String productPrefix() {
            return "AuthorPID";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.pidType();
                }
                case 1: {
                    return this.pid();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AuthorPID;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AuthorPID)) return false;
            if (((AuthorPID)object).eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer() != this.eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            AuthorPID authorPID = (AuthorPID)x$1;
            String string = this.pidType();
            String string2 = authorPID.pidType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.pid();
            String string4 = authorPID.pid();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!authorPID.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer() {
            return this.$outer;
        }

        public AuthorPID(BioScholixTest $outer, String pidType, String pid) {
            this.pidType = pidType;
            this.pid = pid;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class BufferedReaderIterator
    implements Iterator<String> {
        private final BufferedReader reader;
        public final /* synthetic */ BioScholixTest $outer;

        public Iterator<String> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.isTraversableAgain$((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public Iterator<String> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<String> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<String> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<String> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<String, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.$plus$plus$((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<String, GenTraversableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public Iterator<String> filter(Function1<String, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<String, B, Object> p) {
            return Iterator.corresponds$((Iterator)this, that, p);
        }

        public Iterator<String> withFilter(Function1<String, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public Iterator<String> filterNot(Function1<String, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public Iterator<String> takeWhile(Function1<String, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<String> dropWhile(Function1<String, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<String, B>> zip(Iterator<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<String, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<String, U> f) {
            Iterator.foreach$((Iterator)this, f);
        }

        public boolean forall(Function1<String, Object> p) {
            return Iterator.forall$((Iterator)this, p);
        }

        public boolean exists(Function1<String, Object> p) {
            return Iterator.exists$((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public Option<String> find(Function1<String, Object> p) {
            return Iterator.find$((Iterator)this, p);
        }

        public int indexWhere(Function1<String, Object> p) {
            return Iterator.indexWhere$((Iterator)this, p);
        }

        public int indexWhere(Function1<String, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public BufferedIterator<String> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public int length() {
            return Iterator.length$((Iterator)this);
        }

        public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Traversable<String> toTraversable() {
            return Iterator.toTraversable$((Iterator)this);
        }

        public Iterator<String> toIterator() {
            return Iterator.toIterator$((Iterator)this);
        }

        public Stream<String> toStream() {
            return Iterator.toStream$((Iterator)this);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public List<String> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<String, Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, String, B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<String, B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, String, B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<String, B, B> op) {
            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, String, B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<String, B, B> op) {
            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<String> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Iterable<String> toIterable() {
            return TraversableOnce.toIterable$((TraversableOnce)this);
        }

        public Seq<String> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<String> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<String> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, String, Col> cbf) {
            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
        }

        public <T, U> Map<T, U> toMap(Predef$.less.colon.less<String, Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        public boolean hasNext() {
            return this.reader.ready();
        }

        public String next() {
            return this.reader.readLine();
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$BufferedReaderIterator$$$outer() {
            return this.$outer;
        }

        public BufferedReaderIterator(BioScholixTest $outer, BufferedReader reader) {
            this.reader = reader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Iterator.$init$((Iterator)this);
        }
    }

    public class EBILinks
    implements Product,
    scala.Serializable {
        private final String relType;
        private final String date;
        private final String title;
        private final String pmid;
        private final String targetPid;
        private final String targetPidType;
        public final /* synthetic */ BioScholixTest $outer;

        public String relType() {
            return this.relType;
        }

        public String date() {
            return this.date;
        }

        public String title() {
            return this.title;
        }

        public String pmid() {
            return this.pmid;
        }

        public String targetPid() {
            return this.targetPid;
        }

        public String targetPidType() {
            return this.targetPidType;
        }

        public EBILinks copy(String relType, String date, String title, String pmid, String targetPid, String targetPidType) {
            return new EBILinks(this.eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer(), relType, date, title, pmid, targetPid, targetPidType);
        }

        public String copy$default$1() {
            return this.relType();
        }

        public String copy$default$2() {
            return this.date();
        }

        public String copy$default$3() {
            return this.title();
        }

        public String copy$default$4() {
            return this.pmid();
        }

        public String copy$default$5() {
            return this.targetPid();
        }

        public String copy$default$6() {
            return this.targetPidType();
        }

        public String productPrefix() {
            return "EBILinks";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.relType();
                }
                case 1: {
                    return this.date();
                }
                case 2: {
                    return this.title();
                }
                case 3: {
                    return this.pmid();
                }
                case 4: {
                    return this.targetPid();
                }
                case 5: {
                    return this.targetPidType();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EBILinks;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EBILinks)) return false;
            if (((EBILinks)object).eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer() != this.eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            EBILinks eBILinks = (EBILinks)x$1;
            String string = this.relType();
            String string2 = eBILinks.relType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.date();
            String string4 = eBILinks.date();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.title();
            String string6 = eBILinks.title();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.pmid();
            String string8 = eBILinks.pmid();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.targetPid();
            String string10 = eBILinks.targetPid();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            String string11 = this.targetPidType();
            String string12 = eBILinks.targetPidType();
            if (string11 == null) {
                if (string12 != null) {
                    return false;
                }
            } else if (!string11.equals(string12)) return false;
            if (!eBILinks.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer() {
            return this.$outer;
        }

        public EBILinks(BioScholixTest $outer, String relType, String date, String title, String pmid, String targetPid, String targetPidType) {
            this.relType = relType;
            this.date = date;
            this.title = title;
            this.pmid = pmid;
            this.targetPid = targetPid;
            this.targetPidType = targetPidType;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

