/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.createunresolvedentities;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.createunresolvedentities.PrepareFOSSparkJob;
import eu.dnetlib.dhp.actionmanager.createunresolvedentities.PrepareSDGSparkJob;
import eu.dnetlib.dhp.actionmanager.createunresolvedentities.SparkSaveUnresolved;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Measure;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProduceTest {
    private static final Logger log = LoggerFactory.getLogger(ProduceTest.class);
    private static Path workingDir;
    private static SparkSession spark;
    private static LocalFileSystem fs;
    private static final ObjectMapper OBJECT_MAPPER;
    private static final String ID_PREFIX = "50|doi_________";

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(ProduceTest.class.getSimpleName(), new FileAttribute[0]);
        fs = FileSystem.getLocal((Configuration)new Configuration());
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(ProduceTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(ProduceTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void produceTestSubjects() throws Exception {
        JavaRDD<Result> tmp = this.getResultJavaRDD();
        List sbjs = tmp.filter((Function & Serializable)row -> row.getSubject() != null && row.getSubject().size() > 0).flatMap((FlatMapFunction & Serializable)row -> row.getSubject().iterator()).collect();
        sbjs.forEach(sbj -> Assertions.assertEquals((Object)"FOS", (Object)sbj.getQualifier().getClassid()));
        sbjs.forEach(sbj -> Assertions.assertEquals((Object)"Fields of Science and Technology classification", (Object)sbj.getQualifier().getClassname()));
        sbjs.forEach(sbj -> Assertions.assertEquals((Object)"dnet:subject_classification_typologies", (Object)sbj.getQualifier().getSchemeid()));
        sbjs.forEach(sbj -> Assertions.assertEquals((Object)"dnet:subject_classification_typologies", (Object)sbj.getQualifier().getSchemename()));
        sbjs.forEach(sbj -> Assertions.assertEquals((Object)false, (Object)sbj.getDataInfo().getDeletedbyinference()));
        sbjs.forEach(sbj -> Assertions.assertEquals((Object)true, (Object)sbj.getDataInfo().getInferred()));
        sbjs.forEach(sbj -> Assertions.assertEquals((Object)false, (Object)sbj.getDataInfo().getInvisible()));
        sbjs.forEach(sbj -> Assertions.assertEquals((Object)"", (Object)sbj.getDataInfo().getTrust()));
        sbjs.forEach(sbj -> Assertions.assertEquals((Object)"update", (Object)sbj.getDataInfo().getInferenceprovenance()));
        sbjs.forEach(sbj -> Assertions.assertEquals((Object)"subject:fos", (Object)sbj.getDataInfo().getProvenanceaction().getClassid()));
        sbjs.forEach(sbj -> Assertions.assertEquals((Object)"Inferred by OpenAIRE", (Object)sbj.getDataInfo().getProvenanceaction().getClassname()));
        sbjs.forEach(sbj -> Assertions.assertEquals((Object)"dnet:provenanceActions", (Object)sbj.getDataInfo().getProvenanceaction().getSchemeid()));
        sbjs.forEach(sbj -> Assertions.assertEquals((Object)"dnet:provenanceActions", (Object)sbj.getDataInfo().getProvenanceaction().getSchemename()));
    }

    @Test
    void produceTestMeasuress() throws Exception {
        JavaRDD<Result> tmp = this.getResultJavaRDD();
        List mes = tmp.filter((Function & Serializable)row -> row.getInstance() != null && row.getInstance().size() > 0).flatMap((FlatMapFunction & Serializable)row -> row.getInstance().iterator()).flatMap((FlatMapFunction & Serializable)i -> i.getMeasures().iterator()).flatMap((FlatMapFunction & Serializable)m -> m.getUnit().iterator()).collect();
        mes.forEach(sbj -> Assertions.assertEquals((Object)false, (Object)sbj.getDataInfo().getDeletedbyinference()));
        mes.forEach(sbj -> Assertions.assertEquals((Object)true, (Object)sbj.getDataInfo().getInferred()));
        mes.forEach(sbj -> Assertions.assertEquals((Object)false, (Object)sbj.getDataInfo().getInvisible()));
        mes.forEach(sbj -> Assertions.assertEquals((Object)"", (Object)sbj.getDataInfo().getTrust()));
        mes.forEach(sbj -> Assertions.assertEquals((Object)"update", (Object)sbj.getDataInfo().getInferenceprovenance()));
        mes.forEach(sbj -> Assertions.assertEquals((Object)"measure:bip", (Object)sbj.getDataInfo().getProvenanceaction().getClassid()));
        mes.forEach(sbj -> Assertions.assertEquals((Object)"Inferred by OpenAIRE", (Object)sbj.getDataInfo().getProvenanceaction().getClassname()));
        mes.forEach(sbj -> Assertions.assertEquals((Object)"dnet:provenanceActions", (Object)sbj.getDataInfo().getProvenanceaction().getSchemeid()));
        mes.forEach(sbj -> Assertions.assertEquals((Object)"dnet:provenanceActions", (Object)sbj.getDataInfo().getProvenanceaction().getSchemename()));
    }

    @Test
    void produceTest6Subjects() throws Exception {
        String doi = "unresolved::10.3390/s18072310::doi";
        JavaRDD<Result> tmp = this.getResultJavaRDD();
        Assertions.assertEquals((int)6, (int)((Result)tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.3390/s18072310::doi")).collect().get(0)).getSubject().size());
        List sbjs = tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.3390/s18072310::doi")).flatMap((FlatMapFunction & Serializable)row -> row.getSubject().iterator()).collect();
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("04 agricultural and veterinary sciences")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("0404 agricultural biotechnology")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("040502 food science")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("03 medical and health sciences")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("0303 health sciences")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("030309 nutrition & dietetics")));
    }

    @Test
    void produceTest3Measures() throws Exception {
        String doi = "unresolved::10.3390/s18072310::doi";
        JavaRDD<Result> tmp = this.getResultJavaRDD();
        tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.3390/s18072310::doi")).foreach((VoidFunction & Serializable)r -> System.out.println(OBJECT_MAPPER.writeValueAsString(r)));
        Assertions.assertEquals((int)3, (int)((Instance)((Result)tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.3390/s18072310::doi")).collect().get(0)).getInstance().get(0)).getMeasures().size());
        List measures = tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.3390/s18072310::doi")).flatMap((FlatMapFunction & Serializable)row -> row.getInstance().iterator()).flatMap((FlatMapFunction & Serializable)inst -> inst.getMeasures().iterator()).collect();
        Assertions.assertEquals((Object)"7.5597134689e-09", (Object)((KeyValue)((Measure)measures.stream().filter(mes -> mes.getId().equals("influence")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"4.903880192", (Object)((KeyValue)((Measure)measures.stream().filter(mes -> mes.getId().equals("popularity_alt")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"1.17977512835e-08", (Object)((KeyValue)((Measure)measures.stream().filter(mes -> mes.getId().equals("popularity")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"10.3390/s18072310", (Object)((StructuredProperty)((Instance)((Result)tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.3390/s18072310::doi")).collect().get(0)).getInstance().get(0)).getPid().get(0)).getValue().toLowerCase());
        Assertions.assertEquals((Object)"doi", (Object)((StructuredProperty)((Instance)((Result)tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.3390/s18072310::doi")).collect().get(0)).getInstance().get(0)).getPid().get(0)).getQualifier().getClassid());
        Assertions.assertEquals((Object)"Digital Object Identifier", (Object)((StructuredProperty)((Instance)((Result)tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.3390/s18072310::doi")).collect().get(0)).getInstance().get(0)).getPid().get(0)).getQualifier().getClassname());
    }

    @Test
    void produceTestMeasures() throws Exception {
        String doi = "unresolved::10.3390/s18072310::doi";
        JavaRDD<Result> tmp = this.getResultJavaRDD();
        List mes = tmp.filter((Function & Serializable)row -> row.getInstance() != null && row.getInstance().size() > 0).flatMap((FlatMapFunction & Serializable)row -> row.getInstance().iterator()).flatMap((FlatMapFunction & Serializable)i -> i.getPid().iterator()).collect();
        Assertions.assertEquals((int)86, (int)mes.size());
        tmp.filter((Function & Serializable)row -> row.getInstance() != null && row.getInstance().size() > 0).foreach((VoidFunction & Serializable)e -> Assertions.assertEquals((Object)"sysimport:enrich", (Object)e.getDataInfo().getProvenanceaction().getClassid()));
    }

    @Test
    void produceTestSomeNumbers() throws Exception {
        String doi = "unresolved::10.3390/s18072310::doi";
        JavaRDD<Result> tmp = this.getResultJavaRDD();
        Assertions.assertEquals((long)105L, (long)tmp.count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.3390/s18072310::doi")).count());
        Assertions.assertEquals((long)19L, (long)tmp.filter((Function & Serializable)row -> !row.getId().equals("unresolved::10.3390/s18072310::doi")).filter((Function & Serializable)row -> row.getSubject() != null).count());
        Assertions.assertEquals((long)85L, (long)tmp.filter((Function & Serializable)row -> !row.getId().equals("unresolved::10.3390/s18072310::doi")).filter((Function & Serializable)r -> r.getInstance() != null && r.getInstance().size() > 0).count());
    }

    private JavaRDD<Result> getResultJavaRDD() throws Exception {
        String fosPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/createunresolvedentities/fos/fos.json").getPath();
        PrepareFOSSparkJob.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", fosPath, "-outputPath", workingDir.toString() + "/work"});
        SparkSaveUnresolved.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", workingDir.toString() + "/work", "-outputPath", workingDir.toString() + "/unresolved"});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        return sc.textFile(workingDir.toString() + "/unresolved").map((Function & Serializable)item -> (Result)OBJECT_MAPPER.readValue(item, Result.class));
    }

    @Test
    public JavaRDD<Result> getResultFosJavaRDD() throws Exception {
        String fosPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/createunresolvedentities/fos/fos_sbs_2.json").getPath();
        PrepareFOSSparkJob.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", fosPath, "-outputPath", workingDir.toString() + "/work"});
        SparkSaveUnresolved.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", workingDir.toString() + "/work", "-outputPath", workingDir.toString() + "/unresolved"});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/unresolved").map((Function & Serializable)item -> (Result)OBJECT_MAPPER.readValue(item, Result.class));
        tmp.foreach((VoidFunction & Serializable)r -> System.out.println(new ObjectMapper().writeValueAsString(r)));
        return tmp;
    }

    @Test
    void prepareTest5Subjects() throws Exception {
        String doi = "unresolved::10.1063/5.0032658::doi";
        JavaRDD<Result> tmp = this.getResultJavaRDD();
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.1063/5.0032658::doi")).count());
        Assertions.assertEquals((int)5, (int)((Result)tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.1063/5.0032658::doi")).collect().get(0)).getSubject().size());
        List sbjs = tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.1063/5.0032658::doi")).flatMap((FlatMapFunction & Serializable)row -> row.getSubject().iterator()).collect();
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("01 natural sciences")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("0103 physical sciences")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("010304 chemical physics")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("0104 chemical sciences")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("010402 general chemistry")));
    }

    private JavaRDD<Result> getResultJavaRDDPlusSDG() throws Exception {
        String fosPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/createunresolvedentities/fos/fos.json").getPath();
        PrepareFOSSparkJob.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", fosPath, "-outputPath", workingDir.toString() + "/work"});
        String sdgPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/createunresolvedentities/sdg/sdg.json").getPath();
        PrepareSDGSparkJob.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", sdgPath, "-outputPath", workingDir.toString() + "/work"});
        SparkSaveUnresolved.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", workingDir.toString() + "/work", "-outputPath", workingDir.toString() + "/unresolved"});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        return sc.textFile(workingDir.toString() + "/unresolved").map((Function & Serializable)item -> (Result)OBJECT_MAPPER.readValue(item, Result.class));
    }

    @Test
    void produceTestSomeNumbersWithSDG() throws Exception {
        String doi = "unresolved::10.3390/s18072310::doi";
        JavaRDD<Result> tmp = this.getResultJavaRDDPlusSDG();
        Assertions.assertEquals((long)136L, (long)tmp.count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.3390/s18072310::doi")).count());
        Assertions.assertEquals((long)50L, (long)tmp.filter((Function & Serializable)row -> !row.getId().equals("unresolved::10.3390/s18072310::doi")).filter((Function & Serializable)row -> row.getSubject() != null).count());
    }

    @Test
    void produceTest7Subjects() throws Exception {
        String doi = "unresolved::10.3390/s18072310::doi";
        JavaRDD<Result> tmp = this.getResultJavaRDDPlusSDG();
        Assertions.assertEquals((int)7, (int)((Result)tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.3390/s18072310::doi")).collect().get(0)).getSubject().size());
        List sbjs = tmp.filter((Function & Serializable)row -> row.getId().equals("unresolved::10.3390/s18072310::doi")).flatMap((FlatMapFunction & Serializable)row -> row.getSubject().iterator()).collect();
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("04 agricultural and veterinary sciences")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("0404 agricultural biotechnology")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("040502 food science")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("03 medical and health sciences")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("0303 health sciences")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("030309 nutrition & dietetics")));
        Assertions.assertEquals((Object)true, (Object)sbjs.stream().anyMatch(sbj -> sbj.getValue().equals("1. No poverty")));
    }

    @Test
    void produceTestSubjectsWithSDG() throws Exception {
        JavaRDD<Result> tmp = this.getResultJavaRDDPlusSDG();
        List sbjs_sdg = tmp.filter((Function & Serializable)row -> row.getSubject() != null && row.getSubject().size() > 0).flatMap((FlatMapFunction & Serializable)row -> row.getSubject().iterator()).filter((Function & Serializable)sbj -> sbj.getQualifier().getClassid().equals("SDG")).collect();
        sbjs_sdg.forEach(sbj -> Assertions.assertEquals((Object)"SDG", (Object)sbj.getQualifier().getClassid()));
        sbjs_sdg.forEach(sbj -> Assertions.assertEquals((Object)"Sustainable Development Goals", (Object)sbj.getQualifier().getClassname()));
        sbjs_sdg.forEach(sbj -> Assertions.assertEquals((Object)"dnet:subject_classification_typologies", (Object)sbj.getQualifier().getSchemeid()));
        sbjs_sdg.forEach(sbj -> Assertions.assertEquals((Object)"dnet:subject_classification_typologies", (Object)sbj.getQualifier().getSchemename()));
        sbjs_sdg.forEach(sbj -> Assertions.assertEquals((Object)false, (Object)sbj.getDataInfo().getDeletedbyinference()));
        sbjs_sdg.forEach(sbj -> Assertions.assertEquals((Object)true, (Object)sbj.getDataInfo().getInferred()));
        sbjs_sdg.forEach(sbj -> Assertions.assertEquals((Object)false, (Object)sbj.getDataInfo().getInvisible()));
        sbjs_sdg.forEach(sbj -> Assertions.assertEquals((Object)"", (Object)sbj.getDataInfo().getTrust()));
        sbjs_sdg.forEach(sbj -> Assertions.assertEquals((Object)"update", (Object)sbj.getDataInfo().getInferenceprovenance()));
        sbjs_sdg.forEach(sbj -> Assertions.assertEquals((Object)"subject:sdg", (Object)sbj.getDataInfo().getProvenanceaction().getClassid()));
        sbjs_sdg.forEach(sbj -> Assertions.assertEquals((Object)"Inferred by OpenAIRE", (Object)sbj.getDataInfo().getProvenanceaction().getClassname()));
        sbjs_sdg.forEach(sbj -> Assertions.assertEquals((Object)"dnet:provenanceActions", (Object)sbj.getDataInfo().getProvenanceaction().getSchemeid()));
        sbjs_sdg.forEach(sbj -> Assertions.assertEquals((Object)"dnet:provenanceActions", (Object)sbj.getDataInfo().getProvenanceaction().getSchemename()));
    }

    static {
        OBJECT_MAPPER = new ObjectMapper();
    }
}

