/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.transformation;

import eu.dnetlib.dhp.schema.mdstore.MetadataRecord;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.ForeachFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ReadParquetMetadataRecordsTest {
    private static final String VALIDATED_PARQUET_ROOT_DIR = "/Users/michele/Develop/temp/store_native_validated";
    private static final String NOT_VALIDATED_PARQUET_ROOT_DIR = "/Users/michele/Develop/temp/store_native_not_validated";
    private SparkConf sparkConf;

    @BeforeEach
    public void setUp() throws IOException, ISLookUpException {
        this.sparkConf = new SparkConf();
        this.sparkConf.setMaster("local[*]");
        this.sparkConf.set("spark.driver.host", "localhost");
        this.sparkConf.set("spark.ui.enabled", "false");
    }

    @Test
    @Disabled
    void testReadParquetAddNewField() {
        try (SparkSession spark = SparkSession.builder().config(this.sparkConf).getOrCreate();){
            Dataset records1 = spark.read().parquet(VALIDATED_PARQUET_ROOT_DIR).as(Encoders.bean(MetadataRecord.class));
            DataType dataType = Arrays.stream(records1.schema().fields()).filter(f -> "validationResults".equals(f.name())).map(StructField::dataType).findFirst().orElseThrow(() -> new RuntimeException("Missing validationResults field in new schema"));
            Dataset rows2 = spark.read().parquet(NOT_VALIDATED_PARQUET_ROOT_DIR);
            Dataset rowsWithNewField = ArrayUtils.contains((Object[])rows2.schema().fieldNames(), (Object)"validationResults") ? rows2 : rows2.withColumn("validationResults", functions.lit(null).cast(dataType));
            Dataset records2 = rowsWithNewField.as(Encoders.bean(MetadataRecord.class));
            Dataset records = records1.union(records2);
            records.foreach((ForeachFunction & Serializable)r -> System.out.println(r.getId()));
            Assertions.assertTrue((records.count() > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    @Disabled
    void testReadParquet() {
        try (SparkSession spark = SparkSession.builder().config(this.sparkConf).getOrCreate();){
            Dataset records = spark.read().parquet(VALIDATED_PARQUET_ROOT_DIR).as(Encoders.bean(MetadataRecord.class));
            records.foreach((ForeachFunction & Serializable)r -> System.out.println(r.getId()));
            Assertions.assertTrue((records.count() > 0L ? 1 : 0) != 0);
        }
    }
}

