/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.project;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.project.ProjectSubset;
import eu.dnetlib.dhp.actionmanager.project.utils.model.CSVProject;
import eu.dnetlib.dhp.actionmanager.project.utils.model.Project;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class PrepareProjects {
    private static final Logger log = LoggerFactory.getLogger(PrepareProjects.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareProjects.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/project/prepare_project_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String projectPath = parser.get("projectPath");
        log.info("projectPath {}: ", (Object)projectPath);
        String workingPath = parser.get("workingPath");
        log.info("workingPath {}: ", (Object)workingPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}: ", (Object)outputPath);
        String dbProjectPath = parser.get("dbProjectPath");
        log.info("dbProjectPath {}: ", (Object)dbProjectPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PrepareProjects.removeOutputDir(spark, outputPath);
            PrepareProjects.exec(spark, projectPath, dbProjectPath, outputPath);
        });
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }

    private static void exec(SparkSession spark, String projectPath, String dbProjectPath, String outputPath) {
        Dataset<Project> project = PrepareProjects.readPath(spark, projectPath, Project.class);
        Dataset<ProjectSubset> dbProjects = PrepareProjects.readPath(spark, dbProjectPath, ProjectSubset.class);
        dbProjects.joinWith(project, dbProjects.col("code").equalTo((Object)project.col("id")), "left").flatMap(PrepareProjects.getTuple2CSVProjectFlatMapFunction(), Encoders.bean(CSVProject.class)).filter(Objects::nonNull).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(outputPath);
    }

    private static FlatMapFunction<Tuple2<ProjectSubset, Project>, CSVProject> getTuple2CSVProjectFlatMapFunction() {
        return (FlatMapFunction & Serializable)value -> {
            ArrayList csvProjectList = new ArrayList();
            if (Optional.ofNullable((Project)value._2()).isPresent()) {
                Project project = (Project)value._2();
                String[] programme = project.getLegalBasis().split(";");
                String topic = project.getTopics();
                Arrays.stream(programme).forEach(p -> {
                    CSVProject proj = new CSVProject();
                    proj.setTopics(topic);
                    proj.setProgramme((String)p);
                    proj.setId(project.getId());
                    csvProjectList.add(proj);
                });
            }
            return csvProjectList.iterator();
        };
    }

    public static <R> Dataset<R> readPath(SparkSession spark, String inputPath, Class<R> clazz) {
        return spark.read().textFile(inputPath).map((MapFunction & Serializable)value -> OBJECT_MAPPER.readValue(value, clazz), Encoders.bean(clazz));
    }
}

