/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.project.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.project.utils.EXCELParser;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpConnector2;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class ReadExcel
implements Closeable {
    private static final Log log = LogFactory.getLog(ReadExcel.class);
    private final BufferedWriter writer;
    private final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final InputStream excelFile;

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)ReadExcel.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/project/parameters.json")));
        parser.parseArgument(args);
        String fileURL = parser.get("fileURL");
        String hdfsPath = parser.get("hdfsPath");
        String hdfsNameNode = parser.get("hdfsNameNode");
        String classForName = parser.get("classForName");
        String sheetName = parser.get("sheetName");
        try (ReadExcel readExcel = new ReadExcel(hdfsPath, hdfsNameNode, fileURL);){
            log.info((Object)"Getting Excel file...");
            readExcel.execute(classForName, sheetName);
        }
    }

    public void execute(String classForName, String sheetName) throws IOException, ClassNotFoundException, InvalidFormatException, IllegalAccessException, InstantiationException {
        EXCELParser excelParser = new EXCELParser();
        excelParser.parse(this.excelFile, classForName, sheetName).stream().forEach(this::write);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public ReadExcel(String hdfsPath, String hdfsNameNode, String fileURL) throws CollectorException, IOException {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", hdfsNameNode);
        HttpConnector2 httpConnector = new HttpConnector2();
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        Path hdfsWritePath = new Path(hdfsPath);
        if (fileSystem.exists(hdfsWritePath)) {
            fileSystem.delete(hdfsWritePath, false);
        }
        FSDataOutputStream fos = fileSystem.create(hdfsWritePath);
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));
        this.excelFile = httpConnector.getInputSourceAsStream(fileURL);
    }

    protected void write(Object p) {
        try {
            this.writer.write(this.OBJECT_MAPPER.writeValueAsString(p));
            this.writer.newLine();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

