/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.osf;

import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.osf.OsfPreprintsCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.utils.JsonUtils;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.common.collection.HttpConnector2;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.dom4j.DocumentHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsfPreprintsCollectorPluginTest {
    private static final Logger log = LoggerFactory.getLogger(OsfPreprintsCollectorPlugin.class);
    private final String baseUrl = "https://api.osf.io/v2/preprints/";
    private final int pageSize = 100;
    private final ApiDescriptor api = new ApiDescriptor();
    private OsfPreprintsCollectorPlugin plugin;

    @BeforeEach
    public void setUp() {
        HashMap<String, CallSite> params = new HashMap<String, CallSite>();
        params.put("pageSize", (CallSite)((Object)("" + this.pageSize)));
        this.api.setBaseUrl(this.baseUrl);
        this.api.setParams(params);
        this.plugin = new OsfPreprintsCollectorPlugin(new HttpClientParams());
    }

    @Test
    @Disabled
    void test_one() throws CollectorException {
        this.plugin.collect(this.api, new AggregatorReport()).limit(1L).forEach(arg_0 -> ((Logger)log).info(arg_0));
    }

    @Test
    @Disabled
    void test_limited() throws CollectorException {
        AtomicInteger i = new AtomicInteger(0);
        Stream stream = this.plugin.collect(this.api, new AggregatorReport());
        stream.limit(2000L).forEach(s -> {
            Assertions.assertTrue((s.length() > 0 ? 1 : 0) != 0);
            i.incrementAndGet();
            log.info(s);
        });
        log.info("{}", (Object)i.intValue());
        Assertions.assertTrue((i.intValue() > 0 ? 1 : 0) != 0);
    }

    @Test
    @Disabled
    void test_all() throws CollectorException {
        AtomicLong i = new AtomicLong(0L);
        Stream stream = this.plugin.collect(this.api, new AggregatorReport());
        stream.forEach(s -> {
            Assertions.assertTrue((s.length() > 0 ? 1 : 0) != 0);
            if (i.incrementAndGet() % 1000L == 0L) {
                log.info("COLLECTED: {}", (Object)i.get());
            }
        });
        log.info("TOTAL: {}", (Object)i.get());
        Assertions.assertTrue((i.get() > 0L ? 1 : 0) != 0);
    }

    @Test
    @Disabled
    void test_authentication_required() {
        HttpConnector2 connector = new HttpConnector2();
        try {
            String res = connector.getInputSource("https://api.osf.io/v2/preprints/ydtzx/contributors/?format=json");
            System.out.println(res);
            Assertions.fail();
        }
        catch (Throwable e) {
            System.out.println("**** ERROR: " + e.getMessage());
            if (e instanceof CollectorException && e.getMessage().contains("401")) {
                System.out.println(" XML: " + String.valueOf(DocumentHelper.createDocument().getRootElement().detach()));
            }
            Assertions.assertTrue((boolean)e.getMessage().contains("401"));
        }
    }

    @Test
    void testXML() {
        String xml = JsonUtils.convertToXML((String)"{'next':null}");
        System.out.println(xml);
    }
}

