/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.datacite;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import eu.dnetlib.dhp.aggregation.AbstractVocabularyTest;
import eu.dnetlib.dhp.datacite.DataciteToOAFTransformation$;
import eu.dnetlib.dhp.datacite.DataciteUtilityTest$;
import eu.dnetlib.dhp.datacite.GenerateDataciteDatasetSpark;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={MockitoExtension.class})
@ScalaSignature(bytes="\u0006\u0005Q4A!\u0004\b\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001a\u0001\n\u0013\u0019\u0003b\u0002\u0018\u0001\u0001\u0004%Ia\f\u0005\u0007q\u0001\u0001\u000b\u0015\u0002\u0013\t\u000fe\u0002!\u0019!C\u0001u!11\t\u0001Q\u0001\nmBQ\u0001\u0012\u0001\u0005\u0002\u0015CQ!\u0015\u0001\u0005\u0002\u0015CQA\u0016\u0001\u0005\u0002]CQ\u0001\u0018\u0001\u0005\u0002\u0015CQA\u0018\u0001\u0005\u0002\u0015CQ\u0001\u0019\u0001\u0005\u0002\u0015\u0013\u0011\u0003R1uC\u000eLG/\u001a+p\u001f\u00063E+Z:u\u0015\ty\u0001#\u0001\u0005eCR\f7-\u001b;f\u0015\t\t\"#A\u0002eQBT!a\u0005\u000b\u0002\u000f\u0011tW\r\u001e7jE*\tQ#\u0001\u0002fk\u000e\u00011C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\tY\u0002#A\u0006bO\u001e\u0014XmZ1uS>t\u0017BA\u000f\u001b\u0005Y\t%m\u001d;sC\u000e$hk\\2bEVd\u0017M]=UKN$\u0018A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u000f\u0003)9xN]6j]\u001e$\u0015N]\u000b\u0002IA\u0011Q\u0005L\u0007\u0002M)\u0011q\u0005K\u0001\u0005M&dWM\u0003\u0002*U\u0005\u0019a.[8\u000b\u0003-\nAA[1wC&\u0011QF\n\u0002\u0005!\u0006$\b.\u0001\bx_J\\\u0017N\\4ESJ|F%Z9\u0015\u0005A2\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$\u0001B+oSRDqaN\u0002\u0002\u0002\u0003\u0007A%A\u0002yIE\n1b^8sW&tw\rR5sA\u0005\u0019An\\4\u0016\u0003m\u0002\"\u0001P!\u000e\u0003uR!AP \u0002\u000bMdg\r\u000e6\u000b\u0003\u0001\u000b1a\u001c:h\u0013\t\u0011UH\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\u0003tKR,\u0006\u000fF\u00011Q\t9q\t\u0005\u0002I\u001f6\t\u0011J\u0003\u0002K\u0017\u0006\u0019\u0011\r]5\u000b\u00051k\u0015a\u00026va&$XM\u001d\u0006\u0003\u001d~\nQA[;oSRL!\u0001U%\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\tA1\u000b\u0005\u0002I)&\u0011Q+\u0013\u0002\n\u0003\u001a$XM]#bG\"\fq\u0002^3ti\u0012\u000bG/Z'baBLgnZ\u000b\u0002a!\u0012\u0011\"\u0017\t\u0003\u0011jK!aW%\u0003\tQ+7\u000f^\u0001\fi\u0016\u001cHoQ8om\u0016\u0014H\u000f\u000b\u0002\u000b3\u0006YA/Z:u\u001b\u0006\u0004\b/\u001b8hQ\tY\u0011,\u0001\u0006uKN$h)\u001b7uKJD#\u0001D-)\t\u0001\u0019\u0017N\u001b\t\u0003I\u001el\u0011!\u001a\u0006\u0003M&\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005!,'AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\n1nI\u0001m!\ti'/D\u0001o\u0015\tauN\u0003\u0002Oa*\u0011\u0011oP\u0001\b[>\u001c7.\u001b;p\u0013\t\u0019hN\u0001\tN_\u000e\\\u0017\u000e^8FqR,gn]5p]\u0002")
public class DataciteToOAFTest
extends AbstractVocabularyTest {
    private Path workingDir = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    private Path workingDir() {
        return this.workingDir;
    }

    private void workingDir_$eq(Path x$1) {
        this.workingDir = x$1;
    }

    public Logger log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        this.workingDir_$eq(Files.createTempDirectory(this.getClass().getSimpleName(), new FileAttribute[0]));
        super.setUpVocabulary();
    }

    @AfterEach
    public void tearDown() {
        FileUtils.deleteDirectory((File)this.workingDir().toFile());
    }

    @Test
    public void testDateMapping() {
        String inputDate = "2021-07-14T11:52:54+0000";
        SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        Date dt = ISO8601FORMAT.parse(inputDate);
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToLong((long)dt.getTime()));
    }

    @Test
    public void testConvert() {
        String path = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/datacite/dataset").getPath();
        SparkConf conf = new SparkConf();
        conf.set("spark.driver.host", "localhost");
        conf.set("spark.ui.enabled", "false");
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).master("local[*]").getOrCreate();
        Encoder oafEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Oaf.class));
        GenerateDataciteDatasetSpark instance = new GenerateDataciteDatasetSpark(null, null, this.log());
        String targetPath = this.workingDir() + "/result";
        instance.generateDataciteDataset(path, true, this.vocabularies, targetPath, spark);
        long nativeSize = spark.read().load(path).count();
        Assertions.assertEquals((long)100L, (long)nativeSize);
        Dataset result = spark.read().text(targetPath).as(spark.implicits().newStringEncoder()).map((Function1 & Serializable)input -> DataciteUtilityTest$.MODULE$.convertToOAF((String)input), Encoders$.MODULE$.STRING());
        result.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("value").alias("class")})).agg(functions$.MODULE$.count("value").alias("Total"), (Seq)Nil$.MODULE$).show(false);
        long t = spark.read().text(targetPath).as(spark.implicits().newStringEncoder()).count();
        Assertions.assertTrue((t > 0L ? 1 : 0) != 0);
        spark.stop();
    }

    @Test
    public void testMapping() {
        String record = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/actionmanager/datacite/record.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        List res = DataciteToOAFTransformation$.MODULE$.generateOAF(record, 0L, 0L, this.vocabularies, true);
        res.foreach((Function1 & Serializable)r -> {
            DataciteToOAFTest.$anonfun$testMapping$1(mapper, r);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFilter() {
        String record = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/actionmanager/datacite/record_fairsharing.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        List res = DataciteToOAFTransformation$.MODULE$.generateOAF(record, 0L, 0L, this.vocabularies, true);
        Assertions.assertTrue((boolean)res.isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testMapping$1(ObjectMapper mapper$1, Oaf r) {
        Predef$.MODULE$.println((Object)mapper$1.writeValueAsString((Object)r));
        Predef$.MODULE$.println((Object)"----------------------------");
    }
}

