/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.bio;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import eu.dnetlib.dhp.aggregation.AbstractVocabularyTest;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.dhp.sx.bio.BioDBToOAF;
import eu.dnetlib.dhp.sx.bio.BioDBToOAF$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$AuthorPID$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$EBILinks$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$GzFileIterator$;
import eu.dnetlib.dhp.sx.bio.ebi.SparkCreatePubmedDump;
import eu.dnetlib.dhp.sx.bio.pubmed.PMArticle;
import eu.dnetlib.dhp.sx.bio.pubmed.PMAuthor;
import eu.dnetlib.dhp.sx.bio.pubmed.PMIdentifier;
import eu.dnetlib.dhp.sx.bio.pubmed.PMParser;
import eu.dnetlib.dhp.sx.bio.pubmed.PMParser2;
import eu.dnetlib.dhp.sx.bio.pubmed.PMSubject;
import eu.dnetlib.dhp.sx.bio.pubmed.PubMedToOaf$;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.io.IOUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.JsonAST$;
import org.json4s.MonadicJValue$;
import org.json4s.SomeValue$;
import org.json4s.jackson.JsonMethods$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.LoggerFactory;
import scala.;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExtendWith(value={MockitoExtension.class})
@ScalaSignature(bytes="\u0006\u0005\r\u0005f\u0001B/_\u0001%DQ\u0001\u001d\u0001\u0005\u0002EDq\u0001\u001e\u0001C\u0002\u0013\u0005Q\u000fC\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u0002<\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n\u00191\u0011\u0011\u0007\u0001\u0001\u0003gA!\"a\u0019\u0006\u0005\u0003\u0005\u000b\u0011BA3\u0011\u0019\u0001X\u0001\"\u0001\u0002v!9\u0011QP\u0003\u0005B\u0005}\u0004bBAD\u000b\u0011\u0005\u0013\u0011R\u0004\b\u0003+\u0003\u0001\u0012AAL\r\u001d\tI\n\u0001E\u0001\u00037Ca\u0001]\u0006\u0005\u0002\u0005u\u0005bBAP\u0017\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003c\u0003A\u0011AA\u0005\u0011\u001d\tY\f\u0001C\u0001\u0003{3a!!3\u0001\u0001\u0006-\u0007BCAm!\tU\r\u0011\"\u0001\u0002\\\"Q\u0011Q\u001c\t\u0003\u0012\u0003\u0006I!a\u0015\t\u0015\u0005}\u0007C!f\u0001\n\u0003\tY\u000e\u0003\u0006\u0002bB\u0011\t\u0012)A\u0005\u0003'Ba\u0001\u001d\t\u0005\u0002\u0005\r\b\"CAv!\u0005\u0005I\u0011AAw\u0011%\t\u0019\u0010EI\u0001\n\u0003\t)\u0010C\u0005\u0003\fA\t\n\u0011\"\u0001\u0002v\"I!Q\u0002\t\u0002\u0002\u0013\u0005#q\u0002\u0005\n\u0005#\u0001\u0012\u0011!C\u0001\u0005'A\u0011Ba\u0007\u0011\u0003\u0003%\tA!\b\t\u0013\t%\u0002#!A\u0005B\t-\u0002\"\u0003B\u001c!\u0005\u0005I\u0011\u0001B\u001d\u0011%\u0011i\u0004EA\u0001\n\u0003\u0012y\u0004C\u0005\u0003DA\t\t\u0011\"\u0011\u0003F!I!q\t\t\u0002\u0002\u0013\u0005\u0013\u0011\u0012\u0005\n\u0005\u0013\u0002\u0012\u0011!C!\u0005\u0017:\u0011Ba\u0014\u0001\u0003\u0003E\tA!\u0015\u0007\u0013\u0005%\u0007!!A\t\u0002\tM\u0003B\u00029$\t\u0003\u0011)\u0007C\u0005\u0003H\r\n\t\u0011\"\u0012\u0002\n\"I\u0011qT\u0012\u0002\u0002\u0013\u0005%q\r\u0005\n\u0005[\u001a\u0013\u0011!CA\u0005_BqA!!\u0001\t\u0003\u0011\u0019\tC\u0004\u0003\n\u0002!\t!!\u0003\t\u000f\t5\u0005\u0001\"\u0001\u0002\n!9!\u0011\u0013\u0001\u0005\u0002\u0005%\u0001b\u0002BK\u0001\u0011%!q\u0013\u0005\b\u0005S\u0003A\u0011AA\u0005\u0011\u001d\u0011i\u000b\u0001C\u0005\u0005_CqA!2\u0001\t\u0003\tI\u0001C\u0004\u0003H\u0002!\t!!\u0003\t\u000f\t-\u0007\u0001\"\u0001\u0002\n!9!q\u001a\u0001\u0005\u0002\u0005%\u0001b\u0002Bj\u0001\u0011\u0005\u0011\u0011\u0002\u0004\u0007\u0005/\u0004\u0001I!7\t\u0015\tmGG!f\u0001\n\u0003\tY\u000e\u0003\u0006\u0003^R\u0012\t\u0012)A\u0005\u0003'B!Ba85\u0005+\u0007I\u0011AAn\u0011)\u0011\t\u000f\u000eB\tB\u0003%\u00111\u000b\u0005\u000b\u0005G$$Q3A\u0005\u0002\u0005m\u0007B\u0003Bsi\tE\t\u0015!\u0003\u0002T!Q!q\u001d\u001b\u0003\u0016\u0004%\t!a7\t\u0015\t%HG!E!\u0002\u0013\t\u0019\u0006\u0003\u0006\u0003lR\u0012)\u001a!C\u0001\u00037D!B!<5\u0005#\u0005\u000b\u0011BA*\u0011)\u0011y\u000f\u000eBK\u0002\u0013\u0005\u00111\u001c\u0005\u000b\u0005c$$\u0011#Q\u0001\n\u0005M\u0003B\u000295\t\u0003\u0011\u0019\u0010C\u0005\u0002lR\n\t\u0011\"\u0001\u0004\u0004!I\u00111\u001f\u001b\u0012\u0002\u0013\u0005\u0011Q\u001f\u0005\n\u0005\u0017!\u0014\u0013!C\u0001\u0003kD\u0011b!\u00055#\u0003%\t!!>\t\u0013\rMA'%A\u0005\u0002\u0005U\b\"CB\u000biE\u0005I\u0011AA{\u0011%\u00199\u0002NI\u0001\n\u0003\t)\u0010C\u0005\u0003\u000eQ\n\t\u0011\"\u0011\u0003\u0010!I!\u0011\u0003\u001b\u0002\u0002\u0013\u0005!1\u0003\u0005\n\u00057!\u0014\u0011!C\u0001\u00073A\u0011B!\u000b5\u0003\u0003%\tEa\u000b\t\u0013\t]B'!A\u0005\u0002\ru\u0001\"\u0003B\u001fi\u0005\u0005I\u0011IB\u0011\u0011%\u0011\u0019\u0005NA\u0001\n\u0003\u0012)\u0005C\u0005\u0003HQ\n\t\u0011\"\u0011\u0002\n\"I!\u0011\n\u001b\u0002\u0002\u0013\u00053QE\u0004\n\u0007S\u0001\u0011\u0011!E\u0001\u0007W1\u0011Ba6\u0001\u0003\u0003E\ta!\f\t\rA\u001cF\u0011AB\u001b\u0011%\u00119eUA\u0001\n\u000b\nI\tC\u0005\u0002 N\u000b\t\u0011\"!\u00048!I!QN*\u0002\u0002\u0013\u00055Q\t\u0005\b\u0007#\u0002A\u0011AB*\u0011\u001d\u0019Y\u0006\u0001C\u0001\u0003\u0013Aqaa\u0018\u0001\t\u0003\tI\u0001C\u0004\u0004d\u0001!\t!!\u0003\t\u0019\r\u001d\u0004\u0001%A\u0001\u0002\u0003%\ta!\u001b\u0003\u001d\tKwnU2i_2L\u0007\u0010V3ti*\u0011q\fY\u0001\u0004E&|'BA1c\u0003\t\u0019\bP\u0003\u0002dI\u0006\u0019A\r\u001b9\u000b\u0005\u00154\u0017a\u00023oKRd\u0017N\u0019\u0006\u0002O\u0006\u0011Q-^\u0002\u0001'\t\u0001!\u000e\u0005\u0002l]6\tAN\u0003\u0002nE\u0006Y\u0011mZ4sK\u001e\fG/[8o\u0013\tyGN\u0001\fBEN$(/Y2u->\u001c\u0017MY;mCJLH+Z:u\u0003\u0019a\u0014N\\5u}Q\t!\u000f\u0005\u0002t\u00015\ta,\u0001\u0004nCB\u0004XM]\u000b\u0002mB\u0019q/!\u0001\u000e\u0003aT!!\u001f>\u0002\u0011\u0011\fG/\u00192j]\u0012T!a\u001f?\u0002\u000f)\f7m[:p]*\u0011QP`\u0001\nM\u0006\u001cH/\u001a:y[2T\u0011a`\u0001\u0004G>l\u0017bAA\u0002q\naqJ\u00196fGRl\u0015\r\u001d9fe\u00069Q.\u00199qKJ\u0004\u0013!B:fiV\u0003HCAA\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!BAA\t\u0003\u0015\u00198-\u00197b\u0013\u0011\t)\"a\u0004\u0003\tUs\u0017\u000e\u001e\u0015\u0004\t\u0005e\u0001\u0003BA\u000e\u0003[i!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0004CBL'\u0002BA\u0012\u0003K\tqA[;qSR,'O\u0003\u0003\u0002(\u0005%\u0012!\u00026v]&$(BAA\u0016\u0003\ry'oZ\u0005\u0005\u0003_\tiB\u0001\u0006CK\u001a|'/Z#bG\"\u0014aCQ;gM\u0016\u0014X\r\u001a*fC\u0012,'/\u0013;fe\u0006$xN]\n\u0006\u000b\u0005U\u00121\b\t\u0005\u0003\u001b\t9$\u0003\u0003\u0002:\u0005=!AB!osJ+g\r\u0005\u0004\u0002>\u00055\u00131\u000b\b\u0005\u0003\u007f\tIE\u0004\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)\u0005[\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005E\u0011\u0002BA&\u0003\u001f\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002P\u0005E#\u0001C%uKJ\fGo\u001c:\u000b\t\u0005-\u0013q\u0002\t\u0005\u0003+\niF\u0004\u0003\u0002X\u0005e\u0003\u0003BA!\u0003\u001fIA!a\u0017\u0002\u0010\u00051\u0001K]3eK\u001aLA!a\u0018\u0002b\t11\u000b\u001e:j]\u001eTA!a\u0017\u0002\u0010\u00051!/Z1eKJ\u0004B!a\u001a\u0002r5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'\u0001\u0002j_*\u0011\u0011qN\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002t\u0005%$A\u0004\"vM\u001a,'/\u001a3SK\u0006$WM\u001d\u000b\u0005\u0003o\nY\bE\u0002\u0002z\u0015i\u0011\u0001\u0001\u0005\b\u0003G:\u0001\u0019AA3\u0003\u001dA\u0017m\u001d(fqR$\"!!!\u0011\t\u00055\u00111Q\u0005\u0005\u0003\u000b\u000byAA\u0004C_>dW-\u00198\u0002\t9,\u0007\u0010\u001e\u000b\u0003\u0003\u0017\u0003B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0005\u0003#\u000bi'\u0001\u0003mC:<\u0017\u0002BA0\u0003\u001f\u000bab\u0012>GS2,\u0017\n^3sCR|'\u000fE\u0002\u0002z-\u0011ab\u0012>GS2,\u0017\n^3sCR|'oE\u0002\f\u0003k!\"!a&\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005]\u00141UAW\u0011\u001d\t)+\u0004a\u0001\u0003O\u000b!![:\u0011\t\u0005\u001d\u0014\u0011V\u0005\u0005\u0003W\u000bIGA\u0006J]B,Ho\u0015;sK\u0006l\u0007bBAX\u001b\u0001\u0007\u00111K\u0001\tK:\u001cw\u000eZ5oO\u00069A/Z:u!&$\u0007f\u0001\b\u00026B!\u00111DA\\\u0013\u0011\tI,!\b\u0003\tQ+7\u000f^\u0001\u0013Kb$(/Y2u\u0003\u001a4\u0017\u000e\\5bi&|g\u000e\u0006\u0003\u0002@\u0006\u0015\u0007CBA\u001f\u0003\u0003\f\u0019&\u0003\u0003\u0002D\u0006E#\u0001\u0002'jgRDq!a2\u0010\u0001\u0004\t\u0019&A\u0001t\u0005%\tU\u000f\u001e5peBKEiE\u0004\u0011\u0003k\ti-a5\u0011\t\u00055\u0011qZ\u0005\u0005\u0003#\fyAA\u0004Qe>$Wo\u0019;\u0011\t\u0005u\u0012Q[\u0005\u0005\u0003/\f\tF\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004qS\u0012$\u0016\u0010]3\u0016\u0005\u0005M\u0013\u0001\u00039jIRK\b/\u001a\u0011\u0002\u0007ALG-\u0001\u0003qS\u0012\u0004CCBAs\u0003O\fI\u000fE\u0002\u0002zAAq!!7\u0016\u0001\u0004\t\u0019\u0006C\u0004\u0002`V\u0001\r!a\u0015\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003K\fy/!=\t\u0013\u0005eg\u0003%AA\u0002\u0005M\u0003\"CAp-A\u0005\t\u0019AA*\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a>+\t\u0005M\u0013\u0011`\u0016\u0003\u0003w\u0004B!!@\u0003\b5\u0011\u0011q \u0006\u0005\u0005\u0003\u0011\u0019!A\u0005v]\u000eDWmY6fI*!!QAA\b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0013\tyPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0017\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!\u0006\u0011\t\u00055!qC\u0005\u0005\u00053\tyAA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003 \t\u0015\u0002\u0003BA\u0007\u0005CIAAa\t\u0002\u0010\t\u0019\u0011I\\=\t\u0013\t\u001d2$!AA\u0002\tU\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003.A1!q\u0006B\u001b\u0005?i!A!\r\u000b\t\tM\u0012qB\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA(\u0005c\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0003\u0013Y\u0004C\u0005\u0003(u\t\t\u00111\u0001\u0003 \u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tYI!\u0011\t\u0013\t\u001db$!AA\u0002\tU\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\tU\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0002\r\u0015\fX/\u00197t)\u0011\t\tI!\u0014\t\u0013\t\u001d\u0012%!AA\u0002\t}\u0011!C!vi\"|'\u000fU%E!\r\tIhI\n\u0006G\tU#\u0011\r\t\u000b\u0005/\u0012i&a\u0015\u0002T\u0005\u0015XB\u0001B-\u0015\u0011\u0011Y&a\u0004\u0002\u000fI,h\u000e^5nK&!!q\fB-\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003O\u0012\u0019'\u0003\u0003\u0002X\u0006%DC\u0001B))\u0019\t)O!\u001b\u0003l!9\u0011\u0011\u001c\u0014A\u0002\u0005M\u0003bBApM\u0001\u0007\u00111K\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tH! \u0011\r\u00055!1\u000fB<\u0013\u0011\u0011)(a\u0004\u0003\r=\u0003H/[8o!!\tiA!\u001f\u0002T\u0005M\u0013\u0002\u0002B>\u0003\u001f\u0011a\u0001V;qY\u0016\u0014\u0004\"\u0003B@O\u0005\u0005\t\u0019AAs\u0003\rAH\u0005M\u0001\u0018Kb$(/Y2u\u0003V$\bn\u001c:JI\u0016tG/\u001b4jKJ$BA!\"\u0003\bB1\u0011QHAa\u0003KDq!a2)\u0001\u0004\t\u0019&\u0001\nuKN$\b+\u0019:tS:<\u0007+\u001e2nK\u0012\u0014\u0004fA\u0015\u00026\u0006YA/Z:u\u000b\nKE)\u0019;bQ\rQ\u0013QW\u0001\u0010i\u0016\u001cH\u000fU;c[\u0016$Gk\\(bM\"\u001a1&!.\u0002\u001d\rDWmY6Q\u001b\u0006\u0013H/[2mKR!\u00111\u0002BM\u0011\u001d\u0011Y\n\fa\u0001\u0005;\u000bq!\u0019:uS\u000edW\r\u0005\u0003\u0003 \n\u0015VB\u0001BQ\u0015\r\u0011\u0019KX\u0001\u0007aV\u0014W.\u001a3\n\t\t\u001d&\u0011\u0015\u0002\n!6\u000b%\u000f^5dY\u0016\fA\u0003^3tiB\u000b'o]5oOB+(-\\3e16c\u0005fA\u0017\u00026\u000612\r[3dWB+(-\\3e!V\u0014G.[2bi&|g\u000e\u0006\u0003\u0002\f\tE\u0006b\u0002BZ]\u0001\u0007!QW\u0001\u0002_B!!q\u0017Ba\u001b\t\u0011IL\u0003\u0003\u0003<\nu\u0016aA8bM*\u0019!q\u00182\u0002\rM\u001c\u0007.Z7b\u0013\u0011\u0011\u0019M!/\u0003\u0007=\u000bg-A\nuKN$\b+\u001e2nK\u0012\u001c\u0006\u000f\\5ui&tw-\u0001\u000buKN$\b+\u001e2nK\u0012|%/[4j]\u0006d\u0017\n\u0012\u0015\u0004a\u0005U\u0016!\u0005;fgR\u0004VOY7fI6\u000b\u0007\u000f]5oO\"\u001a\u0011'!.\u0002\u0019Q,7\u000f\u001e)E\u0005R{w*\u0011$)\u0007I\n),\u0001\tuKN$XKT%qe>$Hk\\(B\r\"\u001a1'!.\u0003\u0011\u0015\u0013\u0015\nT5oWN\u001cr\u0001NA\u001b\u0003\u001b\f\u0019.A\u0004sK2$\u0016\u0010]3\u0002\u0011I,G\u000eV=qK\u0002\nA\u0001Z1uK\u0006)A-\u0019;fA\u0005)A/\u001b;mK\u00061A/\u001b;mK\u0002\nA\u0001]7jI\u0006)\u0001/\\5eA\u0005IA/\u0019:hKR\u0004\u0016\u000eZ\u0001\u000bi\u0006\u0014x-\u001a;QS\u0012\u0004\u0013!\u0004;be\u001e,G\u000fU5e)f\u0004X-\u0001\buCJ<W\r\u001e)jIRK\b/\u001a\u0011\u0015\u001d\tU(q\u001fB}\u0005w\u0014iPa@\u0004\u0002A\u0019\u0011\u0011\u0010\u001b\t\u000f\tm\u0017\t1\u0001\u0002T!9!q\\!A\u0002\u0005M\u0003b\u0002Br\u0003\u0002\u0007\u00111\u000b\u0005\b\u0005O\f\u0005\u0019AA*\u0011\u001d\u0011Y/\u0011a\u0001\u0003'BqAa<B\u0001\u0004\t\u0019\u0006\u0006\b\u0003v\u000e\u00151qAB\u0005\u0007\u0017\u0019iaa\u0004\t\u0013\tm'\t%AA\u0002\u0005M\u0003\"\u0003Bp\u0005B\u0005\t\u0019AA*\u0011%\u0011\u0019O\u0011I\u0001\u0002\u0004\t\u0019\u0006C\u0005\u0003h\n\u0003\n\u00111\u0001\u0002T!I!1\u001e\"\u0011\u0002\u0003\u0007\u00111\u000b\u0005\n\u0005_\u0014\u0005\u0013!a\u0001\u0003'\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122D\u0003\u0002B\u0010\u00077A\u0011Ba\nL\u0003\u0003\u0005\rA!\u0006\u0015\t\u0005\u00055q\u0004\u0005\n\u0005Oi\u0015\u0011!a\u0001\u0005?!B!a#\u0004$!I!q\u0005(\u0002\u0002\u0003\u0007!Q\u0003\u000b\u0005\u0003\u0003\u001b9\u0003C\u0005\u0003(E\u000b\t\u00111\u0001\u0003 \u0005AQIQ%MS:\\7\u000fE\u0002\u0002zM\u001bRaUB\u0018\u0005C\u0002\"Ca\u0016\u00042\u0005M\u00131KA*\u0003'\n\u0019&a\u0015\u0003v&!11\u0007B-\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\u000e\u000b\u0003\u0007W!bB!>\u0004:\rm2QHB \u0007\u0003\u001a\u0019\u0005C\u0004\u0003\\Z\u0003\r!a\u0015\t\u000f\t}g\u000b1\u0001\u0002T!9!1\u001d,A\u0002\u0005M\u0003b\u0002Bt-\u0002\u0007\u00111\u000b\u0005\b\u0005W4\u0006\u0019AA*\u0011\u001d\u0011yO\u0016a\u0001\u0003'\"Baa\u0012\u0004PA1\u0011Q\u0002B:\u0007\u0013\u0002\u0002#!\u0004\u0004L\u0005M\u00131KA*\u0003'\n\u0019&a\u0015\n\t\r5\u0013q\u0002\u0002\u0007)V\u0004H.\u001a\u001c\t\u0013\t}t+!AA\u0002\tU\u0018a\u00049beN,w,\u001a2j?2Lgn[:\u0015\t\rU3q\u000b\t\u0007\u0003{\t\tM!>\t\u000f\re\u0003\f1\u0001\u0002T\u0005)\u0011N\u001c9vi\u00061B/Z:u\u0007J|7o\u001d:fM2Kgn[:U_>\u000be\tK\u0002Z\u0003k\u000b\u0011\u0003^3ti\u0016\u0013\u0015\nT5oWN$vnT!GQ\rQ\u0016QW\u0001\u0015g\u000eDw\u000e\\5y%\u0016\u001cx\u000e\u001c<fIR{w*\u0011$)\u0007m\u000b),\u0001\fqe>$Xm\u0019;fI\u00122xnY1ck2\f'/[3t)\u0011\u0019Yga\u001f\u0011\t\r54qO\u0007\u0003\u0007_RAa!\u001d\u0004t\u0005Qao\\2bEVd\u0017M]=\u000b\u0007\rU$-\u0001\u0004d_6lwN\\\u0005\u0005\u0007s\u001ayGA\bW_\u000e\f'-\u001e7bef<%o\\;q\u0011!\u00119\u0003XA\u0001\u0002\u0004\u0011\bf\u0002\u0001\u0004\u0000\r-5Q\u0012\t\u0005\u0007\u0003\u001b9)\u0004\u0002\u0004\u0004*!1QQA\u000f\u0003%)\u0007\u0010^3og&|g.\u0003\u0003\u0004\n\u000e\r%AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\u00121qR\u0012\u0003\u0007#\u0003Baa%\u0004\u001e6\u00111Q\u0013\u0006\u0005\u0003G\u00199J\u0003\u0003\u0002(\re%\u0002BBN\u0003S\tq!\\8dW&$x.\u0003\u0003\u0004 \u000eU%\u0001E'pG.LGo\\#yi\u0016t7/[8o\u0001")
public class BioScholixTest
extends AbstractVocabularyTest {
    private volatile BioScholixTest$GzFileIterator$ GzFileIterator$module;
    private volatile BioScholixTest$AuthorPID$ AuthorPID$module;
    private volatile BioScholixTest$EBILinks$ EBILinks$module;
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public BioScholixTest$GzFileIterator$ GzFileIterator() {
        if (this.GzFileIterator$module == null) {
            this.GzFileIterator$lzycompute$1();
        }
        return this.GzFileIterator$module;
    }

    public BioScholixTest$AuthorPID$ AuthorPID() {
        if (this.AuthorPID$module == null) {
            this.AuthorPID$lzycompute$1();
        }
        return this.AuthorPID$module;
    }

    public BioScholixTest$EBILinks$ EBILinks() {
        if (this.EBILinks$module == null) {
            this.EBILinks$lzycompute$1();
        }
        return this.EBILinks$module;
    }

    public /* synthetic */ VocabularyGroup protected$vocabularies(BioScholixTest x$1) {
        return x$1.vocabularies;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    @BeforeEach
    public void setUp() {
        super.setUpVocabulary();
    }

    @Test
    public void testPid() {
        List pids = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0000000163025705", "000000018494732X", "0000000308873343", "0000000335964515", "0000000333457333", "0000000335964515", "0000000302921949", "http://orcid.org/0000-0001-8567-3543", "http://orcid.org/0000-0001-7868-8528", "0000-0001-9189-1440", "0000-0003-3727-9247", "0000-0001-7246-1058", "000000033962389X", "0000000330371470", "0000000171236123", "0000000272569752", "0000000293231371", "http://orcid.org/0000-0003-3345-7333", "0000000340145688", "http://orcid.org/0000-0003-4894-1689"}));
        pids.foreach((Function1 & Serializable)pid -> {
            BioScholixTest.$anonfun$testPid$1(pid);
            return BoxedUnit.UNIT;
        });
    }

    public List<String> extractAffiliation(String s) {
        String regex = "<Affiliation>(.*)<\\/Affiliation>";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(s);
        ListBuffer l = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (matcher.find()) {
            l.$plus$eq((Object)matcher.group(1));
        }
        return l.toList();
    }

    public List<AuthorPID> extractAuthorIdentifier(String s) {
        String regex = "<Identifier Source=\"(.*)\">(.*)<\\/Identifier>";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(s);
        ListBuffer l = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (matcher.find()) {
            l.$plus$eq((Object)new AuthorPID(this, matcher.group(1), matcher.group(2)));
        }
        return l.toList();
    }

    @Test
    public void testParsingPubmed2() {
        ObjectMapper mapper = new ObjectMapper();
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/single_pubmed.xml"));
        PMParser2 parser = new PMParser2();
        PMArticle article = parser.parse(xml);
        Predef$.MODULE$.println((Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)PubMedToOaf$.MODULE$.convert(article, this.vocabularies)));
    }

    @Test
    public void testEBIData() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        new PMParser(xml).foreach((Function1 & Serializable)s -> {
            Predef$.MODULE$.println((Object)this.mapper().writeValueAsString((Object)s));
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPubmedToOaf() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        List r = StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).toList().map((Function1 & Serializable)s -> (PMArticle)this.mapper().readValue(s, PMArticle.class)).map((Function1 & Serializable)a -> PubMedToOaf$.MODULE$.convert(a, this.protected$vocabularies(this)));
        Assertions.assertEquals((int)10, (int)r.size());
        Assertions.assertTrue((boolean)r.map((Function1 & Serializable)p -> (Result)p).flatMap((Function1 & Serializable)p -> (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).map((Function1 & Serializable)i -> i.getInstancetype().getClassid())).exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$testPubmedToOaf$7(p))));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(r.head()));
    }

    private void checkPMArticle(PMArticle article) {
        Assertions.assertNotNull((Object)article.getPmid());
        Assertions.assertNotNull((Object)article.getTitle());
        Assertions.assertNotNull((Object)article.getAuthors());
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(article.getAuthors()).asScala()).foreach((Function1 & Serializable)a -> {
            BioScholixTest.$anonfun$checkPMArticle$1(a);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testParsingPubmedXML() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        PMParser parser = new PMParser(xml);
        parser.foreach((Function1 & Serializable)article -> {
            this.checkPMArticle(article);
            return BoxedUnit.UNIT;
        });
    }

    private void checkPubmedPublication(Oaf o) {
        Assertions.assertTrue((boolean)(o instanceof Publication));
        Publication p = (Publication)o;
        Assertions.assertNotNull((Object)p.getId());
        Assertions.assertNotNull((Object)p.getTitle());
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getTitle()).asScala()).foreach((Function1 & Serializable)t -> {
            BioScholixTest.$anonfun$checkPubmedPublication$1(t);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getAuthor()).asScala()).foreach((Function1 & Serializable)a -> {
            BioScholixTest.$anonfun$checkPubmedPublication$2(a);
            return BoxedUnit.UNIT;
        });
        Assertions.assertNotNull((Object)p.getInstance());
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).foreach((Function1 & Serializable)i -> {
            BioScholixTest.$anonfun$checkPubmedPublication$3(i);
            return BoxedUnit.UNIT;
        });
        Assertions.assertNotNull((Object)p.getOriginalId());
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getOriginalId()).asScala()).foreach((Function1 & Serializable)oId -> {
            BioScholixTest.$anonfun$checkPubmedPublication$4(oId);
            return BoxedUnit.UNIT;
        });
        boolean hasPMC = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).exists((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$checkPubmedPublication$5(i)));
        if (hasPMC) {
            Assertions.assertTrue((boolean)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getOriginalId()).asScala()).exists((Function1 & Serializable)oId -> BoxesRunTime.boxToBoolean((boolean)oId.startsWith("od_______267::"))));
            return;
        }
    }

    public void testPubmedSplitting() {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("test").master("local").getOrCreate();
        new SparkCreatePubmedDump("", (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), LoggerFactory.getLogger(this.getClass())).createPubmedDump(spark, "/home/sandro/Downloads/pubmed", "/home/sandro/Downloads/pubmed_mapped", this.vocabularies);
    }

    @Test
    public void testPubmedOriginalID() {
        PMArticle article = new PMArticle();
        article.setPmid("1234");
        article.setTitle("a Title");
        article.getPublicationTypes().add(new PMSubject("article", null, null));
        Publication publication = (Publication)PubMedToOaf$.MODULE$.convert(article, this.vocabularies);
        Assertions.assertNotNull((Object)publication);
        Assertions.assertEquals((Object)"50|pmid________::81dc9bdb52d04dc20036dbd8313ed055", (Object)publication.getId());
        article.setPmcId("PMC1517292");
        publication = (Publication)PubMedToOaf$.MODULE$.convert(article, this.vocabularies);
        Assertions.assertNotNull((Object)publication);
        Assertions.assertEquals((Object)"50|pmid________::81dc9bdb52d04dc20036dbd8313ed055", (Object)publication.getId());
        String oldOpenaireID = "od_______267::0000072375bc0e68fa09d4e6b7658248";
        boolean hasOldOpenAIREID = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getOriginalId()).asScala()).exists((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)o.equalsIgnoreCase(oldOpenaireID)));
        Assertions.assertTrue((boolean)hasOldOpenAIREID);
    }

    @Test
    public void testPubmedMapping() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        PMParser parser = new PMParser(xml);
        ListBuffer results = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        parser.foreach((Function1 & Serializable)x -> (ListBuffer)results.$plus$eq((Object)PubMedToOaf$.MODULE$.convert(x, this.protected$vocabularies(this))));
        results.foreach((Function1 & Serializable)o -> {
            this.checkPubmedPublication(o);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPDBToOAF() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pdb_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).foreach((Function1 & Serializable)s -> {
            BioScholixTest.$anonfun$testPDBToOAF$2(s);
            return BoxedUnit.UNIT;
        });
        List result = StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).toList().flatMap((Function1 & Serializable)o -> BioDBToOAF$.MODULE$.pdbTOOaf(o));
        Assertions.assertTrue((boolean)result.nonEmpty());
        result.foreach((Function1 & Serializable)r -> {
            BioScholixTest.$anonfun$testPDBToOAF$5(r);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)result.count((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$testPDBToOAF$6(o)))));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    @Test
    public void testUNIprotToOAF() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/uniprot_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).foreach((Function1 & Serializable)s -> {
            BioScholixTest.$anonfun$testUNIprotToOAF$2(s);
            return BoxedUnit.UNIT;
        });
        List result = StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).toList().flatMap((Function1 & Serializable)o -> BioDBToOAF$.MODULE$.uniprotToOAF(o));
        Assertions.assertTrue((boolean)result.nonEmpty());
        result.foreach((Function1 & Serializable)r -> {
            BioScholixTest.$anonfun$testUNIprotToOAF$5(r);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)result.count((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$testUNIprotToOAF$6(o)))));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    public List<EBILinks> parse_ebi_links(String input) {
        LazyRef formats$lzy = new LazyRef();
        LazyRef json$lzy = new LazyRef();
        String pmid = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(BioScholixTest.json$1(json$lzy, input)), "publication")), "pmid")), (Formats)BioScholixTest.formats$1(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
        return MonadicJValue$.MODULE$.withFilter$extension(org.json4s.package$.MODULE$.jvalue2monadic(MonadicJValue$.MODULE$.$bslash$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(BioScholixTest.json$1(json$lzy, input)), "Link")), (Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$1(check$ifrefutable$1))).flatMap((Function1 & Serializable)x$9 -> {
            JValue jValue = x$9;
            if (jValue instanceof JObject) {
                JObject jObject = (JObject)jValue;
                List link = jObject.obj();
                return (List)link.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$3(check$ifrefutable$2))).flatMap((Function1 & Serializable)x$8 -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = x$8;
                    if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                        String string = (String)tuple2._1();
                        JValue jValue = (JValue)tuple2._2();
                        if ("Target".equals(string) && jValue instanceof JObject) {
                            JObject jObject = (JObject)jValue;
                            List target = jObject.obj();
                            return (IterableOnce)link.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$5(check$ifrefutable$3))).flatMap((Function1 & Serializable)x$7 -> {
                                Tuple2 tuple2;
                                Tuple2 tuple22 = x$7;
                                if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                    String string = (String)tuple2._1();
                                    JValue jValue = (JValue)tuple2._2();
                                    if ("RelationshipType".equals(string) && jValue instanceof JObject) {
                                        JObject jObject = (JObject)jValue;
                                        List relType = jObject.obj();
                                        return (IterableOnce)relType.withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$7(check$ifrefutable$4))).flatMap((Function1 & Serializable)x$6 -> {
                                            Tuple2 tuple2;
                                            Tuple2 tuple22 = x$6;
                                            if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                                String string = (String)tuple2._1();
                                                JValue jValue = (JValue)tuple2._2();
                                                if ("Name".equals(string) && jValue instanceof JString) {
                                                    JString jString = (JString)jValue;
                                                    String relation = jString.s();
                                                    return (IterableOnce)link.withFilter((Function1 & Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$9(check$ifrefutable$5))).flatMap((Function1 & Serializable)x$5 -> {
                                                        Tuple2 tuple2;
                                                        Tuple2 tuple22 = x$5;
                                                        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                                            String string = (String)tuple2._1();
                                                            JValue jValue = (JValue)tuple2._2();
                                                            if ("PublicationDate".equals(string) && jValue instanceof JString) {
                                                                JString jString = (JString)jValue;
                                                                String publicationDate = jString.s();
                                                                return (IterableOnce)target.withFilter((Function1 & Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$11(check$ifrefutable$6))).flatMap((Function1 & Serializable)x$4 -> {
                                                                    Tuple2 tuple2;
                                                                    Tuple2 tuple22 = x$4;
                                                                    if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                                                        String string = (String)tuple2._1();
                                                                        JValue jValue = (JValue)tuple2._2();
                                                                        if ("Title".equals(string) && jValue instanceof JString) {
                                                                            JString jString = (JString)jValue;
                                                                            String title = jString.s();
                                                                            return (IterableOnce)target.withFilter((Function1 & Serializable)check$ifrefutable$7 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$13(check$ifrefutable$7))).flatMap((Function1 & Serializable)x$3 -> {
                                                                                Tuple2 tuple2;
                                                                                Tuple2 tuple22 = x$3;
                                                                                if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                                                                    String string = (String)tuple2._1();
                                                                                    JValue jValue = (JValue)tuple2._2();
                                                                                    if ("Identifier".equals(string) && jValue instanceof JObject) {
                                                                                        JObject jObject = (JObject)jValue;
                                                                                        List identifier = jObject.obj();
                                                                                        return (IterableOnce)identifier.withFilter((Function1 & Serializable)check$ifrefutable$8 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$15(check$ifrefutable$8))).flatMap((Function1 & Serializable)x$2 -> {
                                                                                            Tuple2 tuple2;
                                                                                            Tuple2 tuple22 = x$2;
                                                                                            if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                                                                                String string = (String)tuple2._1();
                                                                                                JValue jValue = (JValue)tuple2._2();
                                                                                                if ("IDScheme".equals(string) && jValue instanceof JString) {
                                                                                                    JString jString = (JString)jValue;
                                                                                                    String idScheme = jString.s();
                                                                                                    return (IterableOnce)identifier.withFilter((Function1 & Serializable)check$ifrefutable$9 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$17(check$ifrefutable$9))).map((Function1 & Serializable)x$1 -> {
                                                                                                        Tuple2 tuple2;
                                                                                                        Tuple2 tuple22 = x$1;
                                                                                                        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                                                                                            String string = (String)tuple2._1();
                                                                                                            JValue jValue = (JValue)tuple2._2();
                                                                                                            if ("ID".equals(string) && jValue instanceof JString) {
                                                                                                                JString jString = (JString)jValue;
                                                                                                                String id = jString.s();
                                                                                                                return new EBILinks(this, relation, publicationDate, title, pmid, id, idScheme);
                                                                                                            }
                                                                                                        }
                                                                                                        throw new MatchError((Object)tuple22);
                                                                                                    });
                                                                                                }
                                                                                            }
                                                                                            throw new MatchError((Object)tuple22);
                                                                                        });
                                                                                    }
                                                                                }
                                                                                throw new MatchError((Object)tuple22);
                                                                            });
                                                                        }
                                                                    }
                                                                    throw new MatchError((Object)tuple22);
                                                                });
                                                            }
                                                        }
                                                        throw new MatchError((Object)tuple22);
                                                    });
                                                }
                                            }
                                            throw new MatchError((Object)tuple22);
                                        });
                                    }
                                }
                                throw new MatchError((Object)tuple22);
                            });
                        }
                    }
                    throw new MatchError((Object)tuple22);
                });
            }
            throw new MatchError((Object)jValue);
        });
    }

    @Test
    public void testCrossrefLinksToOAF() {
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/crossref_links"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).foreach((Function1 & Serializable)s -> {
            BioScholixTest.$anonfun$testCrossrefLinksToOAF$2(s);
            return BoxedUnit.UNIT;
        });
        List result = StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).map((Function1 & Serializable)s -> BioDBToOAF$.MODULE$.crossrefLinksToOaf(s)).toList();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.nonEmpty());
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    @Test
    public void testEBILinksToOAF() {
        BufferedReaderIterator iterator = this.GzFileIterator().apply(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/ebi_links.gz"), "UTF-8");
        String data = iterator.next();
        List res = BioDBToOAF$.MODULE$.parse_ebi_links(BioDBToOAF$.MODULE$.extractEBILinksFromDump(data).links()).filter((Function1 & Serializable)input -> BoxesRunTime.boxToBoolean((boolean)BioDBToOAF$.MODULE$.EBITargetLinksFilter(input))).flatMap((Function1 & Serializable)input -> BioDBToOAF$.MODULE$.convertEBILinksToOaf(input));
        Predef$.MODULE$.print((Object)BoxesRunTime.boxToInteger((int)res.length()));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(res.head()));
    }

    @Test
    public void scholixResolvedToOAF() {
        LazyRef formats$lzy = new LazyRef();
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/scholix_resolved"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).foreach((Function1 & Serializable)s -> {
            BioScholixTest.$anonfun$scholixResolvedToOAF$2(s);
            return BoxedUnit.UNIT;
        });
        List l2 = StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).map((Function1 & Serializable)input -> {
            LazyRef json$lzy = new LazyRef();
            return (BioDBToOAF.ScholixResolved)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(BioScholixTest.json$2(json$lzy, input)), (Formats)BioScholixTest.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(BioDBToOAF.ScholixResolved.class));
        }).toList();
        List result = l2.map((Function1 & Serializable)s -> BioDBToOAF$.MODULE$.scholixResolvedToOAF(s));
        Assertions.assertTrue((boolean)result.nonEmpty());
    }

    private final void GzFileIterator$lzycompute$1() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.GzFileIterator$module == null) {
                this.GzFileIterator$module = new BioScholixTest$GzFileIterator$(this);
            }
        }
    }

    private final void AuthorPID$lzycompute$1() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.AuthorPID$module == null) {
                this.AuthorPID$module = new BioScholixTest$AuthorPID$(this);
            }
        }
    }

    private final void EBILinks$lzycompute$1() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.EBILinks$module == null) {
                this.EBILinks$module = new BioScholixTest$EBILinks$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$testPid$1(String pid) {
        String pidCleaned = new PMIdentifier(pid, "ORCID").getPid();
        Predef$.MODULE$.println((Object)pidCleaned);
        Assertions.assertTrue((boolean)pidCleaned.matches("[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{3}[0-9X]"));
    }

    public static final /* synthetic */ boolean $anonfun$testPubmedToOaf$7(String p) {
        return "0037".equalsIgnoreCase(p);
    }

    public static final /* synthetic */ void $anonfun$checkPMArticle$1(PMAuthor a) {
        Assertions.assertNotNull((Object)a);
        Assertions.assertNotNull((Object)a.getFullName());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$1(StructuredProperty t) {
        Assertions.assertNotNull((Object)t.getValue());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$2(Author a) {
        Assertions.assertNotNull((Object)a.getFullname());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$3(Instance i) {
        Assertions.assertNotNull((Object)i.getCollectedfrom());
        Assertions.assertNotNull((Object)i.getPid());
        Assertions.assertNotNull((Object)i.getInstancetype());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$4(String oId) {
        Assertions.assertNotNull((Object)oId);
    }

    public static final /* synthetic */ boolean $anonfun$checkPubmedPublication$6(StructuredProperty pid) {
        return pid.getQualifier().getClassid().equalsIgnoreCase(PidType.pmc.toString());
    }

    public static final /* synthetic */ boolean $anonfun$checkPubmedPublication$5(Instance i) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(i.getPid()).asScala()).exists((Function1 & Serializable)pid -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$checkPubmedPublication$6(pid)));
    }

    public static final /* synthetic */ void $anonfun$testPDBToOAF$2(String s) {
        Assertions.assertTrue((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)));
    }

    public static final /* synthetic */ void $anonfun$testPDBToOAF$5(Oaf r) {
        Assertions.assertNotNull((Object)r);
    }

    public static final /* synthetic */ boolean $anonfun$testPDBToOAF$6(Oaf o) {
        return o instanceof Relation;
    }

    public static final /* synthetic */ void $anonfun$testUNIprotToOAF$2(String s) {
        Assertions.assertTrue((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)));
    }

    public static final /* synthetic */ void $anonfun$testUNIprotToOAF$5(Oaf r) {
        Assertions.assertNotNull((Object)r);
    }

    public static final /* synthetic */ boolean $anonfun$testUNIprotToOAF$6(Oaf o) {
        return o instanceof Relation;
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$1(LazyRef formats$lzy$1) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$1;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$1.initialized() ? (DefaultFormats$)formats$lzy$1.value() : (DefaultFormats$)formats$lzy$1.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$1(LazyRef formats$lzy$1) {
        if (formats$lzy$1.initialized()) {
            return (DefaultFormats$)formats$lzy$1.value();
        }
        return BioScholixTest.formats$lzycompute$1(formats$lzy$1);
    }

    private static final /* synthetic */ JValue json$lzycompute$1(LazyRef json$lzy$1, String input$1) {
        JValue jValue;
        LazyRef lazyRef = json$lzy$1;
        synchronized (lazyRef) {
            jValue = json$lzy$1.initialized() ? (JValue)json$lzy$1.value() : (JValue)json$lzy$1.initialize((Object)JsonMethods$.MODULE$.parse((Object)input$1, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()));
        }
        return jValue;
    }

    private static final JValue json$1(LazyRef json$lzy$1, String input$1) {
        if (json$lzy$1.initialized()) {
            return (JValue)json$lzy$1.value();
        }
        return BioScholixTest.json$lzycompute$1(json$lzy$1, input$1);
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$1(JValue check$ifrefutable$1) {
        JValue jValue = check$ifrefutable$1;
        return jValue instanceof JObject;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$2;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("Target".equals(string) && jValue instanceof JObject) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$5(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$3;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("RelationshipType".equals(string) && jValue instanceof JObject) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$7(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$4;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("Name".equals(string) && jValue instanceof JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$9(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$5;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("PublicationDate".equals(string) && jValue instanceof JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$11(Tuple2 check$ifrefutable$6) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$6;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("Title".equals(string) && jValue instanceof JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$13(Tuple2 check$ifrefutable$7) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$7;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("Identifier".equals(string) && jValue instanceof JObject) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$15(Tuple2 check$ifrefutable$8) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$8;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("IDScheme".equals(string) && jValue instanceof JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$17(Tuple2 check$ifrefutable$9) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$9;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("ID".equals(string) && jValue instanceof JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$testCrossrefLinksToOAF$2(String s) {
        Assertions.assertTrue((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)));
    }

    public static final /* synthetic */ void $anonfun$scholixResolvedToOAF$2(String s) {
        Assertions.assertTrue((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)));
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$2(LazyRef formats$lzy$2) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$2;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$2.initialized() ? (DefaultFormats$)formats$lzy$2.value() : (DefaultFormats$)formats$lzy$2.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$2(LazyRef formats$lzy$2) {
        if (formats$lzy$2.initialized()) {
            return (DefaultFormats$)formats$lzy$2.value();
        }
        return BioScholixTest.formats$lzycompute$2(formats$lzy$2);
    }

    private static final /* synthetic */ JValue json$lzycompute$2(LazyRef json$lzy$2, String input$2) {
        JValue jValue;
        LazyRef lazyRef = json$lzy$2;
        synchronized (lazyRef) {
            jValue = json$lzy$2.initialized() ? (JValue)json$lzy$2.value() : (JValue)json$lzy$2.initialize((Object)JsonMethods$.MODULE$.parse((Object)input$2, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()));
        }
        return jValue;
    }

    private static final JValue json$2(LazyRef json$lzy$2, String input$2) {
        if (json$lzy$2.initialized()) {
            return (JValue)json$lzy$2.value();
        }
        return BioScholixTest.json$lzycompute$2(json$lzy$2, input$2);
    }

    public BioScholixTest() {
        this.mapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public class AuthorPID
    implements Product,
    Serializable {
        private final String pidType;
        private final String pid;
        public final /* synthetic */ BioScholixTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String pidType() {
            return this.pidType;
        }

        public String pid() {
            return this.pid;
        }

        public AuthorPID copy(String pidType, String pid) {
            return new AuthorPID(this.eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer(), pidType, pid);
        }

        public String copy$default$1() {
            return this.pidType();
        }

        public String copy$default$2() {
            return this.pid();
        }

        public String productPrefix() {
            return "AuthorPID";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.pidType();
                }
                case 1: {
                    return this.pid();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AuthorPID;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "pidType";
                }
                case 1: {
                    return "pid";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AuthorPID)) return false;
            if (((AuthorPID)object).eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer() != this.eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            AuthorPID authorPID = (AuthorPID)x$1;
            String string = this.pidType();
            String string2 = authorPID.pidType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.pid();
            String string4 = authorPID.pid();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!authorPID.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer() {
            return this.$outer;
        }

        public AuthorPID(BioScholixTest $outer, String pidType, String pid) {
            this.pidType = pidType;
            this.pid = pid;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class BufferedReaderIterator
    implements Iterator<String> {
        private final BufferedReader reader;
        public final /* synthetic */ BioScholixTest $outer;

        public final boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public final Iterator<String> iterator() {
            return Iterator.iterator$((Iterator)this);
        }

        public Option<String> nextOption() {
            return Iterator.nextOption$((Iterator)this);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public BufferedIterator<String> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator<B> padTo(int len, B elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public int indexWhere(Function1<String, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public int indexWhere$default$2() {
            return Iterator.indexWhere$default$2$((Iterator)this);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public final int length() {
            return Iterator.length$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public Iterator<String> filter(Function1<String, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public Iterator<String> filterNot(Function1<String, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public Iterator<String> filterImpl(Function1<String, Object> p, boolean isFlipped) {
            return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
        }

        public Iterator<String> withFilter(Function1<String, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public Iterator<String> distinct() {
            return Iterator.distinct$((Iterator)this);
        }

        public <B> Iterator<String> distinctBy(Function1<String, B> f) {
            return Iterator.distinctBy$((Iterator)this, f);
        }

        public <B> Iterator<B> map(Function1<String, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> flatMap(Function1<String, IterableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public <B> Iterator<B> flatten(Function1<String, IterableOnce<B>> ev) {
            return Iterator.flatten$((Iterator)this, ev);
        }

        public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
            return Iterator.concat$((Iterator)this, xs);
        }

        public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
            return Iterator.$plus$plus$((Iterator)this, xs);
        }

        public Iterator<String> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<String> takeWhile(Function1<String, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Iterator<String> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<String> dropWhile(Function1<String, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<String> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<String> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<Tuple2<String, B>> zip(IterableOnce<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public Iterator<Tuple2<String, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B> boolean sameElements(IterableOnce<B> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <U> Iterator<String> tapEach(Function1<String, U> f) {
            return Iterator.tapEach$((Iterator)this, f);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public Iterator<String> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public Tuple2<Iterator<String>, Iterator<String>> splitAt(int n) {
            return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
        }

        public boolean isTraversableAgain() {
            return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
        }

        public <U> void foreach(Function1<String, U> f) {
            IterableOnceOps.foreach$((IterableOnceOps)this, f);
        }

        public boolean forall(Function1<String, Object> p) {
            return IterableOnceOps.forall$((IterableOnceOps)this, p);
        }

        public boolean exists(Function1<String, Object> p) {
            return IterableOnceOps.exists$((IterableOnceOps)this, p);
        }

        public int count(Function1<String, Object> p) {
            return IterableOnceOps.count$((IterableOnceOps)this, p);
        }

        public Option<String> find(Function1<String, Object> p) {
            return IterableOnceOps.find$((IterableOnceOps)this, p);
        }

        public <B> B foldLeft(B z, Function2<B, String, B> op) {
            return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
        }

        public <B> B foldRight(B z, Function2<String, B, B> op) {
            return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
        }

        public final <B> B $div$colon(B z, Function2<B, String, B> op) {
            return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
        }

        public final <B> B $colon$bslash(B z, Function2<String, B, B> op) {
            return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
        }

        public <B> B reduce(Function2<B, B, B> op) {
            return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceOption(Function2<B, B, B> op) {
            return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
        }

        public <B> B reduceLeft(Function2<B, String, B> op) {
            return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
        }

        public <B> B reduceRight(Function2<String, B, B> op) {
            return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
            return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
            return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
        }

        public boolean nonEmpty() {
            return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
        }

        public int size() {
            return IterableOnceOps.size$((IterableOnceOps)this);
        }

        public final <B> void copyToBuffer(Buffer<B> dest) {
            IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
        }

        public <B> int copyToArray(Object xs) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
        }

        public <B> int copyToArray(Object xs, int start) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
        }

        public <B> int copyToArray(Object xs, int start, int len) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
        }

        public Object min(Ordering ord) {
            return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
        }

        public <B> Option<String> minOption(Ordering<B> ord) {
            return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
        }

        public Object max(Ordering ord) {
            return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
        }

        public <B> Option<String> maxOption(Ordering<B> ord) {
            return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
        }

        public Object maxBy(Function1 f, Ordering ord) {
            return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
        }

        public <B> Option<String> maxByOption(Function1<String, B> f, Ordering<B> ord) {
            return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
        }

        public Object minBy(Function1 f, Ordering ord) {
            return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
        }

        public <B> Option<String> minByOption(Function1<String, B> f, Ordering<B> ord) {
            return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
        }

        public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
            return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
            return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
        }

        public <B> boolean corresponds(IterableOnce<B> that, Function2<String, B, Object> p) {
            return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
        }

        public final String mkString(String start, String sep, String end) {
            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
        }

        public final String mkString(String sep) {
            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
        }

        public final String mkString() {
            return IterableOnceOps.mkString$((IterableOnceOps)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public final StringBuilder addString(StringBuilder b, String sep) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
        }

        public final StringBuilder addString(StringBuilder b) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
        }

        public <C1> C1 to(Factory<String, C1> factory) {
            return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
        }

        public final Iterator<String> toIterator() {
            return IterableOnceOps.toIterator$((IterableOnceOps)this);
        }

        public List<String> toList() {
            return IterableOnceOps.toList$((IterableOnceOps)this);
        }

        public Vector<String> toVector() {
            return IterableOnceOps.toVector$((IterableOnceOps)this);
        }

        public <K, V> Map<K, V> toMap(.less.colon.less<String, Tuple2<K, V>> ev) {
            return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
        }

        public <B> Set<B> toSet() {
            return IterableOnceOps.toSet$((IterableOnceOps)this);
        }

        public Seq<String> toSeq() {
            return IterableOnceOps.toSeq$((IterableOnceOps)this);
        }

        public IndexedSeq<String> toIndexedSeq() {
            return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
        }

        public final Stream<String> toStream() {
            return IterableOnceOps.toStream$((IterableOnceOps)this);
        }

        public final <B> Buffer<B> toBuffer() {
            return IterableOnceOps.toBuffer$((IterableOnceOps)this);
        }

        public <B> Object toArray(ClassTag<B> evidence$2) {
            return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
        }

        public Iterable<String> reversed() {
            return IterableOnceOps.reversed$((IterableOnceOps)this);
        }

        public <S extends Stepper<?>> S stepper(StepperShape<String, S> shape) {
            return (S)IterableOnce.stepper$((IterableOnce)this, shape);
        }

        public int knownSize() {
            return IterableOnce.knownSize$((IterableOnce)this);
        }

        public boolean hasNext() {
            return this.reader.ready();
        }

        public String next() {
            return this.reader.readLine();
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$BufferedReaderIterator$$$outer() {
            return this.$outer;
        }

        public BufferedReaderIterator(BioScholixTest $outer, BufferedReader reader) {
            this.reader = reader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
        }
    }

    public class EBILinks
    implements Product,
    Serializable {
        private final String relType;
        private final String date;
        private final String title;
        private final String pmid;
        private final String targetPid;
        private final String targetPidType;
        public final /* synthetic */ BioScholixTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String relType() {
            return this.relType;
        }

        public String date() {
            return this.date;
        }

        public String title() {
            return this.title;
        }

        public String pmid() {
            return this.pmid;
        }

        public String targetPid() {
            return this.targetPid;
        }

        public String targetPidType() {
            return this.targetPidType;
        }

        public EBILinks copy(String relType, String date, String title, String pmid, String targetPid, String targetPidType) {
            return new EBILinks(this.eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer(), relType, date, title, pmid, targetPid, targetPidType);
        }

        public String copy$default$1() {
            return this.relType();
        }

        public String copy$default$2() {
            return this.date();
        }

        public String copy$default$3() {
            return this.title();
        }

        public String copy$default$4() {
            return this.pmid();
        }

        public String copy$default$5() {
            return this.targetPid();
        }

        public String copy$default$6() {
            return this.targetPidType();
        }

        public String productPrefix() {
            return "EBILinks";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.relType();
                }
                case 1: {
                    return this.date();
                }
                case 2: {
                    return this.title();
                }
                case 3: {
                    return this.pmid();
                }
                case 4: {
                    return this.targetPid();
                }
                case 5: {
                    return this.targetPidType();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EBILinks;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "relType";
                }
                case 1: {
                    return "date";
                }
                case 2: {
                    return "title";
                }
                case 3: {
                    return "pmid";
                }
                case 4: {
                    return "targetPid";
                }
                case 5: {
                    return "targetPidType";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EBILinks)) return false;
            if (((EBILinks)object).eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer() != this.eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            EBILinks eBILinks = (EBILinks)x$1;
            String string = this.relType();
            String string2 = eBILinks.relType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.date();
            String string4 = eBILinks.date();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.title();
            String string6 = eBILinks.title();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.pmid();
            String string8 = eBILinks.pmid();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.targetPid();
            String string10 = eBILinks.targetPid();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            String string11 = this.targetPidType();
            String string12 = eBILinks.targetPidType();
            if (string11 == null) {
                if (string12 != null) {
                    return false;
                }
            } else if (!string11.equals(string12)) return false;
            if (!eBILinks.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer() {
            return this.$outer;
        }

        public EBILinks(BioScholixTest $outer, String relType, String date, String title, String pmid, String targetPid, String targetPidType) {
            this.relType = relType;
            this.date = date;
            this.title = title;
            this.pmid = pmid;
            this.targetPid = targetPid;
            this.targetPidType = targetPidType;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

