/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.person;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.personentity.ExtractPerson;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Person;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePersonAS {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(CreatePersonAS.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(CreatePersonAS.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.codegen.wholeStage", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(CreatePersonAS.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testAuthors() throws Exception {
        JavaRDD filterAffiliation;
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/person/").getPath();
        ExtractPerson.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-inputPath", inputPath, "-outputPath", workingDir.toString() + "/actionSet1", "-workingDir", workingDir.toString() + "/working", "-postgresUrl", "noneed", "-postgresUser", "noneed", "-postgresPassword", "noneed", "-publisherInputPath", this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/personpublisher/ieee.json").getPath()});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD relations = sc.sequenceFile(workingDir.toString() + "/actionSet1", Text.class, Text.class).filter((Function & Serializable)v -> "eu.dnetlib.dhp.schema.oaf.Relation".equalsIgnoreCase(((Text)v._1()).toString())).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        JavaRDD people = sc.sequenceFile(workingDir.toString() + "/actionSet1", Text.class, Text.class).filter((Function & Serializable)v -> "eu.dnetlib.dhp.schema.oaf.Person".equalsIgnoreCase(((Text)v._1()).toString())).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Person)aa.getPayload());
        Assertions.assertEquals((long)8L, (long)people.count());
        Assertions.assertEquals((Object)"Seda", (Object)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0001-6544-2588"))).first()).getGivenName());
        Assertions.assertEquals((Object)"Ardahan Sevgili", (Object)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0001-6544-2588"))).first()).getFamilyName());
        Assertions.assertEquals((int)0, (int)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0001-6544-2588"))).first()).getAlternativeNames().size());
        Assertions.assertEquals((int)2, (int)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0001-6544-2588"))).first()).getPid().size());
        Assertions.assertTrue((boolean)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0001-6544-2588"))).first()).getPid().stream().anyMatch(p -> p.getQualifier().getClassname().equalsIgnoreCase("Scopus Author ID") && p.getValue().equalsIgnoreCase("57203318816")));
        Assertions.assertEquals((long)3L, (long)relations.filter((Function & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasAuthored")).count());
        Assertions.assertEquals((long)2L, (long)relations.filter((Function & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasCoAuthor")).count());
        Assertions.assertEquals((long)1L, (long)relations.filter((Function & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-6291-9619")) && r.getRelClass().equalsIgnoreCase("hasAuthored")).count());
        Assertions.assertEquals((long)1L, (long)relations.filter((Function & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-6291-9619")) && r.getRelClass().equalsIgnoreCase("hasAuthored") && r.getTarget().startsWith("50|doi")).count());
        Assertions.assertEquals((long)0L, (long)relations.filter((Function & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-6291-9619")) && r.getRelClass().equalsIgnoreCase("hasAuthored") && r.getTarget().startsWith("50|arXiv")).count());
        Assertions.assertEquals((long)1L, (long)relations.filter((Function & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-6291-9619")) && r.getRelClass().equalsIgnoreCase("hasCoAuthor")).count());
        JavaRDD filterRelations = relations.filter((Function & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::4e3bfd34079624f293a03e03c243b96b") && r.getRelClass().equalsIgnoreCase("hasAuthored") && r.getTarget().startsWith("50|doi_________::a69682d48d289d8b5d735a70a5ef00ec"));
        Assertions.assertEquals((long)1L, (long)filterRelations.count());
        List properties = ((Relation)filterRelations.first()).getProperties();
        Assertions.assertFalse((boolean)properties.isEmpty());
        Assertions.assertEquals((int)4, (int)properties.size());
        Assertions.assertEquals((long)1L, (long)properties.stream().filter(p -> p.getKey().equalsIgnoreCase("corresponding")).count());
        Assertions.assertEquals((long)1L, (long)properties.stream().filter(p -> p.getKey().equalsIgnoreCase("corresponding") && p.getValue().equalsIgnoreCase("true")).count());
        Assertions.assertEquals((long)1L, (long)properties.stream().filter(p -> p.getKey().equalsIgnoreCase("declared_affiliation")).count());
        Assertions.assertEquals((long)1L, (long)properties.stream().filter(p -> p.getKey().equalsIgnoreCase("declared_affiliation") && p.getValue().equalsIgnoreCase("https://ror.org/05582kr93") && p.getDataInfo() != null && p.getDataInfo().getTrust().equalsIgnoreCase("1.0")).count());
        Assertions.assertEquals((long)2L, (long)properties.stream().filter(p -> p.getKey().equalsIgnoreCase("role")).count());
        JavaRDD rels = filterAffiliation = relations.filter((Function & Serializable)r -> r.getRelClass().equalsIgnoreCase("isAffiliatedWith"));
        relations.foreach((VoidFunction & Serializable)r -> System.out.println(new ObjectMapper().writeValueAsString(r)));
        Assertions.assertEquals((long)4L, (long)filterAffiliation.count());
        Assertions.assertEquals((long)3L, (long)filterAffiliation.filter((Function & Serializable)r -> ((KeyValue)r.getCollectedfrom().get(0)).getValue().equalsIgnoreCase("OpenAIRE")).count());
        Assertions.assertEquals((long)1L, (long)filterAffiliation.filter((Function & Serializable)r -> ((KeyValue)r.getCollectedfrom().get(0)).getValue().equalsIgnoreCase("ORCID")).count());
    }

    @Test
    void testAuthors2() throws Exception {
        JavaRDD filterAffiliation;
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/person/").getPath();
        ExtractPerson.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-inputPath", inputPath, "-outputPath", workingDir.toString() + "/actionSet1", "-workingDir", workingDir.toString() + "/working", "-postgresUrl", "noneed", "-postgresUser", "noneed", "-postgresPassword", "noneed", "-publisherInputPath", this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/personpublisher/noloaded.json").getPath()});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD relations = sc.sequenceFile(workingDir.toString() + "/actionSet1", Text.class, Text.class).filter((Function & Serializable)v -> "eu.dnetlib.dhp.schema.oaf.Relation".equalsIgnoreCase(((Text)v._1()).toString())).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        JavaRDD people = sc.sequenceFile(workingDir.toString() + "/actionSet1", Text.class, Text.class).filter((Function & Serializable)v -> "eu.dnetlib.dhp.schema.oaf.Person".equalsIgnoreCase(((Text)v._1()).toString())).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Person)aa.getPayload());
        Assertions.assertEquals((long)8L, (long)people.count());
        Assertions.assertEquals((Object)"Seda", (Object)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0001-6544-2588"))).first()).getGivenName());
        Assertions.assertEquals((Object)"Ardahan Sevgili", (Object)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0001-6544-2588"))).first()).getFamilyName());
        Assertions.assertEquals((int)0, (int)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0001-6544-2588"))).first()).getAlternativeNames().size());
        Assertions.assertEquals((int)2, (int)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0001-6544-2588"))).first()).getPid().size());
        Assertions.assertTrue((boolean)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0001-6544-2588"))).first()).getPid().stream().anyMatch(p -> p.getQualifier().getClassname().equalsIgnoreCase("Scopus Author ID") && p.getValue().equalsIgnoreCase("57203318816")));
        Assertions.assertEquals((long)1L, (long)relations.filter((Function & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasAuthored")).count());
        Assertions.assertEquals((long)0L, (long)relations.filter((Function & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasCoAuthor")).count());
        Assertions.assertEquals((long)1L, (long)relations.filter((Function & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::" + DHPUtils.md5((String)"0000-0003-4414-9432")) && r.getRelClass().equalsIgnoreCase("hasAuthored")).count());
        Assertions.assertEquals((long)1L, (long)relations.filter((Function & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::" + DHPUtils.md5((String)"0000-0003-4414-9432")) && r.getRelClass().equalsIgnoreCase("hasAuthored") && r.getTarget().startsWith("50|doi")).count());
        JavaRDD filterRelations = relations.filter((Function & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasAuthored"));
        Assertions.assertEquals((long)1L, (long)filterRelations.count());
        List properties = ((Relation)filterRelations.first()).getProperties();
        Assertions.assertFalse((boolean)properties.isEmpty());
        Assertions.assertEquals((int)2, (int)properties.size());
        Assertions.assertEquals((long)1L, (long)properties.stream().filter(p -> p.getKey().equalsIgnoreCase("corresponding")).count());
        Assertions.assertEquals((long)1L, (long)properties.stream().filter(p -> p.getKey().equalsIgnoreCase("corresponding") && p.getValue().equalsIgnoreCase("true")).count());
        Assertions.assertEquals((long)1L, (long)properties.stream().filter(p -> p.getKey().equalsIgnoreCase("declared_affiliation")).count());
        Assertions.assertEquals((long)1L, (long)properties.stream().filter(p -> p.getKey().equalsIgnoreCase("declared_affiliation") && p.getValue().equalsIgnoreCase("https://ror.org/00py81415") && p.getDataInfo() != null && p.getDataInfo().getTrust().equalsIgnoreCase("1.0")).count());
        JavaRDD rels = filterAffiliation = relations.filter((Function & Serializable)r -> r.getRelClass().equalsIgnoreCase("isAffiliatedWith"));
        relations.foreach((VoidFunction & Serializable)r -> System.out.println(new ObjectMapper().writeValueAsString(r)));
        Assertions.assertEquals((long)2L, (long)filterAffiliation.count());
        Assertions.assertEquals((long)1L, (long)filterAffiliation.filter((Function & Serializable)r -> ((KeyValue)r.getCollectedfrom().get(0)).getValue().equalsIgnoreCase("OpenAIRE")).count());
        Assertions.assertEquals((long)1L, (long)filterAffiliation.filter((Function & Serializable)r -> ((KeyValue)r.getCollectedfrom().get(0)).getValue().equalsIgnoreCase("ORCID")).count());
    }

    static {
        log = LoggerFactory.getLogger(CreatePersonAS.class);
    }
}

