/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.mag;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.collection.mag.MAGAuthor;
import eu.dnetlib.dhp.collection.mag.MAGPaper;
import eu.dnetlib.dhp.collection.mag.MagUtility$;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.InstanceTypeMapping;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.dhp.utils.DHPUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileByteRef;

public final class MagUtility$
implements Serializable {
    public static final MagUtility$ MODULE$;
    private final ObjectMapper mapper;
    private final KeyValue MAGCollectedFrom;
    private final DataInfo MAGDataInfo;
    private final Map<String, AtomicType> datatypedict;
    private final Map<String, Tuple2<String, Seq<String>>> stream;

    static {
        new MagUtility$();
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    private KeyValue MAGCollectedFrom() {
        return this.MAGCollectedFrom;
    }

    private DataInfo MAGDataInfo() {
        return this.MAGDataInfo;
    }

    public Map<String, AtomicType> datatypedict() {
        return this.datatypedict;
    }

    public Map<String, Tuple2<String, Seq<String>>> stream() {
        return this.stream;
    }

    public StructType getSchema(String streamName) {
        ObjectRef schema = ObjectRef.create((Object)new StructType());
        Seq d = (Seq)((Tuple2)this.stream().apply((Object)streamName))._2();
        d.foreach((Function1)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final ObjectRef schema$1;

            public final void apply(String t) {
                String[] currentType = t.split(":");
                String fieldName = (String)Predef$.MODULE$.refArrayOps((Object[])currentType).head();
                String fieldType = (String)Predef$.MODULE$.refArrayOps((Object[])currentType).last();
                boolean nullable = fieldType.endsWith("?");
                if (nullable) {
                    fieldType = fieldType.replace("?", "");
                }
                this.schema$1.elem = ((StructType)this.schema$1.elem).add(new StructField(fieldName, (DataType)MagUtility$.MODULE$.datatypedict().apply((Object)fieldType), nullable, StructField$.MODULE$.apply$default$4()));
            }
            {
                this.schema$1 = schema$1;
            }
        });
        return (StructType)schema.elem;
    }

    public org.apache.spark.sql.Dataset<Row> loadMagEntity(SparkSession spark, String entity, String basePath) {
        org.apache.spark.sql.Dataset dataset;
        if (this.stream().contains((Object)entity)) {
            StructType s = this.getSchema(entity);
            String pt = (String)((Tuple2)this.stream().apply((Object)entity))._1();
            dataset = spark.read().option("header", "false").option("charset", "UTF8").option("delimiter", "\t").schema(s).csv(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath, pt})));
        } else {
            dataset = null;
        }
        return dataset;
    }

    /*
     * WARNING - void declaration
     */
    public Result createResultFromType(Option<String> magType, Option<String> source) {
        String string;
        block21: {
            void var3_3;
            Qualifier qualifier;
            String currentType;
            Publication result;
            block14: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                Qualifier qualifier2;
                                block16: {
                                    block15: {
                                        block13: {
                                            result = null;
                                            if (magType == null || magType.orNull(Predef$.MODULE$.$conforms()) == null) {
                                                result = new Publication();
                                                result.setDataInfo(this.MAGDataInfo());
                                                Instance i = new Instance();
                                                i.setInstancetype(OafMapperUtils.qualifier((String)"0038", (String)"Other literature type", (String)"dnet:publication_resource", (String)"dnet:publication_resource"));
                                                result.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{i}))).asJava());
                                                return result;
                                            }
                                            currentType = (String)magType.get();
                                            string = currentType.toLowerCase();
                                            if (!"book".equals(string)) break block13;
                                            result = new Publication();
                                            qualifier = OafMapperUtils.qualifier((String)"0002", (String)"Book", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                                            break block14;
                                        }
                                        if (!"bookchapter".equals(string)) break block15;
                                        result = new Publication();
                                        qualifier = OafMapperUtils.qualifier((String)"00013", (String)"Part of book or chapter of book", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                                        break block14;
                                    }
                                    if (!"journal".equals(string)) break block16;
                                    result = new Publication();
                                    qualifier = OafMapperUtils.qualifier((String)"0001", (String)"Article", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                                    break block14;
                                }
                                if (!"patent".equals(string)) break block17;
                                if (source == null || source.orNull(Predef$.MODULE$.$conforms()) == null) {
                                    qualifier2 = null;
                                } else {
                                    String s = ((String)source.get()).toLowerCase();
                                    if (s.contains("patent") || s.contains("brevet")) {
                                        result = new Publication();
                                        qualifier2 = OafMapperUtils.qualifier((String)"0019", (String)"Patent", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                                    } else if (s.contains("journal of")) {
                                        result = new Publication();
                                        qualifier2 = OafMapperUtils.qualifier((String)"0043", (String)"Journal", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                                    } else if (s.contains("proceedings") || s.contains("conference") || s.contains("workshop") || s.contains("symposium")) {
                                        result = new Publication();
                                        qualifier2 = OafMapperUtils.qualifier((String)"0001", (String)"Article", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                                    } else {
                                        qualifier2 = null;
                                    }
                                }
                                qualifier = qualifier2;
                                break block14;
                            }
                            if (!"repository".equals(string)) break block18;
                            result = new Publication();
                            qualifier = OafMapperUtils.qualifier((String)"0038", (String)"Other literature type", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                            break block14;
                        }
                        if (!"thesis".equals(string)) break block19;
                        result = new Publication();
                        qualifier = OafMapperUtils.qualifier((String)"0044", (String)"Thesis", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                        break block14;
                    }
                    if (!"dataset".equals(string)) break block20;
                    result = new Dataset();
                    qualifier = OafMapperUtils.qualifier((String)"0021", (String)"Dataset", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                    break block14;
                }
                if (!"conference".equals(string)) break block21;
                result = new Publication();
                qualifier = OafMapperUtils.qualifier((String)"0001", (String)"Article", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
            }
            Qualifier tp = qualifier;
            if (result != null) {
                result.setDataInfo(this.MAGDataInfo());
                Instance i = new Instance();
                i.setInstancetype(tp);
                i.setInstanceTypeMapping((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InstanceTypeMapping[]{OafMapperUtils.instanceTypeMapping((String)currentType, (String)"openaire::coar_resource_types_3_1")}))).asJava());
                result.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{i}))).asJava());
            }
            return var3_3;
        }
        throw new MatchError((Object)string);
    }

    public String convertMAGtoOAF(MAGPaper paper) {
        if (paper.urls().orNull(Predef$.MODULE$.$conforms()) == null) {
            return null;
        }
        Result result = this.createResultFromType(paper.docType(), paper.originalVenue());
        if (result == null) {
            return null;
        }
        result.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{this.MAGCollectedFrom()}))).asJava());
        List pidList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{OafMapperUtils.structuredProperty((String)paper.paperId().get().toString(), (Qualifier)OafMapperUtils.qualifier((String)PidType.mag_id.toString(), (String)PidType.mag_id.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null)}));
        result.setOriginalId((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pidList.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructuredProperty s) {
                return s.getValue();
            }
        }, List$.MODULE$.canBuildFrom())).asJava());
        result.setId(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"50|mag_________::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DHPUtils.md5((String)paper.paperId().get().toString())})));
        StructuredProperty originalTitles = OafMapperUtils.structuredProperty((String)((String)paper.paperTitle().get()), (Qualifier)ModelConstants.MAIN_TITLE_QUALIFIER, null);
        result.setTitle((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{originalTitles}))).asJava());
        if (paper.date().orNull(Predef$.MODULE$.$conforms()) == null) {
            if (paper.year().isDefined() && BoxesRunTime.unboxToInt((Object)paper.year().get()) > 1700) {
                result.setDateofacceptance(OafMapperUtils.field((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-01-01"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paper.year().get()})), null));
            }
        } else {
            result.setDateofacceptance(OafMapperUtils.field((Object)paper.date().get(), null));
        }
        if (paper.onlineDate().orNull(Predef$.MODULE$.$conforms()) != null) {
            result.setRelevantdate((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{OafMapperUtils.structuredProperty((String)((String)paper.onlineDate().get()), (Qualifier)OafMapperUtils.qualifier((String)"published-online", (String)"published-online", (String)"dnet:dataCite_date", (String)"dnet:dataCite_date"), null)}))).asJava());
        }
        if (paper.publisher().orNull(Predef$.MODULE$.$conforms()) != null) {
            result.setPublisher(OafMapperUtils.field((Object)paper.publisher().get(), null));
        }
        if (paper.date().isDefined()) {
            result.setDateofacceptance(OafMapperUtils.field((Object)paper.date().get(), null));
        }
        if (paper.onlineDate().orNull(Predef$.MODULE$.$conforms()) != null) {
            result.setRelevantdate((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{OafMapperUtils.structuredProperty((String)((String)paper.onlineDate().get()), (Qualifier)OafMapperUtils.qualifier((String)"published-online", (String)"published-online", (String)"dnet:dataCite_date", (String)"dnet:dataCite_date"), null)}))).asJava());
        }
        if (paper.publisher().isDefined()) {
            result.setPublisher(OafMapperUtils.field((Object)paper.publisher().get(), null));
        }
        if (paper.journalId().isDefined() && paper.journalName().isDefined()) {
            Journal j = new Journal();
            j.setName((String)paper.journalName().get());
            j.setSp((String)paper.firstPage().orNull(Predef$.MODULE$.$conforms()));
            j.setEp((String)paper.lastPage().orNull(Predef$.MODULE$.$conforms()));
            if (paper.publisher().isDefined()) {
                result.setPublisher(OafMapperUtils.field((Object)paper.publisher().get(), null));
            }
            j.setIssnPrinted((String)paper.journalIssn().orNull(Predef$.MODULE$.$conforms()));
            j.setVol((String)paper.volume().orNull(Predef$.MODULE$.$conforms()));
            j.setIss((String)paper.issue().orNull(Predef$.MODULE$.$conforms()));
            j.setConferenceplace((String)paper.conferenceLocation().orNull(Predef$.MODULE$.$conforms()));
            Result result2 = result;
            if (result2 instanceof Publication) {
                Publication publication = (Publication)result2;
                publication.setJournal(j);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)result2);
            }
        }
        if (paper.abstractText().isDefined()) {
            result.setDescription((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Field[]{OafMapperUtils.field((Object)paper.abstractText().get(), null)}))).asJava());
        }
        if (paper.authors().isDefined() && ((TraversableOnce)paper.authors().get()).nonEmpty()) {
            result.setAuthor((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)((TraversableLike)paper.authors().get()).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(MAGAuthor a) {
                    return a.AuthorName().isDefined();
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final Author apply(MAGAuthor a) {
                    void var2_2;
                    Author author = new Author();
                    author.setFullname((String)a.AuthorName().get());
                    return var2_2;
                }
            }, List$.MODULE$.canBuildFrom())).asJava());
        }
        Instance instance = (Instance)result.getInstance().get(0);
        if (paper.doi().orNull(Predef$.MODULE$.$conforms()) != null) {
            List list = pidList;
            pidList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{OafMapperUtils.structuredProperty((String)((String)paper.doi().get()), (Qualifier)OafMapperUtils.qualifier((String)PidType.doi.toString(), (String)PidType.doi.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null)})).$colon$colon$colon(list);
        }
        instance.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pidList).asJava());
        result.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pidList).asJava());
        instance.setUrl((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)paper.urls().get()).asJava());
        instance.setHostedby(ModelConstants.UNKNOWN_REPOSITORY);
        instance.setCollectedfrom(this.MAGCollectedFrom());
        instance.setAccessright(OafMapperUtils.accessRight((String)"UNKNOWN", (String)"not available", (String)"dnet:access_modes", (String)"dnet:access_modes"));
        if (paper.authors().orNull(Predef$.MODULE$.$conforms()) != null && ((TraversableOnce)paper.authors().get()).nonEmpty()) {
            result.setAuthor((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)((TraversableLike)paper.authors().get()).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(MAGAuthor a) {
                    return a.AuthorName().orNull(Predef$.MODULE$.$conforms()) != null;
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final Author apply(MAGAuthor a) {
                    void var2_2;
                    Author author = new Author();
                    author.setFullname((String)a.AuthorName().get());
                    List authorPid = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{OafMapperUtils.structuredProperty((String)a.AuthorId().get().toString(), (Qualifier)OafMapperUtils.qualifier((String)PidType.mag_id.toString(), (String)PidType.mag_id.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null)}));
                    if (a.GridId().orNull(Predef$.MODULE$.$conforms()) != null) {
                        List list = authorPid;
                        authorPid = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{OafMapperUtils.structuredProperty((String)a.AuthorId().get().toString(), (Qualifier)OafMapperUtils.qualifier((String)PidType.mag_id.toString(), (String)PidType.mag_id.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null)})).$colon$colon$colon(list);
                    }
                    author.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)authorPid).asJava());
                    return var2_2;
                }
            }, List$.MODULE$.canBuildFrom())).asJava());
        }
        return this.mapper().writeValueAsString((Object)result);
    }

    public String generateOrganization(Row r) {
        Organization o = new Organization();
        String affId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"20|mag_________::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DHPUtils.md5((String)r.getAs("AffiliationId").toString())}));
        o.setId(affId);
        o.setDataInfo(this.MAGDataInfo());
        o.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{this.MAGCollectedFrom()}))).asJava());
        o.setLegalname(OafMapperUtils.field((Object)r.getAs("DisplayName"), null));
        String gid = (String)r.getAs("GridId");
        if (gid == null) {
            o.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{OafMapperUtils.structuredProperty((String)r.getAs("AffiliationId").toString(), (Qualifier)OafMapperUtils.qualifier((String)PidType.mag_id.toString(), (String)PidType.mag_id.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null)}))).asJava());
        } else {
            o.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{OafMapperUtils.structuredProperty((String)gid, (Qualifier)OafMapperUtils.qualifier((String)PidType.GRID.toString(), (String)PidType.GRID.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null), OafMapperUtils.structuredProperty((String)r.getAs("AffiliationId").toString(), (Qualifier)OafMapperUtils.qualifier((String)PidType.mag_id.toString(), (String)PidType.mag_id.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null)}))).asJava());
        }
        String c = (String)r.getAs("Iso3166Code");
        if (c == null) {
            o.setCountry(ModelConstants.UNKNOWN_COUNTRY);
        } else {
            o.setCountry(OafMapperUtils.qualifier((String)c, (String)c, (String)"dnet:countries", (String)"dnet:countries"));
        }
        String ws = (String)r.getAs("OfficialPage");
        if (ws != null) {
            o.setWebsiteurl(OafMapperUtils.field((Object)ws, null));
        }
        AtomicAction a = new AtomicAction();
        a.setClazz(Organization.class);
        a.setPayload((Oaf)o);
        return this.mapper().writeValueAsString((Object)a);
    }

    public List<Relation> generateAffiliationRelations(Row paperAffiliation) {
        String affId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"20|mag_________::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DHPUtils.md5((String)paperAffiliation.getAs("AffiliationId").toString())}));
        String oafId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"50|mag_________::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DHPUtils.md5((String)paperAffiliation.getAs("PaperId").toString())}));
        Relation r = new Relation();
        r.setSource(oafId);
        r.setTarget(affId);
        r.setRelType("resultOrganization");
        r.setRelClass("hasAuthorInstitution");
        r.setSubRelType("affiliation");
        r.setDataInfo(this.MAGDataInfo());
        r.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{this.MAGCollectedFrom()}))).asJava());
        Relation r1 = new Relation();
        r1.setTarget(oafId);
        r1.setSource(affId);
        r1.setRelType("resultOrganization");
        r1.setRelClass("isAuthorInstitutionOf");
        r1.setSubRelType("affiliation");
        r1.setDataInfo(this.MAGDataInfo());
        r1.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{this.MAGCollectedFrom()}))).asJava());
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relation[]{r, r1}));
    }

    public String convertInvertedIndexString(String json_input) {
        VolatileByteRef bitmap$0;
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        int idl = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$1(json_input, json$lzy, bitmap$0 = VolatileByteRef.create((byte)0))).$bslash("IndexLength")).extract((Formats)this.formats$1(formats$lzy, bitmap$0), (Manifest)ManifestFactory$.MODULE$.Int()));
        if (idl > 0) {
            String[] res = (String[])Array$.MODULE$.ofDim(idl, ClassTag$.MODULE$.apply(String.class));
            Map iid = (Map)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$1(json_input, json$lzy, bitmap$0)).$bslash("InvertedIndex")).extract((Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))})));
            iid.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(Tuple2<String, List<Object>> check$ifrefutable$1) {
                    Tuple2<String, List<Object>> tuple2 = check$ifrefutable$1;
                    if (tuple2 == null) return false;
                    String k = (String)tuple2._1();
                    List v = (List)tuple2._2();
                    if (k == null) return false;
                    if (v == null) return false;
                    return true;
                }
            }).foreach((Function1)new Serializable(res){
                public static final long serialVersionUID = 0L;
                public final String[] res$1;

                public final void apply(Tuple2<String, List<Object>> x$3) {
                    Tuple2<String, List<Object>> tuple2 = x$3;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        List v = (List)tuple2._2();
                        if (k != null) {
                            String string = k;
                            if (v != null) {
                                List list = v;
                                list.foreach((Function1)new Serializable(this, string){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.convertInvertedIndexString.3 $outer;
                                    private final String x2$1;

                                    public final void apply(int item) {
                                        this.apply$mcVI$sp(item);
                                    }

                                    public void apply$mcVI$sp(int item) {
                                        this.$outer.res$1[item] = this.x2$1;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.x2$1 = x2$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.res$1 = res$1;
                }
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), idl).foreach$mVc$sp((Function1)new Serializable(res){
                public static final long serialVersionUID = 0L;
                private final String[] res$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    if (this.res$1[i] == null) {
                        this.res$1[i] = "";
                    }
                }
                {
                    this.res$1 = res$1;
                }
            });
            return Predef$.MODULE$.refArrayOps((Object[])res).mkString(" ");
        }
        return "";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final DefaultFormats$ formats$lzycompute$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        MagUtility$ magUtility$ = this;
        synchronized (magUtility$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                formats$lzy$1.elem = DefaultFormats$.MODULE$;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$1.elem;
        }
    }

    private final DefaultFormats$ formats$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.formats$lzycompute$1(formats$lzy$1, bitmap$0$1) : (DefaultFormats$)formats$lzy$1.elem;
    }

    private final JsonAST.JValue json$lzycompute$1(String json_input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        MagUtility$ magUtility$ = this;
        synchronized (magUtility$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                json$lzy$1.elem = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json_input$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$1.elem;
        }
    }

    private final JsonAST.JValue json$1(String json_input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.json$lzycompute$1(json_input$1, json$lzy$1, bitmap$0$1) : (JsonAST.JValue)json$lzy$1.elem;
    }

    /*
     * WARNING - void declaration
     */
    private MagUtility$() {
        void var1_1;
        MODULE$ = this;
        this.mapper = new ObjectMapper();
        this.MAGCollectedFrom = OafMapperUtils.keyValue((String)"10|openaire____::5f532a3fc4f1ea403f37070f59a7a53a", (String)"Microsoft Academic Graph");
        DataInfo di = new DataInfo();
        di.setDeletedbyinference(Predef$.MODULE$.boolean2Boolean(false));
        di.setInferred(Predef$.MODULE$.boolean2Boolean(false));
        di.setInvisible(Predef$.MODULE$.boolean2Boolean(true));
        di.setTrust("0.9");
        di.setProvenanceaction(OafMapperUtils.qualifier((String)"sysimport:actionset", (String)"sysimport:actionset", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"));
        this.MAGDataInfo = var1_1;
        this.datatypedict = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bool"), (Object)BooleanType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"int"), (Object)IntegerType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uint"), (Object)IntegerType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"long"), (Object)LongType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ulong"), (Object)LongType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"float"), (Object)FloatType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string"), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DateTime"), (Object)DateType$.MODULE$)}));
        this.stream = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Affiliations"), (Object)new Tuple2((Object)"mag/Affiliations.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AffiliationId:long", "Rank:uint", "NormalizedName:string", "DisplayName:string", "GridId:string", "OfficialPage:string", "WikiPage:string", "PaperCount:long", "PaperFamilyCount:long", "CitationCount:long", "Iso3166Code:string", "Latitude:float?", "Longitude:float?", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"AuthorExtendedAttributes"), (Object)new Tuple2((Object)"mag/AuthorExtendedAttributes.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AuthorId:long", "AttributeType:int", "AttributeValue:string"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Authors"), (Object)new Tuple2((Object)"mag/Authors.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AuthorId:long", "Rank:uint", "NormalizedName:string", "DisplayName:string", "LastKnownAffiliationId:long?", "PaperCount:long", "PaperFamilyCount:long", "CitationCount:long", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ConferenceInstances"), (Object)new Tuple2((Object)"mag/ConferenceInstances.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ConferenceInstanceId:long", "NormalizedName:string", "DisplayName:string", "ConferenceSeriesId:long", "Location:string", "OfficialUrl:string", "StartDate:DateTime?", "EndDate:DateTime?", "AbstractRegistrationDate:DateTime?", "SubmissionDeadlineDate:DateTime?", "NotificationDueDate:DateTime?", "FinalVersionDueDate:DateTime?", "PaperCount:long", "PaperFamilyCount:long", "CitationCount:long", "Latitude:float?", "Longitude:float?", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ConferenceSeries"), (Object)new Tuple2((Object)"mag/ConferenceSeries.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ConferenceSeriesId:long", "Rank:uint", "NormalizedName:string", "DisplayName:string", "PaperCount:long", "PaperFamilyCount:long", "CitationCount:long", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EntityRelatedEntities"), (Object)new Tuple2((Object)"advanced/EntityRelatedEntities.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EntityId:long", "EntityType:string", "RelatedEntityId:long", "RelatedEntityType:string", "RelatedType:int", "Score:float"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FieldOfStudyChildren"), (Object)new Tuple2((Object)"advanced/FieldOfStudyChildren.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FieldOfStudyId:long", "ChildFieldOfStudyId:long"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FieldOfStudyExtendedAttributes"), (Object)new Tuple2((Object)"advanced/FieldOfStudyExtendedAttributes.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FieldOfStudyId:long", "AttributeType:int", "AttributeValue:string"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FieldsOfStudy"), (Object)new Tuple2((Object)"advanced/FieldsOfStudy.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FieldOfStudyId:long", "Rank:uint", "NormalizedName:string", "DisplayName:string", "MainType:string", "Level:int", "PaperCount:long", "PaperFamilyCount:long", "CitationCount:long", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Journals"), (Object)new Tuple2((Object)"mag/Journals.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JournalId:long", "Rank:uint", "NormalizedName:string", "DisplayName:string", "Issn:string", "Publisher:string", "Webpage:string", "PaperCount:long", "PaperFamilyCount:long", "CitationCount:long", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperAbstractsInvertedIndex"), (Object)new Tuple2((Object)"nlp/PaperAbstractsInvertedIndex.txt.*", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PaperId:long", "IndexedAbstract:string"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperAuthorAffiliations"), (Object)new Tuple2((Object)"mag/PaperAuthorAffiliations.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PaperId:long", "AuthorId:long", "AffiliationId:long?", "AuthorSequenceNumber:uint", "OriginalAuthor:string", "OriginalAffiliation:string"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperCitationContexts"), (Object)new Tuple2((Object)"nlp/PaperCitationContexts.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PaperId:long", "PaperReferenceId:long", "CitationContext:string"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperExtendedAttributes"), (Object)new Tuple2((Object)"mag/PaperExtendedAttributes.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PaperId:long", "AttributeType:int", "AttributeValue:string"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperFieldsOfStudy"), (Object)new Tuple2((Object)"advanced/PaperFieldsOfStudy.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PaperId:long", "FieldOfStudyId:long", "Score:float"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperMeSH"), (Object)new Tuple2((Object)"advanced/PaperMeSH.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PaperId:long", "DescriptorUI:string", "DescriptorName:string", "QualifierUI:string", "QualifierName:string", "IsMajorTopic:bool"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperRecommendations"), (Object)new Tuple2((Object)"advanced/PaperRecommendations.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PaperId:long", "RecommendedPaperId:long", "Score:float"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperReferences"), (Object)new Tuple2((Object)"mag/PaperReferences.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PaperId:long", "PaperReferenceId:long"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperResources"), (Object)new Tuple2((Object)"mag/PaperResources.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PaperId:long", "ResourceType:int", "ResourceUrl:string", "SourceUrl:string", "RelationshipType:int"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperUrls"), (Object)new Tuple2((Object)"mag/PaperUrls.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PaperId:long", "SourceType:int?", "SourceUrl:string", "LanguageCode:string"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Papers"), (Object)new Tuple2((Object)"mag/Papers.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PaperId:long", "Rank:uint", "Doi:string", "DocType:string", "PaperTitle:string", "OriginalTitle:string", "BookTitle:string", "Year:int?", "Date:DateTime?", "OnlineDate:DateTime?", "Publisher:string", "JournalId:long?", "ConferenceSeriesId:long?", "ConferenceInstanceId:long?", "Volume:string", "Issue:string", "FirstPage:string", "LastPage:string", "ReferenceCount:long", "CitationCount:long", "EstimatedCitation:long", "OriginalVenue:string", "FamilyId:long?", "FamilyRank:uint?", "DocSubTypes:string", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"RelatedFieldOfStudy"), (Object)new Tuple2((Object)"advanced/RelatedFieldOfStudy.txt", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FieldOfStudyId1:long", "Type1:string", "FieldOfStudyId2:long", "Type2:string", "Rank:float"}))))}));
    }
}

