/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.raid;

import eu.dnetlib.dhp.actionmanager.raid.GenerateRAiDActionSetJob;
import eu.dnetlib.dhp.actionmanager.raid.model.RAiDEntity;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GenerateRAiDActionSetJobTest {
    private static String input_path;
    private static String output_path;
    private static String baseUrl;
    private static String graphBasePath;
    static SparkSession spark;

    @BeforeEach
    void setUp() throws Exception {
        input_path = Paths.get(GenerateRAiDActionSetJobTest.class.getResource("/eu/dnetlib/dhp/actionmanager/raid/raid_example.json").toURI()).toFile().getAbsolutePath();
        output_path = Files.createTempDirectory(GenerateRAiDActionSetJobTest.class.getSimpleName() + "-", new FileAttribute[0]).toAbsolutePath().toString();
        baseUrl = "https://baseurl/";
        graphBasePath = Paths.get(GenerateRAiDActionSetJobTest.class.getResource("/eu/dnetlib/dhp/actionmanager/raid/").toURI()).toFile().getAbsolutePath();
        SparkConf conf = new SparkConf();
        conf.setAppName(GenerateRAiDActionSetJobTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", output_path);
        conf.set("hive.metastore.warehouse.dir", output_path);
        spark = SparkSession.builder().appName(GenerateRAiDActionSetJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    static void cleanUp() throws Exception {
        FileUtils.deleteDirectory((File)new File(output_path));
    }

    @Test
    void rawRAiDToGraphEntitiesTest() {
        List graphEntities = GenerateRAiDActionSetJob.rawRAiDtoGraphEntities((RAiDEntity)new RAiDEntity("-92190526", "Exploring Multi-Scale Map Generalization and Design", "This project aims to advance the generalization of multi-scale maps by investigating the impact of different design elements on user experience. The research involves collecting and analyzing data from various sources, including surveys, eye-tracking studies, and user experiments. The goal is to identify best practices for map generalization and design, with a focus on reducing disorientation and improving information retrieval during exploration. The project has led to the development of several datasets, including BasqueRoads, AnchorWhat, and L'Alpe d'Huez, which can be used to benchmark road selection algorithms and topographic map generalization techniques. The research has also resulted in the creation of a Python library, Cartagen4py, for map generalization. The findings of this project have the potential to improve the design and usability of multi-scale maps, making them more effective tools for navigation and information retrieval.", Arrays.asList("50|doi_dedup___::6915135e0aa39f913394513f809ae58a", "50|doi_dedup___::754e3c283639bc6e104c925ff3e34007", "50|doi_dedup___::13517477f3c1261d57a3364363ce6ce0", "50|doi_dedup___::675b16c73accc4e7242bbb4ed9b3724a", "50|doi_dedup___::94ce09906b2d7d37eb2206cea8a50153", "50|dedup_wf_002::cc575d5ca5651ff8c3029a3a76e7e70a", "50|doi_dedup___::c5e52baddda17c755d1bae012a97dc13", "50|doi_dedup___::4f5f38c9e08fe995f7278963183f8ad4", "50|doi_dedup___::a9bc4453273b2d02648a5cb453195042", "50|doi_dedup___::5e893dc0cb7624a33f41c9b428bd59f7", "50|doi_dedup___::c1ecdef48fd9be811a291deed950e1c5", "50|doi_dedup___::9e93c8f2d97c35de8a6a57a5b53ef283", "50|dedup_wf_002::d08be0ed27b13d8a880e891e08d093ea", "50|doi_dedup___::f8d8b3b9eddeca2fc0e3bc9e63996555"), "2021-09-10", "2024-02-16"), (String)"https://baseurl/");
        OtherResearchProduct orp = (OtherResearchProduct)graphEntities.get(0);
        Relation rel = (Relation)graphEntities.get(1);
        Assertions.assertEquals((Object)"Exploring Multi-Scale Map Generalization and Design", (Object)((StructuredProperty)orp.getTitle().get(0)).getValue());
        Assertions.assertEquals((Object)"https://baseurl/raid________::759a564ce5cc7360cab030c517c7366b", ((Instance)orp.getInstance().get(0)).getUrl().get(0));
        Assertions.assertEquals((Object)"50|raid________::759a564ce5cc7360cab030c517c7366b", (Object)rel.getSource());
        Assertions.assertEquals((Object)"50|doi_dedup___::6915135e0aa39f913394513f809ae58a", (Object)rel.getTarget());
    }

    @Test
    void raidEntitiesToAtomicActionsTest() {
        JavaRDD atomicActions = GenerateRAiDActionSetJob.raidEntitiesToAtomicActions((SparkSession)spark, (String)input_path, (String)baseUrl, (String)graphBasePath);
        JavaRDD relations = atomicActions.filter((Function & Serializable)aa -> aa.getClazz().equals(Relation.class)).map(AtomicAction::getPayload).map((Function & Serializable)p -> (Relation)p);
        JavaRDD raids = atomicActions.filter((Function & Serializable)aa -> aa.getClazz().equals(OtherResearchProduct.class)).map(AtomicAction::getPayload).map((Function & Serializable)p -> (OtherResearchProduct)p);
        Assertions.assertEquals((long)6L, (long)raids.count());
        Assertions.assertEquals((long)80L, (long)relations.count());
        Assertions.assertEquals((long)4L, (long)relations.filter((Function & Serializable)r -> r.getRelType().equals("resultOrganization")).count());
        Assertions.assertEquals((long)2L, (long)relations.filter((Function & Serializable)r -> r.getRelType().equals("resultProject")).count());
        Assertions.assertEquals((long)74L, (long)relations.filter((Function & Serializable)r -> r.getRelType().equals("resultResult")).count());
    }
}

