/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.mag;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.collection.mag.MagUtility$;
import eu.dnetlib.dhp.collection.mag.SparkMAGtoOAF;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Result;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001\u001b\tqQ*Q$NCB\u0004\u0018N\\4UKN$(BA\u0002\u0005\u0003\ri\u0017m\u001a\u0006\u0003\u000b\u0019\t!bY8mY\u0016\u001cG/[8o\u0015\t9\u0001\"A\u0002eQBT!!\u0003\u0006\u0002\u000f\u0011tW\r\u001e7jE*\t1\"\u0001\u0002fk\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\b5\u0001\u0011\r\u0011\"\u0001\u001c\u0003\u0019i\u0017\r\u001d9feV\tA\u0004\u0005\u0002\u001eM5\taD\u0003\u0002 A\u0005AA-\u0019;bE&tGM\u0003\u0002\"E\u00059!.Y2lg>t'BA\u0012%\u0003%1\u0017m\u001d;feblGNC\u0001&\u0003\r\u0019w.\\\u0005\u0003Oy\u0011Ab\u00142kK\u000e$X*\u00199qKJDa!\u000b\u0001!\u0002\u0013a\u0012aB7baB,'\u000f\t\u0005\u0006W\u0001!\t\u0001L\u0001\f[\u0006\u0004\b/\u001b8h)\u0016\u001cH\u000fF\u0001.!\tya&\u0003\u00020!\t!QK\\5u\u0011\u0015\t\u0004\u0001\"\u0001-\u00039i\u0017\r\u001d9j]\u001el\u0015m\u001a+za\u0016D#\u0001M\u001a\u0011\u0005QjT\"A\u001b\u000b\u0005Y:\u0014aA1qS*\u0011\u0001(O\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQ4(A\u0003kk:LGOC\u0001=\u0003\ry'oZ\u0005\u0003}U\u0012A\u0001V3ti\")\u0001\t\u0001C\u0001\u0003\u0006Y1\r[3dWJ+7/\u001e7u+\t\u00115\f\u0006\u0003.\u00076\u0013\u0006\"\u0002#@\u0001\u0004)\u0015!\u0001:\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015aA8bM*\u0011!JB\u0001\u0007g\u000eDW-\\1\n\u00051;%A\u0002*fgVdG\u000fC\u0003O\u007f\u0001\u0007q*A\u0005j]ZL7/\u001b2mKB\u0011q\u0002U\u0005\u0003#B\u0011qAQ8pY\u0016\fg\u000eC\u0003T\u007f\u0001\u0007A+\u0001\u0005usB,g*Y7f!\t)\u0006L\u0004\u0002\u0010-&\u0011q\u000bE\u0001\u0007!J,G-\u001a4\n\u0005eS&AB*ue&twM\u0003\u0002X!\u0011)Al\u0010b\u0001;\n\tA+\u0005\u0002_CB\u0011qbX\u0005\u0003AB\u0011qAT8uQ&tw\r\u0005\u0002\u0010E&\u00111\r\u0005\u0002\u0004\u0003:L\b")
public class MAGMappingTest {
    private final ObjectMapper mapper = new ObjectMapper();

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public void mappingTest() {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Test").master("local[*]").getOrCreate();
        SparkMAGtoOAF s = new SparkMAGtoOAF(null, null, null);
        s.convertMAG(spark, "/Users/sandro/Downloads/", "/Users/sandro/Downloads/mag_OAF");
    }

    @Test
    public void mappingMagType() {
        this.checkResult(MagUtility$.MODULE$.createResultFromType(null, null), true, "Other literature type");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"BookChapter"), null), true, "Part of book or chapter of book");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Book"), null), true, "Book");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Repository"), null), true, "Other literature type");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Thesis"), null), true, "Thesis");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Conference"), null), true, "Article");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Journal"), null), true, "Article");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Dataset"), null), true, "Dataset");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Patent"), (Option)new Some((Object)"Patent Department of the Navy")), true, "Patent");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Patent"), (Option)new Some((Object)"Brevet Department of the Navy")), true, "Patent");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Patent"), (Option)new Some((Object)"Journal of the Navy")), true, "Journal");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Patent"), (Option)new Some((Object)"Proceedings of the Navy")), true, "Article");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Dataset"), null), true, "Dataset");
        Assertions.assertNull((Object)MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Patent"), null));
        Assertions.assertNull((Object)MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Patent"), (Option)new Some((Object)"Some name ")));
    }

    public <T> void checkResult(Result r, boolean invisible, String typeName) {
        Assertions.assertNotNull((Object)r);
        Assertions.assertTrue((boolean)(r instanceof Object));
        Assertions.assertNotNull((Object)r.getDataInfo());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)invisible), (Object)r.getDataInfo().getInvisible());
        Assertions.assertNotNull((Object)r.getInstance());
        Assertions.assertTrue((r.getInstance().size() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)((Instance)r.getInstance().get(0)).getInstancetype());
        Assertions.assertEquals((Object)typeName, (Object)((Instance)r.getInstance().get(0)).getInstancetype().getClassname());
    }
}

