/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.project;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.project.PrepareProjects;
import eu.dnetlib.dhp.actionmanager.project.utils.model.CSVProject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareProjectTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ClassLoader cl = PrepareProjectTest.class.getClassLoader();
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(PrepareProjectTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(PrepareProjectTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PrepareProjectTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void numberDistinctProjectTest() throws Exception {
        PrepareProjects.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-projectPath", this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/project/projects_nld.json.gz").getPath(), "-outputPath", workingDir.toString() + "/preparedProjects", "-dbProjectPath", this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/project/dbProject").getPath()});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/preparedProjects").map((Function & Serializable)item -> (CSVProject)OBJECT_MAPPER.readValue(item, CSVProject.class));
        Assertions.assertEquals((long)8L, (long)tmp.count());
        Dataset verificationDataset = spark.createDataset(tmp.rdd(), Encoders.bean(CSVProject.class));
        Assertions.assertEquals((long)0L, (long)verificationDataset.filter("length(id) = 0").count());
        Assertions.assertEquals((long)0L, (long)verificationDataset.filter("length(programme) = 0").count());
        Assertions.assertEquals((long)0L, (long)verificationDataset.filter("length(topics) = 0").count());
        CSVProject project = (CSVProject)tmp.filter((Function & Serializable)p -> p.getId().equals("886828")).first();
        Assertions.assertEquals((Object)"H2020-EU.2.3.", (Object)project.getProgramme());
        Assertions.assertEquals((Object)"EIC-SMEInst-2018-2020", (Object)project.getTopics());
    }

    static {
        log = LoggerFactory.getLogger(PrepareProjectTest.class);
    }
}

