/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.bipfinder;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.bipfinder.SparkAtomicActionScoreJob;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkAtomicActionScoreJobTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(SparkAtomicActionScoreJobTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(SparkAtomicActionScoreJobTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(SparkAtomicActionScoreJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    private void runJob(String resultsInputPath, String projectsInputPath, String outputPath) throws Exception {
        SparkAtomicActionScoreJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-resultsInputPath", resultsInputPath, "-projectsInputPath", projectsInputPath, "-outputPath", outputPath});
    }

    @Test
    void testScores() throws Exception {
        String resultsInputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/bipfinder/result_bip_scores.json").getPath();
        String projectsInputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/bipfinder/project_bip_scores.json").getPath();
        String outputPath = workingDir.toString() + "/actionSet";
        this.runJob(resultsInputPath, projectsInputPath, outputPath);
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(outputPath, Text.class, Text.class).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (OafEntity)aa.getPayload());
        Assertions.assertEquals((long)8L, (long)tmp.count());
        Dataset verificationDataset = spark.createDataset(tmp.rdd(), Encoders.bean(OafEntity.class));
        verificationDataset.createOrReplaceTempView("result");
        Dataset testDataset = spark.sql("Select p.id oaid, mes.id, mUnit.value from result p lateral view explode(measures) m as mes lateral view explode(mes.unit) u as mUnit ");
        Assertions.assertEquals((long)28L, (long)testDataset.count());
        this.assertResultImpactScores((Dataset<Row>)testDataset);
        this.assertProjectImpactScores((Dataset<Row>)testDataset);
    }

    void assertResultImpactScores(Dataset<Row> testDataset) {
        Assertions.assertEquals((Object)"6.63451994567e-09", (Object)((Row)testDataset.filter("oaid='50|arXiv_dedup_::4a2d5fd8d71daec016c176ec71d957b1' and id = 'influence'").select("value", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"0.348694533145", (Object)((Row)testDataset.filter("oaid='50|arXiv_dedup_::4a2d5fd8d71daec016c176ec71d957b1' and id = 'popularity_alt'").select("value", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"2.16094680115e-09", (Object)((Row)testDataset.filter("oaid='50|arXiv_dedup_::4a2d5fd8d71daec016c176ec71d957b1' and id = 'popularity'").select("value", new String[0]).collectAsList().get(0)).getString(0));
    }

    void assertProjectImpactScores(Dataset<Row> testDataset) throws Exception {
        Assertions.assertEquals((Object)"0", (Object)((Row)testDataset.filter("oaid='40|nih_________::c02a8233e9b60f05bb418f0c9b714833' and id = 'numOfInfluentialResults'").select("value", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"1", (Object)((Row)testDataset.filter("oaid='40|nih_________::c02a8233e9b60f05bb418f0c9b714833' and id = 'numOfPopularResults'").select("value", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"25", (Object)((Row)testDataset.filter("oaid='40|nih_________::c02a8233e9b60f05bb418f0c9b714833' and id = 'totalImpulse'").select("value", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"43", (Object)((Row)testDataset.filter("oaid='40|nih_________::c02a8233e9b60f05bb418f0c9b714833' and id = 'totalCitationCount'").select("value", new String[0]).collectAsList().get(0)).getString(0));
    }

    static {
        log = LoggerFactory.getLogger(SparkAtomicActionScoreJobTest.class);
    }
}

