/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.rest;

import com.google.common.collect.Maps;
import eu.dnetlib.dhp.collection.plugin.utils.JsonUtils;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RestIterator
implements Iterator<String> {
    private static final Logger log = LoggerFactory.getLogger(RestIterator.class);
    public static final String UTF_8 = "UTF-8";
    private static final int MAX_ATTEMPTS = 5;
    private final HttpClientParams clientParams;
    private final String AUTHBASIC = "basic";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String EMPTY_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><recordWrap></recordWrap>";
    private final String baseUrl;
    private final String resumptionType;
    private final String resumptionParam;
    private final String resultFormatValue;
    private String queryParams = "";
    private final int resultSizeValue;
    private int resumptionInt = 0;
    private int resultTotal = -1;
    private String resumptionStr = Integer.toString(this.resumptionInt);
    private InputStream resultStream;
    private Transformer transformer;
    private XPath xpath;
    private String query;
    private XPathExpression xprResultTotalPath;
    private XPathExpression xprResumptionPath;
    private XPathExpression xprEntity;
    private final String queryFormat;
    private final String querySize;
    private final String authMethod;
    private final String authToken;
    private final Queue<String> recordQueue = new PriorityBlockingQueue<String>();
    private int discoverResultSize = 0;
    private int pagination = 1;
    private final String resultOutputFormat;
    private Map<String, String> requestHeaders;

    public RestIterator(HttpClientParams clientParams, String baseUrl, String resumptionType, String resumptionParam, String resumptionXpath, String resultTotalXpath, String resultFormatParam, String resultFormatValue, String resultSizeParam, String resultSizeValueStr, String queryParams, String entityXpath, String authMethod, String authToken, String resultOutputFormat, Map<String, String> requestHeaders) {
        this.clientParams = clientParams;
        this.baseUrl = baseUrl;
        this.resumptionType = resumptionType;
        this.resumptionParam = resumptionParam;
        this.resultFormatValue = resultFormatValue;
        this.resultSizeValue = Integer.parseInt(resultSizeValueStr);
        this.queryParams = queryParams;
        this.authMethod = authMethod;
        this.authToken = authToken;
        this.resultOutputFormat = resultOutputFormat;
        this.requestHeaders = requestHeaders != null ? requestHeaders : Maps.newHashMap();
        this.queryFormat = StringUtils.isNotBlank((CharSequence)resultFormatParam) ? "&" + resultFormatParam + "=" + resultFormatValue : "";
        this.querySize = StringUtils.isNotBlank((CharSequence)resultSizeParam) ? "&" + resultSizeParam + "=" + resultSizeValueStr : "";
        try {
            this.initXmlTransformation(resultTotalXpath, resumptionXpath, entityXpath);
        }
        catch (Exception e) {
            throw new IllegalStateException("xml transformation init failed: " + e.getMessage());
        }
        this.initQueue();
    }

    private void initXmlTransformation(String resultTotalXpath, String resumptionXpath, String entityXpath) throws TransformerConfigurationException, XPathExpressionException {
        TransformerFactory factory = TransformerFactory.newInstance();
        this.transformer = factory.newTransformer();
        this.transformer.setOutputProperty("indent", "yes");
        this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        this.xpath = XPathFactory.newInstance().newXPath();
        this.xprResultTotalPath = this.xpath.compile(resultTotalXpath);
        this.xprResumptionPath = this.xpath.compile(StringUtils.isBlank((CharSequence)resumptionXpath) ? "/" : resumptionXpath);
        this.xprEntity = this.xpath.compile(entityXpath);
    }

    private void initQueue() {
        this.query = this.queryParams.equals("") && this.querySize.equals("") && this.queryFormat.equals("") ? this.baseUrl : this.baseUrl + "?" + this.queryParams + this.querySize + this.queryFormat;
        log.info("REST calls starting with {}", (Object)this.query);
    }

    private void disconnect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Queue<String> queue = this.recordQueue;
        synchronized (queue) {
            while (this.recordQueue.isEmpty() && !this.query.isEmpty()) {
                try {
                    this.query = this.downloadPage(this.query, 0);
                }
                catch (CollectorException e) {
                    log.debug("CollectorPlugin.next()-Exception: {}", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            if (!this.recordQueue.isEmpty()) {
                return true;
            }
            this.disconnect();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Queue<String> queue = this.recordQueue;
        synchronized (queue) {
            return this.recordQueue.poll();
        }
    }

    private String downloadPage(String query, int attempt) throws CollectorException {
        if (attempt > 5) {
            throw new CollectorException("Max Number of attempts reached, query:" + query);
        }
        if (attempt > 0) {
            int delay = attempt * 5000;
            log.debug("Attempt {} with delay {}", (Object)attempt, (Object)delay);
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                new CollectorException((Throwable)e);
            }
        }
        try {
            String resultXml = XML_HEADER;
            String nextQuery = "";
            Node resultNode = null;
            NodeList nodeList = null;
            String qUrlArgument = "";
            int urlOldResumptionSize = 0;
            if ("deep-cursor".equalsIgnoreCase(this.resumptionType)) {
                log.debug("check resumptionType deep-cursor and check cursor=*?{}", (Object)query);
                if (!query.contains("&cursor=")) {
                    query = query + "&cursor=*";
                }
            }
            if ((this.resumptionType.toLowerCase().equals("pagination") || this.resumptionType.toLowerCase().equals("page")) && query.contains("paginationStart=")) {
                Matcher m = Pattern.compile("paginationStart=([0-9]+)").matcher(query);
                m.find();
                String[] pageVal = m.group(0).split("=");
                this.pagination = Integer.parseInt(pageVal[1]);
                this.queryParams = this.queryParams.replaceFirst("&?paginationStart=[0-9]+", "");
                query = query.replaceFirst("&?paginationStart=[0-9]+", "");
            }
            try {
                log.info("requesting URL [{}]", (Object)query);
                URL qUrl = new URL(query);
                log.debug("authMethod: {}", (Object)this.authMethod);
                if (this.authMethod == "bearer") {
                    log.trace("RestIterator.downloadPage():: authMethod before inputStream: " + resultXml);
                    this.requestHeaders.put("Authorization", "Bearer " + this.authToken);
                } else if ("basic".equalsIgnoreCase(this.authMethod)) {
                    log.trace("RestIterator.downloadPage():: authMethod before inputStream: " + resultXml);
                    this.requestHeaders.put("Authorization", "Basic " + this.authToken);
                }
                HttpURLConnection conn = (HttpURLConnection)qUrl.openConnection();
                conn.setRequestMethod("GET");
                this.setRequestHeader(conn);
                this.resultStream = conn.getInputStream();
                if ("json".equals(this.resultOutputFormat)) {
                    String resultJson = IOUtils.toString((InputStream)this.resultStream, (Charset)StandardCharsets.UTF_8);
                    resultXml = JsonUtils.convertToXML(resultJson);
                    this.resultStream = IOUtils.toInputStream((String)resultXml, (String)UTF_8);
                }
                if (!this.isEmptyXml(resultXml)) {
                    resultNode = (Node)this.xpath.evaluate("/", new InputSource(this.resultStream), XPathConstants.NODE);
                    nodeList = (NodeList)this.xprEntity.evaluate(resultNode, XPathConstants.NODESET);
                    log.debug("nodeList.length: {}", (Object)nodeList.getLength());
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        StringWriter sw = new StringWriter();
                        this.transformer.transform(new DOMSource(nodeList.item(i)), new StreamResult(sw));
                        String toEnqueue = sw.toString();
                        if (toEnqueue == null || StringUtils.isBlank((CharSequence)toEnqueue) || this.isEmptyXml(toEnqueue)) {
                            log.warn("The following record resulted in empty item for the feeding queue: {}", (Object)resultXml);
                            continue;
                        }
                        this.recordQueue.add(sw.toString());
                    }
                } else {
                    log.warn("resultXml is equal with emptyXml");
                }
                this.resumptionInt += this.resultSizeValue;
                switch (this.resumptionType.toLowerCase()) {
                    case "scan": {
                        this.resumptionStr = this.xprResumptionPath.evaluate(resultNode);
                        break;
                    }
                    case "count": {
                        this.resumptionStr = Integer.toString(this.resumptionInt);
                        break;
                    }
                    case "discover": {
                        String[] arrayQUrlArgument;
                        if (this.resultSizeValue < 2) {
                            throw new CollectorException("Mode: discover, Param 'resultSizeValue' is less than 2");
                        }
                        qUrlArgument = qUrl.getQuery();
                        for (String arrayUrlArgStr : arrayQUrlArgument = qUrlArgument.split("&")) {
                            if (!arrayUrlArgStr.startsWith(this.resumptionParam)) continue;
                            String[] resumptionKeyValue = arrayUrlArgStr.split("=");
                            if (this.isInteger(resumptionKeyValue[1])) {
                                urlOldResumptionSize = Integer.parseInt(resumptionKeyValue[1]);
                                log.debug("discover OldResumptionSize from Url (int): {}", (Object)urlOldResumptionSize);
                                continue;
                            }
                            log.debug("discover OldResumptionSize from Url (str): {}", (Object)resumptionKeyValue[1]);
                        }
                        if (this.isEmptyXml(resultXml) || nodeList != null && nodeList.getLength() < this.resultSizeValue) {
                            if (nodeList != null) {
                                this.discoverResultSize += nodeList.getLength();
                            }
                            this.resultTotal = this.discoverResultSize;
                        } else {
                            this.resumptionStr = Integer.toString(this.resumptionInt);
                            this.resultTotal = this.resumptionInt + 1;
                            if (nodeList != null) {
                                this.discoverResultSize += nodeList.getLength();
                            }
                        }
                        log.info("discoverResultSize: {}", (Object)this.discoverResultSize);
                        break;
                    }
                    case "pagination": 
                    case "page": {
                        if (nodeList != null && nodeList.getLength() > 0) {
                            this.discoverResultSize += nodeList.getLength();
                        } else {
                            this.resultTotal = this.discoverResultSize;
                            this.pagination = this.discoverResultSize;
                        }
                        ++this.pagination;
                        this.resumptionInt = this.pagination;
                        this.resumptionStr = Integer.toString(this.resumptionInt);
                        break;
                    }
                    case "deep-cursor": {
                        this.resumptionStr = this.encodeValue(this.xprResumptionPath.evaluate(resultNode));
                        this.queryParams = this.queryParams.replace("&cursor=*", "");
                        this.resumptionInt = nodeList != null && nodeList.getLength() < this.discoverResultSize ? (this.resumptionInt += nodeList.getLength() + 1 - this.resultSizeValue) : (this.resumptionInt += nodeList.getLength() - this.resultSizeValue);
                        this.discoverResultSize = nodeList.getLength();
                        log.debug("downloadPage().deep-cursor: resumptionStr=" + this.resumptionStr + " ; queryParams=" + this.queryParams + " resumptionLengthIncreased: " + this.resumptionInt);
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new IllegalStateException("collection failed: " + e.getMessage());
            }
            try {
                if (this.resultTotal == -1) {
                    this.resultTotal = Integer.parseInt(this.xprResultTotalPath.evaluate(resultNode));
                    if ("page".equalsIgnoreCase(this.resumptionType) && !this.AUTHBASIC.equalsIgnoreCase(this.authMethod)) {
                        ++this.resultTotal;
                    }
                    log.info("resultTotal was -1 is now: " + this.resultTotal);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new IllegalStateException("downloadPage resultTotal couldn't parse: " + e.getMessage());
            }
            log.debug("resultTotal: " + this.resultTotal);
            log.debug("resInt: " + this.resumptionInt);
            nextQuery = this.resumptionInt <= this.resultTotal ? this.baseUrl + "?" + this.queryParams + this.querySize + "&" + this.resumptionParam + "=" + this.resumptionStr + this.queryFormat : "";
            log.debug("nextQueryUrl: " + nextQuery);
            return nextQuery;
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
            return this.downloadPage(query, attempt + 1);
        }
    }

    private boolean isEmptyXml(String s) {
        return EMPTY_XML.equalsIgnoreCase(s);
    }

    private boolean isInteger(String s) {
        boolean isValidInteger = false;
        try {
            Integer.parseInt(s);
            isValidInteger = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return isValidInteger;
    }

    private String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    private void setRequestHeader(HttpURLConnection conn) {
        if (this.requestHeaders != null) {
            for (String key : this.requestHeaders.keySet()) {
                conn.setRequestProperty(key, this.requestHeaders.get(key));
            }
            log.debug("Set Request Header with: " + this.requestHeaders);
        }
    }

    public String getResultFormatValue() {
        return this.resultFormatValue;
    }

    public String getResultOutputFormat() {
        return this.resultOutputFormat;
    }
}

