/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.transformation;

import eu.dnetlib.dhp.aggregation.common.AggregationCounter;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.message.MessageSender;
import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import eu.dnetlib.dhp.schema.mdstore.MetadataRecord;
import eu.dnetlib.dhp.transformation.DnetTransformationException;
import eu.dnetlib.dhp.transformation.TransformationFactory;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformSparkJobNode {
    private static final Logger log = LoggerFactory.getLogger(TransformSparkJobNode.class);
    private static final int RECORDS_PER_TASK = 200;

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)TransformSparkJobNode.class.getResourceAsStream("/eu/dnetlib/dhp/transformation/transformation_input_parameters.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String mdstoreInputVersion = parser.get("mdstoreInputVersion");
        String mdstoreOutputVersion = parser.get("mdstoreOutputVersion");
        MDStoreVersion nativeMdStoreVersion = (MDStoreVersion)DHPUtils.MAPPER.readValue(mdstoreInputVersion, MDStoreVersion.class);
        String inputPath = nativeMdStoreVersion.getHdfsPath() + "/store";
        log.info("inputPath: {}", (Object)inputPath);
        MDStoreVersion cleanedMdStoreVersion = (MDStoreVersion)DHPUtils.MAPPER.readValue(mdstoreOutputVersion, MDStoreVersion.class);
        String outputBasePath = cleanedMdStoreVersion.getHdfsPath();
        log.info("outputBasePath: {}", (Object)outputBasePath);
        String isLookupUrl = parser.get("isLookupUrl");
        log.info("isLookupUrl: {}", (Object)isLookupUrl);
        String dateOfTransformation = parser.get("dateOfTransformation");
        log.info("dateOfTransformation: {}", (Object)dateOfTransformation);
        Integer rpt = Optional.ofNullable(parser.get("recordsPerTask")).map(Integer::valueOf).orElse(200);
        ISLookUpService isLookupService = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
        VocabularyGroup vocabularies = VocabularyGroup.loadVocsFromIS((ISLookUpService)isLookupService);
        log.info("Retrieved {} vocabularies", (Object)vocabularies.vocabularyNames().size());
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> TransformSparkJobNode.transformRecords(parser.getObjectMap(), isLookupService, spark, inputPath, outputBasePath, rpt));
    }

    public static void transformRecords(Map<String, String> args, ISLookUpService isLookUpService, SparkSession spark, String inputPath, String outputBasePath, Integer rpt) throws DnetTransformationException, IOException {
        LongAccumulator totalItems = spark.sparkContext().longAccumulator("TotalItems");
        LongAccumulator errorItems = spark.sparkContext().longAccumulator("InvalidRecords");
        LongAccumulator transformedItems = spark.sparkContext().longAccumulator("transformedItems");
        AggregationCounter ct = new AggregationCounter(totalItems, errorItems, transformedItems);
        Encoder encoder = Encoders.bean(MetadataRecord.class);
        String dnetMessageManagerURL = args.get("dnetMessageManagerURL");
        log.info("dnetMessageManagerURL is {}", (Object)dnetMessageManagerURL);
        String workflowId = args.get("workflowId");
        log.info("workflowId is {}", (Object)workflowId);
        MapFunction<MetadataRecord, MetadataRecord> x = TransformationFactory.getTransformationPlugin(args, ct, isLookUpService);
        Dataset rows = spark.read().parquet(inputPath);
        StructType schema = Encoders.bean(MetadataRecord.class).schema();
        DataType dataType = schema.apply("validationResults").dataType();
        Dataset rowsWithNewField = ArrayUtils.contains((Object[])rows.schema().fieldNames(), (Object)"validationResults") ? rows : rows.withColumn("validationResults", functions.lit(null).cast(dataType));
        Dataset inputMDStore = rowsWithNewField.as(encoder);
        long totalInput = inputMDStore.count();
        MessageSender messageSender = new MessageSender(dnetMessageManagerURL, workflowId);
        try (AggregatorReport report = new AggregatorReport(messageSender);){
            try {
                JavaRDD mdstore = inputMDStore.javaRDD().repartition(TransformSparkJobNode.getRepartitionNumber(totalInput, rpt)).map(arg_0 -> x.call(arg_0)).filter(Objects::nonNull);
                DHPUtils.saveDataset((Dataset)spark.createDataset(mdstore.rdd(), encoder), (String)(outputBasePath + "/store"));
                log.info("Transformed item {}", (Object)ct.getProcessedItems().count());
                log.info("Total item {}", (Object)ct.getTotalItems().count());
                log.info("Transformation Error item {}", (Object)ct.getErrorItems().count());
                long mdStoreSize = spark.read().load(outputBasePath + "/store").count();
                DHPUtils.writeHdfsFile((Configuration)spark.sparkContext().hadoopConfiguration(), (String)("" + mdStoreSize), (String)(outputBasePath + "/size"));
            }
            catch (Throwable e) {
                log.error("error during record transformation", e);
                report.put((Object)TransformSparkJobNode.class.getSimpleName(), (Object)e.getMessage());
                report.put((Object)"TotalItems", (Object)ct.getTotalItems().value().toString());
                report.put((Object)"InvalidRecords", (Object)ct.getErrorItems().value().toString());
                report.put((Object)"transformedItems", (Object)ct.getProcessedItems().value().toString());
                throw e;
            }
        }
    }

    private static int getRepartitionNumber(long totalInput, Integer rpt) {
        return Math.max(1, (int)(totalInput / (long)rpt.intValue()));
    }
}

