/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.bio;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import eu.dnetlib.dhp.aggregation.AbstractVocabularyTest;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.dhp.sx.bio.BioDBToOAF$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$AuthorPID$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$EBILinks$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$GzFileIterator$;
import eu.dnetlib.dhp.sx.bio.ebi.SparkCreatePubmedDump;
import eu.dnetlib.dhp.sx.bio.pubmed.PMArticle;
import eu.dnetlib.dhp.sx.bio.pubmed.PMAuthor;
import eu.dnetlib.dhp.sx.bio.pubmed.PMIdentifier;
import eu.dnetlib.dhp.sx.bio.pubmed.PMParser;
import eu.dnetlib.dhp.sx.bio.pubmed.PMParser2;
import eu.dnetlib.dhp.sx.bio.pubmed.PMSubject;
import eu.dnetlib.dhp.sx.bio.pubmed.PubMedToOaf$;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.io.IOUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.SomeValue$;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={MockitoExtension.class})
@ScalaSignature(bytes="\u0006\u0001\r\re\u0001B-[\u0001\u0015DQ\u0001\u001c\u0001\u0005\u00025Dq\u0001\u001d\u0001C\u0002\u0013\u0005\u0011\u000f\u0003\u0004\u007f\u0001\u0001\u0006IA\u001d\u0005\u0007\u007f\u0002!\t!!\u0001\u0007\r\u0005%\u0002\u0001AA\u0016\u0011)\tY&\u0002B\u0001B\u0003%\u0011Q\f\u0005\u0007Y\u0016!\t!!\u001c\t\u000f\u0005UT\u0001\"\u0011\u0002x!9\u0011qP\u0003\u0005B\u0005\u0005uaBAG\u0001!\u0005\u0011q\u0012\u0004\b\u0003#\u0003\u0001\u0012AAJ\u0011\u0019a7\u0002\"\u0001\u0002\u0016\"9\u0011qS\u0006\u0005\u0002\u0005e\u0005bBAU\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003g\u0003A\u0011AA[\r\u0019\t\t\r\u0001!\u0002D\"Q\u0011\u0011\u001b\t\u0003\u0016\u0004%\t!a5\t\u0015\u0005U\u0007C!E!\u0002\u0013\tY\u0005\u0003\u0006\u0002XB\u0011)\u001a!C\u0001\u0003'D!\"!7\u0011\u0005#\u0005\u000b\u0011BA&\u0011\u0019a\u0007\u0003\"\u0001\u0002\\\"I\u00111\u001d\t\u0002\u0002\u0013\u0005\u0011Q\u001d\u0005\n\u0003W\u0004\u0012\u0013!C\u0001\u0003[D\u0011Ba\u0001\u0011#\u0003%\t!!<\t\u0013\t\u0015\u0001#!A\u0005B\t\u001d\u0001\"\u0003B\u0005!\u0005\u0005I\u0011\u0001B\u0006\u0011%\u0011\u0019\u0002EA\u0001\n\u0003\u0011)\u0002C\u0005\u0003\"A\t\t\u0011\"\u0011\u0003$!I!q\u0006\t\u0002\u0002\u0013\u0005!\u0011\u0007\u0005\n\u0005k\u0001\u0012\u0011!C!\u0005oA\u0011B!\u000f\u0011\u0003\u0003%\t%!!\t\u0013\tm\u0002#!A\u0005B\tur!\u0003B!\u0001\u0005\u0005\t\u0012\u0001B\"\r%\t\t\rAA\u0001\u0012\u0003\u0011)\u0005\u0003\u0004mE\u0011\u0005!1\u000b\u0005\n\u0005s\u0011\u0013\u0011!C#\u0003\u0003C\u0011\"a&#\u0003\u0003%\tI!\u0016\t\u0013\tm#%!A\u0005\u0002\nu\u0003b\u0002B8\u0001\u0011\u0005!\u0011\u000f\u0005\b\u0005o\u0002A\u0011AA\u0001\u0011\u001d\u0011Y\b\u0001C\u0001\u0003\u0003AqAa \u0001\t\u0003\t\t\u0001C\u0004\u0003\u0004\u0002!IA!\"\t\u000f\t]\u0005\u0001\"\u0001\u0002\u0002!9!1\u0014\u0001\u0005\n\tu\u0005b\u0002BZ\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0005k\u0003A\u0011AA\u0001\u0011\u001d\u0011I\f\u0001C\u0001\u0003\u0003AqA!0\u0001\t\u0003\t\t\u0001C\u0004\u0003B\u0002!\t!!\u0001\u0007\r\t\u0015\u0007\u0001\u0011Bd\u0011)\u0011Im\rBK\u0002\u0013\u0005\u00111\u001b\u0005\u000b\u0005\u0017\u001c$\u0011#Q\u0001\n\u0005-\u0003B\u0003Bgg\tU\r\u0011\"\u0001\u0002T\"Q!qZ\u001a\u0003\u0012\u0003\u0006I!a\u0013\t\u0015\tE7G!f\u0001\n\u0003\t\u0019\u000e\u0003\u0006\u0003TN\u0012\t\u0012)A\u0005\u0003\u0017B!B!64\u0005+\u0007I\u0011AAj\u0011)\u00119n\rB\tB\u0003%\u00111\n\u0005\u000b\u00053\u001c$Q3A\u0005\u0002\u0005M\u0007B\u0003Bng\tE\t\u0015!\u0003\u0002L!Q!Q\\\u001a\u0003\u0016\u0004%\t!a5\t\u0015\t}7G!E!\u0002\u0013\tY\u0005\u0003\u0004mg\u0011\u0005!\u0011\u001d\u0005\n\u0003G\u001c\u0014\u0011!C\u0001\u0005cD\u0011\"a;4#\u0003%\t!!<\t\u0013\t\r1'%A\u0005\u0002\u00055\b\"\u0003B\u0000gE\u0005I\u0011AAw\u0011%\u0019\taMI\u0001\n\u0003\ti\u000fC\u0005\u0004\u0004M\n\n\u0011\"\u0001\u0002n\"I1QA\u001a\u0012\u0002\u0013\u0005\u0011Q\u001e\u0005\n\u0005\u000b\u0019\u0014\u0011!C!\u0005\u000fA\u0011B!\u00034\u0003\u0003%\tAa\u0003\t\u0013\tM1'!A\u0005\u0002\r\u001d\u0001\"\u0003B\u0011g\u0005\u0005I\u0011\tB\u0012\u0011%\u0011ycMA\u0001\n\u0003\u0019Y\u0001C\u0005\u00036M\n\t\u0011\"\u0011\u00038!I!\u0011H\u001a\u0002\u0002\u0013\u0005\u0013\u0011\u0011\u0005\n\u0005w\u0019\u0014\u0011!C!\u0007\u001f9\u0011ba\u0005\u0001\u0003\u0003E\ta!\u0006\u0007\u0013\t\u0015\u0007!!A\t\u0002\r]\u0001B\u00027R\t\u0003\u0019y\u0002C\u0005\u0003:E\u000b\t\u0011\"\u0012\u0002\u0002\"I\u0011qS)\u0002\u0002\u0013\u00055\u0011\u0005\u0005\n\u00057\n\u0016\u0011!CA\u0007_Aqaa\u000f\u0001\t\u0003\u0019i\u0004C\u0004\u0004F\u0001!\t!!\u0001\t\u0019\r%\u0003\u0001%A\u0001\u0002\u0003%\taa\u0013\u0003\u001d\tKwnU2i_2L\u0007\u0010V3ti*\u00111\fX\u0001\u0004E&|'BA/_\u0003\t\u0019\bP\u0003\u0002`A\u0006\u0019A\r\u001b9\u000b\u0005\u0005\u0014\u0017a\u00023oKRd\u0017N\u0019\u0006\u0002G\u0006\u0011Q-^\u0002\u0001'\t\u0001a\r\u0005\u0002hU6\t\u0001N\u0003\u0002j=\u0006Y\u0011mZ4sK\u001e\fG/[8o\u0013\tY\u0007N\u0001\fBEN$(/Y2u->\u001c\u0017MY;mCJLH+Z:u\u0003\u0019a\u0014N\\5u}Q\ta\u000e\u0005\u0002p\u00015\t!,\u0001\u0004nCB\u0004XM]\u000b\u0002eB\u00111\u000f`\u0007\u0002i*\u0011QO^\u0001\tI\u0006$\u0018MY5oI*\u0011q\u000f_\u0001\bU\u0006\u001c7n]8o\u0015\tI(0A\u0005gCN$XM\u001d=nY*\t10A\u0002d_6L!! ;\u0003\u0019=\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\u0002\u000f5\f\u0007\u000f]3sA\u0005)1/\u001a;VaR\u0011\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0011\u0011\u0011B\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003\u001b\t9A\u0001\u0003V]&$\bf\u0001\u0003\u0002\u0012A!\u00111CA\u0013\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011aA1qS*!\u00111DA\u000f\u0003\u001dQW\u000f]5uKJTA!a\b\u0002\"\u0005)!.\u001e8ji*\u0011\u00111E\u0001\u0004_J<\u0017\u0002BA\u0014\u0003+\u0011!BQ3g_J,W)Y2i\u0005Y\u0011UO\u001a4fe\u0016$'+Z1eKJLE/\u001a:bi>\u00148#B\u0003\u0002.\u0005M\u0002\u0003BA\u0003\u0003_IA!!\r\u0002\b\t1\u0011I\\=SK\u001a\u0004b!!\u000e\u0002F\u0005-c\u0002BA\u001c\u0003\u0003rA!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{!\u0017A\u0002\u001fs_>$h(\u0003\u0002\u0002\n%!\u00111IA\u0004\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0012\u0002J\tA\u0011\n^3sCR|'O\u0003\u0003\u0002D\u0005\u001d\u0001\u0003BA'\u0003+rA!a\u0014\u0002RA!\u0011\u0011HA\u0004\u0013\u0011\t\u0019&a\u0002\u0002\rA\u0013X\rZ3g\u0013\u0011\t9&!\u0017\u0003\rM#(/\u001b8h\u0015\u0011\t\u0019&a\u0002\u0002\rI,\u0017\rZ3s!\u0011\ty&!\u001b\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\n!![8\u000b\u0005\u0005\u001d\u0014\u0001\u00026bm\u0006LA!a\u001b\u0002b\tq!)\u001e4gKJ,GMU3bI\u0016\u0014H\u0003BA8\u0003g\u00022!!\u001d\u0006\u001b\u0005\u0001\u0001bBA.\u000f\u0001\u0007\u0011QL\u0001\bQ\u0006\u001ch*\u001a=u)\t\tI\b\u0005\u0003\u0002\u0006\u0005m\u0014\u0002BA?\u0003\u000f\u0011qAQ8pY\u0016\fg.\u0001\u0003oKb$HCAAB!\u0011\t))a#\u000e\u0005\u0005\u001d%\u0002BAE\u0003K\nA\u0001\\1oO&!\u0011qKAD\u000399%PR5mK&#XM]1u_J\u00042!!\u001d\f\u000599%PR5mK&#XM]1u_J\u001c2aCA\u0017)\t\ty)A\u0003baBd\u0017\u0010\u0006\u0004\u0002p\u0005m\u0015Q\u0015\u0005\b\u0003;k\u0001\u0019AAP\u0003\tI7\u000f\u0005\u0003\u0002`\u0005\u0005\u0016\u0002BAR\u0003C\u00121\"\u00138qkR\u001cFO]3b[\"9\u0011qU\u0007A\u0002\u0005-\u0013\u0001C3oG>$\u0017N\\4\u0002\u000fQ,7\u000f\u001e)jI\"\u001aa\"!,\u0011\t\u0005M\u0011qV\u0005\u0005\u0003c\u000b)B\u0001\u0003UKN$\u0018AE3yiJ\f7\r^!gM&d\u0017.\u0019;j_:$B!a.\u0002>B1\u0011QGA]\u0003\u0017JA!a/\u0002J\t!A*[:u\u0011\u001d\tyl\u0004a\u0001\u0003\u0017\n\u0011a\u001d\u0002\n\u0003V$\bn\u001c:Q\u0013\u0012\u001br\u0001EA\u0017\u0003\u000b\fY\r\u0005\u0003\u0002\u0006\u0005\u001d\u0017\u0002BAe\u0003\u000f\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002\u0006\u00055\u0017\u0002BAh\u0003\u000f\u0011AbU3sS\u0006d\u0017N_1cY\u0016\fq\u0001]5e)f\u0004X-\u0006\u0002\u0002L\u0005A\u0001/\u001b3UsB,\u0007%A\u0002qS\u0012\fA\u0001]5eAQ1\u0011Q\\Ap\u0003C\u00042!!\u001d\u0011\u0011\u001d\t\t.\u0006a\u0001\u0003\u0017Bq!a6\u0016\u0001\u0004\tY%\u0001\u0003d_BLHCBAo\u0003O\fI\u000fC\u0005\u0002RZ\u0001\n\u00111\u0001\u0002L!I\u0011q\u001b\f\u0011\u0002\u0003\u0007\u00111J\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyO\u000b\u0003\u0002L\u0005E8FAAz!\u0011\t)0a@\u000e\u0005\u0005](\u0002BA}\u0003w\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\u0005u\u0018qA\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0001\u0003o\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAB\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011i\u0001\u0005\u0003\u0002\u0006\t=\u0011\u0002\u0002B\t\u0003\u000f\u00111!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u0006\u0003\u001eA!\u0011Q\u0001B\r\u0013\u0011\u0011Y\"a\u0002\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003 m\t\t\u00111\u0001\u0003\u000e\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\n\u0011\r\t\u001d\"Q\u0006B\f\u001b\t\u0011IC\u0003\u0003\u0003,\u0005\u001d\u0011AC2pY2,7\r^5p]&!\u0011q\tB\u0015\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA=\u0005gA\u0011Ba\b\u001e\u0003\u0003\u0005\rAa\u0006\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\u0004\u0002\u0011Q|7\u000b\u001e:j]\u001e\fa!Z9vC2\u001cH\u0003BA=\u0005\u007fA\u0011Ba\b!\u0003\u0003\u0005\rAa\u0006\u0002\u0013\u0005+H\u000f[8s!&#\u0005cAA9EM)!Ea\u0012\u0002LBQ!\u0011\nB(\u0003\u0017\nY%!8\u000e\u0005\t-#\u0002\u0002B'\u0003\u000f\tqA];oi&lW-\u0003\u0003\u0003R\t-#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!1\t\u000b\u0007\u0003;\u00149F!\u0017\t\u000f\u0005EW\u00051\u0001\u0002L!9\u0011q[\u0013A\u0002\u0005-\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0005?\u0012Y\u0007\u0005\u0004\u0002\u0006\t\u0005$QM\u0005\u0005\u0005G\n9A\u0001\u0004PaRLwN\u001c\t\t\u0003\u000b\u00119'a\u0013\u0002L%!!\u0011NA\u0004\u0005\u0019!V\u000f\u001d7fe!I!Q\u000e\u0014\u0002\u0002\u0003\u0007\u0011Q\\\u0001\u0004q\u0012\u0002\u0014aF3yiJ\f7\r^!vi\"|'/\u00133f]RLg-[3s)\u0011\u0011\u0019H!\u001e\u0011\r\u0005U\u0012\u0011XAo\u0011\u001d\tyl\na\u0001\u0003\u0017\n!\u0003^3tiB\u000b'o]5oOB+(-\\3ee!\u001a\u0001&!,\u0002\u0017Q,7\u000f^#C\u0013\u0012\u000bG/\u0019\u0015\u0004S\u00055\u0016a\u0004;fgR\u0004VOY7fIR{w*\u00194)\u0007)\ni+\u0001\bdQ\u0016\u001c7\u000eU'BeRL7\r\\3\u0015\t\u0005\r!q\u0011\u0005\b\u0005\u0013[\u0003\u0019\u0001BF\u0003\u001d\t'\u000f^5dY\u0016\u0004BA!$\u0003\u00146\u0011!q\u0012\u0006\u0004\u0005#S\u0016A\u00029vE6,G-\u0003\u0003\u0003\u0016\n=%!\u0003)N\u0003J$\u0018n\u00197f\u0003Q!Xm\u001d;QCJ\u001c\u0018N\\4Qk\nlW\r\u001a-N\u0019\"\u001aA&!,\u0002-\rDWmY6Qk\nlW\r\u001a)vE2L7-\u0019;j_:$B!a\u0001\u0003 \"9!\u0011U\u0017A\u0002\t\r\u0016!A8\u0011\t\t\u0015&qV\u0007\u0003\u0005OSAA!+\u0003,\u0006\u0019q.\u00194\u000b\u0007\t5f,\u0001\u0004tG\",W.Y\u0005\u0005\u0005c\u00139KA\u0002PC\u001a\f1\u0003^3tiB+(-\\3e'Bd\u0017\u000e\u001e;j]\u001e\fA\u0003^3tiB+(-\\3e\u001fJLw-\u001b8bY&#\u0005fA\u0018\u0002.\u0006\tB/Z:u!V\u0014W.\u001a3NCB\u0004\u0018N\\4)\u0007A\ni+\u0001\u0007uKN$\b\u000b\u0012\"U_>\u000be\tK\u00022\u0003[\u000b\u0001\u0003^3tiVs\u0015\n\u001d:piR{w*\u0011$)\u0007I\niK\u0001\u0005F\u0005&c\u0015N\\6t'\u001d\u0019\u0014QFAc\u0003\u0017\fqA]3m)f\u0004X-\u0001\u0005sK2$\u0016\u0010]3!\u0003\u0011!\u0017\r^3\u0002\u000b\u0011\fG/\u001a\u0011\u0002\u000bQLG\u000f\\3\u0002\rQLG\u000f\\3!\u0003\u0011\u0001X.\u001b3\u0002\u000bAl\u0017\u000e\u001a\u0011\u0002\u0013Q\f'oZ3u!&$\u0017A\u0003;be\u001e,G\u000fU5eA\u0005iA/\u0019:hKR\u0004\u0016\u000e\u001a+za\u0016\fa\u0002^1sO\u0016$\b+\u001b3UsB,\u0007\u0005\u0006\b\u0003d\n\u0015(q\u001dBu\u0005W\u0014iOa<\u0011\u0007\u0005E4\u0007C\u0004\u0003J\u0002\u0003\r!a\u0013\t\u000f\t5\u0007\t1\u0001\u0002L!9!\u0011\u001b!A\u0002\u0005-\u0003b\u0002Bk\u0001\u0002\u0007\u00111\n\u0005\b\u00053\u0004\u0005\u0019AA&\u0011\u001d\u0011i\u000e\u0011a\u0001\u0003\u0017\"bBa9\u0003t\nU(q\u001fB}\u0005w\u0014i\u0010C\u0005\u0003J\u0006\u0003\n\u00111\u0001\u0002L!I!QZ!\u0011\u0002\u0003\u0007\u00111\n\u0005\n\u0005#\f\u0005\u0013!a\u0001\u0003\u0017B\u0011B!6B!\u0003\u0005\r!a\u0013\t\u0013\te\u0017\t%AA\u0002\u0005-\u0003\"\u0003Bo\u0003B\u0005\t\u0019AA&\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%mQ!!qCB\u0005\u0011%\u0011yBSA\u0001\u0002\u0004\u0011i\u0001\u0006\u0003\u0002z\r5\u0001\"\u0003B\u0010\u0019\u0006\u0005\t\u0019\u0001B\f)\u0011\tIh!\u0005\t\u0013\t}q*!AA\u0002\t]\u0011\u0001C#C\u00132Kgn[:\u0011\u0007\u0005E\u0014kE\u0003R\u00073\tY\r\u0005\n\u0003J\rm\u00111JA&\u0003\u0017\nY%a\u0013\u0002L\t\r\u0018\u0002BB\u000f\u0005\u0017\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87)\t\u0019)\u0002\u0006\b\u0003d\u000e\r2QEB\u0014\u0007S\u0019Yc!\f\t\u000f\t%G\u000b1\u0001\u0002L!9!Q\u001a+A\u0002\u0005-\u0003b\u0002Bi)\u0002\u0007\u00111\n\u0005\b\u0005+$\u0006\u0019AA&\u0011\u001d\u0011I\u000e\u0016a\u0001\u0003\u0017BqA!8U\u0001\u0004\tY\u0005\u0006\u0003\u00042\re\u0002CBA\u0003\u0005C\u001a\u0019\u0004\u0005\t\u0002\u0006\rU\u00121JA&\u0003\u0017\nY%a\u0013\u0002L%!1qGA\u0004\u0005\u0019!V\u000f\u001d7fm!I!QN+\u0002\u0002\u0003\u0007!1]\u0001\u0010a\u0006\u00148/Z0fE&|F.\u001b8lgR!1qHB!!\u0019\t)$!/\u0003d\"911\t,A\u0002\u0005-\u0013!B5oaV$\u0018!\u0005;fgR,%)\u0013'j].\u001cHk\\(B\r\"\u001aq+!,\u0002-A\u0014x\u000e^3di\u0016$GE^8dC\n,H.\u0019:jKN$Ba!\u0014\u0004^A!1qJB-\u001b\t\u0019\tF\u0003\u0003\u0004T\rU\u0013A\u0003<pG\u0006\u0014W\u000f\\1ss*\u00191q\u000b0\u0002\r\r|W.\\8o\u0013\u0011\u0019Yf!\u0015\u0003\u001fY{7-\u00192vY\u0006\u0014\u0018p\u0012:pkBD\u0001Ba\bY\u0003\u0003\u0005\rA\u001c\u0015\b\u0001\r\u00054QNB8!\u0011\u0019\u0019g!\u001b\u000e\u0005\r\u0015$\u0002BB4\u0003+\t\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\r-4Q\r\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,GFAB9G\t\u0019\u0019\b\u0005\u0003\u0004v\r}TBAB<\u0015\u0011\tYb!\u001f\u000b\t\u0005}11\u0010\u0006\u0005\u0007{\n\t#A\u0004n_\u000e\\\u0017\u000e^8\n\t\r\u00055q\u000f\u0002\u0011\u001b>\u001c7.\u001b;p\u000bb$XM\\:j_:\u0004")
public class BioScholixTest
extends AbstractVocabularyTest {
    private volatile BioScholixTest$GzFileIterator$ GzFileIterator$module;
    private volatile BioScholixTest$AuthorPID$ AuthorPID$module;
    private volatile BioScholixTest$EBILinks$ EBILinks$module;
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public BioScholixTest$GzFileIterator$ GzFileIterator() {
        if (this.GzFileIterator$module == null) {
            this.GzFileIterator$lzycompute$1();
        }
        return this.GzFileIterator$module;
    }

    public BioScholixTest$AuthorPID$ AuthorPID() {
        if (this.AuthorPID$module == null) {
            this.AuthorPID$lzycompute$1();
        }
        return this.AuthorPID$module;
    }

    public BioScholixTest$EBILinks$ EBILinks() {
        if (this.EBILinks$module == null) {
            this.EBILinks$lzycompute$1();
        }
        return this.EBILinks$module;
    }

    public /* synthetic */ VocabularyGroup protected$vocabularies(BioScholixTest x$1) {
        return x$1.vocabularies;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    @BeforeEach
    public void setUp() {
        super.setUpVocabulary();
    }

    @Test
    public void testPid() {
        List pids = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000163025705", "000000018494732X", "0000000308873343", "0000000335964515", "0000000333457333", "0000000335964515", "0000000302921949", "http://orcid.org/0000-0001-8567-3543", "http://orcid.org/0000-0001-7868-8528", "0000-0001-9189-1440", "0000-0003-3727-9247", "0000-0001-7246-1058", "000000033962389X", "0000000330371470", "0000000171236123", "0000000272569752", "0000000293231371", "http://orcid.org/0000-0003-3345-7333", "0000000340145688", "http://orcid.org/0000-0003-4894-1689"}));
        pids.foreach((Function1 & Serializable & scala.Serializable)pid -> {
            BioScholixTest.$anonfun$testPid$1(pid);
            return BoxedUnit.UNIT;
        });
    }

    public List<String> extractAffiliation(String s) {
        String regex = "<Affiliation>(.*)<\\/Affiliation>";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(s);
        ListBuffer l = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (matcher.find()) {
            l.$plus$eq((Object)matcher.group(1));
        }
        return l.toList();
    }

    public List<AuthorPID> extractAuthorIdentifier(String s) {
        String regex = "<Identifier Source=\"(.*)\">(.*)<\\/Identifier>";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(s);
        ListBuffer l = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (matcher.find()) {
            l.$plus$eq((Object)new AuthorPID(this, matcher.group(1), matcher.group(2)));
        }
        return l.toList();
    }

    @Test
    public void testParsingPubmed2() {
        ObjectMapper mapper = new ObjectMapper();
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/single_pubmed.xml"));
        PMParser2 parser = new PMParser2();
        PMArticle article = parser.parse(xml);
        Predef$.MODULE$.println((Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)PubMedToOaf$.MODULE$.convert(article, this.vocabularies)));
    }

    @Test
    public void testEBIData() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        new PMParser(xml).foreach((Function1 & Serializable & scala.Serializable)s -> {
            Predef$.MODULE$.println((Object)this.mapper().writeValueAsString((Object)s));
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPubmedToOaf() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        List r = (List)((List)new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).toList().map((Function1 & Serializable & scala.Serializable)s -> (PMArticle)this.mapper().readValue(s, PMArticle.class), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)a -> PubMedToOaf$.MODULE$.convert(a, this.protected$vocabularies(this)), List$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)10, (int)r.size());
        Assertions.assertTrue((boolean)((LinearSeqOptimized)((List)r.map((Function1 & Serializable & scala.Serializable)p -> (Result)p, List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)p -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> i.getInstancetype().getClassid(), Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$testPubmedToOaf$7(p))));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(r.head()));
    }

    private void checkPMArticle(PMArticle article) {
        Assertions.assertNotNull((Object)article.getPmid());
        Assertions.assertNotNull((Object)article.getTitle());
        Assertions.assertNotNull((Object)article.getAuthors());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(article.getAuthors()).asScala()).foreach((Function1 & Serializable & scala.Serializable)a -> {
            BioScholixTest.$anonfun$checkPMArticle$1(a);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testParsingPubmedXML() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        PMParser parser = new PMParser(xml);
        parser.foreach((Function1 & Serializable & scala.Serializable)article -> {
            this.checkPMArticle(article);
            return BoxedUnit.UNIT;
        });
    }

    private void checkPubmedPublication(Oaf o) {
        Assertions.assertTrue((boolean)(o instanceof Publication));
        Publication p = (Publication)o;
        Assertions.assertNotNull((Object)p.getId());
        Assertions.assertNotNull((Object)p.getTitle());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getTitle()).asScala()).foreach((Function1 & Serializable & scala.Serializable)t -> {
            BioScholixTest.$anonfun$checkPubmedPublication$1(t);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getAuthor()).asScala()).foreach((Function1 & Serializable & scala.Serializable)a -> {
            BioScholixTest.$anonfun$checkPubmedPublication$2(a);
            return BoxedUnit.UNIT;
        });
        Assertions.assertNotNull((Object)p.getInstance());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).foreach((Function1 & Serializable & scala.Serializable)i -> {
            BioScholixTest.$anonfun$checkPubmedPublication$3(i);
            return BoxedUnit.UNIT;
        });
        Assertions.assertNotNull((Object)p.getOriginalId());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getOriginalId()).asScala()).foreach((Function1 & Serializable & scala.Serializable)oId -> {
            BioScholixTest.$anonfun$checkPubmedPublication$4(oId);
            return BoxedUnit.UNIT;
        });
        boolean hasPMC = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).exists((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$checkPubmedPublication$5(i)));
        if (hasPMC) {
            Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getOriginalId()).asScala()).exists((Function1 & Serializable & scala.Serializable)oId -> BoxesRunTime.boxToBoolean((boolean)oId.startsWith("od_______267::"))));
            return;
        }
    }

    public void testPubmedSplitting() {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("test").master("local").getOrCreate();
        new SparkCreatePubmedDump("", (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), LoggerFactory.getLogger(this.getClass())).createPubmedDump(spark, "/home/sandro/Downloads/pubmed", "/home/sandro/Downloads/pubmed_mapped", this.vocabularies);
    }

    @Test
    public void testPubmedOriginalID() {
        PMArticle article = new PMArticle();
        article.setPmid("1234");
        article.setTitle("a Title");
        article.getPublicationTypes().add(new PMSubject("article", null, null));
        Publication publication = (Publication)PubMedToOaf$.MODULE$.convert(article, this.vocabularies);
        Assertions.assertNotNull((Object)publication);
        Assertions.assertEquals((Object)"50|pmid________::81dc9bdb52d04dc20036dbd8313ed055", (Object)publication.getId());
        article.setPmcId("PMC1517292");
        publication = (Publication)PubMedToOaf$.MODULE$.convert(article, this.vocabularies);
        Assertions.assertNotNull((Object)publication);
        Assertions.assertEquals((Object)"50|pmid________::81dc9bdb52d04dc20036dbd8313ed055", (Object)publication.getId());
        String oldOpenaireID = "od_______267::0000072375bc0e68fa09d4e6b7658248";
        boolean hasOldOpenAIREID = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getOriginalId()).asScala()).exists((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)o.equalsIgnoreCase(oldOpenaireID)));
        Assertions.assertTrue((boolean)hasOldOpenAIREID);
    }

    @Test
    public void testPubmedMapping() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        PMParser parser = new PMParser(xml);
        ListBuffer results = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        parser.foreach((Function1 & Serializable & scala.Serializable)x -> results.$plus$eq((Object)PubMedToOaf$.MODULE$.convert(x, this.protected$vocabularies(this))));
        results.foreach((Function1 & Serializable & scala.Serializable)o -> {
            this.checkPubmedPublication(o);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPDBToOAF() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pdb_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            BioScholixTest.$anonfun$testPDBToOAF$2(s);
            return BoxedUnit.UNIT;
        });
        List result = (List)new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).toList().flatMap((Function1 & Serializable & scala.Serializable)o -> BioDBToOAF$.MODULE$.pdbTOOaf(o, this.protected$vocabularies(this)), List$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)result.nonEmpty());
        result.foreach((Function1 & Serializable & scala.Serializable)r -> {
            BioScholixTest.$anonfun$testPDBToOAF$5(r);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)result.count((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$testPDBToOAF$6(o)))));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    @Test
    public void testUNIprotToOAF() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/uniprot_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            BioScholixTest.$anonfun$testUNIprotToOAF$2(s);
            return BoxedUnit.UNIT;
        });
        List result = (List)new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).toList().flatMap((Function1 & Serializable & scala.Serializable)o -> BioDBToOAF$.MODULE$.uniprotToOAF(o, this.protected$vocabularies(this)), List$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)result.nonEmpty());
        result.foreach((Function1 & Serializable & scala.Serializable)r -> {
            BioScholixTest.$anonfun$testUNIprotToOAF$5(r);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)result.count((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$testUNIprotToOAF$6(o)))));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    public List<EBILinks> parse_ebi_links(String input) {
        LazyRef formats$lzy = new LazyRef();
        LazyRef json$lzy = new LazyRef();
        String pmid = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(BioScholixTest.json$1(json$lzy, input)).$bslash("publication")).$bslash("pmid")).extract((Formats)BioScholixTest.formats$1(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
        return package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(BioScholixTest.json$1(json$lzy, input)).$bslash$bslash("Link")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$1(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            JsonAST.JValue jValue = x$9;
            if (jValue instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                List link = jObject.obj();
                return (List)link.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$3(check$ifrefutable$2))).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> {
                    Tuple2 tuple2 = x$8;
                    Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                    if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                        String string = (String)tuple22._1();
                        JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                        if ("Target".equals(string) && jValue instanceof JsonAST.JObject) {
                            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                            List target = jObject.obj();
                            return (List)link.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$5(check$ifrefutable$3))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
                                Tuple2 tuple2 = x$7;
                                Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                    String string = (String)tuple22._1();
                                    JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                    if ("RelationshipType".equals(string) && jValue instanceof JsonAST.JObject) {
                                        JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                                        List relType = jObject.obj();
                                        return (List)relType.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$7(check$ifrefutable$4))).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> {
                                            Tuple2 tuple2 = x$6;
                                            Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                            if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                                String string = (String)tuple22._1();
                                                JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                                if ("Name".equals(string) && jValue instanceof JsonAST.JString) {
                                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                                    String relation = jString.s();
                                                    return (List)link.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$9(check$ifrefutable$5))).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> {
                                                        Tuple2 tuple2 = x$5;
                                                        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                                            String string = (String)tuple22._1();
                                                            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                                            if ("PublicationDate".equals(string) && jValue instanceof JsonAST.JString) {
                                                                JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                String publicationDate = jString.s();
                                                                return (List)target.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$11(check$ifrefutable$6))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
                                                                    Tuple2 tuple2 = x$4;
                                                                    Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                    if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                                                        String string = (String)tuple22._1();
                                                                        JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                                                        if ("Title".equals(string) && jValue instanceof JsonAST.JString) {
                                                                            JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                            String title = jString.s();
                                                                            return (List)target.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$7 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$13(check$ifrefutable$7))).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
                                                                                Tuple2 tuple2 = x$3;
                                                                                Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                                                                    String string = (String)tuple22._1();
                                                                                    JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                                                                    if ("Identifier".equals(string) && jValue instanceof JsonAST.JObject) {
                                                                                        JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                                                                                        List identifier = jObject.obj();
                                                                                        return (List)identifier.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$8 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$15(check$ifrefutable$8))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
                                                                                            Tuple2 tuple2 = x$2;
                                                                                            Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                            if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                                                                                String string = (String)tuple22._1();
                                                                                                JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                                                                                if ("IDScheme".equals(string) && jValue instanceof JsonAST.JString) {
                                                                                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                                                    String idScheme = jString.s();
                                                                                                    return (List)identifier.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$9 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$17(check$ifrefutable$9))).map((Function1 & Serializable & scala.Serializable)x$1 -> {
                                                                                                        Tuple2 tuple2 = x$1;
                                                                                                        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                                        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                                                                                            String string = (String)tuple22._1();
                                                                                                            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                                                                                            if ("ID".equals(string) && jValue instanceof JsonAST.JString) {
                                                                                                                JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                                                                String id = jString.s();
                                                                                                                return new EBILinks(this, relation, publicationDate, title, pmid, id, idScheme);
                                                                                                            }
                                                                                                        }
                                                                                                        throw new MatchError((Object)tuple2);
                                                                                                    }, List$.MODULE$.canBuildFrom());
                                                                                                }
                                                                                            }
                                                                                            throw new MatchError((Object)tuple2);
                                                                                        }, List$.MODULE$.canBuildFrom());
                                                                                    }
                                                                                }
                                                                                throw new MatchError((Object)tuple2);
                                                                            }, List$.MODULE$.canBuildFrom());
                                                                        }
                                                                    }
                                                                    throw new MatchError((Object)tuple2);
                                                                }, List$.MODULE$.canBuildFrom());
                                                            }
                                                        }
                                                        throw new MatchError((Object)tuple2);
                                                    }, List$.MODULE$.canBuildFrom());
                                                }
                                            }
                                            throw new MatchError((Object)tuple2);
                                        }, List$.MODULE$.canBuildFrom());
                                    }
                                }
                                throw new MatchError((Object)tuple2);
                            }, List$.MODULE$.canBuildFrom());
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)jValue);
        });
    }

    @Test
    public void testEBILinksToOAF() {
        BufferedReaderIterator iterator = this.GzFileIterator().apply(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/ebi_links.gz"), "UTF-8");
        String data = iterator.next();
        List res = (List)((List)BioDBToOAF$.MODULE$.parse_ebi_links(BioDBToOAF$.MODULE$.extractEBILinksFromDump(data).links()).filter((Function1 & Serializable & scala.Serializable)input -> BoxesRunTime.boxToBoolean((boolean)BioDBToOAF$.MODULE$.EBITargetLinksFilter(input)))).flatMap((Function1 & Serializable & scala.Serializable)input -> BioDBToOAF$.MODULE$.convertEBILinksToOaf(input), List$.MODULE$.canBuildFrom());
        Predef$.MODULE$.print((Object)BoxesRunTime.boxToInteger((int)res.length()));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(res.head()));
    }

    private final void GzFileIterator$lzycompute$1() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.GzFileIterator$module == null) {
                this.GzFileIterator$module = new BioScholixTest$GzFileIterator$(this);
            }
        }
    }

    private final void AuthorPID$lzycompute$1() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.AuthorPID$module == null) {
                this.AuthorPID$module = new BioScholixTest$AuthorPID$(this);
            }
        }
    }

    private final void EBILinks$lzycompute$1() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.EBILinks$module == null) {
                this.EBILinks$module = new BioScholixTest$EBILinks$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$testPid$1(String pid) {
        String pidCleaned = new PMIdentifier(pid, "ORCID").getPid();
        Predef$.MODULE$.println((Object)pidCleaned);
        Assertions.assertTrue((boolean)pidCleaned.matches("[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{3}[0-9X]"));
    }

    public static final /* synthetic */ boolean $anonfun$testPubmedToOaf$7(String p) {
        return "0037".equalsIgnoreCase(p);
    }

    public static final /* synthetic */ void $anonfun$checkPMArticle$1(PMAuthor a) {
        Assertions.assertNotNull((Object)a);
        Assertions.assertNotNull((Object)a.getFullName());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$1(StructuredProperty t) {
        Assertions.assertNotNull((Object)t.getValue());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$2(Author a) {
        Assertions.assertNotNull((Object)a.getFullname());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$3(Instance i) {
        Assertions.assertNotNull((Object)i.getCollectedfrom());
        Assertions.assertNotNull((Object)i.getPid());
        Assertions.assertNotNull((Object)i.getInstancetype());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$4(String oId) {
        Assertions.assertNotNull((Object)oId);
    }

    public static final /* synthetic */ boolean $anonfun$checkPubmedPublication$6(StructuredProperty pid) {
        return pid.getQualifier().getClassid().equalsIgnoreCase(PidType.pmc.toString());
    }

    public static final /* synthetic */ boolean $anonfun$checkPubmedPublication$5(Instance i) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(i.getPid()).asScala()).exists((Function1 & Serializable & scala.Serializable)pid -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$checkPubmedPublication$6(pid)));
    }

    public static final /* synthetic */ void $anonfun$testPDBToOAF$2(String s) {
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty());
    }

    public static final /* synthetic */ void $anonfun$testPDBToOAF$5(Oaf r) {
        Assertions.assertNotNull((Object)r);
    }

    public static final /* synthetic */ boolean $anonfun$testPDBToOAF$6(Oaf o) {
        return o instanceof Relation;
    }

    public static final /* synthetic */ void $anonfun$testUNIprotToOAF$2(String s) {
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty());
    }

    public static final /* synthetic */ void $anonfun$testUNIprotToOAF$5(Oaf r) {
        Assertions.assertNotNull((Object)r);
    }

    public static final /* synthetic */ boolean $anonfun$testUNIprotToOAF$6(Oaf o) {
        return o instanceof Relation;
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$1(LazyRef formats$lzy$1) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$1;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$1.initialized() ? (DefaultFormats$)formats$lzy$1.value() : (DefaultFormats$)formats$lzy$1.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$1(LazyRef formats$lzy$1) {
        if (formats$lzy$1.initialized()) {
            return (DefaultFormats$)formats$lzy$1.value();
        }
        return BioScholixTest.formats$lzycompute$1(formats$lzy$1);
    }

    private static final /* synthetic */ JsonAST.JValue json$lzycompute$1(LazyRef json$lzy$1, String input$1) {
        JsonAST.JValue jValue;
        LazyRef lazyRef = json$lzy$1;
        synchronized (lazyRef) {
            jValue = json$lzy$1.initialized() ? (JsonAST.JValue)json$lzy$1.value() : (JsonAST.JValue)json$lzy$1.initialize((Object)JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
        }
        return jValue;
    }

    private static final JsonAST.JValue json$1(LazyRef json$lzy$1, String input$1) {
        if (json$lzy$1.initialized()) {
            return (JsonAST.JValue)json$lzy$1.value();
        }
        return BioScholixTest.json$lzycompute$1(json$lzy$1, input$1);
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$1(JsonAST.JValue check$ifrefutable$1) {
        JsonAST.JValue jValue = check$ifrefutable$1;
        return jValue instanceof JsonAST.JObject;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("Target".equals(string) && jValue instanceof JsonAST.JObject) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$5(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("RelationshipType".equals(string) && jValue instanceof JsonAST.JObject) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$7(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("Name".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$9(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("PublicationDate".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$11(Tuple2 check$ifrefutable$6) {
        Tuple2 tuple2 = check$ifrefutable$6;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("Title".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$13(Tuple2 check$ifrefutable$7) {
        Tuple2 tuple2 = check$ifrefutable$7;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("Identifier".equals(string) && jValue instanceof JsonAST.JObject) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$15(Tuple2 check$ifrefutable$8) {
        Tuple2 tuple2 = check$ifrefutable$8;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("IDScheme".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$17(Tuple2 check$ifrefutable$9) {
        Tuple2 tuple2 = check$ifrefutable$9;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("ID".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public BioScholixTest() {
        this.mapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public class AuthorPID
    implements Product,
    scala.Serializable {
        private final String pidType;
        private final String pid;
        public final /* synthetic */ BioScholixTest $outer;

        public String pidType() {
            return this.pidType;
        }

        public String pid() {
            return this.pid;
        }

        public AuthorPID copy(String pidType, String pid) {
            return new AuthorPID(this.eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer(), pidType, pid);
        }

        public String copy$default$1() {
            return this.pidType();
        }

        public String copy$default$2() {
            return this.pid();
        }

        public String productPrefix() {
            return "AuthorPID";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.pidType();
                }
                case 1: {
                    return this.pid();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AuthorPID;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AuthorPID)) return false;
            if (((AuthorPID)object).eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer() != this.eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            AuthorPID authorPID = (AuthorPID)x$1;
            String string = this.pidType();
            String string2 = authorPID.pidType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.pid();
            String string4 = authorPID.pid();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!authorPID.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer() {
            return this.$outer;
        }

        public AuthorPID(BioScholixTest $outer, String pidType, String pid) {
            this.pidType = pidType;
            this.pid = pid;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class BufferedReaderIterator
    implements Iterator<String> {
        private final BufferedReader reader;
        public final /* synthetic */ BioScholixTest $outer;

        public Iterator<String> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.isTraversableAgain$((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public Iterator<String> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<String> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<String> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<String> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<String, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.$plus$plus$((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<String, GenTraversableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public Iterator<String> filter(Function1<String, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<String, B, Object> p) {
            return Iterator.corresponds$((Iterator)this, that, p);
        }

        public Iterator<String> withFilter(Function1<String, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public Iterator<String> filterNot(Function1<String, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public Iterator<String> takeWhile(Function1<String, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<String> dropWhile(Function1<String, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<String, B>> zip(Iterator<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<String, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<String, U> f) {
            Iterator.foreach$((Iterator)this, f);
        }

        public boolean forall(Function1<String, Object> p) {
            return Iterator.forall$((Iterator)this, p);
        }

        public boolean exists(Function1<String, Object> p) {
            return Iterator.exists$((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public Option<String> find(Function1<String, Object> p) {
            return Iterator.find$((Iterator)this, p);
        }

        public int indexWhere(Function1<String, Object> p) {
            return Iterator.indexWhere$((Iterator)this, p);
        }

        public int indexWhere(Function1<String, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public BufferedIterator<String> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public int length() {
            return Iterator.length$((Iterator)this);
        }

        public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Traversable<String> toTraversable() {
            return Iterator.toTraversable$((Iterator)this);
        }

        public Iterator<String> toIterator() {
            return Iterator.toIterator$((Iterator)this);
        }

        public Stream<String> toStream() {
            return Iterator.toStream$((Iterator)this);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public List<String> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<String, Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, String, B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<String, B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, String, B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<String, B, B> op) {
            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, String, B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<String, B, B> op) {
            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<String> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Iterable<String> toIterable() {
            return TraversableOnce.toIterable$((TraversableOnce)this);
        }

        public Seq<String> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<String> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<String> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, String, Col> cbf) {
            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
        }

        public <T, U> Map<T, U> toMap(Predef$.less.colon.less<String, Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        public boolean hasNext() {
            return this.reader.ready();
        }

        public String next() {
            return this.reader.readLine();
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$BufferedReaderIterator$$$outer() {
            return this.$outer;
        }

        public BufferedReaderIterator(BioScholixTest $outer, BufferedReader reader) {
            this.reader = reader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Iterator.$init$((Iterator)this);
        }
    }

    public class EBILinks
    implements Product,
    scala.Serializable {
        private final String relType;
        private final String date;
        private final String title;
        private final String pmid;
        private final String targetPid;
        private final String targetPidType;
        public final /* synthetic */ BioScholixTest $outer;

        public String relType() {
            return this.relType;
        }

        public String date() {
            return this.date;
        }

        public String title() {
            return this.title;
        }

        public String pmid() {
            return this.pmid;
        }

        public String targetPid() {
            return this.targetPid;
        }

        public String targetPidType() {
            return this.targetPidType;
        }

        public EBILinks copy(String relType, String date, String title, String pmid, String targetPid, String targetPidType) {
            return new EBILinks(this.eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer(), relType, date, title, pmid, targetPid, targetPidType);
        }

        public String copy$default$1() {
            return this.relType();
        }

        public String copy$default$2() {
            return this.date();
        }

        public String copy$default$3() {
            return this.title();
        }

        public String copy$default$4() {
            return this.pmid();
        }

        public String copy$default$5() {
            return this.targetPid();
        }

        public String copy$default$6() {
            return this.targetPidType();
        }

        public String productPrefix() {
            return "EBILinks";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.relType();
                }
                case 1: {
                    return this.date();
                }
                case 2: {
                    return this.title();
                }
                case 3: {
                    return this.pmid();
                }
                case 4: {
                    return this.targetPid();
                }
                case 5: {
                    return this.targetPidType();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EBILinks;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EBILinks)) return false;
            if (((EBILinks)object).eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer() != this.eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            EBILinks eBILinks = (EBILinks)x$1;
            String string = this.relType();
            String string2 = eBILinks.relType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.date();
            String string4 = eBILinks.date();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.title();
            String string6 = eBILinks.title();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.pmid();
            String string8 = eBILinks.pmid();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.targetPid();
            String string10 = eBILinks.targetPid();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            String string11 = this.targetPidType();
            String string12 = eBILinks.targetPidType();
            if (string11 == null) {
                if (string12 != null) {
                    return false;
                }
            } else if (!string11.equals(string12)) return false;
            if (!eBILinks.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer() {
            return this.$outer;
        }

        public EBILinks(BioScholixTest $outer, String relType, String date, String title, String pmid, String targetPid, String targetPidType) {
            this.relType = relType;
            this.date = date;
            this.title = title;
            this.pmid = pmid;
            this.targetPid = targetPid;
            this.targetPidType = targetPidType;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

