/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.crossref;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.ror.GenerateRorActionSetJob;
import eu.dnetlib.dhp.collection.crossref.Crossref2Oaf$TransformationType$;
import eu.dnetlib.dhp.collection.crossref.UnpayWall;
import eu.dnetlib.dhp.collection.crossref.funderInfo;
import eu.dnetlib.dhp.collection.crossref.mappingAffiliation;
import eu.dnetlib.dhp.collection.crossref.mappingAuthor;
import eu.dnetlib.dhp.collection.crossref.mappingFunder;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.AccessRight;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.InstanceTypeMapping;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OpenAccessRoute;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.DoiCleaningRule;
import eu.dnetlib.dhp.schema.oaf.utils.GraphCleaningFunctions;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.Row;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.SomeValue$;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Queue;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class Crossref2Oaf$
implements Product,
scala.Serializable {
    public static Crossref2Oaf$ MODULE$;
    private final Logger logger;
    private final ObjectMapper mapper;
    private final List<funderInfo> irishFunder;
    private final List<String> invalidName;

    static {
        new Crossref2Oaf$();
    }

    public Logger logger() {
        return this.logger;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public List<funderInfo> irishFunder() {
        return this.irishFunder;
    }

    public List<String> invalidName() {
        return this.invalidName;
    }

    public Option<String> getIrishId(String doi) {
        String id = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doi.split("/"))).last();
        return this.irishFunder().find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$getIrishId$1(id, f))).map((Function1 & Serializable & scala.Serializable)f -> f.id());
    }

    public KeyValue createCrossrefCollectedFrom() {
        KeyValue cf = new KeyValue();
        cf.setValue("Crossref");
        cf.setKey("10|openaire____::081b82f96300b6a6e3d282bad31cb6e2");
        return cf;
    }

    public KeyValue createUnpayWallCollectedFrom() {
        KeyValue cf = new KeyValue();
        cf.setValue("UnpayWall");
        cf.setKey(new StringBuilder(17).append("10|openaire____::").append(DHPUtils.md5((String)"UnpayWall".toLowerCase())).toString());
        return cf;
    }

    public DataInfo generateDataInfo() {
        return this.generateDataInfo("0.91");
    }

    public DataInfo generateDataInfo(String trust) {
        DataInfo di = new DataInfo();
        di.setDeletedbyinference(Predef$.MODULE$.boolean2Boolean(false));
        di.setInferred(Predef$.MODULE$.boolean2Boolean(false));
        di.setInvisible(Predef$.MODULE$.boolean2Boolean(false));
        di.setTrust(trust);
        di.setProvenanceaction(OafMapperUtils.qualifier((String)"sysimport:actionset", (String)"sysimport:actionset", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"));
        return di;
    }

    public AccessRight getOpenAccessQualifier() {
        return OafMapperUtils.accessRight((String)"OPEN", (String)"Open Access", (String)"dnet:access_modes", (String)"dnet:access_modes");
    }

    public AccessRight getRestrictedQualifier() {
        return OafMapperUtils.accessRight((String)"RESTRICTED", (String)"Restricted", (String)"dnet:access_modes", (String)"dnet:access_modes");
    }

    public AccessRight getUnknownQualifier() {
        return OafMapperUtils.accessRight((String)"UNKNOWN", (String)"not available", (String)"dnet:access_modes", (String)"dnet:access_modes");
    }

    public AccessRight getEmbargoedAccessQualifier() {
        return OafMapperUtils.accessRight((String)"EMBARGO", (String)"Embargo", (String)"dnet:access_modes", (String)"dnet:access_modes");
    }

    public AccessRight getClosedAccessQualifier() {
        return OafMapperUtils.accessRight((String)"CLOSED", (String)"Closed Access", (String)"dnet:access_modes", (String)"dnet:access_modes");
    }

    public AccessRight decideAccessRight(Field<String> lic, String date) {
        if (lic == null) {
            return this.getUnknownQualifier();
        }
        String license = (String)lic.getValue();
        if (license.startsWith("cc") || license.startsWith("http://creativecommons.org/licenses") || license.startsWith("https://creativecommons.org/licenses") || license.equals("http://pubs.acs.org/page/policy/authorchoice_ccby_termsofuse.html") || license.equals("http://pubs.acs.org/page/policy/authorchoice_termsofuse.html") || license.equals("http://pubs.acs.org/page/policy/authorchoice_ccbyncnd_termsofuse.html") || license.equals("http://www.apa.org/pubs/journals/resources/open-access.aspx")) {
            AccessRight oaq = this.getOpenAccessQualifier();
            oaq.setOpenAccessRoute(OpenAccessRoute.hybrid);
            return oaq;
        }
        if (license.equals("https://academic.oup.com/journals/pages/open_access/funder_policies/chorus/standard_publication_model")) {
            LocalDate now = LocalDate.now();
            try {
                LocalDate pub_date = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                if ((double)(now.toEpochDay() - pub_date.toEpochDay()) / 365.0 > 1.0) {
                    AccessRight oaq = this.getOpenAccessQualifier();
                    oaq.setOpenAccessRoute(OpenAccessRoute.hybrid);
                    return oaq;
                }
                return this.getEmbargoedAccessQualifier();
            }
            catch (Exception e) {
                try {
                    LocalDate pub_date = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"));
                    if ((double)(now.toEpochDay() - pub_date.toEpochDay()) / 365.0 > 1.0) {
                        AccessRight oaq = this.getOpenAccessQualifier();
                        oaq.setOpenAccessRoute(OpenAccessRoute.hybrid);
                        return oaq;
                    }
                    return this.getEmbargoedAccessQualifier();
                }
                catch (Exception ex) {
                    return this.getClosedAccessQualifier();
                }
            }
        }
        return this.getClosedAccessQualifier();
    }

    public boolean isValidAuthorName(String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return false;
        }
        return !this.invalidName().contains((Object)fullName.toLowerCase().trim());
    }

    public boolean filterResult(Result publication) {
        String publisher;
        if (publication == null) {
            return false;
        }
        if (publication.getId() == null || publication.getId().isEmpty()) {
            return false;
        }
        if (publication.getTitle() == null || publication.getTitle().size() == 0) {
            return false;
        }
        int s2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getTitle()).asScala()).count((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$filterResult$1(p)));
        if (s2 == 0) {
            return false;
        }
        String string = publisher = publication.getPublisher() != null ? (String)publication.getPublisher().getValue() : null;
        if (publisher != null && (publisher.equalsIgnoreCase("Test accounts") || publisher.equalsIgnoreCase("CrossRef Test Account"))) {
            return false;
        }
        if (publication.getAuthor() == null || publication.getAuthor().size() == 0) {
            return true;
        }
        Buffer authors = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getAuthor()).asScala()).map((Function1 & Serializable & scala.Serializable)s -> {
            if (new StringOps(Predef$.MODULE$.augmentString(s.getFullname())).nonEmpty()) {
                return s.getFullname();
            }
            return new StringBuilder(1).append(s.getName()).append(" ").append(s.getSurname()).toString();
        }, Buffer$.MODULE$.canBuildFrom());
        int c = authors.count((Function1 & Serializable & scala.Serializable)fullName -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.MODULE$.isValidAuthorName(fullName)));
        if (c == 0) {
            return false;
        }
        return authors.count((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)s.equalsIgnoreCase("Addie Jackson"))) <= 0 || !"Elsevier BV".equalsIgnoreCase((String)publication.getPublisher().getValue());
    }

    public Option<OpenAccessRoute> get_unpaywall_color(String input) {
        if (input == null || input.equalsIgnoreCase("close")) {
            return None$.MODULE$;
        }
        if (input.equalsIgnoreCase("green")) {
            return new Some((Object)OpenAccessRoute.green);
        }
        if (input.equalsIgnoreCase("bronze")) {
            return new Some((Object)OpenAccessRoute.bronze);
        }
        if (input.equalsIgnoreCase("hybrid")) {
            return new Some((Object)OpenAccessRoute.hybrid);
        }
        return new Some((Object)OpenAccessRoute.gold);
    }

    public Option<OpenAccessRoute> get_color(String input) {
        if (input == null || input.equalsIgnoreCase("closed")) {
            return None$.MODULE$;
        }
        if (input.equalsIgnoreCase("green")) {
            return new Some((Object)OpenAccessRoute.green);
        }
        if (input.equalsIgnoreCase("bronze")) {
            return new Some((Object)OpenAccessRoute.bronze);
        }
        if (input.equalsIgnoreCase("hybrid")) {
            return new Some((Object)OpenAccessRoute.hybrid);
        }
        return new Some((Object)OpenAccessRoute.gold);
    }

    public Result mappingResult(Result result, JsonAST.JValue json, Qualifier instanceType, String originalType) {
        JsonAST.JValue has_review;
        LazyRef formats$lzy = new LazyRef();
        String doi = DoiCleaningRule.clean((String)((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash("DOI")).extract((Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(String.class))));
        result.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)OafMapperUtils.structuredProperty((String)doi, (Qualifier)OafMapperUtils.qualifier((String)PidType.doi.toString(), (String)PidType.doi.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null), (List)Nil$.MODULE$)).asJava());
        List clinicalTrialNumbers = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("clinical-trial-number")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            JsonAST.JValue jValue = x$1;
            if (jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String ctr = jString.s();
                return ctr;
            }
            throw new MatchError((Object)jValue);
        });
        List alternativeIds = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("alternative-id")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$3(check$ifrefutable$2))).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            JsonAST.JValue jValue = x$2;
            if (jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String ids = jString.s();
                return ids;
            }
            throw new MatchError((Object)jValue);
        });
        List list = clinicalTrialNumbers;
        List list2 = alternativeIds;
        List tmp = new .colon.colon((Object)doi, (List)Nil$.MODULE$).$colon$colon$colon(list2).$colon$colon$colon(list);
        ArrayList originalIds = new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)tmp.filter((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$5(id)))).asJava());
        result.setOriginalId(originalIds);
        result.setDataInfo(this.generateDataInfo());
        result.setLastupdatetimestamp(Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("indexed")).$bslash("timestamp")).extract((Formats)Crossref2Oaf$.formats$2(formats$lzy), (Manifest)ManifestFactory$.MODULE$.Long()))));
        result.setDateofcollection((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("indexed")).$bslash("date-time")).extract((Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(String.class)));
        result.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.createCrossrefCollectedFrom(), (List)Nil$.MODULE$)).asJava());
        String publisher = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash("publisher")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
        if (publisher != null && new StringOps(Predef$.MODULE$.augmentString(publisher)).nonEmpty()) {
            result.setPublisher(OafMapperUtils.field((Object)publisher, null));
        }
        List mainTitles = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("title")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$7(check$ifrefutable$3))).withFilter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$8(x$5))).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            JsonAST.JValue jValue = x$6;
            if (jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String title = jString.s();
                return OafMapperUtils.structuredProperty((String)title, (Qualifier)ModelConstants.MAIN_TITLE_QUALIFIER, null);
            }
            throw new MatchError((Object)jValue);
        });
        List originalTitles = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("original-title")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$10(check$ifrefutable$4))).withFilter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$11(x$7))).map((Function1 & Serializable & scala.Serializable)x$8 -> {
            JsonAST.JValue jValue = x$8;
            if (jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String title = jString.s();
                return OafMapperUtils.structuredProperty((String)title, (Qualifier)ModelConstants.ALTERNATIVE_TITLE_QUALIFIER, null);
            }
            throw new MatchError((Object)jValue);
        });
        List shortTitles = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("short-title")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$13(check$ifrefutable$5))).withFilter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$14(x$9))).map((Function1 & Serializable & scala.Serializable)x$10 -> {
            JsonAST.JValue jValue = x$10;
            if (jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String title = jString.s();
                return OafMapperUtils.structuredProperty((String)title, (Qualifier)ModelConstants.ALTERNATIVE_TITLE_QUALIFIER, null);
            }
            throw new MatchError((Object)jValue);
        });
        List subtitles = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("subtitle")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$16(check$ifrefutable$6))).withFilter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$17(x$11))).map((Function1 & Serializable & scala.Serializable)x$12 -> {
            JsonAST.JValue jValue = x$12;
            if (jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String title = jString.s();
                return OafMapperUtils.structuredProperty((String)title, (Qualifier)ModelConstants.SUBTITLE_QUALIFIER, null);
            }
            throw new MatchError((Object)jValue);
        });
        List list3 = mainTitles;
        List list4 = originalTitles;
        List list5 = shortTitles;
        result.setTitle((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)subtitles.$colon$colon$colon(list5).$colon$colon$colon(list4).$colon$colon$colon(list3)).asJava());
        List descriptionList = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("abstract")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$7 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$19(check$ifrefutable$7))).map((Function1 & Serializable & scala.Serializable)x$16 -> {
            JsonAST.JValue jValue = x$16;
            if (jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String description = jString.s();
                return OafMapperUtils.field((Object)description, null);
            }
            throw new MatchError((Object)jValue);
        });
        result.setDescription((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)descriptionList).asJava());
        List sourceList = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("source")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$8 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$21(check$ifrefutable$8))).withFilter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$22(x$17))).map((Function1 & Serializable & scala.Serializable)x$18 -> {
            JsonAST.JValue jValue = x$18;
            if (jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String source = jString.s();
                return OafMapperUtils.field((Object)source, null);
            }
            throw new MatchError((Object)jValue);
        });
        result.setSource((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)sourceList).asJava());
        StructuredProperty createdDate = this.generateDate((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("created")).$bslash("date-time")).extract((Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(String.class)), (List<List<Object>>)((List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("created")).$bslash("date-parts")).extract((Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))), "created", "dnet:dataCite_date");
        StructuredProperty postedDate = this.generateDate((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("posted")).$bslash("date-time")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(String.class)), (List<List<Object>>)((List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("posted")).$bslash("date-parts")).extract((Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))), "available", "dnet:dataCite_date");
        StructuredProperty acceptedDate = this.generateDate((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("accepted")).$bslash("date-time")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(String.class)), (List<List<Object>>)((List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("accepted")).$bslash("date-parts")).extract((Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))), "accepted", "dnet:dataCite_date");
        StructuredProperty publishedPrintDate = this.generateDate((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("published-print")).$bslash("date-time")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(String.class)), (List<List<Object>>)((List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("published-print")).$bslash("date-parts")).extract((Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))), "published-print", "dnet:dataCite_date");
        StructuredProperty publishedOnlineDate = this.generateDate((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("published-online")).$bslash("date-time")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(String.class)), (List<List<Object>>)((List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("published-online")).$bslash("date-parts")).extract((Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))), "published-online", "dnet:dataCite_date");
        String issuedDate = this.extractDate((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("issued")).$bslash("date-time")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(String.class)), (List<List<Object>>)((List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("issued")).$bslash("date-parts")).extract((Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))));
        if (StringUtils.isNotBlank((CharSequence)issuedDate)) {
            result.setDateofacceptance(OafMapperUtils.field((Object)issuedDate, null));
        } else {
            result.setDateofacceptance(OafMapperUtils.field((Object)createdDate.getValue(), null));
        }
        result.setRelevantdate((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)createdDate, (List)new .colon.colon((Object)postedDate, (List)new .colon.colon((Object)acceptedDate, (List)new .colon.colon((Object)publishedOnlineDate, (List)new .colon.colon((Object)publishedPrintDate, (List)Nil$.MODULE$))))).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$29(p)))).asJava());
        List subjectList = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash("subject")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$, (Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        if (subjectList.nonEmpty()) {
            result.setSubject((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)subjectList.map((Function1 & Serializable & scala.Serializable)s -> OafMapperUtils.subject((String)s, (Qualifier)ModelConstants.SUBTITLE_QUALIFIER, null), List$.MODULE$.canBuildFrom())).asJava());
        }
        List authorList = (List)((TraversableLike)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash("author")).extract((Formats)Crossref2Oaf$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(mappingAuthor.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$32(a)));
        List sorted_list = (List)authorList.sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$33(a, b)));
        result.setAuthor((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)sorted_list.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                mappingAuthor a = (mappingAuthor)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return MODULE$.generateAuthor((String)a.given().orNull(Predef$.MODULE$.$conforms()), (String)a.family().get(), (String)a.ORCID().orNull(Predef$.MODULE$.$conforms()), index, a.affiliation());
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom())).asJava());
        Instance instance = new Instance();
        List license = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("license")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$9 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$35(check$ifrefutable$9))).flatMap((Function1 & Serializable & scala.Serializable)x$21 -> {
            JsonAST.JValue jValue = x$21;
            if (jValue instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                List license = jObject.obj();
                return (List)license.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$10 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$37(check$ifrefutable$10))).flatMap((Function1 & Serializable & scala.Serializable)x$20 -> {
                    Tuple2 tuple2 = x$20;
                    Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                    if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                        String string = (String)tuple22._1();
                        JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                        if ("URL".equals(string) && jValue instanceof JsonAST.JString) {
                            JsonAST.JString jString = (JsonAST.JString)jValue;
                            String lic = jString.s();
                            return (List)license.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$11 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$39(check$ifrefutable$11))).map((Function1 & Serializable & scala.Serializable)x$19 -> {
                                Tuple2 tuple2 = x$19;
                                Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                    String string = (String)tuple22._1();
                                    JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                    if ("content-version".equals(string) && jValue instanceof JsonAST.JString) {
                                        JsonAST.JString jString = (JsonAST.JString)jValue;
                                        String content_version = jString.s();
                                        return new Tuple2((Object)OafMapperUtils.field((Object)lic, null), (Object)content_version);
                                    }
                                }
                                throw new MatchError((Object)tuple2);
                            }, List$.MODULE$.canBuildFrom());
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)jValue);
        });
        List l = (List)license.filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$41(d)));
        if (l.nonEmpty()) {
            if (l.exists((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingResult$42(d)))) {
                l.foreach((Function1 & Serializable & scala.Serializable)d -> {
                    Crossref2Oaf$.$anonfun$mappingResult$43(instance, d);
                    return BoxedUnit.UNIT;
                });
            } else {
                instance.setLicense((Field)((Tuple2)l.head())._1());
            }
        }
        instance.setPid(result.getPid());
        JsonAST.JValue jValue = has_review = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("relation")).$bslash("has-review")).$bslash("id");
        JsonAST.JNothing$ jNothing$ = JsonAST.JNothing$.MODULE$;
        if (jValue == null ? jNothing$ != null : !jValue.equals(jNothing$)) {
            instance.setRefereed(OafMapperUtils.qualifier((String)"0001", (String)"peerReviewed", (String)"dnet:review_levels", (String)"dnet:review_levels"));
        }
        if (doi.startsWith("10.3410") || doi.startsWith("10.12703")) {
            instance.setHostedby(OafMapperUtils.keyValue((String)OafMapperUtils.createOpenaireId((int)10, (String)"openaire____::H1Connect", (boolean)true), (String)"H1Connect"));
        }
        instance.setAccessright(this.decideAccessRight((Field<String>)instance.getLicense(), (String)result.getDateofacceptance().getValue()));
        instance.setInstancetype(instanceType);
        InstanceTypeMapping itm = new InstanceTypeMapping();
        itm.setOriginalType(originalType);
        itm.setVocabularyName("openaire::coar_resource_types_3_1");
        instance.setInstanceTypeMapping((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)itm, (List)Nil$.MODULE$)).asJava());
        instance.setCollectedfrom(this.createCrossrefCollectedFrom());
        if (StringUtils.isNotBlank((CharSequence)issuedDate)) {
            instance.setDateofacceptance(OafMapperUtils.field((Object)issuedDate, null));
        } else {
            instance.setDateofacceptance(OafMapperUtils.field((Object)createdDate.getValue(), null));
        }
        .colon.colon s2 = new .colon.colon((Object)new StringBuilder(16).append("https://doi.org/").append(doi).toString(), (List)Nil$.MODULE$);
        if (s2.nonEmpty()) {
            instance.setUrl((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)s2).asJava());
        }
        result.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)instance, (List)Nil$.MODULE$)).asJava());
        String oldId = this.generateIdentifier(result, doi);
        result.setId(oldId);
        String newId = IdentifierFactory.createDOIBoostIdentifier((Result)result);
        Object object = !oldId.equalsIgnoreCase(newId) ? BoxesRunTime.boxToBoolean((boolean)result.getOriginalId().add(oldId)) : BoxedUnit.UNIT;
        result.setId(newId);
        if (result.getId() == null) {
            return null;
        }
        return result;
    }

    public String generateIdentifier(Result oaf, String doi) {
        String id = DHPUtils.md5((String)doi.toLowerCase());
        return new StringBuilder(16).append("50|doiboost____|").append(id).toString();
    }

    private Author generateAuthor(String given, String family, String orcid, int index, Option<List<mappingAffiliation>> affiliation) {
        Author a2;
        block1: {
            a2 = new Author();
            a2.setName(given);
            a2.setSurname(family);
            a2.setFullname(new StringBuilder(1).append(given).append(" ").append(family).toString());
            a2.setRank(Predef$.MODULE$.int2Integer(index + 1));
            if (affiliation.isDefined()) {
                a2.setRawAffiliationString((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)affiliation.get()).map((Function1 & Serializable & scala.Serializable)a -> a.name(), List$.MODULE$.canBuildFrom())).asJava());
            }
            if (!StringUtils.isNotBlank((CharSequence)orcid)) break block1;
            a2.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)OafMapperUtils.structuredProperty((String)orcid, (Qualifier)OafMapperUtils.qualifier((String)"orcid_pending", (String)"orcid_pending", (String)"dnet:pid_types", (String)"dnet:pid_types"), (DataInfo)this.generateDataInfo()), (List)Nil$.MODULE$)).asJava());
        }
        return a2;
    }

    public Tuple3<Qualifier, Qualifier, String> getTypeQualifier(String resourceType, VocabularyGroup vocabularies) {
        Qualifier typeQualifier;
        if (resourceType != null && new StringOps(Predef$.MODULE$.augmentString(resourceType)).nonEmpty() && (typeQualifier = vocabularies.getSynonymAsQualifier("dnet:publication_resource", resourceType)) != null) {
            return new Tuple3((Object)typeQualifier, (Object)vocabularies.getSynonymAsQualifier("dnet:result_typologies", typeQualifier.getClassid()), (Object)resourceType);
        }
        return null;
    }

    public Result mergeUnpayWall(Result r, UnpayWall uw) {
        block3: {
            if (uw == null) break block3;
            r.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)((KeyValue)r.getCollectedfrom().get(0)), (List)new .colon.colon((Object)this.createUnpayWallCollectedFrom(), (List)Nil$.MODULE$))).asJava());
            Instance i = new Instance();
            i.setCollectedfrom(this.createUnpayWallCollectedFrom());
            if (uw.best_oa_location() != null) {
                Option<OpenAccessRoute> colour;
                i.setUrl((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)uw.best_oa_location().url(), (List)Nil$.MODULE$)).asJava());
                if (uw.best_oa_location().license().isDefined()) {
                    i.setLicense(OafMapperUtils.field((Object)uw.best_oa_location().license().get(), null));
                }
                if ((colour = this.get_unpaywall_color(uw.oa_status())).isDefined()) {
                    AccessRight a = new AccessRight();
                    a.setClassid("OPEN");
                    a.setClassname("OPEN");
                    a.setSchemeid("dnet:access_modes");
                    a.setSchemename("dnet:access_modes");
                    a.setOpenAccessRoute((OpenAccessRoute)colour.get());
                    i.setAccessright(a);
                }
                i.setInstancetype(((Instance)r.getInstance().get(0)).getInstancetype());
                i.setInstanceTypeMapping(((Instance)r.getInstance().get(0)).getInstanceTypeMapping());
                i.setPid(r.getPid());
                r.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)((Instance)r.getInstance().get(0)), (List)new .colon.colon((Object)i, (List)Nil$.MODULE$))).asJava());
            }
        }
        return r;
    }

    public List<String> generateAffliation(Row input) {
        String doi = input.getString(0);
        String rorId = input.getString(1);
        String pubId = IdentifierFactory.idFromPid((String)"50", (String)"doi", (String)DoiCleaningRule.clean((String)doi), (boolean)true);
        String affId = GenerateRorActionSetJob.calculateOpenaireId(rorId);
        Relation r = new Relation();
        r.setSource(pubId);
        r.setTarget(affId);
        r.setRelType("resultOrganization");
        r.setRelClass("hasAuthorInstitution");
        r.setSubRelType("affiliation");
        r.setDataInfo(this.generateDataInfo());
        r.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.createCrossrefCollectedFrom(), (List)Nil$.MODULE$)).asJava());
        Relation r1 = new Relation();
        r1.setTarget(pubId);
        r1.setSource(affId);
        r1.setRelType("resultOrganization");
        r1.setRelClass("isAuthorInstitutionOf");
        r1.setSubRelType("affiliation");
        r1.setDataInfo(this.generateDataInfo());
        r1.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.createCrossrefCollectedFrom(), (List)Nil$.MODULE$)).asJava());
        return new .colon.colon((Object)this.mapper().writeValueAsString((Object)r), (List)new .colon.colon((Object)this.mapper().writeValueAsString((Object)r1), (List)Nil$.MODULE$));
    }

    public List<Oaf> convert(String input, VocabularyGroup vocabularies, Enumeration.Value mode) {
        Nil$ resultList;
        block21: {
            Result result;
            block20: {
                block19: {
                    List doisReference;
                    List funderList;
                    LazyRef json$lzy;
                    LazyRef formats$lzy;
                    block18: {
                        Tuple3<Qualifier, Qualifier, String> typology;
                        formats$lzy = new LazyRef();
                        json$lzy = new LazyRef();
                        resultList = Nil$.MODULE$;
                        String objectType = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(Crossref2Oaf$.json$2(json$lzy, input)).$bslash("type")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)Crossref2Oaf$.formats$3(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
                        if (objectType == null) {
                            return resultList;
                        }
                        JsonAST.JValue is_review = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(Crossref2Oaf$.json$2(json$lzy, input)).$bslash("relation")).$bslash("is-review-of")).$bslash("id");
                        boolean force_to_review = false;
                        JsonAST.JValue jValue = is_review;
                        JsonAST.JNothing$ jNothing$ = JsonAST.JNothing$.MODULE$;
                        if (jValue == null ? jNothing$ != null : !jValue.equals(jNothing$)) {
                            force_to_review = true;
                        }
                        if ((typology = this.getTypeQualifier(force_to_review ? "peer-review" : objectType, vocabularies)) == null) {
                            return Nil$.MODULE$;
                        }
                        result = this.generateItemFromType((Qualifier)typology._2());
                        if (result == null) {
                            return Nil$.MODULE$;
                        }
                        this.mappingResult(result, Crossref2Oaf$.json$2(json$lzy, input), (Qualifier)typology._1(), (String)typology._3());
                        if (result == null || result.getId() == null) {
                            return Nil$.MODULE$;
                        }
                        Result result2 = result;
                        if (result2 instanceof Publication) {
                            Publication publication = (Publication)result2;
                            this.convertPublication(publication, Crossref2Oaf$.json$2(json$lzy, input), (Qualifier)typology._1());
                        } else if (result2 instanceof Dataset) {
                            Dataset dataset = (Dataset)result2;
                            this.convertDataset(dataset);
                        } else {
                            throw new MatchError((Object)result2);
                        }
                        Enumeration.Value value = mode;
                        Enumeration.Value value2 = Crossref2Oaf$TransformationType$.MODULE$.OnlyRelation();
                        if (!(value == null ? value2 != null : !value.equals(value2))) break block18;
                        Enumeration.Value value3 = mode;
                        Enumeration.Value value4 = Crossref2Oaf$TransformationType$.MODULE$.All();
                        if (value3 != null ? !value3.equals(value4) : value4 != null) break block19;
                    }
                    if ((funderList = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(Crossref2Oaf$.json$2(json$lzy, input)).$bslash("funder")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$, (Formats)Crossref2Oaf$.formats$3(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(mappingFunder.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).nonEmpty()) {
                        Nil$ nil$ = resultList;
                        resultList = this.mappingFunderToRelations((List<mappingFunder>)funderList, result.getId(), this.createCrossrefCollectedFrom(), result.getDataInfo(), Predef$.MODULE$.Long2long(result.getLastupdatetimestamp())).$colon$colon$colon((List)nil$);
                    }
                    if ((doisReference = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(Crossref2Oaf$.json$2(json$lzy, input)).$bslash("reference")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$12 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$convert$3(check$ifrefutable$12))).flatMap((Function1 & Serializable & scala.Serializable)x$24 -> {
                        JsonAST.JValue jValue = x$24;
                        if (jValue instanceof JsonAST.JObject) {
                            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                            List reference_json = jObject.obj();
                            return (List)reference_json.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$13 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$convert$5(check$ifrefutable$13))).map((Function1 & Serializable & scala.Serializable)x$23 -> {
                                Tuple2 tuple2 = x$23;
                                Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                    String string = (String)tuple22._1();
                                    JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                    if ("DOI".equals(string) && jValue instanceof JsonAST.JString) {
                                        JsonAST.JString jString = (JsonAST.JString)jValue;
                                        String doi_json = jString.s();
                                        return doi_json;
                                    }
                                }
                                throw new MatchError((Object)tuple2);
                            }, List$.MODULE$.canBuildFrom());
                        }
                        throw new MatchError((Object)jValue);
                    })) != null && doisReference.nonEmpty()) {
                        List<Relation> citation_relations = this.generateCitationRelations((List<String>)doisReference, result);
                        Nil$ nil$ = resultList;
                        resultList = citation_relations.$colon$colon$colon((List)nil$);
                    }
                }
                if (!this.filterResult(result)) {
                    return Nil$.MODULE$;
                }
                Enumeration.Value value = mode;
                Enumeration.Value value5 = Crossref2Oaf$TransformationType$.MODULE$.OnlyResult();
                if (!(value == null ? value5 != null : !value.equals(value5))) break block20;
                Enumeration.Value value6 = mode;
                Enumeration.Value value7 = Crossref2Oaf$TransformationType$.MODULE$.All();
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block21;
            }
            Nil$ nil$ = resultList;
            return new .colon.colon((Object)result, (List)Nil$.MODULE$).$colon$colon$colon((List)nil$);
        }
        return resultList;
    }

    private List<Relation> createCiteRelation(Result source, String targetPid, String targetPidType) {
        String targetId = IdentifierFactory.idFromPid((String)"50", (String)targetPidType, (String)targetPid, (boolean)true);
        Relation from = new Relation();
        from.setSource(source.getId());
        from.setTarget(targetId);
        from.setRelType("resultResult");
        from.setRelClass("Cites");
        from.setSubRelType("citation");
        from.setCollectedfrom(source.getCollectedfrom());
        from.setDataInfo(source.getDataInfo());
        from.setLastupdatetimestamp(source.getLastupdatetimestamp());
        return new .colon.colon((Object)from, (List)Nil$.MODULE$);
    }

    public List<Relation> generateCitationRelations(List<String> dois, Result result) {
        return (List)dois.flatMap((Function1 & Serializable & scala.Serializable)d -> MODULE$.createCiteRelation(result, (String)d, "doi"), List$.MODULE$.canBuildFrom());
    }

    public List<Relation> mappingFunderToRelations(List<mappingFunder> funders, String sourceId, KeyValue cf, DataInfo di, long ts) {
        Queue queue;
        block0: {
            queue = new Queue();
            if (funders == null) break block0;
            funders.foreach((Function1 & Serializable & scala.Serializable)funder -> {
                if (funder.DOI().isDefined() && new StringOps(Predef$.MODULE$.augmentString((String)funder.DOI().get())).nonEmpty()) {
                    BoxedUnit boxedUnit;
                    if (MODULE$.getIrishId((String)funder.DOI().get()).isDefined()) {
                        String nsPrefix = (String)new StringOps(Predef$.MODULE$.augmentString((String)MODULE$.getIrishId((String)funder.DOI().get()).get())).padTo(12, (Object)BoxesRunTime.boxToCharacter((char)'_'), Predef$.MODULE$.StringCanBuildFrom());
                        String targetId = Crossref2Oaf$.getProjectId$1(nsPrefix, "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        boxedUnit = queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    String string = (String)funder.DOI().get();
                    if ("10.13039/100010663".equals(string) ? true : ("10.13039/100010661".equals(string) ? true : ("10.13039/501100007601".equals(string) ? true : ("10.13039/501100000780".equals(string) ? true : "10.13039/100010665".equals(string))))) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "corda__h2020", (Function1 & Serializable & scala.Serializable)award -> Crossref2Oaf$.extractECAward$1(award), queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/100011199".equals(string) ? true : ("10.13039/100004431".equals(string) ? true : ("10.13039/501100004963".equals(string) ? true : "10.13039/501100000780".equals(string)))) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "corda_______", (Function1 & Serializable & scala.Serializable)award -> Crossref2Oaf$.extractECAward$1(award), queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100000781".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "corda_______", (Function1 & Serializable & scala.Serializable)award -> Crossref2Oaf$.extractECAward$1(award), queue, sourceId, cf, di, ts);
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "corda__h2020", (Function1 & Serializable & scala.Serializable)award -> Crossref2Oaf$.extractECAward$1(award), queue, sourceId, cf, di, ts);
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "corda_____he", (Function1 & Serializable & scala.Serializable)award -> Crossref2Oaf$.extractECAward$1(award), queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/100000001".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "nsf_________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100001665".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "anr_________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100002341".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "aka_________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100001602".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "sfi_________", (Function1 & Serializable & scala.Serializable)a -> a.replace("SFI", ""), queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100000923".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "arc_________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100000038".equals(string)) {
                        String targetId = Crossref2Oaf$.getProjectId$1("nserc_______", "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    }
                    if ("10.13039/501100000155".equals(string)) {
                        String targetId = Crossref2Oaf$.getProjectId$1("sshrc_______", "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    }
                    if ("10.13039/501100000024".equals(string)) {
                        String targetId = Crossref2Oaf$.getProjectId$1("cihr________", "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    }
                    if ("10.13039/501100001659".equals(string)) {
                        String targetId = Crossref2Oaf$.getProjectId$1("dfgf________", "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    }
                    if ("10.13039/100020031".equals(string)) {
                        String targetId = Crossref2Oaf$.getProjectId$1("tara________", "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    }
                    if ("10.13039/501100005416".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "rcn_________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100002848".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "conicytf____", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100003448".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "gsrt________", (Function1 & Serializable & scala.Serializable)award -> Crossref2Oaf$.extractECAward$1(award), queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100010198".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "sgov________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100004564".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "mestd_______", (Function1 & Serializable & scala.Serializable)award -> Crossref2Oaf$.extractECAward$1(award), queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100003407".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "miur________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        String targetId = Crossref2Oaf$.getProjectId$1("miur________", "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    }
                    if ("10.13039/501100006588".equals(string) ? true : "10.13039/501100004488".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "irb_hr______", (Function1 & Serializable & scala.Serializable)a -> a.replaceAll("Project No.", "").replaceAll("HRZZ-", ""), queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100006769".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "rsf_________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100001711".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "snsf________", (Function1 & Serializable & scala.Serializable)award -> this.snsfRule$1((String)award), queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100004410".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "tubitakf____", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/100004440".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "wt__________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        String targetId = Crossref2Oaf$.getProjectId$1("wt__________", "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    }
                    if ("10.13039/100018231".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "asap________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100001942".equals(string)) {
                        String targetId = Crossref2Oaf$.getProjectId$1("chistera____", "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    }
                    if ("10.13039/100018693".equals(string) ? true : ("10.13039/100018694".equals(string) ? true : ("10.13039/100019188".equals(string) ? true : ("10.13039/100019180".equals(string) ? true : ("10.13039/100018695".equals(string) ? true : ("10.13039/100019185".equals(string) ? true : ("10.13039/100019186".equals(string) ? true : "10.13039/100019187".equals(string)))))))) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "corda_____he", (Function1 & Serializable & scala.Serializable)award -> Crossref2Oaf$.extractECAward$1(award), queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100001871".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "fct_________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100000925".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "nhmrc_______", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/100000002".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "nih_________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100003246".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "nwo_________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/100014013".equals(string) ? true : ("10.13039/501100000267".equals(string) ? true : ("10.13039/501100000268".equals(string) ? true : ("10.13039/501100000269".equals(string) ? true : ("10.13039/501100000266".equals(string) ? true : ("10.13039/501100006041".equals(string) ? true : ("10.13039/501100000265".equals(string) ? true : ("10.13039/501100000270".equals(string) ? true : ("10.13039/501100013589".equals(string) ? true : "10.13039/501100000271".equals(string)))))))))) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "ukri________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100013209".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "hfri________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        String targetId = Crossref2Oaf$.getProjectId$1("hfri________", "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    }
                    if ("10.13039/501100010790".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "erasmusplus_", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        return BoxedUnit.UNIT;
                    }
                    if ("10.13039/501100004836".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "irfd________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        String targetId = Crossref2Oaf$.getProjectId$1("irfd________", "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    }
                    if ("10.13039/501100002808".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "cf__________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        String targetId = Crossref2Oaf$.getProjectId$1("cf__________", "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    }
                    if ("10.13039/501100009708".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "nnf___________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        String targetId = Crossref2Oaf$.getProjectId$1("nnf_________", "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    }
                    if ("10.13039/501100018877".equals(string)) {
                        Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "rif___________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                        String targetId = Crossref2Oaf$.getProjectId$1("rif_________", "1e5e62235d094afd01cd56e65112fc63");
                        queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                        return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                    }
                    MODULE$.logger().debug(new StringBuilder(13).append("no match for ").append(funder.DOI().get()).toString());
                    return BoxedUnit.UNIT;
                }
                String string = funder.name();
                if ("European Union\u2019s Horizon 2020 research and innovation program".equals(string)) {
                    Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "corda__h2020", (Function1 & Serializable & scala.Serializable)award -> Crossref2Oaf$.extractECAward$1(award), queue, sourceId, cf, di, ts);
                    return BoxedUnit.UNIT;
                }
                if ("European Union's".equals(string)) {
                    Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "corda__h2020", (Function1 & Serializable & scala.Serializable)award -> Crossref2Oaf$.extractECAward$1(award), queue, sourceId, cf, di, ts);
                    Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "corda_______", (Function1 & Serializable & scala.Serializable)award -> Crossref2Oaf$.extractECAward$1(award), queue, sourceId, cf, di, ts);
                    Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "corda_____he", (Function1 & Serializable & scala.Serializable)award -> Crossref2Oaf$.extractECAward$1(award), queue, sourceId, cf, di, ts);
                    return BoxedUnit.UNIT;
                }
                if ("The French National Research Agency (ANR)".equals(string) ? true : "The French National Research Agency".equals(string)) {
                    Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "anr_________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                    return BoxedUnit.UNIT;
                }
                if ("CONICYT, Programa de Formaci\u00f3n de Capital Humano Avanzado".equals(string)) {
                    Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "conicytf____", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                    return BoxedUnit.UNIT;
                }
                if ("Wellcome Trust Masters Fellowship".equals(string)) {
                    Crossref2Oaf$.generateSimpleRelationFromAward$1(funder, "wt__________", (Function1 & Serializable & scala.Serializable)a -> a, queue, sourceId, cf, di, ts);
                    String targetId = Crossref2Oaf$.getProjectId$1("wt__________", "1e5e62235d094afd01cd56e65112fc63");
                    queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId, targetId, "isProducedBy", cf, di, ts));
                    return queue.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId, "produces", cf, di, ts));
                }
                MODULE$.logger().debug(new StringBuilder(13).append("no match for ").append(funder.name()).toString());
                return BoxedUnit.UNIT;
            });
        }
        return queue.toList();
    }

    public void convertDataset(Dataset dataset) {
    }

    public void convertPublication(Publication publication, JsonAST.JValue json, Qualifier cobjCategory) {
        LazyRef formats$lzy = new LazyRef();
        List containerTitles = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("container-title")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$14 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$convertPublication$1(check$ifrefutable$14))).map((Function1 & Serializable & scala.Serializable)x$27 -> {
            JsonAST.JValue jValue = x$27;
            if (jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String ct = jString.s();
                return ct;
            }
            throw new MatchError((Object)jValue);
        });
        if (cobjCategory.getClassname().toLowerCase().contains("book")) {
            List ISBN = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("ISBN")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$15 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$convertPublication$3(check$ifrefutable$15))).map((Function1 & Serializable & scala.Serializable)x$28 -> {
                JsonAST.JValue jValue = x$28;
                if (jValue instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String isbn = jString.s();
                    return isbn;
                }
                throw new MatchError((Object)jValue);
            });
            if (ISBN.nonEmpty() && containerTitles.nonEmpty()) {
                String source = new StringBuilder(7).append(containerTitles.head()).append(" ISBN: ").append(ISBN.head()).toString();
                if (publication.getSource() != null) {
                    List l;
                    List list = l = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getSource()).asScala()).toList();
                    List ll = new .colon.colon((Object)OafMapperUtils.field((Object)source, null), (List)Nil$.MODULE$).$colon$colon$colon(list);
                    publication.setSource((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ll).asJava());
                    return;
                }
                publication.setSource((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)OafMapperUtils.field((Object)source, null), (List)Nil$.MODULE$)).asJava());
                return;
            }
            return;
        }
        List issnInfos = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(json).$bslash("issn-type")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$16 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$convertPublication$5(check$ifrefutable$16))).flatMap((Function1 & Serializable & scala.Serializable)x$33 -> {
            JsonAST.JValue jValue = x$33;
            if (jValue instanceof JsonAST.JArray) {
                JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                List issn_types = jArray.arr();
                return (List)issn_types.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$17 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$convertPublication$7(check$ifrefutable$17))).flatMap((Function1 & Serializable & scala.Serializable)x$32 -> {
                    JsonAST.JValue jValue = x$32;
                    if (jValue instanceof JsonAST.JObject) {
                        JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                        List issn_type = jObject.obj();
                        return (List)issn_type.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$18 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$convertPublication$9(check$ifrefutable$18))).flatMap((Function1 & Serializable & scala.Serializable)x$31 -> {
                            Tuple2 tuple2 = x$31;
                            Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                            if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                String string = (String)tuple22._1();
                                JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                if ("type".equals(string) && jValue instanceof JsonAST.JString) {
                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                    String tp = jString.s();
                                    return (List)issn_type.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$19 -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$convertPublication$11(check$ifrefutable$19))).map((Function1 & Serializable & scala.Serializable)x$30 -> {
                                        Tuple2 tuple2 = x$30;
                                        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                            String string = (String)tuple22._1();
                                            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                            if ("value".equals(string) && jValue instanceof JsonAST.JString) {
                                                JsonAST.JString jString = (JsonAST.JString)jValue;
                                                String vl = jString.s();
                                                return new Tuple2((Object)tp, (Object)vl);
                                            }
                                        }
                                        throw new MatchError((Object)tuple2);
                                    }, List$.MODULE$.canBuildFrom());
                                }
                            }
                            throw new MatchError((Object)tuple2);
                        }, List$.MODULE$.canBuildFrom());
                    }
                    throw new MatchError((Object)jValue);
                }, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)jValue);
        });
        String volume = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash("volume")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)Crossref2Oaf$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
        if (containerTitles.nonEmpty()) {
            Journal journal = new Journal();
            journal.setName((String)containerTitles.head());
            if (issnInfos.nonEmpty()) {
                issnInfos.foreach((Function1 & Serializable & scala.Serializable)tp -> {
                    Crossref2Oaf$.$anonfun$convertPublication$14(journal, tp);
                    return BoxedUnit.UNIT;
                });
            }
            journal.setVol(volume);
            String page = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash("page")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)Crossref2Oaf$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
            if (page != null) {
                String[] pp = page.split("-");
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pp)).nonEmpty()) {
                    journal.setSp((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pp)).head());
                }
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pp)).size() > 1) {
                    journal.setEp(pp[1]);
                }
            }
            publication.setJournal(journal);
            return;
        }
    }

    public String extractDate(String dt, List<List<Object>> datePart) {
        if (StringUtils.isNotBlank((CharSequence)dt)) {
            return GraphCleaningFunctions.cleanDate((String)dt);
        }
        if (datePart != null && datePart.size() == 1) {
            List res = (List)datePart.head();
            if (res.size() == 3) {
                Object arg$macro$1 = res.head();
                int arg$macro$2 = BoxesRunTime.unboxToInt((Object)res.apply(1));
                int arg$macro$3 = BoxesRunTime.unboxToInt((Object)res.apply(2));
                String dp = new StringOps("%s-%02d-%02d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToInteger((int)arg$macro$2), BoxesRunTime.boxToInteger((int)arg$macro$3)}));
                if (dp.length() == 10) {
                    return GraphCleaningFunctions.cleanDate((String)dp);
                }
            } else {
                if (res.size() == 2) {
                    Object arg$macro$4 = res.head();
                    int arg$macro$5 = BoxesRunTime.unboxToInt((Object)res.apply(1));
                    String dp = new StringOps("%s-%02d-01").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$4, BoxesRunTime.boxToInteger((int)arg$macro$5)}));
                    return GraphCleaningFunctions.cleanDate((String)dp);
                }
                if (res.size() == 1) {
                    return GraphCleaningFunctions.cleanDate((String)new StringBuilder(6).append(res.head()).append("-01-01").toString());
                }
            }
        }
        return null;
    }

    public StructuredProperty generateDate(String dt, List<List<Object>> datePart, String classId, String schemeId) {
        String dp = this.extractDate(dt, datePart);
        if (StringUtils.isNotBlank((CharSequence)dp)) {
            return OafMapperUtils.structuredProperty((String)dp, (Qualifier)OafMapperUtils.qualifier((String)classId, (String)classId, (String)schemeId, (String)schemeId), null);
        }
        return null;
    }

    public Result generateItemFromType(Qualifier objectType) {
        if (objectType.getClassid().equalsIgnoreCase("publication")) {
            Publication item = new Publication();
            item.setResourcetype(objectType);
            return item;
        }
        if (objectType.getClassid().equalsIgnoreCase("dataset")) {
            Dataset item = new Dataset();
            item.setResourcetype(objectType);
            return item;
        }
        if (objectType.getClassid().equalsIgnoreCase("software")) {
            Software item = new Software();
            item.setResourcetype(objectType);
            return item;
        }
        if (objectType.getClassid().equalsIgnoreCase("OtherResearchProduct")) {
            OtherResearchProduct item = new OtherResearchProduct();
            item.setResourcetype(objectType);
            return item;
        }
        return null;
    }

    public String productPrefix() {
        return "Crossref2Oaf";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Crossref2Oaf$;
    }

    public int hashCode() {
        return -1029170635;
    }

    public String toString() {
        return "Crossref2Oaf";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$1(LazyRef formats$lzy$1) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$1;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$1.initialized() ? (DefaultFormats$)formats$lzy$1.value() : (DefaultFormats$)formats$lzy$1.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$1(LazyRef formats$lzy$1) {
        if (formats$lzy$1.initialized()) {
            return (DefaultFormats$)formats$lzy$1.value();
        }
        return Crossref2Oaf$.formats$lzycompute$1(formats$lzy$1);
    }

    private static final /* synthetic */ JsonAST.JValue json$lzycompute$1(LazyRef json$lzy$1, String s$1) {
        JsonAST.JValue jValue;
        LazyRef lazyRef = json$lzy$1;
        synchronized (lazyRef) {
            jValue = json$lzy$1.initialized() ? (JsonAST.JValue)json$lzy$1.value() : (JsonAST.JValue)json$lzy$1.initialize((Object)JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(s$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
        }
        return jValue;
    }

    private static final JsonAST.JValue json$1(LazyRef json$lzy$1, String s$1) {
        if (json$lzy$1.initialized()) {
            return (JsonAST.JValue)json$lzy$1.value();
        }
        return Crossref2Oaf$.json$lzycompute$1(json$lzy$1, s$1);
    }

    public static final /* synthetic */ boolean $anonfun$getIrishId$1(String id$1, funderInfo f) {
        return id$1.equalsIgnoreCase(f.id()) || f.synonym().nonEmpty() && f.synonym().exists((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)s.equalsIgnoreCase(id$1)));
    }

    public static final /* synthetic */ boolean $anonfun$filterResult$1(StructuredProperty p) {
        return p.getValue() != null && new StringOps(Predef$.MODULE$.augmentString(p.getValue())).nonEmpty() && !p.getValue().equalsIgnoreCase("[NO TITLE AVAILABLE]");
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$2(LazyRef formats$lzy$2) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$2;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$2.initialized() ? (DefaultFormats$)formats$lzy$2.value() : (DefaultFormats$)formats$lzy$2.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$2(LazyRef formats$lzy$2) {
        if (formats$lzy$2.initialized()) {
            return (DefaultFormats$)formats$lzy$2.value();
        }
        return Crossref2Oaf$.formats$lzycompute$2(formats$lzy$2);
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$1(JsonAST.JValue check$ifrefutable$1) {
        JsonAST.JValue jValue = check$ifrefutable$1;
        return jValue instanceof JsonAST.JString;
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$3(JsonAST.JValue check$ifrefutable$2) {
        JsonAST.JValue jValue = check$ifrefutable$2;
        return jValue instanceof JsonAST.JString;
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$5(String id) {
        return id != null;
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$7(JsonAST.JValue check$ifrefutable$3) {
        JsonAST.JValue jValue = check$ifrefutable$3;
        return jValue instanceof JsonAST.JString;
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$8(JsonAST.JValue x$5) {
        JsonAST.JValue jValue = x$5;
        if (jValue instanceof JsonAST.JString) {
            JsonAST.JString jString = (JsonAST.JString)jValue;
            String title = jString.s();
            return new StringOps(Predef$.MODULE$.augmentString(title)).nonEmpty();
        }
        throw new MatchError((Object)jValue);
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$10(JsonAST.JValue check$ifrefutable$4) {
        JsonAST.JValue jValue = check$ifrefutable$4;
        return jValue instanceof JsonAST.JString;
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$11(JsonAST.JValue x$7) {
        JsonAST.JValue jValue = x$7;
        if (jValue instanceof JsonAST.JString) {
            JsonAST.JString jString = (JsonAST.JString)jValue;
            String title = jString.s();
            return new StringOps(Predef$.MODULE$.augmentString(title)).nonEmpty();
        }
        throw new MatchError((Object)jValue);
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$13(JsonAST.JValue check$ifrefutable$5) {
        JsonAST.JValue jValue = check$ifrefutable$5;
        return jValue instanceof JsonAST.JString;
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$14(JsonAST.JValue x$9) {
        JsonAST.JValue jValue = x$9;
        if (jValue instanceof JsonAST.JString) {
            JsonAST.JString jString = (JsonAST.JString)jValue;
            String title = jString.s();
            return new StringOps(Predef$.MODULE$.augmentString(title)).nonEmpty();
        }
        throw new MatchError((Object)jValue);
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$16(JsonAST.JValue check$ifrefutable$6) {
        JsonAST.JValue jValue = check$ifrefutable$6;
        return jValue instanceof JsonAST.JString;
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$17(JsonAST.JValue x$11) {
        JsonAST.JValue jValue = x$11;
        if (jValue instanceof JsonAST.JString) {
            JsonAST.JString jString = (JsonAST.JString)jValue;
            String title = jString.s();
            return new StringOps(Predef$.MODULE$.augmentString(title)).nonEmpty();
        }
        throw new MatchError((Object)jValue);
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$19(JsonAST.JValue check$ifrefutable$7) {
        JsonAST.JValue jValue = check$ifrefutable$7;
        return jValue instanceof JsonAST.JString;
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$21(JsonAST.JValue check$ifrefutable$8) {
        JsonAST.JValue jValue = check$ifrefutable$8;
        return jValue instanceof JsonAST.JString;
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$22(JsonAST.JValue x$17) {
        JsonAST.JValue jValue = x$17;
        if (jValue instanceof JsonAST.JString) {
            JsonAST.JString jString = (JsonAST.JString)jValue;
            String source = jString.s();
            return source != null && new StringOps(Predef$.MODULE$.augmentString(source)).nonEmpty();
        }
        throw new MatchError((Object)jValue);
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$29(StructuredProperty p) {
        return p != null;
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$32(mappingAuthor a) {
        return a.family().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$33(mappingAuthor a, mappingAuthor b) {
        return a.sequence().isDefined() && ((String)a.sequence().get()).equalsIgnoreCase("first");
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$35(JsonAST.JValue check$ifrefutable$9) {
        JsonAST.JValue jValue = check$ifrefutable$9;
        return jValue instanceof JsonAST.JObject;
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$37(Tuple2 check$ifrefutable$10) {
        Tuple2 tuple2 = check$ifrefutable$10;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("URL".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$39(Tuple2 check$ifrefutable$11) {
        Tuple2 tuple2 = check$ifrefutable$11;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("content-version".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$41(Tuple2 d) {
        return StringUtils.isNotBlank((CharSequence)((CharSequence)((Field)d._1()).getValue()));
    }

    public static final /* synthetic */ boolean $anonfun$mappingResult$42(Tuple2 d) {
        return ((String)d._2()).equals("vor");
    }

    public static final /* synthetic */ void $anonfun$mappingResult$43(Instance instance$1, Tuple2 d) {
        if (((String)d._2()).equals("vor")) {
            instance$1.setLicense((Field)d._1());
            return;
        }
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$3(LazyRef formats$lzy$3) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$3;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$3.initialized() ? (DefaultFormats$)formats$lzy$3.value() : (DefaultFormats$)formats$lzy$3.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$3(LazyRef formats$lzy$3) {
        if (formats$lzy$3.initialized()) {
            return (DefaultFormats$)formats$lzy$3.value();
        }
        return Crossref2Oaf$.formats$lzycompute$3(formats$lzy$3);
    }

    private static final /* synthetic */ JsonAST.JValue json$lzycompute$2(LazyRef json$lzy$2, String input$1) {
        JsonAST.JValue jValue;
        LazyRef lazyRef = json$lzy$2;
        synchronized (lazyRef) {
            jValue = json$lzy$2.initialized() ? (JsonAST.JValue)json$lzy$2.value() : (JsonAST.JValue)json$lzy$2.initialize((Object)JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
        }
        return jValue;
    }

    private static final JsonAST.JValue json$2(LazyRef json$lzy$2, String input$1) {
        if (json$lzy$2.initialized()) {
            return (JsonAST.JValue)json$lzy$2.value();
        }
        return Crossref2Oaf$.json$lzycompute$2(json$lzy$2, input$1);
    }

    public static final /* synthetic */ boolean $anonfun$convert$3(JsonAST.JValue check$ifrefutable$12) {
        JsonAST.JValue jValue = check$ifrefutable$12;
        return jValue instanceof JsonAST.JObject;
    }

    public static final /* synthetic */ boolean $anonfun$convert$5(Tuple2 check$ifrefutable$13) {
        Tuple2 tuple2 = check$ifrefutable$13;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("DOI".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    private final String snsfRule$1(String award) {
        String tmp1 = StringUtils.substringAfter((String)award, (String)"_");
        String tmp2 = StringUtils.substringBefore((String)tmp1, (String)"/");
        this.logger().debug(new StringBuilder(9).append("From ").append(award).append(" to ").append(tmp2).toString());
        return tmp2;
    }

    private static final String extractECAward$1(String award) {
        Regex awardECRegex = new StringOps(Predef$.MODULE$.augmentString("[0-9]{4,9}")).r();
        if (awardECRegex.findAllIn((CharSequence)award).hasNext()) {
            return (String)awardECRegex.findAllIn((CharSequence)award).max((Ordering)Ordering.String$.MODULE$);
        }
        return null;
    }

    private static final Relation generateRelation$1(String sourceId, String targetId, String relClass, KeyValue cf$1, DataInfo di$1, long ts$1) {
        Relation r = new Relation();
        r.setSource(sourceId);
        r.setTarget(targetId);
        r.setRelType("resultProject");
        r.setRelClass(relClass);
        r.setSubRelType("outcome");
        r.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)cf$1, (List)Nil$.MODULE$)).asJava());
        r.setDataInfo(di$1);
        r.setLastupdatetimestamp(Predef$.MODULE$.long2Long(ts$1));
        return r;
    }

    public static final /* synthetic */ boolean $anonfun$mappingFunderToRelations$1(String a) {
        return a != null && new StringOps(Predef$.MODULE$.augmentString(a)).nonEmpty();
    }

    private static final void generateSimpleRelationFromAward$1(mappingFunder funder, String nsPrefix, Function1 extractField, Queue queue$1, String sourceId$1, KeyValue cf$1, DataInfo di$1, long ts$1) {
        if (funder.award().isDefined() && ((TraversableOnce)funder.award().get()).nonEmpty()) {
            ((List)((TraversableLike)((List)funder.award().get()).map(extractField, List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)Crossref2Oaf$.$anonfun$mappingFunderToRelations$1(a)))).foreach((Function1 & Serializable & scala.Serializable)award -> {
                String targetId = Crossref2Oaf$.getProjectId$1(nsPrefix, DHPUtils.md5((String)award));
                queue$1.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(sourceId$1, targetId, "isProducedBy", cf$1, di$1, ts$1));
                return (Queue)queue$1.$plus$eq((Object)Crossref2Oaf$.generateRelation$1(targetId, sourceId$1, "produces", cf$1, di$1, ts$1));
            });
            return;
        }
    }

    private static final String getProjectId$1(String nsPrefix, String targetId) {
        return new StringBuilder(5).append("40|").append(nsPrefix).append("::").append(targetId).toString();
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$4(LazyRef formats$lzy$4) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$4;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$4.initialized() ? (DefaultFormats$)formats$lzy$4.value() : (DefaultFormats$)formats$lzy$4.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$4(LazyRef formats$lzy$4) {
        if (formats$lzy$4.initialized()) {
            return (DefaultFormats$)formats$lzy$4.value();
        }
        return Crossref2Oaf$.formats$lzycompute$4(formats$lzy$4);
    }

    public static final /* synthetic */ boolean $anonfun$convertPublication$1(JsonAST.JValue check$ifrefutable$14) {
        JsonAST.JValue jValue = check$ifrefutable$14;
        return jValue instanceof JsonAST.JString;
    }

    public static final /* synthetic */ boolean $anonfun$convertPublication$3(JsonAST.JValue check$ifrefutable$15) {
        JsonAST.JValue jValue = check$ifrefutable$15;
        return jValue instanceof JsonAST.JString;
    }

    public static final /* synthetic */ boolean $anonfun$convertPublication$5(JsonAST.JValue check$ifrefutable$16) {
        JsonAST.JValue jValue = check$ifrefutable$16;
        return jValue instanceof JsonAST.JArray;
    }

    public static final /* synthetic */ boolean $anonfun$convertPublication$7(JsonAST.JValue check$ifrefutable$17) {
        JsonAST.JValue jValue = check$ifrefutable$17;
        return jValue instanceof JsonAST.JObject;
    }

    public static final /* synthetic */ boolean $anonfun$convertPublication$9(Tuple2 check$ifrefutable$18) {
        Tuple2 tuple2 = check$ifrefutable$18;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("type".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$convertPublication$11(Tuple2 check$ifrefutable$19) {
        Tuple2 tuple2 = check$ifrefutable$19;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("value".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$convertPublication$14(Journal journal$1, Tuple2 tp) {
        String string = (String)tp._1();
        if ("electronic".equals(string)) {
            journal$1.setIssnOnline((String)tp._2());
            return;
        }
        if ("print".equals(string)) {
            journal$1.setIssnPrinted((String)tp._2());
            return;
        }
    }

    private Crossref2Oaf$() {
        MODULE$ = this;
        Product.$init$((Product)this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.mapper = new ObjectMapper();
        LazyRef formats$lzy = new LazyRef();
        LazyRef json$lzy = new LazyRef();
        String s = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/collection/crossref/irish_funder.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        this.irishFunder = (List)package$.MODULE$.jvalue2extractable(Crossref2Oaf$.json$1(json$lzy, s)).extract((Formats)Crossref2Oaf$.formats$1(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(funderInfo.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        this.invalidName = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",", "none none", "none, none", "none &na;", "(:null)", "test test test", "test test", "test", "&na; &na;"}));
    }
}

