/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.bio;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.collection.CollectionUtils$;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.sx.bio.BioDBToOAF$;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkTransformBioDatabaseToOAF$ {
    public static SparkTransformBioDatabaseToOAF$ MODULE$;

    static {
        new SparkTransformBioDatabaseToOAF$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf();
        Logger log = LoggerFactory.getLogger(this.getClass());
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/bio/ebi/bio_to_oaf_params.json")));
        parser.parseArgument(args);
        String database = parser.get("database");
        log.info("database: {}", new Object[]{database});
        String dbPath = parser.get("dbPath");
        log.info("dbPath: {}", new Object[]{database});
        String mdstoreOutputVersion = parser.get("mdstoreOutputVersion");
        log.info(new StringBuilder(26).append("mdstoreOutputVersion is '").append(mdstoreOutputVersion).append("'").toString());
        String isLookupUrl = parser.get("isLookupUrl");
        log.info("isLookupUrl: {}", new Object[]{isLookupUrl});
        ObjectMapper mapper = new ObjectMapper();
        MDStoreVersion cleanedMdStoreVersion = (MDStoreVersion)mapper.readValue(mdstoreOutputVersion, MDStoreVersion.class);
        String outputBasePath = cleanedMdStoreVersion.getHdfsPath();
        log.info(new StringBuilder(20).append("outputBasePath is '").append(outputBasePath).append("'").toString());
        ISLookUpService isLookupService = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
        VocabularyGroup vocabularies = VocabularyGroup.loadVocsFromIS((ISLookUpService)isLookupService);
        Predef$.MODULE$.require(vocabularies != null);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).getOrCreate();
        SparkContext sc = spark.sparkContext();
        Encoder resultEncoder = Encoders$.MODULE$.kryo(Oaf.class);
        String string = database.toUpperCase();
        if ("UNIPROT".equals(string)) {
            CollectionUtils$.MODULE$.saveDataset((Dataset<Oaf>)spark.createDataset(sc.textFile(dbPath, sc.textFile$default$2()).flatMap((Function1 & Serializable & scala.Serializable)i -> BioDBToOAF$.MODULE$.uniprotToOAF((String)i, vocabularies), ClassTag$.MODULE$.apply(Oaf.class)), resultEncoder), new StringBuilder(6).append(outputBasePath).append("/store").toString());
            long mdStoreSize = spark.read().text(new StringBuilder(6).append(outputBasePath).append("/store").toString()).count();
            DHPUtils.writeHdfsFile((Configuration)spark.sparkContext().hadoopConfiguration(), (String)String.valueOf(BoxesRunTime.boxToLong((long)mdStoreSize)), (String)new StringBuilder(5).append(outputBasePath).append("/size").toString());
            return;
        }
        if ("PDB".equals(string)) {
            CollectionUtils$.MODULE$.saveDataset((Dataset<Oaf>)spark.createDataset(sc.textFile(dbPath, sc.textFile$default$2()).flatMap((Function1 & Serializable & scala.Serializable)i -> BioDBToOAF$.MODULE$.pdbTOOaf((String)i, vocabularies), ClassTag$.MODULE$.apply(Oaf.class)), resultEncoder), new StringBuilder(6).append(outputBasePath).append("/store").toString());
            long mdStoreSize = spark.read().text(new StringBuilder(6).append(outputBasePath).append("/store").toString()).count();
            DHPUtils.writeHdfsFile((Configuration)spark.sparkContext().hadoopConfiguration(), (String)String.valueOf(BoxesRunTime.boxToLong((long)mdStoreSize)), (String)new StringBuilder(5).append(outputBasePath).append("/size").toString());
            return;
        }
        throw new MatchError((Object)string);
    }

    private SparkTransformBioDatabaseToOAF$() {
        MODULE$ = this;
    }
}

