/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.bio.ebi;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.sx.bio.BioDBToOAF;
import eu.dnetlib.dhp.sx.bio.ebi.SparkDownloadEBILinks$;
import eu.dnetlib.dhp.sx.bio.ebi.SparkEBILinksToOaf$;
import eu.dnetlib.dhp.sx.bio.pubmed.PMArticle;
import eu.dnetlib.dhp.sx.bio.pubmed.PMAuthor;
import eu.dnetlib.dhp.sx.bio.pubmed.PMJournal;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkDownloadEBILinks$ {
    public static SparkDownloadEBILinks$ MODULE$;

    static {
        new SparkDownloadEBILinks$();
    }

    public BioDBToOAF.EBILinkItem createEBILinks(long pmid) {
        String res = this.requestLinks(pmid);
        if (res != null) {
            return new BioDBToOAF.EBILinkItem(pmid, res);
        }
        return null;
    }

    public String requestPage(String url) {
        String string;
        block9: {
            String string2;
            block8: {
                HttpGet r = new HttpGet(url);
                int timeout = 60;
                RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
                try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
                    int tries = 4;
                    while (tries > 0) {
                        Predef$.MODULE$.println((Object)new StringBuilder(11).append("requesting ").append(r.getURI()).toString());
                        try {
                            CloseableHttpResponse response = client.execute((HttpUriRequest)r);
                            Predef$.MODULE$.println((Object)new StringBuilder(24).append("get response with status").append(response.getStatusLine().getStatusCode()).toString());
                            if (response.getStatusLine().getStatusCode() > 400) {
                                --tries;
                                continue;
                            }
                            string2 = IOUtils.toString((InputStream)response.getEntity().getContent());
                            break block8;
                        }
                        catch (Throwable e) {
                            Predef$.MODULE$.println((Object)new StringBuilder(20).append("Error on requesting ").append(r.getURI()).toString());
                            e.printStackTrace();
                            --tries;
                        }
                    }
                    string = "";
                    break block9;
                }
            }
            return string2;
        }
        return string;
    }

    public String requestLinks(long PMID) {
        return this.requestPage(new StringBuilder(75).append("https://www.ebi.ac.uk/europepmc/webservices/rest/MED/").append(PMID).append("/datalinks?format=json").toString());
    }

    public void main(String[] args) {
        public final class Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator21$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.bio")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.bio.BioDBToOAF")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.bio.BioDBToOAF.EBILinkItem"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator21$1() {
            }
        }
        Logger log = LoggerFactory.getLogger(this.getClass());
        int MAX_ITEM_PER_PARTITION = 20000;
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/bio/ebi/ebi_download_update.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(SparkEBILinksToOaf$.MODULE$.getClass().getSimpleName()).getOrCreate();
        Encoder PMEncoder = Encoders$.MODULE$.kryo(PMArticle.class);
        Encoder PMJEncoder = Encoders$.MODULE$.kryo(PMJournal.class);
        Encoder PMAEncoder = Encoders$.MODULE$.kryo(PMAuthor.class);
        String sourcePath = parser.get("sourcePath");
        log.info(new StringBuilder(15).append("sourcePath  -> ").append(sourcePath).toString());
        String workingPath = parser.get("workingPath");
        log.info(new StringBuilder(16).append("workingPath  -> ").append(workingPath).toString());
        log.info("Getting max pubmedId where the links have already requested");
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.bio")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.bio.BioDBToOAF")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.bio.BioDBToOAF.EBILinkItem"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator5$1() {
            }
        }
        Dataset links = spark.read().load(new StringBuilder(18).append(sourcePath).append("/ebi_links_dataset").toString()).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator5$1())));
        long lastPMIDRequested = ((Row)links.map((Function1 & Serializable & scala.Serializable)l -> BoxesRunTime.boxToLong((long)l.id()), spark.implicits().newLongEncoder()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max("value")})).first()).getLong(0);
        log.info("Retrieving PMID to request links");
        Dataset pubmed = spark.read().load(new StringBuilder(17).append(sourcePath).append("/baseline_dataset").toString()).as(PMEncoder);
        pubmed.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToLong((long)SparkDownloadEBILinks$.$anonfun$main$2(p)), spark.implicits().newLongEncoder()).where(new StringBuilder(8).append("value > ").append(lastPMIDRequested).toString()).write().mode(SaveMode.Overwrite).save(new StringBuilder(14).append(workingPath).append("/id_to_request").toString());
        Dataset pmidToReq = spark.read().load(new StringBuilder(14).append(workingPath).append("/id_to_request").toString()).as(spark.implicits().newLongEncoder());
        long total = pmidToReq.count();
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator11$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.bio")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.bio.BioDBToOAF")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.bio.BioDBToOAF.EBILinkItem"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator11$1() {
            }
        }
        spark.createDataset(pmidToReq.rdd().repartition((int)(total / (long)MAX_ITEM_PER_PARTITION), (Ordering)Ordering.Long$.MODULE$).map((Function1 & Serializable & scala.Serializable)pmid -> SparkDownloadEBILinks$.MODULE$.createEBILinks(BoxesRunTime.unboxToLong((Object)pmid)), ClassTag$.MODULE$.apply(BioDBToOAF.EBILinkItem.class)).filter((Function1 & Serializable & scala.Serializable)l -> BoxesRunTime.boxToBoolean((boolean)SparkDownloadEBILinks$.$anonfun$main$4(l))), spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator11$1()))).write().mode(SaveMode.Overwrite).save(new StringBuilder(13).append(workingPath).append("/links_update").toString());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator16$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.bio")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.bio.BioDBToOAF")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.bio.BioDBToOAF.EBILinkItem"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator16$1() {
            }
        }
        Dataset updates = spark.read().load(new StringBuilder(13).append(workingPath).append("/links_update").toString()).as(spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator16$1())));
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        links.union(updates).groupByKey((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.id()), spark.implicits().newLongEncoder()).reduceGroups((Function2 & Serializable & scala.Serializable)(x, y) -> {
            BioDBToOAF.EBILinkItem eBILinkItem = x == null || x.links() == null ? y : BoxedUnit.UNIT;
            BioDBToOAF.EBILinkItem eBILinkItem2 = y == null || y.links() == null ? x : BoxedUnit.UNIT;
            if (x.links().length() > y.links().length()) {
                return x;
            }
            return y;
        }).map((Function1 & Serializable & scala.Serializable)x$2 -> (BioDBToOAF.EBILinkItem)x$2._2(), spark.implicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator21$1()))).write().mode(SaveMode.Overwrite).save(new StringBuilder(12).append(workingPath).append("/links_final").toString());
    }

    public static final /* synthetic */ long $anonfun$main$2(PMArticle p) {
        return new StringOps(Predef$.MODULE$.augmentString(p.getPmid())).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$main$4(BioDBToOAF.EBILinkItem l) {
        return l != null;
    }

    private SparkDownloadEBILinks$() {
        MODULE$ = this;
    }
}

