/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.transformation.xslt;

import eu.dnetlib.dhp.aggregation.common.AggregationCounter;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.mdstore.MetadataRecord;
import eu.dnetlib.dhp.transformation.xslt.Cleaner;
import eu.dnetlib.dhp.transformation.xslt.DateCleaner;
import eu.dnetlib.dhp.transformation.xslt.PersonCleaner;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.commons.io.IOUtils;
import org.apache.spark.api.java.function.MapFunction;

public class XSLTTransformationFunction
implements MapFunction<MetadataRecord, MetadataRecord>,
Serializable {
    public static final String QNAME_BASE_URI = "http://eu/dnetlib/transform";
    private static final String DATASOURCE_ID_PARAM = "varDataSourceId";
    private static final String DATASOURCE_NAME_PARAM = "varOfficialName";
    private final AggregationCounter aggregationCounter;
    private final String transformationRule;
    private final Cleaner cleanFunction;
    private final long dateOfTransformation;
    private final VocabularyGroup vocabularies;

    public XSLTTransformationFunction(AggregationCounter aggregationCounter, String transformationRule, long dateOfTransformation, VocabularyGroup vocabularies) {
        this.aggregationCounter = aggregationCounter;
        this.transformationRule = transformationRule;
        this.vocabularies = vocabularies;
        this.dateOfTransformation = dateOfTransformation;
        this.cleanFunction = new Cleaner(vocabularies);
    }

    public MetadataRecord call(MetadataRecord value) {
        XdmNode source;
        XsltExecutable xslt;
        this.aggregationCounter.getTotalItems().add(1L);
        Processor processor = new Processor(false);
        processor.registerExtensionFunction((ExtensionFunction)this.cleanFunction);
        processor.registerExtensionFunction((ExtensionFunction)new DateCleaner());
        processor.registerExtensionFunction((ExtensionFunction)new PersonCleaner());
        XsltCompiler comp = processor.newXsltCompiler();
        QName datasourceIDParam = new QName(DATASOURCE_ID_PARAM);
        comp.setParameter(datasourceIDParam, (XdmValue)new XdmAtomicValue(value.getProvenance().getDatasourceId()));
        QName datasourceNameParam = new QName(DATASOURCE_NAME_PARAM);
        comp.setParameter(datasourceNameParam, (XdmValue)new XdmAtomicValue(value.getProvenance().getDatasourceName()));
        try {
            xslt = comp.compile((Source)new StreamSource(IOUtils.toInputStream((String)this.transformationRule, (Charset)StandardCharsets.UTF_8)));
            source = processor.newDocumentBuilder().build((Source)new StreamSource(IOUtils.toInputStream((String)value.getBody(), (Charset)StandardCharsets.UTF_8)));
        }
        catch (Throwable e) {
            throw new RuntimeException("Error on parsing xslt", e);
        }
        try {
            XsltTransformer trans = xslt.load();
            trans.setInitialContextNode(source);
            StringWriter output = new StringWriter();
            Serializer out = processor.newSerializer((Writer)output);
            out.setOutputProperty(Serializer.Property.METHOD, "xml");
            out.setOutputProperty(Serializer.Property.INDENT, "yes");
            trans.setDestination((Destination)out);
            trans.transform();
            String xml = output.toString();
            value.setBody(xml);
            value.setDateOfTransformation(Long.valueOf(this.dateOfTransformation));
            this.aggregationCounter.getProcessedItems().add(1L);
            return value;
        }
        catch (Throwable e) {
            this.aggregationCounter.getErrorItems().add(1L);
            return null;
        }
    }

    public AggregationCounter getAggregationCounter() {
        return this.aggregationCounter;
    }

    public String getTransformationRule() {
        return this.transformationRule;
    }

    public Cleaner getCleanFunction() {
        return this.cleanFunction;
    }

    public long getDateOfTransformation() {
        return this.dateOfTransformation;
    }

    public VocabularyGroup getVocabularies() {
        return this.vocabularies;
    }
}

