/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.affro;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.affro.Constants;
import eu.dnetlib.dhp.actionmanager.affro.RedistributeRelations;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedistributeRelationsTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;
    private static final String ID_PREFIX = "50|doi_________::";
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(RedistributeRelationsTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("Using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(RedistributeRelationsTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(RedistributeRelationsTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testMatch() throws Exception {
        String explodedResultPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/affro/exploded").getPath();
        String matchingsPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/affro/matchings").getPath();
        String outputPath = workingDir.toString() + "/actionSet";
        RedistributeRelations.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-explodedResultPath", explodedResultPath, "-matchingsPath", matchingsPath, "-outputPath", outputPath, "-workingDir", workingDir.toString()});
        String stringa = outputPath;
        System.out.println(stringa);
        Dataset dataset = spark.read().schema(Constants.RESULT_MATCHED_SCHEMA).json(stringa);
        Assertions.assertEquals((long)32L, (long)dataset.count());
        Assertions.assertEquals((long)32L, (long)dataset.distinct().count());
        dataset.where("id = '50|doi_________::537bbda4fdfe87a42b239f27af5b14be'").withColumn("author", functions.explode((Column)functions.col((String)"authors"))).select("author", new String[0]).show(false);
        Assertions.assertEquals((int)6, (int)((Row)dataset.where("id = '50|doi_________::537bbda4fdfe87a42b239f27af5b14be'").selectExpr(new String[]{"size(authors) as authors_count"}).first()).getInt(0));
        Assertions.assertEquals((int)3, (int)((Row)dataset.where("id = '50|doi_________::537bbda4fdfe87a42b239f27af5b14be'").selectExpr(new String[]{"size(organizations) as org_count"}).first()).getInt(0));
        dataset.where("id = '50|doi_________::e57dc736f7f5d7c724faf105b85b9106'").show(false);
        Assertions.assertEquals((int)1, (int)((Row)dataset.where("id = '50|doi_________::e57dc736f7f5d7c724faf105b85b9106'").selectExpr(new String[]{"size(authors) as authors_count"}).first()).getInt(0));
        Row author = (Row)((Row)dataset.where("id = '50|doi_________::e57dc736f7f5d7c724faf105b85b9106'").select(new Column[]{functions.explode((Column)functions.col((String)"authors")).alias("author")}).first()).getAs("author");
        Assertions.assertEquals((Object)"Yatracos, Yannis G.", (Object)author.getAs("fullname"));
        Boolean isCorresponding = (Boolean)author.getAs("corresponding");
        Assertions.assertTrue((boolean)isCorresponding);
    }

    static {
        log = LoggerFactory.getLogger(RedistributeRelationsTest.class);
    }
}

