/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.affro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.api.java.UDF1;
import scala.collection.mutable.WrappedArray;

public class AggregateAuthorUDF
implements UDF1<WrappedArray<Row>, Row> {
    public Row call(WrappedArray<Row> group) {
        ArrayList<Row> affiliations = new ArrayList<Row>();
        String id = null;
        String fullname = null;
        Boolean corresponding = null;
        WrappedArray contributor_roles = null;
        for (int i = 0; i < group.length(); ++i) {
            Row entry = (Row)group.apply(i);
            if (id == null) {
                id = (String)entry.getAs("id");
            }
            if (fullname == null) {
                fullname = (String)entry.getAs("fullname");
            }
            if (corresponding == null) {
                corresponding = (Boolean)entry.getAs("corresponding");
            }
            if (contributor_roles == null) {
                contributor_roles = (WrappedArray)entry.getAs("contributor_roles");
            }
            String rawAffString = (String)entry.getAs("raw_affiliation_string");
            WrappedArray matchArray = (WrappedArray)entry.getAs("Matchings");
            ArrayList<Row> matchList = new ArrayList<Row>();
            for (int j = 0; j < matchArray.length(); ++j) {
                matchList.add((Row)matchArray.apply(j));
            }
            List<Row> resolvedMatchings = this.regroupAndSelectDistinctMatch(matchList);
            Row affiliationRow = RowFactory.create((Object[])new Object[]{rawAffString, resolvedMatchings});
            affiliations.add(affiliationRow);
        }
        return RowFactory.create((Object[])new Object[]{id, fullname, affiliations, corresponding, contributor_roles});
    }

    private List<Row> regroupAndSelectDistinctMatch(List<Row> inputGroups) {
        HashMap<String, Tuple> valueMap = new HashMap<String, Tuple>();
        for (Row row : inputGroups) {
            if (!"active".equalsIgnoreCase((String)row.getAs("Status"))) continue;
            String value = (String)row.getAs("Value");
            double confidence = 0.0;
            if (row.getAs("Confidence") != null) {
                confidence = (Double)row.getAs("Confidence");
            }
            String provenance = (String)row.getAs("Provenance");
            String pid = (String)row.getAs("PID");
            String country = (String)row.getAs("Country");
            Tuple newValue = new Tuple(confidence, provenance, pid, country);
            if (!valueMap.containsKey(value)) {
                valueMap.put(value, newValue);
            }
            if (!(((Tuple)valueMap.get((Object)value)).confidence < confidence)) continue;
            valueMap.replace(value, (Tuple)valueMap.get(value), newValue);
        }
        ArrayList<Row> result = new ArrayList<Row>();
        for (Map.Entry entry : valueMap.entrySet()) {
            Tuple t = (Tuple)entry.getValue();
            result.add(RowFactory.create((Object[])new Object[]{t.provenance, t.pid, entry.getKey(), t.confidence, "active", t.country}));
        }
        return result;
    }

    private static class Tuple {
        double confidence;
        String provenance;
        String pid;
        String country;

        public Tuple(double confidence, String provenance, String pid, String country) {
            this.confidence = confidence;
            this.provenance = provenance;
            this.pid = pid;
            this.country = country;
        }
    }
}

