/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.affro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.api.java.UDF1;
import scala.collection.mutable.WrappedArray;

public class AggregateResultUDF
implements UDF1<WrappedArray<Row>, Row> {
    public Row call(WrappedArray<Row> group) {
        ArrayList<Row> authors = new ArrayList<Row>();
        ArrayList<List<Row>> allMatchings = new ArrayList<List<Row>>();
        String id = null;
        for (int i = 0; i < group.length(); ++i) {
            Row entry = (Row)group.apply(i);
            String authorName = (String)entry.getAs("fullname");
            WrappedArray affArray = (WrappedArray)entry.getAs("affiliations");
            Row author = RowFactory.create((Object[])new Object[]{authorName, affArray, entry.getAs("corresponding"), entry.getAs("contributor_roles")});
            authors.add(author);
            if (id == null) {
                id = (String)entry.getAs("id");
            }
            ArrayList<Row> matchList = new ArrayList<Row>();
            for (int j = 0; j < affArray.length(); ++j) {
                WrappedArray matchings = (WrappedArray)((Row)affArray.apply(j)).getAs("Matchings");
                for (int k = 0; k < matchings.length(); ++k) {
                    matchList.add((Row)matchings.apply(k));
                }
            }
            allMatchings.add(matchList);
        }
        List<Row> organizations = this.regroupAndSelectDistinctMatch(allMatchings);
        return RowFactory.create((Object[])new Object[]{id, authors, organizations});
    }

    private List<Row> regroupAndSelectDistinctMatch(List<List<Row>> inputGroups) {
        HashMap<String, Tuple> valueMap = new HashMap<String, Tuple>();
        for (List<Row> group : inputGroups) {
            for (Row row : group) {
                if (!"active".equalsIgnoreCase((String)row.getAs("Status"))) continue;
                String value = (String)row.getAs("Value");
                Double confidence = Double.valueOf(row.getAs("Confidence").toString());
                String provenance = (String)row.getAs("Provenance");
                String pid = (String)row.getAs("PID");
                String country = (String)row.getAs("Country");
                if (valueMap.containsKey(value) && !(((Tuple)valueMap.get((Object)value)).confidence < confidence)) continue;
                valueMap.put(value, new Tuple(confidence, provenance, pid, country));
            }
        }
        ArrayList<Row> result = new ArrayList<Row>();
        for (Map.Entry entry : valueMap.entrySet()) {
            Tuple t = (Tuple)entry.getValue();
            result.add(RowFactory.create((Object[])new Object[]{t.provenance, t.pid, entry.getKey(), t.confidence, "active", t.country}));
        }
        return result;
    }

    private static class Tuple {
        double confidence;
        String provenance;
        String pid;
        String country;

        public Tuple(double confidence, String provenance, String pid, String country) {
            this.confidence = confidence;
            this.provenance = provenance;
            this.pid = pid;
            this.country = country;
        }
    }
}

