/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.affro;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.Constants;
import eu.dnetlib.dhp.actionmanager.ror.GenerateRorActionSetJob;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.utils.DoiCleaningRule;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class PrepareAffiliationRelations
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PrepareAffiliationRelations.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String ID_PREFIX = "50|doi_________::";
    public static final String BIP_AFFILIATIONS_CLASSID = "result:organization:openaireinference";
    public static final String BIP_AFFILIATIONS_CLASSNAME = "Affiliation relation inferred by OpenAIRE";
    public static final String BIP_INFERENCE_PROVENANCE = "openaire:affiliation";
    public static final String OPENAIRE_DATASOURCE_ID = "10|infrastruct_::f66f1bd369679b5b077dcdf006089556";
    public static final String OPENAIRE_DATASOURCE_NAME = "OpenAIRE";
    public static final String DOI_URL_PREFIX = "https://doi.org/";
    public static final int DOI_URL_PREFIX_LENGTH = 16;
    private static final Object OPENORGS_NS_PREFIX = "openorgs____";

    public static <I extends Result> void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareAffiliationRelations.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/affro/input_actionset_parameter.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Constants.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String crossrefInputPath = parser.get("crossrefInputPath");
        log.info("crossrefInputPath: {}", (Object)crossrefInputPath);
        String pubmedInputPath = parser.get("pubmedInputPath");
        log.info("pubmedInputPath: {}", (Object)pubmedInputPath);
        String openapcInputPath = parser.get("openapcInputPath");
        log.info("openapcInputPath: {}", (Object)openapcInputPath);
        String dataciteInputPath = parser.get("dataciteInputPath");
        log.info("dataciteInputPath: {}", (Object)dataciteInputPath);
        String inputPaths = parser.get("inputPaths");
        log.info("inputPaths: {}", (Object)inputPaths);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            Constants.removeOutputDir(spark, outputPath);
            PrepareAffiliationRelations.createActionSet(spark, crossrefInputPath, pubmedInputPath, openapcInputPath, dataciteInputPath, inputPaths, outputPath);
        });
    }

    private static void createActionSet(SparkSession spark, String crossrefInputPath, String pubmedInputPath, String openapcInputPath, String dataciteInputPath, String inputPaths, String outputPath) {
        List collectedfromOpenAIRE = OafMapperUtils.listKeyValues((String[])new String[]{OPENAIRE_DATASOURCE_ID, OPENAIRE_DATASOURCE_NAME});
        JavaPairRDD<Text, Text> crossrefRelations = PrepareAffiliationRelations.prepareAffiliationRelationsNewModel(spark, crossrefInputPath, collectedfromOpenAIRE, "openaire:affiliation:crossref");
        JavaPairRDD<Text, Text> pubmedRelations = PrepareAffiliationRelations.prepareAffiliationRelations(spark, pubmedInputPath, collectedfromOpenAIRE, "openaire:affiliation:pubmed");
        JavaPairRDD<Text, Text> openAPCRelations = PrepareAffiliationRelations.prepareAffiliationRelationsNewModel(spark, openapcInputPath, collectedfromOpenAIRE, "openaire:affiliation:openapc");
        JavaPairRDD<Text, Text> dataciteRelations = PrepareAffiliationRelations.prepareAffiliationRelationFromPublisherNewModel(spark, dataciteInputPath, collectedfromOpenAIRE, "openaire:affiliation:datacite");
        JavaPairRDD<Text, Text> oalexRelations = PrepareAffiliationRelations.prepareAffiliationRelationsGraph(spark, inputPaths + "/oalex", collectedfromOpenAIRE, "openaire:affiliation:rawaff");
        JavaPairRDD<Text, Text> publisherRelations = PrepareAffiliationRelations.prepareAffiliationRelationsGraph(spark, inputPaths + "/publishers", collectedfromOpenAIRE, "openaire:affiliation:webcrawl");
        JavaPairRDD<Text, Text> oaireRelations = PrepareAffiliationRelations.prepareAffiliationRelationsGraph(spark, inputPaths + "/oaire", collectedfromOpenAIRE, "openaire:affiliation:graph");
        JavaPairRDD<Text, Text> iisRelations = PrepareAffiliationRelations.prepareAffiliationRelationsGraph(spark, inputPaths + "/iis", collectedfromOpenAIRE, "openaire:affiliation:iis");
        crossrefRelations.union(pubmedRelations).union(openAPCRelations).union(dataciteRelations).union(oalexRelations).union(publisherRelations).union(oaireRelations).union(iisRelations).saveAsHadoopFile(outputPath, Text.class, Text.class, SequenceFileOutputFormat.class, BZip2Codec.class);
    }

    private static <I extends Result> JavaPairRDD<Text, Text> prepareAffiliationRelations(SparkSession spark, String inputPath, List<KeyValue> collectedfrom, String dataprovenance) {
        spark.udf().register("md5HashWithPrefix", (UDF1 & Serializable)doi -> ID_PREFIX + IdentifierFactory.md5((String)DoiCleaningRule.clean((String)PrepareAffiliationRelations.removePrefix(doi))), DataTypes.StringType);
        Dataset df = spark.read().schema("`DOI` STRING, `Matchings` ARRAY<STRUCT<`RORid`:STRING,`Confidence`:DOUBLE>>").json(inputPath).where("DOI is not null").withColumn("id", functions.expr((String)"md5HashWithPrefix(doi)")).withColumn("matching", functions.explode((Column)new Column("Matchings"))).select("id", new String[]{"matching"});
        return PrepareAffiliationRelations.getTextTextJavaPairRDD(collectedfrom, (Dataset<Row>)df, dataprovenance);
    }

    private static JavaPairRDD<Text, Text> getTextTextJavaPairRDD(List<KeyValue> collectedfrom, Dataset<Row> df, String dataprovenance) {
        df = df.select(new Column[]{new Column("id").as("id"), new Column("matching.RORid").as("rorid"), new Column("matching.Confidence").as("confidence")});
        return df.toJavaRDD().flatMap((FlatMapFunction & Serializable)row -> {
            String paperId = ID_PREFIX + IdentifierFactory.md5((String)DoiCleaningRule.clean((String)PrepareAffiliationRelations.removePrefix((String)row.getAs("doi"))));
            String affId = GenerateRorActionSetJob.calculateOpenaireId((String)row.getAs("rorid"));
            Qualifier qualifier = OafMapperUtils.qualifier((String)BIP_AFFILIATIONS_CLASSID, (String)BIP_AFFILIATIONS_CLASSNAME, (String)"dnet:provenanceActions", (String)"dnet:provenanceActions");
            DataInfo dataInfo = OafMapperUtils.dataInfo((Boolean)false, (String)dataprovenance, (Boolean)true, (Boolean)false, (Qualifier)qualifier, (String)Double.toString((Double)row.getAs("confidence")));
            return PrepareAffiliationRelations.getAffiliationRelationPair(paperId, affId, collectedfrom, dataInfo).iterator();
        }).map((Function & Serializable)p -> new AtomicAction(Relation.class, (Oaf)p)).mapToPair((PairFunction & Serializable)aa -> new Tuple2((Object)new Text(aa.getClazz().getCanonicalName()), (Object)new Text(OBJECT_MAPPER.writeValueAsString(aa))));
    }

    private static JavaPairRDD<Text, Text> prepareAffiliationRelationsGraph(SparkSession spark, String datasetPath, List<KeyValue> collectedfromOpenAIRE, String dataprovenance) {
        Dataset df = spark.read().schema(eu.dnetlib.dhp.actionmanager.affro.Constants.RESULT_MATCHED_SCHEMA).json(datasetPath).select("id", new String[]{"organizations"}).withColumn("matching", functions.explode((Column)new Column("organizations"))).select(new Column[]{new Column("id").as("id"), new Column("matching.PID").as("pidtype"), new Column("matching.Value").as("pidvalue"), new Column("matching.Confidence").as("confidence"), new Column("matching.Status").as("status")}).where("status = 'active'");
        return PrepareAffiliationRelations.getTextTextJavaPairRDDNew(collectedfromOpenAIRE, (Dataset<Row>)df.selectExpr(new String[]{"id", "matching"}), dataprovenance);
    }

    private static JavaPairRDD<Text, Text> prepareAffiliationRelationFromPublisherNewModel(SparkSession spark, String inputPath, List<KeyValue> collectedfrom, String dataprovenance) {
        spark.udf().register("md5HashWithPrefix", (UDF1 & Serializable)doi -> ID_PREFIX + IdentifierFactory.md5((String)DoiCleaningRule.clean((String)PrepareAffiliationRelations.removePrefix(doi))), DataTypes.StringType);
        Dataset df = spark.read().schema("`DOI` STRING, `Organizations` ARRAY<STRUCT<`PID`:STRING, `Value`:STRING,`Confidence`:DOUBLE, `Status`:STRING>>").json(inputPath).where("DOI is not null").withColumn("id", functions.expr((String)"md5HashWithPrefix(doi)")).withColumn("matching", functions.explode((Column)new Column("Matchings"))).select("id", new String[]{"matching"});
        return PrepareAffiliationRelations.getTextTextJavaPairRDDNew(collectedfrom, (Dataset<Row>)df.selectExpr(new String[]{"id", "matching"}), dataprovenance);
    }

    private static <I extends Result> JavaPairRDD<Text, Text> prepareAffiliationRelationsNewModel(SparkSession spark, String inputPath, List<KeyValue> collectedfrom, String dataprovenance) {
        spark.udf().register("md5HashWithPrefix", (UDF1 & Serializable)doi -> ID_PREFIX + IdentifierFactory.md5((String)DoiCleaningRule.clean((String)PrepareAffiliationRelations.removePrefix(doi))), DataTypes.StringType);
        Dataset df = spark.read().schema("`DOI` STRING, `Matchings` ARRAY<STRUCT<`PID`:STRING, `Value`:STRING,`Confidence`:DOUBLE, `Status`:STRING>>").json(inputPath).where("DOI is not null").withColumn("id", functions.expr((String)"md5HashWithPrefix(doi)")).withColumn("matching", functions.explode((Column)new Column("Matchings"))).select("id", new String[]{"matching"});
        return PrepareAffiliationRelations.getTextTextJavaPairRDDNew(collectedfrom, (Dataset<Row>)df, dataprovenance);
    }

    private static JavaPairRDD<Text, Text> getTextTextJavaPairRDDNew(List<KeyValue> collectedfrom, Dataset<Row> df, String dataprovenance) {
        df = df.select(new Column[]{new Column("id").as("id"), new Column("matching.PID").as("pidtype"), new Column("matching.Value").as("pidvalue"), new Column("matching.Confidence").as("confidence"), new Column("matching.Status").as("status")}).where("status = 'active'");
        return df.toJavaRDD().flatMap((FlatMapFunction & Serializable)row -> {
            String paperId = (String)row.getAs("id");
            String affId = null;
            affId = row.getAs("pidtype").equals("ROR") ? GenerateRorActionSetJob.calculateOpenaireId((String)row.getAs("pidvalue")) : PrepareAffiliationRelations.calculateOpenOrgsId((String)row.getAs("pidvalue"));
            Qualifier qualifier = OafMapperUtils.qualifier((String)BIP_AFFILIATIONS_CLASSID, (String)BIP_AFFILIATIONS_CLASSNAME, (String)"dnet:provenanceActions", (String)"dnet:provenanceActions");
            DataInfo dataInfo = OafMapperUtils.dataInfo((Boolean)false, (String)dataprovenance, (Boolean)true, (Boolean)false, (Qualifier)qualifier, (String)Double.toString((Double)row.getAs("confidence")));
            return PrepareAffiliationRelations.getAffiliationRelationPair(paperId, affId, collectedfrom, dataInfo).iterator();
        }).map((Function & Serializable)p -> new AtomicAction(Relation.class, (Oaf)p)).mapToPair((PairFunction & Serializable)aa -> new Tuple2((Object)new Text(aa.getClazz().getCanonicalName()), (Object)new Text(OBJECT_MAPPER.writeValueAsString(aa))));
    }

    private static String calculateOpenOrgsId(String pidvalue) {
        return String.format("20|%s::%s", OPENORGS_NS_PREFIX, DHPUtils.md5((String)pidvalue));
    }

    private static String removePrefix(String doi) {
        if (doi.startsWith(DOI_URL_PREFIX)) {
            return doi.substring(16);
        }
        return doi;
    }

    private static List<Relation> getAffiliationRelationPair(String paperId, String affId, List<KeyValue> collectedfrom, DataInfo dataInfo) {
        return Arrays.asList(OafMapperUtils.getRelation((String)paperId, (String)affId, (String)"resultOrganization", (String)"affiliation", (String)"hasAuthorInstitution", collectedfrom, (DataInfo)dataInfo, null), OafMapperUtils.getRelation((String)affId, (String)paperId, (String)"resultOrganization", (String)"affiliation", (String)"isAuthorInstitutionOf", collectedfrom, (DataInfo)dataInfo, null));
    }
}

