/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.bio.pubmed;

import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.InstanceTypeMapping;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.GraphCleaningFunctions;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.dhp.sx.bio.pubmed.PMArticle;
import eu.dnetlib.dhp.sx.bio.pubmed.PMAuthor;
import eu.dnetlib.dhp.sx.bio.pubmed.PMJournal;
import eu.dnetlib.dhp.sx.bio.pubmed.PMSubject;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PubMedToOaf$ {
    public static PubMedToOaf$ MODULE$;
    private final String SUBJ_CLASS;
    private final String OAI_HEADER;
    private final String OLD_PMC_PREFIX;
    private final Map<String, String> urlMap;
    private final DataInfo dataInfo;
    private final KeyValue collectedFrom;

    static {
        new PubMedToOaf$();
    }

    public String SUBJ_CLASS() {
        return this.SUBJ_CLASS;
    }

    public String OAI_HEADER() {
        return this.OAI_HEADER;
    }

    public String OLD_PMC_PREFIX() {
        return this.OLD_PMC_PREFIX;
    }

    public Map<String, String> urlMap() {
        return this.urlMap;
    }

    public DataInfo dataInfo() {
        return this.dataInfo;
    }

    public KeyValue collectedFrom() {
        return this.collectedFrom;
    }

    public String cleanDoi(String doi) {
        String regex = "^10.\\d{4,9}\\/[\\[\\]\\-\\<\\>._;()\\/:A-Z0-9]+$";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(doi);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    public String createOriginalOpenaireId(PMArticle article) {
        if (StringUtils.isNotEmpty((CharSequence)article.getPmcId())) {
            String md5 = DHPUtils.md5((String)new StringBuilder(0).append(this.OAI_HEADER()).append(article.getPmcId().replace("PMC", "")).toString());
            return new StringBuilder(0).append(this.OLD_PMC_PREFIX()).append(md5).toString();
        }
        return null;
    }

    public Result createResult(Qualifier cobjQualifier, VocabularyGroup vocabularies) {
        Qualifier result_typologies = this.getVocabularyTerm("dnet:result_typologies", vocabularies, cobjQualifier.getClassid());
        String string = result_typologies.getClassid();
        if ("dataset".equals(string)) {
            return new Dataset();
        }
        if ("publication".equals(string)) {
            return new Publication();
        }
        if ("other".equals(string)) {
            return new OtherResearchProduct();
        }
        if ("software".equals(string)) {
            return new Software();
        }
        return null;
    }

    public Journal mapJournal(PMJournal j) {
        if (j == null) {
            return null;
        }
        Journal journal = new Journal();
        journal.setDataInfo(this.dataInfo());
        journal.setName(j.getTitle());
        journal.setConferencedate(j.getDate());
        journal.setVol(j.getVolume());
        journal.setIssnPrinted(j.getIssn());
        journal.setIss(j.getIssue());
        return journal;
    }

    public Qualifier getVocabularyTerm(String vocabularyName, VocabularyGroup vocabularies, String term) {
        Qualifier a = vocabularies.getSynonymAsQualifier(vocabularyName, term);
        Qualifier b = vocabularies.getTermAsQualifier(vocabularyName, term);
        if (a == null) {
            return b;
        }
        return a;
    }

    public Oaf convert(PMArticle article, VocabularyGroup vocabularies) {
        List authors;
        List subjects;
        Qualifier term;
        String normalizedPid;
        if (article.getPublicationTypes() == null) {
            return null;
        }
        ListBuffer pidList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        pidList.$plus$eq((Object)OafMapperUtils.structuredProperty((String)article.getPmid(), (String)PidType.pmid.toString(), (String)PidType.pmid.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types", (DataInfo)this.dataInfo()));
        Object object = StringUtils.isNotBlank((CharSequence)article.getPmcId()) ? pidList.$plus$eq((Object)OafMapperUtils.structuredProperty((String)article.getPmcId(), (String)PidType.pmc.toString(), (String)PidType.pmc.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types", (DataInfo)this.dataInfo())) : BoxedUnit.UNIT;
        if (pidList == null) {
            return null;
        }
        StructuredProperty alternateIdentifier = null;
        if (article.getDoi() != null && (normalizedPid = this.cleanDoi(article.getDoi())) != null) {
            alternateIdentifier = OafMapperUtils.structuredProperty((String)normalizedPid, (String)PidType.doi.toString(), (String)PidType.doi.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types", (DataInfo)this.dataInfo());
        }
        Option ja = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(article.getPublicationTypes()).asScala()).find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)PubMedToOaf$.$anonfun$convert$1(s)));
        Instance pubmedInstance = new Instance();
        if (ja.isDefined()) {
            Qualifier cojbCategory = this.getVocabularyTerm("dnet:publication_resource", vocabularies, ((PMSubject)ja.get()).getValue());
            pubmedInstance.setInstancetype(cojbCategory);
            InstanceTypeMapping itm = new InstanceTypeMapping();
            itm.setOriginalType(((PMSubject)ja.get()).getValue());
            itm.setVocabularyName("openaire::coar_resource_types_3_1");
            pubmedInstance.setInstanceTypeMapping((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)itm, (List)Nil$.MODULE$)).asJava());
        } else {
            Option i_type = ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(article.getPublicationTypes()).asScala()).map((Function1 & Serializable & scala.Serializable)s -> new Tuple2((Object)s.getValue(), (Object)MODULE$.getVocabularyTerm("dnet:publication_resource", vocabularies, s.getValue())), Buffer$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)q -> BoxesRunTime.boxToBoolean((boolean)PubMedToOaf$.$anonfun$convert$3(q)));
            if (i_type.isDefined()) {
                pubmedInstance.setInstancetype((Qualifier)((Tuple2)i_type.get())._2());
                InstanceTypeMapping itm = new InstanceTypeMapping();
                itm.setOriginalType((String)((Tuple2)i_type.get())._1());
                itm.setVocabularyName("openaire::coar_resource_types_3_1");
                pubmedInstance.setInstanceTypeMapping((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)itm, (List)Nil$.MODULE$)).asJava());
            } else {
                return null;
            }
        }
        Result result = this.createResult(pubmedInstance.getInstancetype(), vocabularies);
        if (result == null) {
            return result;
        }
        result.setDataInfo(this.dataInfo());
        pubmedInstance.setPid((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)pidList).asJava());
        if (alternateIdentifier != null) {
            pubmedInstance.setAlternateIdentifier((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)alternateIdentifier, (List)Nil$.MODULE$)).asJava());
        }
        result.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)pubmedInstance, (List)Nil$.MODULE$)).asJava());
        List urlLists = (List)((ListBuffer)((TraversableLike)pidList.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2(MODULE$.urlMap().getOrElse((Object)s.getQualifier().getClassid(), (Function0 & Serializable & scala.Serializable)() -> ""), (Object)s.getValue()), ListBuffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)PubMedToOaf$.$anonfun$convert$6(t)))).toList().map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(0).append((String)t._1()).append(t._2()).toString(), List$.MODULE$.canBuildFrom());
        if (urlLists != null) {
            pubmedInstance.setUrl((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)urlLists).asJava());
        }
        pubmedInstance.setDateofacceptance(OafMapperUtils.field((Object)GraphCleaningFunctions.cleanDate((String)article.getDate()), (DataInfo)this.dataInfo()));
        pubmedInstance.setCollectedfrom(this.collectedFrom());
        result.setPid((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)pidList).asJava());
        if (article.getJournal() != null && result instanceof Publication) {
            ((Publication)result).setJournal(this.mapJournal(article.getJournal()));
        }
        result.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.collectedFrom(), (List)Nil$.MODULE$)).asJava());
        result.setDateofacceptance(OafMapperUtils.field((Object)GraphCleaningFunctions.cleanDate((String)article.getDate()), (DataInfo)this.dataInfo()));
        if (article.getTitle() == null || article.getTitle().isEmpty()) {
            return null;
        }
        result.setTitle((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)OafMapperUtils.structuredProperty((String)article.getTitle(), (Qualifier)ModelConstants.MAIN_TITLE_QUALIFIER, (DataInfo)this.dataInfo()), (List)Nil$.MODULE$)).asJava());
        if (article.getDescription() != null && new StringOps(Predef$.MODULE$.augmentString(article.getDescription())).nonEmpty()) {
            result.setDescription((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)OafMapperUtils.field((Object)article.getDescription(), (DataInfo)this.dataInfo()), (List)Nil$.MODULE$)).asJava());
        }
        if (article.getLanguage() != null && (term = vocabularies.getSynonymAsQualifier("dnet:languages", article.getLanguage())) != null) {
            result.setLanguage(term);
        }
        if (article.getSubjects() != null && (subjects = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(article.getSubjects()).asScala()).map((Function1 & Serializable & scala.Serializable)s -> OafMapperUtils.subject((String)s.getValue(), (String)MODULE$.SUBJ_CLASS(), (String)MODULE$.SUBJ_CLASS(), (String)"dnet:subject_classification_typologies", (String)"dnet:subject_classification_typologies", (DataInfo)MODULE$.dataInfo()), Buffer$.MODULE$.canBuildFrom())).toList()) != null) {
            result.setSubject((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)subjects).asJava());
        }
        if ((authors = ((TraversableOnce)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(article.getAuthors()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                PMAuthor a = (PMAuthor)tuple2._1();
                int index = tuple2._2$mcI$sp();
                Author author = new Author();
                author.setName(a.getForeName());
                author.setSurname(a.getLastName());
                author.setFullname(a.getFullName());
                if (a.getIdentifier() != null) {
                    author.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)OafMapperUtils.structuredProperty((String)a.getIdentifier().getPid(), (Qualifier)OafMapperUtils.qualifier((String)a.getIdentifier().getType(), (String)a.getIdentifier().getType(), (String)"dnet:pid_types", (String)"dnet:pid_types"), (DataInfo)MODULE$.dataInfo()), (List)Nil$.MODULE$)).asJava());
                }
                if (a.getAffiliation() != null) {
                    author.setRawAffiliationString((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)a.getAffiliation().getName(), (List)Nil$.MODULE$)).asJava());
                }
                author.setRank(Predef$.MODULE$.int2Integer(index + 1));
                return author;
            }
            throw new MatchError((Object)tuple2);
        }, Buffer$.MODULE$.canBuildFrom())).toList()) != null && authors.nonEmpty()) {
            result.setAuthor((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)authors).asJava());
        }
        if (StringUtils.isNotEmpty((CharSequence)article.getPmcId())) {
            ListBuffer originalIDS = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            originalIDS.$plus$eq((Object)this.createOriginalOpenaireId(article));
            ((TraversableForwarder)pidList.map((Function1 & Serializable & scala.Serializable)s -> s.getValue(), ListBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)p -> originalIDS.$plus$eq(p));
            result.setOriginalId((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)originalIDS).asJava());
        } else {
            result.setOriginalId((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)pidList.map((Function1 & Serializable & scala.Serializable)s -> s.getValue(), ListBuffer$.MODULE$.canBuildFrom())).asJava());
        }
        result.setId(article.getPmid());
        String id = IdentifierFactory.createIdentifier((OafEntity)result);
        if (article.getPmid().equalsIgnoreCase(id)) {
            return null;
        }
        result.setId(id);
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$convert$1(PMSubject s) {
        return "Journal Article".equalsIgnoreCase(s.getValue());
    }

    public static final /* synthetic */ boolean $anonfun$convert$3(Tuple2 q) {
        return q._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$convert$6(Tuple2 t) {
        return new StringOps(Predef$.MODULE$.augmentString((String)t._1())).nonEmpty();
    }

    private PubMedToOaf$() {
        MODULE$ = this;
        this.SUBJ_CLASS = "keywords";
        this.OAI_HEADER = "oai:pubmedcentral.nih.gov:";
        this.OLD_PMC_PREFIX = "od_______267::";
        this.urlMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pmid"), (Object)"https://pubmed.ncbi.nlm.nih.gov/"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"doi"), (Object)"https://dx.doi.org/")}));
        this.dataInfo = OafMapperUtils.dataInfo((Boolean)Predef$.MODULE$.boolean2Boolean(false), null, (Boolean)Predef$.MODULE$.boolean2Boolean(false), (Boolean)Predef$.MODULE$.boolean2Boolean(false), (Qualifier)ModelConstants.PROVENANCE_ACTION_SET_QUALIFIER, (String)"0.9");
        this.collectedFrom = OafMapperUtils.keyValue((String)"10|opendoar____::8b6dd7db9af49e67306feb59a8bdc52c", (String)"Europe PubMed Central");
    }
}

