/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.opencitations;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.opencitations.ReadCOCI;
import eu.dnetlib.dhp.actionmanager.opencitations.model.COCI;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCOCITest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static java.nio.file.Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(ReadCOCITest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(ReadCOCITest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(ReadCOCITest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testReadCOCI() throws Exception {
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/opencitations/Extracted").getPath();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        fs.copyFromLocalFile(false, new Path(this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/opencitations/Extracted/part-00000").getPath()), new Path(String.valueOf(workingDir) + "/COCI/part-00000"));
        ReadCOCI.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-inputPath", workingDir.toString() + "/COCI", "-outputPath", workingDir.toString() + "/JSON/", "-hdfsNameNode", "local"});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/JSON/").map((Function & Serializable)item -> (COCI)OBJECT_MAPPER.readValue(item, COCI.class));
        Assertions.assertEquals((long)72L, (long)tmp.count());
    }

    static {
        log = LoggerFactory.getLogger(ReadCOCITest.class);
    }
}

