/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.aggregation.mdstore;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.rest.DNetRestClient;
import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDStoreActionNode {
    private static final Logger log = LoggerFactory.getLogger(MDStoreActionNode.class);
    public static final String NEW_VERSION_URI = "%s/mdstore/%s/newVersion";
    public static final String COMMIT_VERSION_URL = "%s/version/%s/commit/%s";
    public static final String ROLLBACK_VERSION_URL = "%s/version/%s/abort";
    public static final String READ_LOCK_URL = "%s/mdstore/%s/startReading";
    public static final String READ_UNLOCK_URL = "%s/version/%s/endReading";
    private static final String MDSTOREVERSIONPARAM = "mdStoreVersion";
    private static final String MDSTOREREADLOCKPARAM = "mdStoreReadLockVersion";

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser argumentParser = new ArgumentApplicationParser(IOUtils.toString((InputStream)MDStoreActionNode.class.getResourceAsStream("/eu/dnetlib/dhp/collection/mdstore_action_parameters.json")));
        argumentParser.parseArgument(args);
        log.info("Java Xmx: {}m", (Object)(Runtime.getRuntime().maxMemory() / 0x100000L));
        MDAction action = MDAction.valueOf(argumentParser.get("action"));
        log.info("Current action is {}", (Object)action);
        String mdStoreManagerURI = argumentParser.get("mdStoreManagerURI");
        log.info("mdStoreManagerURI is {}", (Object)mdStoreManagerURI);
        switch (action) {
            case NEW_VERSION: {
                String mdStoreID = argumentParser.get("mdStoreID");
                if (StringUtils.isBlank((CharSequence)mdStoreID)) {
                    throw new IllegalArgumentException("missing or empty argument mdStoreId");
                }
                MDStoreVersion currentVersion = (MDStoreVersion)DNetRestClient.doGET((String)String.format(NEW_VERSION_URI, mdStoreManagerURI, mdStoreID), MDStoreVersion.class);
                DHPUtils.populateOOZIEEnv((String)MDSTOREVERSIONPARAM, (String)DHPUtils.MAPPER.writeValueAsString((Object)currentVersion));
                break;
            }
            case COMMIT: {
                String hdfsuri = argumentParser.get("namenode");
                if (StringUtils.isBlank((CharSequence)hdfsuri)) {
                    throw new IllegalArgumentException("missing or empty argument namenode");
                }
                String mdStoreVersion_params = argumentParser.get(MDSTOREVERSIONPARAM);
                MDStoreVersion mdStoreVersion = (MDStoreVersion)DHPUtils.MAPPER.readValue(mdStoreVersion_params, MDStoreVersion.class);
                if (StringUtils.isBlank((CharSequence)mdStoreVersion.getId())) {
                    throw new IllegalArgumentException("invalid MDStoreVersion value current is " + mdStoreVersion_params);
                }
                Path hdfstoreSizepath = new Path(mdStoreVersion.getHdfsPath() + "/size");
                try (FileSystem fs = FileSystem.get((URI)URI.create(hdfsuri), (Configuration)DHPUtils.getHadoopConfiguration((String)hdfsuri));
                     FSDataInputStream inputStream = fs.open(hdfstoreSizepath);){
                    Long mdStoreSize = Long.parseLong(IOUtils.toString((InputStream)inputStream));
                    fs.create(hdfstoreSizepath);
                    DNetRestClient.doGET((String)String.format(COMMIT_VERSION_URL, mdStoreManagerURI, mdStoreVersion.getId(), mdStoreSize));
                    break;
                }
            }
            case ROLLBACK: {
                String mdStoreVersion_params = argumentParser.get(MDSTOREVERSIONPARAM);
                MDStoreVersion mdStoreVersion = (MDStoreVersion)DHPUtils.MAPPER.readValue(mdStoreVersion_params, MDStoreVersion.class);
                if (StringUtils.isBlank((CharSequence)mdStoreVersion.getId())) {
                    throw new IllegalArgumentException("invalid MDStoreVersion value current is " + mdStoreVersion_params);
                }
                DNetRestClient.doGET((String)String.format(ROLLBACK_VERSION_URL, mdStoreManagerURI, mdStoreVersion.getId()));
                break;
            }
            case READ_LOCK: {
                String mdStoreID = argumentParser.get("mdStoreID");
                if (StringUtils.isBlank((CharSequence)mdStoreID)) {
                    throw new IllegalArgumentException("missing or empty argument mdStoreId");
                }
                MDStoreVersion currentVersion = (MDStoreVersion)DNetRestClient.doGET((String)String.format(READ_LOCK_URL, mdStoreManagerURI, mdStoreID), MDStoreVersion.class);
                DHPUtils.populateOOZIEEnv((String)MDSTOREREADLOCKPARAM, (String)DHPUtils.MAPPER.writeValueAsString((Object)currentVersion));
                break;
            }
            case READ_UNLOCK: {
                String mdStoreVersion_params = argumentParser.get("readMDStoreId");
                MDStoreVersion mdStoreVersion = (MDStoreVersion)DHPUtils.MAPPER.readValue(mdStoreVersion_params, MDStoreVersion.class);
                if (StringUtils.isBlank((CharSequence)mdStoreVersion.getId())) {
                    throw new IllegalArgumentException("invalid MDStoreVersion value current is " + mdStoreVersion_params);
                }
                DNetRestClient.doGET((String)String.format(READ_UNLOCK_URL, mdStoreManagerURI, mdStoreVersion.getId()));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid action");
            }
        }
    }

    static enum MDAction {
        NEW_VERSION,
        ROLLBACK,
        COMMIT,
        READ_LOCK,
        READ_UNLOCK;

    }
}

