/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.transformation;

import eu.dnetlib.dhp.aggregation.common.AggregationCounter;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.mdstore.MetadataRecord;
import eu.dnetlib.dhp.transformation.DnetTransformationException;
import eu.dnetlib.dhp.transformation.xslt.XSLTTransformationFunction;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationFactory {
    private static final Logger log = LoggerFactory.getLogger(TransformationFactory.class);
    public static final String TRULE_XQUERY = "for $x in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') where $x//RESOURCE_IDENTIFIER/@value = \"%s\" return $x//CODE/*[local-name() =\"stylesheet\"]";

    private TransformationFactory() {
    }

    public static MapFunction<MetadataRecord, MetadataRecord> getTransformationPlugin(Map<String, String> jobArgument, AggregationCounter counters, ISLookUpService isLookupService) throws DnetTransformationException {
        try {
            String transformationPlugin = jobArgument.get("transformationPlugin");
            log.info("Transformation plugin required {}", (Object)transformationPlugin);
            switch (transformationPlugin) {
                case "XSLT_TRANSFORM": {
                    String transformationRuleId = jobArgument.get("transformationRuleId");
                    if (StringUtils.isBlank((CharSequence)transformationRuleId)) {
                        throw new DnetTransformationException("Missing Parameter transformationRule");
                    }
                    VocabularyGroup vocabularies = VocabularyGroup.loadVocsFromIS((ISLookUpService)isLookupService);
                    String transformationRule = TransformationFactory.queryTransformationRuleFromIS(transformationRuleId, isLookupService);
                    long dateOfTransformation = Long.parseLong(jobArgument.get("dateOfTransformation"));
                    return new XSLTTransformationFunction(counters, transformationRule, dateOfTransformation, vocabularies);
                }
            }
            throw new DnetTransformationException("transformation plugin does not exists for " + transformationPlugin);
        }
        catch (Throwable e) {
            throw new DnetTransformationException(e);
        }
    }

    private static String queryTransformationRuleFromIS(String transformationRuleId, ISLookUpService isLookUpService) throws DnetTransformationException, ISLookUpException {
        String query = String.format(TRULE_XQUERY, transformationRuleId);
        log.info("asking query to IS: {}", (Object)query);
        List result = isLookUpService.quickSearchProfile(query);
        if (result == null || result.isEmpty()) {
            throw new DnetTransformationException("Unable to find transformation rule with name: " + transformationRuleId);
        }
        return (String)result.get(0);
    }
}

