/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.aggregation.common;

import eu.dnetlib.dhp.aggregation.common.ReporterCallback;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class ReportingJob {
    public static final int ONGOING_REPORT_FREQUENCY = 5;
    public static final int INITIAL_DELAY = 2;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    protected final AggregatorReport report;

    protected ReportingJob(AggregatorReport report) {
        this.report = report;
    }

    protected void schedule(final ReporterCallback callback) {
        this.executor.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ReportingJob.this.report.ongoing(callback.getCurrent(), callback.getTotal());
            }
        }, 2L, 5L, TimeUnit.SECONDS);
    }

    protected void shutdown() {
        this.executor.shutdown();
    }
}

