/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.orcid;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadORCIDDumpApplication {
    private static final Logger log = LoggerFactory.getLogger(DownloadORCIDDumpApplication.class);
    private final FileSystem fileSystem;

    public DownloadORCIDDumpApplication(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser argumentParser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(DownloadORCIDDumpApplication.class.getResourceAsStream("/eu/dnetlib/dhp/collection/orcid/download_orcid_parameter.json"))));
        argumentParser.parseArgument(args);
        String hdfsuri = argumentParser.get("namenode");
        log.info("hdfsURI is {}", (Object)hdfsuri);
        String targetPath = argumentParser.get("targetPath");
        log.info("targetPath is {}", (Object)targetPath);
        String apiURL = argumentParser.get("apiURL");
        log.info("apiURL is {}", (Object)apiURL);
        FileSystem fileSystem = FileSystem.get((Configuration)DHPUtils.getHadoopConfiguration((String)hdfsuri));
        new DownloadORCIDDumpApplication(fileSystem).run(targetPath, apiURL);
    }

    private void downloadItem(String name, String itemURL, String basePath) {
        try {
            Path hdfsWritePath = new Path(String.format("%s/%s", basePath, name));
            FSDataOutputStream fsDataOutputStream = this.fileSystem.create(hdfsWritePath, true);
            HttpGet request = new HttpGet(itemURL);
            int timeout = 60;
            RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
            log.info("Downloading url {} into {}", (Object)itemURL, (Object)hdfsWritePath.getName());
            try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
                 CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                int responseCode = response.getStatusLine().getStatusCode();
                log.info("Response code is {}", (Object)responseCode);
                if (responseCode >= 200 && responseCode < 400) {
                    IOUtils.copy((InputStream)response.getEntity().getContent(), (OutputStream)fsDataOutputStream);
                }
            }
            catch (Throwable eu) {
                throw new RuntimeException(eu);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected void run(String targetPath, String apiURL) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        URL url = new URL(apiURL);
        URLConnection conn = url.openConnection();
        InputStream is = conn.getInputStream();
        String json = IOUtils.toString((InputStream)is);
        JsonNode jsonNode = mapper.readTree(json);
        jsonNode.get("files").forEach(i -> this.downloadItem(i.get("name").asText(), i.get("download_url").asText(), targetPath));
    }
}

