/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.transformation.xslt;

import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import java.io.Serializable;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SequenceType;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;

public class Cleaner
implements ExtensionFunction,
Serializable {
    private final VocabularyGroup vocabularies;

    public Cleaner(VocabularyGroup vocabularies) {
        this.vocabularies = vocabularies;
    }

    public QName getName() {
        return new QName("http://eu/dnetlib/transform/clean", "clean");
    }

    public SequenceType getResultType() {
        return SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ONE_OR_MORE);
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ZERO_OR_MORE), SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ONE)};
    }

    public XdmValue call(XdmValue[] xdmValues) throws SaxonApiException {
        XdmValue r = xdmValues[0];
        if (r.size() == 0) {
            return new XdmAtomicValue("");
        }
        String currentValue = xdmValues[0].itemAt(0).getStringValue();
        String vocabularyName = xdmValues[1].itemAt(0).getStringValue();
        Qualifier cleanedValue = this.vocabularies.getSynonymAsQualifier(vocabularyName, currentValue);
        return new XdmAtomicValue(cleanedValue != null ? cleanedValue.getClassid() : currentValue);
    }
}

