/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.openaireAlerts;

import eu.dnetlib.broker.common.elasticsearch.AlertNotification;
import eu.dnetlib.broker.common.elasticsearch.AlertNotificationRepository;
import eu.dnetlib.broker.common.elasticsearch.Notification;
import eu.dnetlib.broker.common.properties.ElasticSearchProperties;
import eu.dnetlib.broker.common.subscriptions.ConditionOperator;
import eu.dnetlib.broker.common.subscriptions.ConditionParams;
import eu.dnetlib.broker.common.subscriptions.MapCondition;
import eu.dnetlib.broker.common.subscriptions.NotificationFrequency;
import eu.dnetlib.broker.common.subscriptions.NotificationMode;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.common.subscriptions.SubscriptionRepository;
import eu.dnetlib.broker.common.utils.MapValueType;
import eu.dnetlib.broker.events.output.DispatcherManager;
import eu.dnetlib.broker.objects.alerts.ValidatorAlertMessage;
import eu.dnetlib.broker.openaireAlerts.AlertSubscriptionDesc;
import eu.dnetlib.broker.openaireAlerts.AlertsPage;
import eu.dnetlib.broker.openaireAlerts.DatasourceWithAlert;
import eu.dnetlib.common.controller.AbstractDnetController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Profile(value={"openaire"})
@RestController
@RequestMapping(value={"/api/openaire-alerts"})
@Tag(name="OpenAIRE Alerts")
public class OpenaireAlertsBrokerController
extends AbstractDnetController {
    @Autowired
    private ElasticsearchOperations esOperations;
    @Autowired
    private ElasticSearchProperties props;
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DispatcherManager dispatcher;
    @Autowired
    private AlertNotificationRepository alertNotificationRepository;
    private static final Log log = LogFactory.getLog(OpenaireAlertsBrokerController.class);

    @Operation(summary="Return the datasources having alerts")
    @GetMapping(value={"/datasources-with-alerts"})
    public List<DatasourceWithAlert> findDatasourcesWithAlerts() {
        try {
            String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/sql/datasourceWithAlerts.sql"), (String)"UTF-8");
            RowMapper mapper = (rs, rowNum) -> new DatasourceWithAlert(rs.getString("id"), rs.getString("name"), rs.getString("rule"), rs.getLong("size"));
            return this.jdbcTemplate.query(sql, mapper);
        }
        catch (Exception e) {
            log.error((Object)"Error executing query", (Throwable)e);
            return new ArrayList<DatasourceWithAlert>();
        }
    }

    @Operation(summary="Perform a subscription")
    @PostMapping(value={"/subscribe/{compatibility}"})
    public Subscription registerSubscription(@PathVariable String compatibility, @RequestParam String email, @RequestParam String dsId) {
        if (StringUtils.isBlank((CharSequence)email)) {
            throw new IllegalArgumentException("subscriber is empty");
        }
        String topic = "ALERT/" + compatibility;
        for (Subscription s : this.subscriptionRepo.findBySubscriber(email)) {
            if (!topic.equalsIgnoreCase(s.getTopic()) || !dsId.equalsIgnoreCase(this.extractDatasourceId(s))) continue;
            throw new IllegalArgumentException("Already subscribed");
        }
        String subscriptionId = "sub-" + UUID.randomUUID();
        ArrayList<MapCondition> conds = new ArrayList<MapCondition>();
        conds.add(new MapCondition("datasourceId", MapValueType.STRING, ConditionOperator.EXACT, Arrays.asList(new ConditionParams(dsId, null))));
        Subscription s = new Subscription(subscriptionId, email, topic, NotificationFrequency.realtime, NotificationMode.EMAIL, null, new Date(), conds);
        return (Subscription)this.subscriptionRepo.save((Object)s);
    }

    @Operation(summary="Return the subscriptions of an user (by email and datasource (optional))")
    @GetMapping(value={"/subscriptions"})
    public List<AlertSubscriptionDesc> subscriptions(@RequestParam String email) {
        Iterable iter = this.subscriptionRepo.findBySubscriber(email);
        return StreamSupport.stream(iter.spliterator(), false).filter(s -> s.getTopic().startsWith("ALERT/")).map(arg_0 -> this.subscriptionDesc(arg_0)).sorted(Comparator.comparing(AlertSubscriptionDesc::getDsName)).collect(Collectors.toList());
    }

    private AlertSubscriptionDesc subscriptionDesc(Subscription s) {
        String dsId = this.extractDatasourceId(s);
        String dsName = this.findDatasouceName(dsId);
        return new AlertSubscriptionDesc(s.getSubscriptionId(), dsId, dsName, s.getTopic(), s.getCreationDate(), s.getLastNotificationDate(), this.alertNotificationRepository.countBySubscriptionId(s.getSubscriptionId()));
    }

    private String findDatasouceName(String dsId) {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{(String)this.jdbcTemplate.queryForObject("select name from oa_datasource_stats where id=? and topic ilike 'ALERT/%' limit 1", String.class, new Object[]{dsId}), dsId});
    }

    private String extractDatasourceId(Subscription sub) {
        return sub.getConditionsAsList().stream().filter(c -> "datasourceId".equals(c.getField())).map(MapCondition::getListParams).filter(l -> !l.isEmpty()).map(l -> ((ConditionParams)l.get(0)).getValue()).findFirst().orElse("");
    }

    @Operation(summary="Return a page of alert notifications")
    @GetMapping(value={"/notifications/{subscrId}/{nPage}/{size}"})
    public AlertsPage notifications(@PathVariable String subscrId, @PathVariable int nPage, @PathVariable int size) {
        Optional optSub = this.subscriptionRepo.findById((Object)subscrId);
        if (optSub.isPresent()) {
            Subscription sub = (Subscription)optSub.get();
            NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.termQuery((String)"subscriptionId.keyword", (String)subscrId)).withSearchType(SearchType.DEFAULT).withFields(new String[]{"payload"}).withPageable((Pageable)PageRequest.of((int)nPage, (int)size)).build();
            SearchHits page = this.esOperations.search((Query)searchQuery, AlertNotification.class, IndexCoordinates.of((String[])new String[]{this.props.getAlertNotificationsIndexName()}));
            List list = page.stream().map(SearchHit::getContent).map(Notification::getPayload).map(ValidatorAlertMessage::fromJSON).collect(Collectors.toList());
            return new AlertsPage(this.extractDatasourceId(sub), sub.getTopic(), (long)nPage, this.overrideGetTotalPage(page, size), page.getTotalHits(), list);
        }
        log.warn((Object)("Invalid subscription: " + subscrId));
        return new AlertsPage("", "", (long)nPage, 0L, 0L, new ArrayList());
    }

    @Operation(summary="Send notifications")
    @GetMapping(value={"/notifications/sendMailForDatasource"})
    private List<String> sendMailForNotifications(@RequestParam String dsId) {
        new Thread(() -> this.innerSendMailForNotifications(dsId)).start();
        return Arrays.asList("Sending ...");
    }

    private List<String> innerSendMailForNotifications(String dsId) {
        for (Subscription s : this.subscriptionRepo.findAll()) {
            if (!s.getTopic().startsWith("ALERT/") || !s.getConditionsAsList().stream().anyMatch(c -> "datasourcId".equals(c.getField()) && c.getListParams().stream().anyMatch(p -> dsId.equals(p.getValue())))) continue;
            long count = this.alertNotificationRepository.countBySubscriptionId(s.getSubscriptionId());
            if (count > 0L) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("oa_notifications_total", count);
                params.put("oa_datasource", this.extractDatasourceId(s));
                this.dispatcher.sendNotification(s, params);
            }
            s.setLastNotificationDate(new Date());
            this.subscriptionRepo.save((Object)s);
        }
        return Arrays.asList("Sending ...");
    }

    @Operation(summary="Update stats")
    @GetMapping(value={"/stats/update"})
    public List<String> updateStats(@RequestParam String dsId) {
        new Thread(() -> this._updateStats(dsId)).start();
        return Arrays.asList("Sending ...");
    }

    protected void _updateStats(String dsId) {
        try {
            String tempTable = "oa_datasource_stats_temp_" + DigestUtils.md5Hex((String)dsId);
            String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/sql/updateAlertStats.sql"), (String)"UTF-8").replaceAll("__TEMP_TABLE__", tempTable);
            this.jdbcTemplate.update(sql, new Object[]{dsId});
        }
        catch (Exception e) {
            log.error((Object)"Error updating stats", (Throwable)e);
        }
    }

    private long overrideGetTotalPage(SearchHits<?> page, int size) {
        return (page.getTotalHits() + (long)size - 1L) / (long)size;
    }
}

