var openaireAlertsBroker = angular.module('openaireAlertsBroker', ['ngRoute', 'angular.backtop', 'openaireAlertsBrokerControllers', 'rzModule', 'LocalStorageModule', 'base64']);

openaireAlertsBroker.config([
	'$routeProvider',
	function($routeProvider) {
		$routeProvider
			.when('/login',                { templateUrl: 'login.html',         controller: 'loginCtrl' })
			.when('/datasources',          { templateUrl: 'datasources.html',   controller: 'datasourcesCtrl' })
			.when('/q/:page/:encodedJson', { templateUrl: 'query.html',         controller: 'queryCtrl' })
			.when('/subscriptions',        { templateUrl: 'subscriptions.html', controller: 'subscriptionsCtrl' })
			.when('/ntf/:page/:subscrId',  { templateUrl: 'notifications.html', controller: 'notificationsCtrl' })
			.otherwise({ redirectTo: '/login' });
	}
]);

openaireAlertsBroker.factory('loginService', function(localStorageService) {
	var user;
	var tmpPath;
	
	var setUser = function(aUser) { 
		user = aUser;
		if (user) {
			localStorageService.set('openaire_broker_user', user);
		} else {
			localStorageService.clearAll();
		}
	};

	var getUser = function() {
		if (!user) {
			 user = localStorageService.get('openaire_broker_user');
		}
		return user;
	};
	
	return {
		setUser    : setUser,
		getUser    : getUser,
		isLogged   : function()  { return getUser() ? true : false },
		getTmpPath : function()  { return tmpPath },
		setTmpPath : function(p) { tmpPath = p },
	}
});

openaireAlertsBroker.run(function ($rootScope, $location, loginService) {
	$rootScope.$on('$routeChangeStart', function (event) {
		if (!loginService.isLogged()) {
			if ($location.path() != '/login') {
				loginService.setTmpPath($location.path());
			}
			$location.path('/login');
		} else {
			loginService.setTmpPath('');
		}
	});
});

openaireAlertsBroker.controller('moduleMenuCtrl', function ($scope, $http, $location, loginService) {
	$scope.isActive = function(regex) {
		var re = new RegExp(regex);
		return re.test($location.path());
	}
	
	$scope.$watch(loginService.isLogged, function (value, oldValue) {
		if(!value && oldValue) {
			$location.path('/login');
	    }
	}, true);
	
	$scope.getUser = function() {
		return loginService.getUser()
	}

	$scope.isLogged = function() {
		return loginService.isLogged();
	}
	
	$scope.logout = function() {
		return loginService.setUser('');
	}

});

//---------------------------------------------------------------------------------------------------------------------//

var openaireAlertsBrokerControllers = angular.module('openaireAlertsBrokerControllers', []);


openaireAlertsBrokerControllers.controller('loginCtrl', function ($scope, $location, loginService) {
	
	$scope.isLogged = function() {
		return loginService.isLogged();
	}
	
	$scope.performLogin = function(email) {
		loginService.setUser(email);
		$location.path(loginService.getTmpPath() ? loginService.getTmpPath() : "/datasources");
	}
});

openaireAlertsBrokerControllers.controller('datasourcesCtrl', function ($scope, $http, $sce, $location, $routeParams, $timeout, $base64, loginService) {
	$scope.datasources = [];
	$scope.topics = [];
	$scope.dsName = "";

	$scope.refresh = function() {
		$scope.datasources = [];
		$http.get('../api/openaire-alerts/datasources-with-alerts').then(function(res) {
			$scope.datasources = res.data;
		}, function(res) {
			alert(res.data.message);
		});
	};
	
	$scope.subscribe = function(dsId, rule) {
		$http.post('../api/openaire-alerts/subscribe/' + encodeURIComponent(rule) + "?dsId=" + encodeURIComponent(dsId) + "&email=" + encodeURIComponent(loginService.getUser())).then(function(res) {
			alert("New registered subscription, ID: " + res.data.subscriptionId);
		}, function(res) {
			alert(res.data.message);
		});
	};
	
	$scope.refresh();
});

openaireAlertsBrokerControllers.controller('subscriptionsCtrl', function ($scope, $http, $sce, $location, $routeParams, $timeout, $base64, loginService) {
	$scope.subscriptions = {};
	
	$scope.isEmpty = function() {
		return angular.equals({}, $scope.subscriptions);
	}

	$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
	$http.get('../api/openaire-alerts/subscriptions?email=' + encodeURIComponent(loginService.getUser())).then(function(res) {
		$scope.subscriptions = res.data;
	}, function(res) {
		alert(res.data.message);
	});
});

openaireAlertsBrokerControllers.controller('notificationsCtrl', function ($scope, $http, $sce, $location, $routeParams, $timeout, $base64, loginService) {
	$scope.page = null;
	$scope.nPage = $routeParams.page;
	$scope.subscrId = $routeParams.subscrId;
	
	$scope.refresh = function() {
		$http.get('../api/openaire-alerts/notifications/' + $scope.subscrId + "/" + $scope.nPage + '/20').then(function(res) {
			$scope.page = res.data;
		}, function(res) {
			alert(res.data.message);
		});
	}
	
	$scope.gotoPage = function(n) {		
		$location.path('/ntf/' + n + "/" + $scope.subscrId);
	} 
		
	$scope.refresh();
});
