/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.model.EventFactory;
import eu.dnetlib.dhp.broker.oa.util.EnrichMissingAbstract;
import eu.dnetlib.dhp.broker.oa.util.EnrichMissingAuthorOrcid;
import eu.dnetlib.dhp.broker.oa.util.EnrichMissingOpenAccess;
import eu.dnetlib.dhp.broker.oa.util.EnrichMissingPid;
import eu.dnetlib.dhp.broker.oa.util.EnrichMissingProject;
import eu.dnetlib.dhp.broker.oa.util.EnrichMissingPublicationDate;
import eu.dnetlib.dhp.broker.oa.util.EnrichMissingSubject;
import eu.dnetlib.dhp.broker.oa.util.EnrichMoreOpenAccess;
import eu.dnetlib.dhp.broker.oa.util.EnrichMorePid;
import eu.dnetlib.dhp.broker.oa.util.EnrichMoreSubject;
import eu.dnetlib.dhp.broker.oa.util.UpdateInfo;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateEventsApplication {
    private static final Logger log = LoggerFactory.getLogger(GenerateEventsApplication.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)GenerateEventsApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/merge_claims_parameters.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String graphPath = parser.get("graphPath");
        log.info("graphPath: {}", (Object)graphPath);
        String eventsPath = parser.get("eventsPath");
        log.info("eventsPath: {}", (Object)eventsPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            GenerateEventsApplication.removeOutputDir(spark, eventsPath);
            GenerateEventsApplication.generateEvents(spark, graphPath, eventsPath);
        });
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }

    private static void generateEvents(SparkSession spark, String graphPath, String eventsPath) {
    }

    private List<Event> generateEvents(Result ... children) {
        ArrayList<Event> list = new ArrayList<Event>();
        for (Result source : children) {
            for (Result target : children) {
                if (source == target) continue;
                list.addAll(this.findUpdates(source, target).stream().map(info -> EventFactory.newBrokerEvent(source, target, info)).collect(Collectors.toList()));
            }
        }
        return list;
    }

    private List<UpdateInfo<?>> findUpdates(Result source, Result target) {
        ArrayList list = new ArrayList();
        list.addAll(EnrichMissingAbstract.findUpdates(source, target));
        list.addAll(EnrichMissingAuthorOrcid.findUpdates(source, target));
        list.addAll(EnrichMissingOpenAccess.findUpdates(source, target));
        list.addAll(EnrichMissingPid.findUpdates(source, target));
        list.addAll(EnrichMissingProject.findUpdates(source, target));
        list.addAll(EnrichMissingPublicationDate.findUpdates(source, target));
        list.addAll(EnrichMissingSubject.findUpdates(source, target));
        list.addAll(EnrichMoreOpenAccess.findUpdates(source, target));
        list.addAll(EnrichMorePid.findUpdates(source, target));
        list.addAll(EnrichMoreSubject.findUpdates(source, target));
        return list;
    }
}

