/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.LongAccumulator;

public class ClusterUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private ClusterUtils() {
    }

    public static void createDirIfMissing(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }

    public static void removeDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }

    public static Dataset<Relation> loadRelations(String graphPath, SparkSession spark) {
        return ClusterUtils.readPath(spark, graphPath + "/relation", Relation.class).map((MapFunction & Serializable)r -> {
            r.setSource(ConversionUtils.cleanOpenaireId(r.getSource()));
            r.setTarget(ConversionUtils.cleanOpenaireId(r.getTarget()));
            return r;
        }, Encoders.bean(Relation.class));
    }

    public static <R> Dataset<R> readPath(SparkSession spark, String inputPath, Class<R> clazz) {
        return spark.read().textFile(inputPath).map((MapFunction & Serializable)value -> OBJECT_MAPPER.readValue(value, clazz), Encoders.bean(clazz));
    }

    public static boolean isDedupRoot(String id) {
        return id.contains("dedup");
    }

    public static final boolean isValidResultResultClass(String s) {
        return s.equals("IsReferencedBy") || s.equals("IsRelatedTo") || s.equals("References") || s.equals("IsSupplementedBy") || s.equals("IsSupplementTo");
    }

    public static <T> T incrementAccumulator(T o, LongAccumulator acc) {
        if (acc != null) {
            acc.add(1L);
        }
        return o;
    }

    public static <T> void save(Dataset<T> dataset, String path, Class<T> clazz, LongAccumulator acc) {
        dataset.map((MapFunction & Serializable)o -> ClusterUtils.incrementAccumulator(o, acc), Encoders.bean(clazz)).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(path);
    }

    public static Set<String> parseParamAsList(ArgumentApplicationParser parser, String key) {
        String s = parser.get(key).trim();
        HashSet<String> res = new HashSet<String>();
        if (s.length() > 1) {
            Arrays.stream(s.split(",")).map(String::trim).filter(StringUtils::isNotBlank).forEach(res::add);
        }
        return res;
    }
}

