/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.elasticsearch.spark.rdd.api.java.JavaEsSpark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class IndexOnESJob {
    private static final Logger log = LoggerFactory.getLogger(IndexOnESJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)IndexOnESJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/index_es.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        String eventsPath = parser.get("outputDir") + "/events";
        log.info("eventsPath: {}", (Object)eventsPath);
        String index = parser.get("index");
        log.info("index: {}", (Object)index);
        String indexHost = parser.get("esHost");
        log.info("indexHost: {}", (Object)indexHost);
        String esBatchWriteRetryCount = parser.get("esBatchWriteRetryCount");
        log.info("esBatchWriteRetryCount: {}", (Object)esBatchWriteRetryCount);
        String esBatchWriteRetryWait = parser.get("esBatchWriteRetryWait");
        log.info("esBatchWriteRetryWait: {}", (Object)esBatchWriteRetryWait);
        String esBatchSizeEntries = parser.get("esBatchSizeEntries");
        log.info("esBatchSizeEntries: {}", (Object)esBatchSizeEntries);
        String esNodesWanOnly = parser.get("esNodesWanOnly");
        log.info("esNodesWanOnly: {}", (Object)esNodesWanOnly);
        SparkSession spark = SparkSession.builder().config(conf).getOrCreate();
        JavaRDD inputRdd = ClusterUtils.readPath(spark, eventsPath, Event.class).map(IndexOnESJob::eventAsJsonString, Encoders.STRING()).javaRDD();
        HashMap<String, String> esCfg = new HashMap<String, String>();
        esCfg.put("es.index.auto.create", "false");
        esCfg.put("es.nodes", indexHost);
        esCfg.put("es.mapping.id", "eventId");
        esCfg.put("es.batch.write.retry.count", esBatchWriteRetryCount);
        esCfg.put("es.batch.write.retry.wait", esBatchWriteRetryWait);
        esCfg.put("es.batch.size.entries", esBatchSizeEntries);
        esCfg.put("es.nodes.wan.only", esNodesWanOnly);
        JavaEsSpark.saveJsonToEs((JavaRDD)inputRdd, (String)index, esCfg);
    }

    private static String eventAsJsonString(Event f) throws JsonProcessingException {
        return new ObjectMapper().writeValueAsString((Object)f);
    }
}

