/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.EventGroup;
import eu.dnetlib.dhp.broker.oa.util.aggregators.subset.EventSubsetAggregator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.util.LongAccumulator;
import org.elasticsearch.spark.rdd.api.java.JavaEsSpark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexEventSubsetJob {
    private static final Logger log = LoggerFactory.getLogger(IndexEventSubsetJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)IndexEventSubsetJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/index_event_subset.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        String eventsPath = parser.get("outputDir") + "/events";
        log.info("eventsPath: {}", (Object)eventsPath);
        String index = parser.get("index");
        log.info("index: {}", (Object)index);
        String indexHost = parser.get("esHost");
        log.info("indexHost: {}", (Object)indexHost);
        String esBatchWriteRetryCount = parser.get("esBatchWriteRetryCount");
        log.info("esBatchWriteRetryCount: {}", (Object)esBatchWriteRetryCount);
        String esBatchWriteRetryWait = parser.get("esBatchWriteRetryWait");
        log.info("esBatchWriteRetryWait: {}", (Object)esBatchWriteRetryWait);
        String esBatchSizeEntries = parser.get("esBatchSizeEntries");
        log.info("esBatchSizeEntries: {}", (Object)esBatchSizeEntries);
        String esNodesWanOnly = parser.get("esNodesWanOnly");
        log.info("esNodesWanOnly: {}", (Object)esNodesWanOnly);
        int maxEventsForTopic = NumberUtils.toInt((String)parser.get("maxEventsForTopic"));
        log.info("maxEventsForTopic: {}", (Object)maxEventsForTopic);
        String brokerApiBaseUrl = parser.get("brokerApiBaseUrl");
        log.info("brokerApiBaseUrl: {}", (Object)brokerApiBaseUrl);
        SparkSession spark = SparkSession.builder().config(conf).getOrCreate();
        TypedColumn aggr = new EventSubsetAggregator(maxEventsForTopic).toColumn();
        LongAccumulator total = spark.sparkContext().longAccumulator("total_indexed");
        long now = new Date().getTime();
        Dataset subset = ClusterUtils.readPath(spark, eventsPath, Event.class).groupByKey((MapFunction & Serializable)e -> e.getTopic() + "@" + e.getMap().getTargetDatasourceId(), Encoders.STRING()).agg(aggr).map((MapFunction & Serializable)t -> (EventGroup)t._2, Encoders.bean(EventGroup.class)).flatMap((FlatMapFunction & Serializable)g -> g.getData().iterator(), Encoders.bean(Event.class));
        JavaRDD inputRdd = subset.map((MapFunction & Serializable)e -> IndexEventSubsetJob.prepareEventForIndexing(e, now, total), Encoders.STRING()).javaRDD();
        HashMap<String, String> esCfg = new HashMap<String, String>();
        esCfg.put("es.index.auto.create", "false");
        esCfg.put("es.nodes", indexHost);
        esCfg.put("es.mapping.id", "eventId");
        esCfg.put("es.batch.write.retry.count", esBatchWriteRetryCount);
        esCfg.put("es.batch.write.retry.wait", esBatchWriteRetryWait);
        esCfg.put("es.batch.size.entries", esBatchSizeEntries);
        esCfg.put("es.nodes.wan.only", esNodesWanOnly);
        log.info("*** Start indexing");
        JavaEsSpark.saveJsonToEs((JavaRDD)inputRdd, (String)index, esCfg);
        log.info("*** End indexing");
        log.info("*** Deleting old events");
        String message = IndexEventSubsetJob.deleteOldEvents(brokerApiBaseUrl, now - 1000L);
        log.info("*** Deleted events: {}", (Object)message);
    }

    private static String deleteOldEvents(String brokerApiBaseUrl, long l) throws IOException {
        String url = brokerApiBaseUrl + "/api/events/byCreationDate/0/" + l;
        HttpDelete req = new HttpDelete(url);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            String string;
            block12: {
                CloseableHttpResponse response = client.execute((HttpUriRequest)req);
                try {
                    string = IOUtils.toString((InputStream)response.getEntity().getContent());
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    private static String prepareEventForIndexing(Event e, long creationDate, LongAccumulator acc) throws JsonProcessingException {
        acc.add(1L);
        e.setCreationDate(creationDate);
        e.setExpiryDate(Long.MAX_VALUE);
        return new ObjectMapper().writeValueAsString((Object)e);
    }
}

