/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa_alerts;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.oa.util.BrokerIndexClient;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.index.es.ConvertJSONWithId;
import eu.dnetlib.dhp.schema.mdstore.Provenance;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexAlertNotificationsJob {
    private static final Logger log = LoggerFactory.getLogger(IndexAlertNotificationsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)IndexAlertNotificationsJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa_alert/index_alert_notifications.json")));
        parser.parseArgument(args);
        String notificationsPath = parser.get("path");
        log.info("notificationsPath: {}", (Object)notificationsPath);
        String index = parser.get("index");
        log.info("index: {}", (Object)index);
        String indexHost = parser.get("esHost");
        log.info("indexHost: {}", (Object)indexHost);
        String dsId = ((Provenance)DHPUtils.MAPPER.readValue(parser.get("provenance"), Provenance.class)).getDatasourceId();
        log.info("dsId: {}", (Object)dsId);
        String brokerApiBaseUrl = parser.get("brokerApiBaseUrl");
        log.info("brokerApiBaseUrl: {}", (Object)brokerApiBaseUrl);
        try (BrokerIndexClient feeder = new BrokerIndexClient(indexHost);){
            log.info("*** Clean old notifications");
            feeder.deleteUsingExactField(index, "map.datasourceId", dsId, true);
            FileSystem fileSystem = FileSystem.get((Configuration)new Configuration());
            List<Path> files = ClusterUtils.listFiles(notificationsPath, fileSystem, ".gz");
            log.info("*** Start indexing");
            feeder.parallelBulkIndex(files, 4, fileSystem, (Function)new ConvertJSONWithId("\"notificationId\":\"((\\d|\\w|-)*)\"", index));
            feeder.refreshIndex(index);
        }
        log.info("*** sendNotifications (emails, ...)");
        IndexAlertNotificationsJob.sendAlertNotifications(brokerApiBaseUrl, dsId);
        log.info("*** ALL done.");
    }

    /*
     * Exception decompiling
     */
    private static String sendAlertNotifications(String brokerApiBaseUrl, String dsId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

