/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.aggregators.stats.DatasourceStats;
import eu.dnetlib.dhp.broker.oa.util.aggregators.stats.StatsAggregator;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.TypedColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateStatsJob {
    private static final Logger log = LoggerFactory.getLogger(GenerateStatsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)GenerateStatsJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/stats_params.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        SparkConf conf = new SparkConf();
        String eventsPath = parser.get("outputDir") + "/events";
        log.info("eventsPath: {}", (Object)eventsPath);
        String dbUrl = parser.get("dbUrl");
        log.info("dbUrl: {}", (Object)dbUrl);
        String dbUser = parser.get("dbUser");
        log.info("dbUser: {}", (Object)dbUser);
        String dbPassword = parser.get("dbPassword");
        log.info("dbPassword: {}", (Object)"***");
        String brokerApiBaseUrl = parser.get("brokerApiBaseUrl");
        log.info("brokerApiBaseUrl: {}", (Object)brokerApiBaseUrl);
        TypedColumn aggr = new StatsAggregator().toColumn();
        Properties connectionProperties = new Properties();
        connectionProperties.put("user", dbUser);
        connectionProperties.put("password", dbPassword);
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            ClusterUtils.readPath(spark, eventsPath, Event.class).groupByKey((MapFunction & Serializable)e -> e.getTopic() + "@@@" + e.getMap().getTargetDatasourceId(), Encoders.STRING()).agg(aggr).map((MapFunction & Serializable)t -> (DatasourceStats)t._2, Encoders.bean(DatasourceStats.class)).coalesce(1).write().mode(SaveMode.Overwrite).jdbc(dbUrl, "oa_datasource_stats_temp", connectionProperties);
            log.info("*** updateStats");
            GenerateStatsJob.updateStats(brokerApiBaseUrl);
            log.info("*** ALL done.");
        });
    }

    /*
     * Exception decompiling
     */
    private static String updateStats(String brokerApiBaseUrl) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

