/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.matchers.simple;

import eu.dnetlib.broker.objects.OaBrokerAuthor;
import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.dhp.broker.model.Topic;
import eu.dnetlib.dhp.broker.oa.matchers.UpdateMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class EnrichMissingAuthorOrcid
extends UpdateMatcher<OaBrokerAuthor> {
    public EnrichMissingAuthorOrcid() {
        super(40, aut -> Topic.ENRICH_MISSING_AUTHOR_ORCID, (p, aut) -> p.getCreators().add(aut), OaBrokerAuthor::getOrcid);
    }

    @Override
    protected List<OaBrokerAuthor> findDifferences(OaBrokerMainEntity source, OaBrokerMainEntity target) {
        if (target.getCreators().size() >= 50) {
            return new ArrayList<OaBrokerAuthor>();
        }
        Set existingOrcids = target.getCreators().stream().map(OaBrokerAuthor::getOrcid).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        return source.getCreators().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrcid())).filter(a -> !existingOrcids.contains(a.getOrcid())).collect(Collectors.toList());
    }
}

