/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.util;

import eu.dnetlib.broker.objects.OaBrokerEventPayload;
import eu.dnetlib.broker.objects.OaBrokerInstance;
import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.broker.objects.OaBrokerProvenance;
import eu.dnetlib.broker.objects.OaBrokerRelatedDatasource;
import eu.dnetlib.dhp.broker.model.Topic;
import eu.dnetlib.dhp.broker.oa.util.TrustUtils;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class UpdateInfo<T> {
    private final Topic topic;
    private final T highlightValue;
    private final OaBrokerMainEntity source;
    private final OaBrokerMainEntity target;
    private final OaBrokerRelatedDatasource targetDs;
    private final BiConsumer<OaBrokerMainEntity, T> compileHighlight;
    private final Function<T, String> highlightToString;
    private final float trust;

    public UpdateInfo(Topic topic, T highlightValue, OaBrokerMainEntity source, OaBrokerMainEntity target, OaBrokerRelatedDatasource targetDs, BiConsumer<OaBrokerMainEntity, T> compileHighlight, Function<T, String> highlightToString) {
        this.topic = topic;
        this.highlightValue = highlightValue;
        this.source = source;
        this.target = target;
        this.targetDs = targetDs;
        this.compileHighlight = compileHighlight;
        this.highlightToString = highlightToString;
        this.trust = TrustUtils.calculateTrust(source, target);
    }

    public T getHighlightValue() {
        return this.highlightValue;
    }

    public OaBrokerMainEntity getSource() {
        return this.source;
    }

    public OaBrokerMainEntity getTarget() {
        return this.target;
    }

    public OaBrokerRelatedDatasource getTargetDs() {
        return this.targetDs;
    }

    protected Topic getTopic() {
        return this.topic;
    }

    public String getTopicPath() {
        return this.topic.getPath();
    }

    public float getTrust() {
        return this.trust;
    }

    public String getHighlightValueAsString() {
        return this.highlightToString.apply(this.getHighlightValue());
    }

    public OaBrokerEventPayload asBrokerPayload() {
        this.compileHighlight.accept(this.target, (OaBrokerMainEntity)this.getHighlightValue());
        OaBrokerMainEntity hl = new OaBrokerMainEntity();
        this.compileHighlight.accept(hl, (OaBrokerMainEntity)this.getHighlightValue());
        String provId = this.getSource().getOpenaireId();
        String provRepo = this.getSource().getDatasources().stream().filter(ds -> ds.getRelType().equals("collectedFrom")).map(OaBrokerRelatedDatasource::getName).filter(Objects::nonNull).findFirst().orElse("");
        String provType = this.getSource().getDatasources().stream().filter(ds -> ds.getRelType().equals("collectedFrom")).map(OaBrokerRelatedDatasource::getType).filter(Objects::nonNull).findFirst().orElse("");
        String provUrl = this.getSource().getInstances().stream().map(OaBrokerInstance::getUrl).filter(Objects::nonNull).findFirst().orElse(null);
        OaBrokerProvenance provenance = new OaBrokerProvenance(provId, provRepo, provType, provUrl);
        OaBrokerEventPayload res = new OaBrokerEventPayload();
        res.setResult(this.target);
        res.setHighlight(hl);
        res.setTrust(this.trust);
        res.setProvenance(provenance);
        return res;
    }
}

