/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.aggregators.simple.ResultAggregator;
import eu.dnetlib.dhp.broker.oa.util.aggregators.simple.ResultGroup;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareGroupsJob {
    private static final Logger log = LoggerFactory.getLogger(PrepareGroupsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)PrepareGroupsJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/common_params.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String graphPath = parser.get("graphPath");
        log.info("graphPath: {}", (Object)graphPath);
        String workingDir = parser.get("workingDir");
        log.info("workingDir: {}", (Object)workingDir);
        String groupsPath = workingDir + "/duplicates";
        log.info("groupsPath: {}", (Object)groupsPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            ClusterUtils.removeDir(spark, groupsPath);
            LongAccumulator total = spark.sparkContext().longAccumulator("total_groups");
            Dataset<OaBrokerMainEntity> results = ClusterUtils.readPath(spark, workingDir + "/joinedEntities_step4", OaBrokerMainEntity.class);
            Dataset<Relation> mergedRels = ClusterUtils.loadMergedRelations(graphPath, spark);
            TypedColumn aggr = new ResultAggregator().toColumn();
            Dataset dataset = results.joinWith(mergedRels, results.col("openaireId").equalTo((Object)mergedRels.col("source")), "inner").groupByKey((MapFunction & Serializable)t -> ((Relation)t._2).getTarget(), Encoders.STRING()).agg(aggr).map((MapFunction & Serializable)t -> (ResultGroup)t._2, Encoders.bean(ResultGroup.class)).filter((FilterFunction & Serializable)rg -> rg.getData().size() > 1);
            ClusterUtils.save(dataset, groupsPath, ResultGroup.class, total);
        });
    }
}

